<?php
/**
 * HeartBeatAlertNotification
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * HeartBeatAlertNotification Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class HeartBeatAlertNotification implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'HeartBeatAlertNotification';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'senderId' => 'string',
        'heartBeatTimeoutInMinutes' => 'float',
        'ruleId' => 'string',
        'startDate' => '\DateTime',
        'endDate' => '\DateTime',
        'notificationUsers' => '\PureCloudSDK\HeartBeatAlertNotificationNotificationUsers[]',
        'alertTypes' => 'string[]',
        'ruleType' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'senderId' => 'senderId',
        'heartBeatTimeoutInMinutes' => 'heartBeatTimeoutInMinutes',
        'ruleId' => 'ruleId',
        'startDate' => 'startDate',
        'endDate' => 'endDate',
        'notificationUsers' => 'notificationUsers',
        'alertTypes' => 'alertTypes',
        'ruleType' => 'ruleType'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'senderId' => 'setSenderId',
        'heartBeatTimeoutInMinutes' => 'setHeartBeatTimeoutInMinutes',
        'ruleId' => 'setRuleId',
        'startDate' => 'setStartDate',
        'endDate' => 'setEndDate',
        'notificationUsers' => 'setNotificationUsers',
        'alertTypes' => 'setAlertTypes',
        'ruleType' => 'setRuleType'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'senderId' => 'getSenderId',
        'heartBeatTimeoutInMinutes' => 'getHeartBeatTimeoutInMinutes',
        'ruleId' => 'getRuleId',
        'startDate' => 'getStartDate',
        'endDate' => 'getEndDate',
        'notificationUsers' => 'getNotificationUsers',
        'alertTypes' => 'getAlertTypes',
        'ruleType' => 'getRuleType'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const ALERT_TYPES_SMS = 'SMS';
    const ALERT_TYPES_DEVICE = 'DEVICE';
    const ALERT_TYPES_EMAIL = 'EMAIL';
    const RULE_TYPE_EDGE = 'EDGE';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getAlertTypesAllowableValues()
    {
        return [
            self::ALERT_TYPES_SMS,
            self::ALERT_TYPES_DEVICE,
            self::ALERT_TYPES_EMAIL,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getRuleTypeAllowableValues()
    {
        return [
            self::RULE_TYPE_EDGE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['senderId'] = isset($data['senderId']) ? $data['senderId'] : null;
        $this->container['heartBeatTimeoutInMinutes'] = isset($data['heartBeatTimeoutInMinutes']) ? $data['heartBeatTimeoutInMinutes'] : null;
        $this->container['ruleId'] = isset($data['ruleId']) ? $data['ruleId'] : null;
        $this->container['startDate'] = isset($data['startDate']) ? $data['startDate'] : null;
        $this->container['endDate'] = isset($data['endDate']) ? $data['endDate'] : null;
        $this->container['notificationUsers'] = isset($data['notificationUsers']) ? $data['notificationUsers'] : null;
        $this->container['alertTypes'] = isset($data['alertTypes']) ? $data['alertTypes'] : null;
        $this->container['ruleType'] = isset($data['ruleType']) ? $data['ruleType'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("EDGE");
        if (!in_array($this->container['ruleType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'ruleType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("EDGE");
        if (!in_array($this->container['ruleType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets senderId
     * @return string
     */
    public function getSenderId()
    {
        return $this->container['senderId'];
    }

    /**
     * Sets senderId
     * @param string $senderId
     * @return $this
     */
    public function setSenderId($senderId)
    {
        $this->container['senderId'] = $senderId;

        return $this;
    }

    /**
     * Gets heartBeatTimeoutInMinutes
     * @return float
     */
    public function getHeartBeatTimeoutInMinutes()
    {
        return $this->container['heartBeatTimeoutInMinutes'];
    }

    /**
     * Sets heartBeatTimeoutInMinutes
     * @param float $heartBeatTimeoutInMinutes
     * @return $this
     */
    public function setHeartBeatTimeoutInMinutes($heartBeatTimeoutInMinutes)
    {
        $this->container['heartBeatTimeoutInMinutes'] = $heartBeatTimeoutInMinutes;

        return $this;
    }

    /**
     * Gets ruleId
     * @return string
     */
    public function getRuleId()
    {
        return $this->container['ruleId'];
    }

    /**
     * Sets ruleId
     * @param string $ruleId
     * @return $this
     */
    public function setRuleId($ruleId)
    {
        $this->container['ruleId'] = $ruleId;

        return $this;
    }

    /**
     * Gets startDate
     * @return \DateTime
     */
    public function getStartDate()
    {
        return $this->container['startDate'];
    }

    /**
     * Sets startDate
     * @param \DateTime $startDate
     * @return $this
     */
    public function setStartDate($startDate)
    {
        $this->container['startDate'] = $startDate;

        return $this;
    }

    /**
     * Gets endDate
     * @return \DateTime
     */
    public function getEndDate()
    {
        return $this->container['endDate'];
    }

    /**
     * Sets endDate
     * @param \DateTime $endDate
     * @return $this
     */
    public function setEndDate($endDate)
    {
        $this->container['endDate'] = $endDate;

        return $this;
    }

    /**
     * Gets notificationUsers
     * @return \PureCloudSDK\HeartBeatAlertNotificationNotificationUsers[]
     */
    public function getNotificationUsers()
    {
        return $this->container['notificationUsers'];
    }

    /**
     * Sets notificationUsers
     * @param \PureCloudSDK\HeartBeatAlertNotificationNotificationUsers[] $notificationUsers
     * @return $this
     */
    public function setNotificationUsers($notificationUsers)
    {
        $this->container['notificationUsers'] = $notificationUsers;

        return $this;
    }

    /**
     * Gets alertTypes
     * @return string[]
     */
    public function getAlertTypes()
    {
        return $this->container['alertTypes'];
    }

    /**
     * Sets alertTypes
     * @param string[] $alertTypes
     * @return $this
     */
    public function setAlertTypes($alertTypes)
    {
        $allowed_values = array('SMS', 'DEVICE', 'EMAIL');
        if (!in_array($alertTypes, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'alertTypes', must be one of 'SMS', 'DEVICE', 'EMAIL'");
        }
        $this->container['alertTypes'] = $alertTypes;

        return $this;
    }

    /**
     * Gets ruleType
     * @return string
     */
    public function getRuleType()
    {
        return $this->container['ruleType'];
    }

    /**
     * Sets ruleType
     * @param string $ruleType
     * @return $this
     */
    public function setRuleType($ruleType)
    {
        $allowed_values = array('EDGE');
        if (!in_array($ruleType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'ruleType', must be one of 'EDGE'");
        }
        $this->container['ruleType'] = $ruleType;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


