<?php
/**
 * InteractionStatAlertNotification
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * InteractionStatAlertNotification Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class InteractionStatAlertNotification implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'InteractionStatAlertNotification';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'ruleId' => 'string',
        'dimension' => 'string',
        'dimensionValue' => 'string',
        'dimensionValueName' => 'string',
        'metric' => 'string',
        'mediaType' => 'string',
        'numericRange' => 'string',
        'statistic' => 'string',
        'value' => 'float',
        'unread' => 'bool',
        'startDate' => '\DateTime',
        'endDate' => '\DateTime',
        'notificationUsers' => '\PureCloudSDK\HeartBeatAlertNotificationNotificationUsers[]',
        'alertTypes' => 'string[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'ruleId' => 'ruleId',
        'dimension' => 'dimension',
        'dimensionValue' => 'dimensionValue',
        'dimensionValueName' => 'dimensionValueName',
        'metric' => 'metric',
        'mediaType' => 'mediaType',
        'numericRange' => 'numericRange',
        'statistic' => 'statistic',
        'value' => 'value',
        'unread' => 'unread',
        'startDate' => 'startDate',
        'endDate' => 'endDate',
        'notificationUsers' => 'notificationUsers',
        'alertTypes' => 'alertTypes'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'ruleId' => 'setRuleId',
        'dimension' => 'setDimension',
        'dimensionValue' => 'setDimensionValue',
        'dimensionValueName' => 'setDimensionValueName',
        'metric' => 'setMetric',
        'mediaType' => 'setMediaType',
        'numericRange' => 'setNumericRange',
        'statistic' => 'setStatistic',
        'value' => 'setValue',
        'unread' => 'setUnread',
        'startDate' => 'setStartDate',
        'endDate' => 'setEndDate',
        'notificationUsers' => 'setNotificationUsers',
        'alertTypes' => 'setAlertTypes'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'ruleId' => 'getRuleId',
        'dimension' => 'getDimension',
        'dimensionValue' => 'getDimensionValue',
        'dimensionValueName' => 'getDimensionValueName',
        'metric' => 'getMetric',
        'mediaType' => 'getMediaType',
        'numericRange' => 'getNumericRange',
        'statistic' => 'getStatistic',
        'value' => 'getValue',
        'unread' => 'getUnread',
        'startDate' => 'getStartDate',
        'endDate' => 'getEndDate',
        'notificationUsers' => 'getNotificationUsers',
        'alertTypes' => 'getAlertTypes'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const DIMENSION_QUEUE_ID = 'queueId';
    const DIMENSION_USER_ID = 'userId';
    const METRIC_T_ABANDON = 'tAbandon';
    const METRIC_T_ANSWERED = 'tAnswered';
    const METRIC_T_TALK = 'tTalk';
    const METRIC_N_OFFERED = 'nOffered';
    const METRIC_T_HANDLE = 'tHandle';
    const METRIC_N_TRANSFERRED = 'nTransferred';
    const METRIC_O_SERVICE_LEVEL = 'oServiceLevel';
    const METRIC_T_WAIT = 'tWait';
    const METRIC_T_HELD = 'tHeld';
    const METRIC_T_ACW = 'tAcw';
    const MEDIA_TYPE_VOICE = 'voice';
    const MEDIA_TYPE_CHAT = 'chat';
    const MEDIA_TYPE_EMAIL = 'email';
    const NUMERIC_RANGE_GT = 'gt';
    const NUMERIC_RANGE_GTE = 'gte';
    const NUMERIC_RANGE_LT = 'lt';
    const NUMERIC_RANGE_LTE = 'lte';
    const NUMERIC_RANGE_EQ = 'eq';
    const NUMERIC_RANGE_NE = 'ne';
    const STATISTIC_COUNT = 'count';
    const STATISTIC_MIN = 'min';
    const STATISTIC_RATIO = 'ratio';
    const STATISTIC_MAX = 'max';
    const ALERT_TYPES_SMS = 'SMS';
    const ALERT_TYPES_DEVICE = 'DEVICE';
    const ALERT_TYPES_EMAIL = 'EMAIL';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDimensionAllowableValues()
    {
        return [
            self::DIMENSION_QUEUE_ID,
            self::DIMENSION_USER_ID,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMetricAllowableValues()
    {
        return [
            self::METRIC_T_ABANDON,
            self::METRIC_T_ANSWERED,
            self::METRIC_T_TALK,
            self::METRIC_N_OFFERED,
            self::METRIC_T_HANDLE,
            self::METRIC_N_TRANSFERRED,
            self::METRIC_O_SERVICE_LEVEL,
            self::METRIC_T_WAIT,
            self::METRIC_T_HELD,
            self::METRIC_T_ACW,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMediaTypeAllowableValues()
    {
        return [
            self::MEDIA_TYPE_VOICE,
            self::MEDIA_TYPE_CHAT,
            self::MEDIA_TYPE_EMAIL,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getNumericRangeAllowableValues()
    {
        return [
            self::NUMERIC_RANGE_GT,
            self::NUMERIC_RANGE_GTE,
            self::NUMERIC_RANGE_LT,
            self::NUMERIC_RANGE_LTE,
            self::NUMERIC_RANGE_EQ,
            self::NUMERIC_RANGE_NE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStatisticAllowableValues()
    {
        return [
            self::STATISTIC_COUNT,
            self::STATISTIC_MIN,
            self::STATISTIC_RATIO,
            self::STATISTIC_MAX,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getAlertTypesAllowableValues()
    {
        return [
            self::ALERT_TYPES_SMS,
            self::ALERT_TYPES_DEVICE,
            self::ALERT_TYPES_EMAIL,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['ruleId'] = isset($data['ruleId']) ? $data['ruleId'] : null;
        $this->container['dimension'] = isset($data['dimension']) ? $data['dimension'] : null;
        $this->container['dimensionValue'] = isset($data['dimensionValue']) ? $data['dimensionValue'] : null;
        $this->container['dimensionValueName'] = isset($data['dimensionValueName']) ? $data['dimensionValueName'] : null;
        $this->container['metric'] = isset($data['metric']) ? $data['metric'] : null;
        $this->container['mediaType'] = isset($data['mediaType']) ? $data['mediaType'] : null;
        $this->container['numericRange'] = isset($data['numericRange']) ? $data['numericRange'] : null;
        $this->container['statistic'] = isset($data['statistic']) ? $data['statistic'] : null;
        $this->container['value'] = isset($data['value']) ? $data['value'] : null;
        $this->container['unread'] = isset($data['unread']) ? $data['unread'] : null;
        $this->container['startDate'] = isset($data['startDate']) ? $data['startDate'] : null;
        $this->container['endDate'] = isset($data['endDate']) ? $data['endDate'] : null;
        $this->container['notificationUsers'] = isset($data['notificationUsers']) ? $data['notificationUsers'] : null;
        $this->container['alertTypes'] = isset($data['alertTypes']) ? $data['alertTypes'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("queueId", "userId");
        if (!in_array($this->container['dimension'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'dimension', must be one of #{allowed_values}.";
        }

        $allowed_values = array("tAbandon", "tAnswered", "tTalk", "nOffered", "tHandle", "nTransferred", "oServiceLevel", "tWait", "tHeld", "tAcw");
        if (!in_array($this->container['metric'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'metric', must be one of #{allowed_values}.";
        }

        $allowed_values = array("voice", "chat", "email");
        if (!in_array($this->container['mediaType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'mediaType', must be one of #{allowed_values}.";
        }

        $allowed_values = array("gt", "gte", "lt", "lte", "eq", "ne");
        if (!in_array($this->container['numericRange'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'numericRange', must be one of #{allowed_values}.";
        }

        $allowed_values = array("count", "min", "ratio", "max");
        if (!in_array($this->container['statistic'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'statistic', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("queueId", "userId");
        if (!in_array($this->container['dimension'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("tAbandon", "tAnswered", "tTalk", "nOffered", "tHandle", "nTransferred", "oServiceLevel", "tWait", "tHeld", "tAcw");
        if (!in_array($this->container['metric'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("voice", "chat", "email");
        if (!in_array($this->container['mediaType'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("gt", "gte", "lt", "lte", "eq", "ne");
        if (!in_array($this->container['numericRange'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("count", "min", "ratio", "max");
        if (!in_array($this->container['statistic'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets ruleId
     * @return string
     */
    public function getRuleId()
    {
        return $this->container['ruleId'];
    }

    /**
     * Sets ruleId
     * @param string $ruleId
     * @return $this
     */
    public function setRuleId($ruleId)
    {
        $this->container['ruleId'] = $ruleId;

        return $this;
    }

    /**
     * Gets dimension
     * @return string
     */
    public function getDimension()
    {
        return $this->container['dimension'];
    }

    /**
     * Sets dimension
     * @param string $dimension
     * @return $this
     */
    public function setDimension($dimension)
    {
        $allowed_values = array('queueId', 'userId');
        if (!in_array($dimension, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'dimension', must be one of 'queueId', 'userId'");
        }
        $this->container['dimension'] = $dimension;

        return $this;
    }

    /**
     * Gets dimensionValue
     * @return string
     */
    public function getDimensionValue()
    {
        return $this->container['dimensionValue'];
    }

    /**
     * Sets dimensionValue
     * @param string $dimensionValue
     * @return $this
     */
    public function setDimensionValue($dimensionValue)
    {
        $this->container['dimensionValue'] = $dimensionValue;

        return $this;
    }

    /**
     * Gets dimensionValueName
     * @return string
     */
    public function getDimensionValueName()
    {
        return $this->container['dimensionValueName'];
    }

    /**
     * Sets dimensionValueName
     * @param string $dimensionValueName
     * @return $this
     */
    public function setDimensionValueName($dimensionValueName)
    {
        $this->container['dimensionValueName'] = $dimensionValueName;

        return $this;
    }

    /**
     * Gets metric
     * @return string
     */
    public function getMetric()
    {
        return $this->container['metric'];
    }

    /**
     * Sets metric
     * @param string $metric
     * @return $this
     */
    public function setMetric($metric)
    {
        $allowed_values = array('tAbandon', 'tAnswered', 'tTalk', 'nOffered', 'tHandle', 'nTransferred', 'oServiceLevel', 'tWait', 'tHeld', 'tAcw');
        if (!in_array($metric, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'metric', must be one of 'tAbandon', 'tAnswered', 'tTalk', 'nOffered', 'tHandle', 'nTransferred', 'oServiceLevel', 'tWait', 'tHeld', 'tAcw'");
        }
        $this->container['metric'] = $metric;

        return $this;
    }

    /**
     * Gets mediaType
     * @return string
     */
    public function getMediaType()
    {
        return $this->container['mediaType'];
    }

    /**
     * Sets mediaType
     * @param string $mediaType
     * @return $this
     */
    public function setMediaType($mediaType)
    {
        $allowed_values = array('voice', 'chat', 'email');
        if (!in_array($mediaType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'mediaType', must be one of 'voice', 'chat', 'email'");
        }
        $this->container['mediaType'] = $mediaType;

        return $this;
    }

    /**
     * Gets numericRange
     * @return string
     */
    public function getNumericRange()
    {
        return $this->container['numericRange'];
    }

    /**
     * Sets numericRange
     * @param string $numericRange
     * @return $this
     */
    public function setNumericRange($numericRange)
    {
        $allowed_values = array('gt', 'gte', 'lt', 'lte', 'eq', 'ne');
        if (!in_array($numericRange, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'numericRange', must be one of 'gt', 'gte', 'lt', 'lte', 'eq', 'ne'");
        }
        $this->container['numericRange'] = $numericRange;

        return $this;
    }

    /**
     * Gets statistic
     * @return string
     */
    public function getStatistic()
    {
        return $this->container['statistic'];
    }

    /**
     * Sets statistic
     * @param string $statistic
     * @return $this
     */
    public function setStatistic($statistic)
    {
        $allowed_values = array('count', 'min', 'ratio', 'max');
        if (!in_array($statistic, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'statistic', must be one of 'count', 'min', 'ratio', 'max'");
        }
        $this->container['statistic'] = $statistic;

        return $this;
    }

    /**
     * Gets value
     * @return float
     */
    public function getValue()
    {
        return $this->container['value'];
    }

    /**
     * Sets value
     * @param float $value
     * @return $this
     */
    public function setValue($value)
    {
        $this->container['value'] = $value;

        return $this;
    }

    /**
     * Gets unread
     * @return bool
     */
    public function getUnread()
    {
        return $this->container['unread'];
    }

    /**
     * Sets unread
     * @param bool $unread
     * @return $this
     */
    public function setUnread($unread)
    {
        $this->container['unread'] = $unread;

        return $this;
    }

    /**
     * Gets startDate
     * @return \DateTime
     */
    public function getStartDate()
    {
        return $this->container['startDate'];
    }

    /**
     * Sets startDate
     * @param \DateTime $startDate
     * @return $this
     */
    public function setStartDate($startDate)
    {
        $this->container['startDate'] = $startDate;

        return $this;
    }

    /**
     * Gets endDate
     * @return \DateTime
     */
    public function getEndDate()
    {
        return $this->container['endDate'];
    }

    /**
     * Sets endDate
     * @param \DateTime $endDate
     * @return $this
     */
    public function setEndDate($endDate)
    {
        $this->container['endDate'] = $endDate;

        return $this;
    }

    /**
     * Gets notificationUsers
     * @return \PureCloudSDK\HeartBeatAlertNotificationNotificationUsers[]
     */
    public function getNotificationUsers()
    {
        return $this->container['notificationUsers'];
    }

    /**
     * Sets notificationUsers
     * @param \PureCloudSDK\HeartBeatAlertNotificationNotificationUsers[] $notificationUsers
     * @return $this
     */
    public function setNotificationUsers($notificationUsers)
    {
        $this->container['notificationUsers'] = $notificationUsers;

        return $this;
    }

    /**
     * Gets alertTypes
     * @return string[]
     */
    public function getAlertTypes()
    {
        return $this->container['alertTypes'];
    }

    /**
     * Sets alertTypes
     * @param string[] $alertTypes
     * @return $this
     */
    public function setAlertTypes($alertTypes)
    {
        $allowed_values = array('SMS', 'DEVICE', 'EMAIL');
        if (!in_array($alertTypes, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'alertTypes', must be one of 'SMS', 'DEVICE', 'EMAIL'");
        }
        $this->container['alertTypes'] = $alertTypes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


