# PureCloudSDK\AttributesApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteAttributeId**](AttributesApi.md#deleteAttributeId) | **DELETE** /api/v2/attributes/{attributeId} | Delete an existing Attribute.
[**getAttributeId**](AttributesApi.md#getAttributeId) | **GET** /api/v2/attributes/{attributeId} | Get details about an existing attribute.
[**getAttributes**](AttributesApi.md#getAttributes) | **GET** /api/v2/attributes | Gets a list of existing attributes.
[**postAttributes**](AttributesApi.md#postAttributes) | **POST** /api/v2/attributes | Create an attribute.
[**postQuery**](AttributesApi.md#postQuery) | **POST** /api/v2/attributes/query | Query attributes
[**putAttributeId**](AttributesApi.md#putAttributeId) | **PUT** /api/v2/attributes/{attributeId} | Update an existing attribute.


# **deleteAttributeId**
> deleteAttributeId($attributeId)

Delete an existing Attribute.

This will remove attribute.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AttributesApi();
$attributeId = "attributeId_example"; // string | Attribute ID

try {
    $api_instance->deleteAttributeId($attributeId);
} catch (Exception $e) {
    echo 'Exception when calling AttributesApi->deleteAttributeId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **attributeId** | **string**| Attribute ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAttributeId**
> \PureCloudSDK\Attribute getAttributeId($attributeId)

Get details about an existing attribute.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AttributesApi();
$attributeId = "attributeId_example"; // string | Attribute ID

try {
    $result = $api_instance->getAttributeId($attributeId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AttributesApi->getAttributeId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **attributeId** | **string**| Attribute ID |

### Return type

[**\PureCloudSDK\Attribute**](../Model/Attribute.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAttributes**
> \PureCloudSDK\AttributeEntityListing getAttributes($pageNumber, $pageSize)

Gets a list of existing attributes.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AttributesApi();
$pageNumber = 1; // int | Page number
$pageSize = 25; // int | Page size

try {
    $result = $api_instance->getAttributes($pageNumber, $pageSize);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AttributesApi->getAttributes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **pageSize** | **int**| Page size | [optional] [default to 25]

### Return type

[**\PureCloudSDK\AttributeEntityListing**](../Model/AttributeEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAttributes**
> \PureCloudSDK\Attribute postAttributes($body)

Create an attribute.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AttributesApi();
$body = new \PureCloudSDK\Attribute(); // \PureCloudSDK\Attribute | Attribute

try {
    $result = $api_instance->postAttributes($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AttributesApi->postAttributes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Attribute**](../Model/\PureCloudSDK\Attribute.md)| Attribute |

### Return type

[**\PureCloudSDK\Attribute**](../Model/Attribute.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postQuery**
> \PureCloudSDK\AttributeEntityListing postQuery($body)

Query attributes



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AttributesApi();
$body = new \PureCloudSDK\AttributeQueryRequest(); // \PureCloudSDK\AttributeQueryRequest | query

try {
    $result = $api_instance->postQuery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AttributesApi->postQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\AttributeQueryRequest**](../Model/\PureCloudSDK\AttributeQueryRequest.md)| query |

### Return type

[**\PureCloudSDK\AttributeEntityListing**](../Model/AttributeEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putAttributeId**
> \PureCloudSDK\Attribute putAttributeId($attributeId, $body)

Update an existing attribute.

Fields that can be updated: name, description. The most recent version is required for updates.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AttributesApi();
$attributeId = "attributeId_example"; // string | Attribute ID
$body = new \PureCloudSDK\Attribute(); // \PureCloudSDK\Attribute | Attribute

try {
    $result = $api_instance->putAttributeId($attributeId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AttributesApi->putAttributeId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **attributeId** | **string**| Attribute ID |
 **body** | [**\PureCloudSDK\Attribute**](../Model/\PureCloudSDK\Attribute.md)| Attribute |

### Return type

[**\PureCloudSDK\Attribute**](../Model/Attribute.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

