# PureCloudSDK\FaxApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteDocumentsDocumentId**](FaxApi.md#deleteDocumentsDocumentId) | **DELETE** /api/v2/fax/documents/{documentId} | Delete a fax document.
[**getDocuments**](FaxApi.md#getDocuments) | **GET** /api/v2/fax/documents | Get a list of fax documents.
[**getDocumentsDocumentId**](FaxApi.md#getDocumentsDocumentId) | **GET** /api/v2/fax/documents/{documentId} | Get a document.
[**getDocumentsDocumentIdContent**](FaxApi.md#getDocumentsDocumentIdContent) | **GET** /api/v2/fax/documents/{documentId}/content | Download a fax document.
[**getSummary**](FaxApi.md#getSummary) | **GET** /api/v2/fax/summary | Get fax summary
[**putDocumentsDocumentId**](FaxApi.md#putDocumentsDocumentId) | **PUT** /api/v2/fax/documents/{documentId} | Update a fax document.


# **deleteDocumentsDocumentId**
> deleteDocumentsDocumentId($documentId)

Delete a fax document.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\FaxApi();
$documentId = "documentId_example"; // string | Document ID

try {
    $api_instance->deleteDocumentsDocumentId($documentId);
} catch (Exception $e) {
    echo 'Exception when calling FaxApi->deleteDocumentsDocumentId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **documentId** | **string**| Document ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getDocuments**
> \PureCloudSDK\FaxDocumentEntityListing getDocuments($pageSize, $pageNumber)

Get a list of fax documents.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\FaxApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number

try {
    $result = $api_instance->getDocuments($pageSize, $pageNumber);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FaxApi->getDocuments: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\FaxDocumentEntityListing**](../Model/FaxDocumentEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getDocumentsDocumentId**
> \PureCloudSDK\FaxDocument getDocumentsDocumentId($documentId)

Get a document.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\FaxApi();
$documentId = "documentId_example"; // string | Document ID

try {
    $result = $api_instance->getDocumentsDocumentId($documentId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FaxApi->getDocumentsDocumentId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **documentId** | **string**| Document ID |

### Return type

[**\PureCloudSDK\FaxDocument**](../Model/FaxDocument.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getDocumentsDocumentIdContent**
> \PureCloudSDK\DownloadResponse getDocumentsDocumentIdContent($documentId)

Download a fax document.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\FaxApi();
$documentId = "documentId_example"; // string | Document ID

try {
    $result = $api_instance->getDocumentsDocumentIdContent($documentId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FaxApi->getDocumentsDocumentIdContent: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **documentId** | **string**| Document ID |

### Return type

[**\PureCloudSDK\DownloadResponse**](../Model/DownloadResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSummary**
> \PureCloudSDK\FaxSummary getSummary()

Get fax summary



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\FaxApi();

try {
    $result = $api_instance->getSummary();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FaxApi->getSummary: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\FaxSummary**](../Model/FaxSummary.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putDocumentsDocumentId**
> \PureCloudSDK\FaxDocument putDocumentsDocumentId($documentId, $body)

Update a fax document.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\FaxApi();
$documentId = "documentId_example"; // string | Document ID
$body = new \PureCloudSDK\FaxDocument(); // \PureCloudSDK\FaxDocument | Document

try {
    $result = $api_instance->putDocumentsDocumentId($documentId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FaxApi->putDocumentsDocumentId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **documentId** | **string**| Document ID |
 **body** | [**\PureCloudSDK\FaxDocument**](../Model/\PureCloudSDK\FaxDocument.md)| Document |

### Return type

[**\PureCloudSDK\FaxDocument**](../Model/FaxDocument.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

