# PureCloudSDK\LocationsApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getLocationId**](LocationsApi.md#getLocationId) | **GET** /api/v2/locations/{locationId} | Get Location by ID.
[**getLocations**](LocationsApi.md#getLocations) | **GET** /api/v2/locations | Get a list of all locations.
[**getSearch**](LocationsApi.md#getSearch) | **GET** /api/v2/locations/search | Search locations using the q64 value returned from a previous search
[**postSearch**](LocationsApi.md#postSearch) | **POST** /api/v2/locations/search | Search locations


# **getLocationId**
> \PureCloudSDK\LocationDefinition getLocationId($locationId)

Get Location by ID.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\LocationsApi();
$locationId = "locationId_example"; // string | Location ID

try {
    $result = $api_instance->getLocationId($locationId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LocationsApi->getLocationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **locationId** | **string**| Location ID |

### Return type

[**\PureCloudSDK\LocationDefinition**](../Model/LocationDefinition.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getLocations**
> \PureCloudSDK\LocationDefinition[] getLocations($pageSize, $pageNumber, $sortOrder)

Get a list of all locations.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\LocationsApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$sortOrder = "sortOrder_example"; // string | Sort order

try {
    $result = $api_instance->getLocations($pageSize, $pageNumber, $sortOrder);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LocationsApi->getLocations: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **sortOrder** | **string**| Sort order | [optional]

### Return type

[**\PureCloudSDK\LocationDefinition[]**](../Model/LocationDefinition.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSearch**
> \PureCloudSDK\LocationsSearchResponse getSearch($q64, $expand)

Search locations using the q64 value returned from a previous search



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\LocationsApi();
$q64 = "q64_example"; // string | q64
$expand = array("expand_example"); // string[] | expand

try {
    $result = $api_instance->getSearch($q64, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LocationsApi->getSearch: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **q64** | **string**| q64 |
 **expand** | [**string[]**](../Model/string.md)| expand | [optional]

### Return type

[**\PureCloudSDK\LocationsSearchResponse**](../Model/LocationsSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postSearch**
> \PureCloudSDK\LocationsSearchResponse postSearch($body)

Search locations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\LocationsApi();
$body = new \PureCloudSDK\LocationSearchRequest(); // \PureCloudSDK\LocationSearchRequest | Search request options

try {
    $result = $api_instance->postSearch($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LocationsApi->postSearch: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\LocationSearchRequest**](../Model/\PureCloudSDK\LocationSearchRequest.md)| Search request options |

### Return type

[**\PureCloudSDK\LocationsSearchResponse**](../Model/LocationsSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

