# PureCloudSDK\NotificationsApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteChannelsChannelIdSubscriptions**](NotificationsApi.md#deleteChannelsChannelIdSubscriptions) | **DELETE** /api/v2/notifications/channels/{channelId}/subscriptions | Remove all subscriptions
[**getAvailabletopics**](NotificationsApi.md#getAvailabletopics) | **GET** /api/v2/notifications/availabletopics | Get available notification topics.
[**getChannels**](NotificationsApi.md#getChannels) | **GET** /api/v2/notifications/channels | The list of existing channels
[**getChannelsChannelIdSubscriptions**](NotificationsApi.md#getChannelsChannelIdSubscriptions) | **GET** /api/v2/notifications/channels/{channelId}/subscriptions | The list of all subscriptions for this channel
[**postChannels**](NotificationsApi.md#postChannels) | **POST** /api/v2/notifications/channels | Create a new channel
[**postChannelsChannelIdSubscriptions**](NotificationsApi.md#postChannelsChannelIdSubscriptions) | **POST** /api/v2/notifications/channels/{channelId}/subscriptions | Add a list of subscriptions to the existing list of subscriptions
[**putChannelsChannelIdSubscriptions**](NotificationsApi.md#putChannelsChannelIdSubscriptions) | **PUT** /api/v2/notifications/channels/{channelId}/subscriptions | Replace the current list of subscriptions with a new list.


# **deleteChannelsChannelIdSubscriptions**
> string deleteChannelsChannelIdSubscriptions($channelId)

Remove all subscriptions



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\NotificationsApi();
$channelId = "channelId_example"; // string | Channel ID

try {
    $result = $api_instance->deleteChannelsChannelIdSubscriptions($channelId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling NotificationsApi->deleteChannelsChannelIdSubscriptions: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **channelId** | **string**| Channel ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAvailabletopics**
> \PureCloudSDK\AvailableTopicEntityListing getAvailabletopics($expand)

Get available notification topics.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\NotificationsApi();
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $result = $api_instance->getAvailabletopics($expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling NotificationsApi->getAvailabletopics: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\AvailableTopicEntityListing**](../Model/AvailableTopicEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getChannels**
> \PureCloudSDK\ChannelEntityListing getChannels()

The list of existing channels



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\NotificationsApi();

try {
    $result = $api_instance->getChannels();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling NotificationsApi->getChannels: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\ChannelEntityListing**](../Model/ChannelEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getChannelsChannelIdSubscriptions**
> \PureCloudSDK\ChannelTopicEntityListing getChannelsChannelIdSubscriptions($channelId)

The list of all subscriptions for this channel



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\NotificationsApi();
$channelId = "channelId_example"; // string | Channel ID

try {
    $result = $api_instance->getChannelsChannelIdSubscriptions($channelId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling NotificationsApi->getChannelsChannelIdSubscriptions: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **channelId** | **string**| Channel ID |

### Return type

[**\PureCloudSDK\ChannelTopicEntityListing**](../Model/ChannelTopicEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postChannels**
> \PureCloudSDK\Channel postChannels()

Create a new channel

There is a limit of 10 channels. Creating an 11th channel will remove the channel with oldest last used date.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\NotificationsApi();

try {
    $result = $api_instance->postChannels();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling NotificationsApi->postChannels: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\Channel**](../Model/Channel.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postChannelsChannelIdSubscriptions**
> \PureCloudSDK\ChannelTopicEntityListing postChannelsChannelIdSubscriptions($channelId, $body)

Add a list of subscriptions to the existing list of subscriptions



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\NotificationsApi();
$channelId = "channelId_example"; // string | Channel ID
$body = array(new ChannelTopic()); // \PureCloudSDK\ChannelTopic[] | Topic

try {
    $result = $api_instance->postChannelsChannelIdSubscriptions($channelId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling NotificationsApi->postChannelsChannelIdSubscriptions: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **channelId** | **string**| Channel ID |
 **body** | [**\PureCloudSDK\ChannelTopic[]**](../Model/ChannelTopic.md)| Topic |

### Return type

[**\PureCloudSDK\ChannelTopicEntityListing**](../Model/ChannelTopicEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putChannelsChannelIdSubscriptions**
> \PureCloudSDK\ChannelTopicEntityListing putChannelsChannelIdSubscriptions($channelId, $body)

Replace the current list of subscriptions with a new list.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\NotificationsApi();
$channelId = "channelId_example"; // string | Channel ID
$body = array(new ChannelTopic()); // \PureCloudSDK\ChannelTopic[] | Topic

try {
    $result = $api_instance->putChannelsChannelIdSubscriptions($channelId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling NotificationsApi->putChannelsChannelIdSubscriptions: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **channelId** | **string**| Channel ID |
 **body** | [**\PureCloudSDK\ChannelTopic[]**](../Model/ChannelTopic.md)| Topic |

### Return type

[**\PureCloudSDK\ChannelTopicEntityListing**](../Model/ChannelTopicEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

