# PureCloudSDK\SearchApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getSearch**](SearchApi.md#getSearch) | **GET** /api/v2/groups/search | Search groups using the q64 value returned from a previous search
[**getSearch_0**](SearchApi.md#getSearch_0) | **GET** /api/v2/locations/search | Search locations using the q64 value returned from a previous search
[**getSearch_1**](SearchApi.md#getSearch_1) | **GET** /api/v2/search | Search using the q64 value returned from a previous search.
[**getSearch_2**](SearchApi.md#getSearch_2) | **GET** /api/v2/users/search | Search users using the q64 value returned from a previous search
[**getSuggest**](SearchApi.md#getSuggest) | **GET** /api/v2/search/suggest | Suggest resources using the q64 value returned from a previous suggest query.
[**postSearch**](SearchApi.md#postSearch) | **POST** /api/v2/groups/search | Search groups
[**postSearch_0**](SearchApi.md#postSearch_0) | **POST** /api/v2/locations/search | Search locations
[**postSearch_1**](SearchApi.md#postSearch_1) | **POST** /api/v2/search | Search resources.
[**postSearch_2**](SearchApi.md#postSearch_2) | **POST** /api/v2/users/search | Search users
[**postSuggest**](SearchApi.md#postSuggest) | **POST** /api/v2/search/suggest | Suggest resources.


# **getSearch**
> \PureCloudSDK\GroupsSearchResponse getSearch($q64, $expand)

Search groups using the q64 value returned from a previous search



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\SearchApi();
$q64 = "q64_example"; // string | q64
$expand = array("expand_example"); // string[] | expand

try {
    $result = $api_instance->getSearch($q64, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SearchApi->getSearch: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **q64** | **string**| q64 |
 **expand** | [**string[]**](../Model/string.md)| expand | [optional]

### Return type

[**\PureCloudSDK\GroupsSearchResponse**](../Model/GroupsSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSearch_0**
> \PureCloudSDK\LocationsSearchResponse getSearch_0($q64, $expand)

Search locations using the q64 value returned from a previous search



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\SearchApi();
$q64 = "q64_example"; // string | q64
$expand = array("expand_example"); // string[] | expand

try {
    $result = $api_instance->getSearch_0($q64, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SearchApi->getSearch_0: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **q64** | **string**| q64 |
 **expand** | [**string[]**](../Model/string.md)| expand | [optional]

### Return type

[**\PureCloudSDK\LocationsSearchResponse**](../Model/LocationsSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSearch_1**
> \PureCloudSDK\JsonNodeSearchResponse getSearch_1($q64, $expand, $profile)

Search using the q64 value returned from a previous search.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\SearchApi();
$q64 = "q64_example"; // string | q64
$expand = array("expand_example"); // string[] | expand
$profile = true; // bool | profile

try {
    $result = $api_instance->getSearch_1($q64, $expand, $profile);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SearchApi->getSearch_1: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **q64** | **string**| q64 |
 **expand** | [**string[]**](../Model/string.md)| expand | [optional]
 **profile** | **bool**| profile | [optional] [default to true]

### Return type

[**\PureCloudSDK\JsonNodeSearchResponse**](../Model/JsonNodeSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSearch_2**
> \PureCloudSDK\UsersSearchResponse getSearch_2($q64, $expand)

Search users using the q64 value returned from a previous search



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\SearchApi();
$q64 = "q64_example"; // string | q64
$expand = array("expand_example"); // string[] | expand

try {
    $result = $api_instance->getSearch_2($q64, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SearchApi->getSearch_2: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **q64** | **string**| q64 |
 **expand** | [**string[]**](../Model/string.md)| expand | [optional]

### Return type

[**\PureCloudSDK\UsersSearchResponse**](../Model/UsersSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSuggest**
> \PureCloudSDK\JsonNodeSearchResponse getSuggest($q64, $profile)

Suggest resources using the q64 value returned from a previous suggest query.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\SearchApi();
$q64 = "q64_example"; // string | q64
$profile = true; // bool | profile

try {
    $result = $api_instance->getSuggest($q64, $profile);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SearchApi->getSuggest: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **q64** | **string**| q64 |
 **profile** | **bool**| profile | [optional] [default to true]

### Return type

[**\PureCloudSDK\JsonNodeSearchResponse**](../Model/JsonNodeSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postSearch**
> \PureCloudSDK\GroupsSearchResponse postSearch($body)

Search groups



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\SearchApi();
$body = new \PureCloudSDK\GroupSearchRequest(); // \PureCloudSDK\GroupSearchRequest | Search request options

try {
    $result = $api_instance->postSearch($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SearchApi->postSearch: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\GroupSearchRequest**](../Model/\PureCloudSDK\GroupSearchRequest.md)| Search request options |

### Return type

[**\PureCloudSDK\GroupsSearchResponse**](../Model/GroupsSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postSearch_0**
> \PureCloudSDK\LocationsSearchResponse postSearch_0($body)

Search locations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\SearchApi();
$body = new \PureCloudSDK\LocationSearchRequest(); // \PureCloudSDK\LocationSearchRequest | Search request options

try {
    $result = $api_instance->postSearch_0($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SearchApi->postSearch_0: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\LocationSearchRequest**](../Model/\PureCloudSDK\LocationSearchRequest.md)| Search request options |

### Return type

[**\PureCloudSDK\LocationsSearchResponse**](../Model/LocationsSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postSearch_1**
> \PureCloudSDK\JsonNodeSearchResponse postSearch_1($body, $profile)

Search resources.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\SearchApi();
$body = new \PureCloudSDK\SearchRequest(); // \PureCloudSDK\SearchRequest | Search request options
$profile = true; // bool | profile

try {
    $result = $api_instance->postSearch_1($body, $profile);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SearchApi->postSearch_1: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\SearchRequest**](../Model/\PureCloudSDK\SearchRequest.md)| Search request options |
 **profile** | **bool**| profile | [optional] [default to true]

### Return type

[**\PureCloudSDK\JsonNodeSearchResponse**](../Model/JsonNodeSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postSearch_2**
> \PureCloudSDK\UsersSearchResponse postSearch_2($body)

Search users



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\SearchApi();
$body = new \PureCloudSDK\UserSearchRequest(); // \PureCloudSDK\UserSearchRequest | Search request options

try {
    $result = $api_instance->postSearch_2($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SearchApi->postSearch_2: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\UserSearchRequest**](../Model/\PureCloudSDK\UserSearchRequest.md)| Search request options |

### Return type

[**\PureCloudSDK\UsersSearchResponse**](../Model/UsersSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postSuggest**
> \PureCloudSDK\JsonNodeSearchResponse postSuggest($body, $profile)

Suggest resources.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\SearchApi();
$body = new \PureCloudSDK\SuggestSearchRequest(); // \PureCloudSDK\SuggestSearchRequest | Search request options
$profile = true; // bool | profile

try {
    $result = $api_instance->postSuggest($body, $profile);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SearchApi->postSuggest: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\SuggestSearchRequest**](../Model/\PureCloudSDK\SuggestSearchRequest.md)| Search request options |
 **profile** | **bool**| profile | [optional] [default to true]

### Return type

[**\PureCloudSDK\JsonNodeSearchResponse**](../Model/JsonNodeSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

