<?php
/**
 * ConversationsApi
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK\Api;

use \PureCloudSDK\Configuration;
use \PureCloudSDK\ApiClient;
use \PureCloudSDK\ApiException;
use \PureCloudSDK\ObjectSerializer;

/**
 * ConversationsApi Class Doc Comment
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ConversationsApi
{

    /**
     * API Client
     *
     * @var \PureCloudSDK\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \PureCloudSDK\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\PureCloudSDK\ApiClient $apiClient = null)
    {
        if ($apiClient == null) {
            $apiClient = new ApiClient();
            $apiClient->getConfig()->setHost('https://api.mypurecloud.com');
        }

        $this->apiClient = $apiClient;
    }

    /**
     * Get API client
     *
     * @return \PureCloudSDK\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \PureCloudSDK\ApiClient $apiClient set the API client
     *
     * @return ConversationsApi
     */
    public function setApiClient(\PureCloudSDK\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation deleteCallsCallIdParticipantsParticipantIdConsult
     *
     * Cancel the transfer
     *
     * @param string $callId callId (required)
     * @param string $participantId participantId (required)
     * @return string
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteCallsCallIdParticipantsParticipantIdConsult($callId, $participantId)
    {
        list($response) = $this->deleteCallsCallIdParticipantsParticipantIdConsultWithHttpInfo($callId, $participantId);
        return $response;
    }

    /**
     * Operation deleteCallsCallIdParticipantsParticipantIdConsultWithHttpInfo
     *
     * Cancel the transfer
     *
     * @param string $callId callId (required)
     * @param string $participantId participantId (required)
     * @return Array of string, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteCallsCallIdParticipantsParticipantIdConsultWithHttpInfo($callId, $participantId)
    {
        // verify the required parameter 'callId' is set
        if ($callId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $callId when calling deleteCallsCallIdParticipantsParticipantIdConsult');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling deleteCallsCallIdParticipantsParticipantIdConsult');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/calls/{callId}/participants/{participantId}/consult";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($callId !== null) {
            $resourcePath = str_replace(
                "{" . "callId" . "}",
                $this->apiClient->getSerializer()->toPathValue($callId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                'string',
                '/api/v2/conversations/calls/{callId}/participants/{participantId}/consult'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, 'string', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), 'string', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteConversationIdParticipantsParticipantIdCodesAddcommunicationcode
     *
     * Delete a code used to add a communication to this participant
     *
     * @param string $conversationId conversation ID (required)
     * @param string $participantId participant ID (required)
     * @param string $addCommunicationCode addCommunicationCode (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteConversationIdParticipantsParticipantIdCodesAddcommunicationcode($conversationId, $participantId, $addCommunicationCode)
    {
        list($response) = $this->deleteConversationIdParticipantsParticipantIdCodesAddcommunicationcodeWithHttpInfo($conversationId, $participantId, $addCommunicationCode);
        return $response;
    }

    /**
     * Operation deleteConversationIdParticipantsParticipantIdCodesAddcommunicationcodeWithHttpInfo
     *
     * Delete a code used to add a communication to this participant
     *
     * @param string $conversationId conversation ID (required)
     * @param string $participantId participant ID (required)
     * @param string $addCommunicationCode addCommunicationCode (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteConversationIdParticipantsParticipantIdCodesAddcommunicationcodeWithHttpInfo($conversationId, $participantId, $addCommunicationCode)
    {
        // verify the required parameter 'conversationId' is set
        if ($conversationId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $conversationId when calling deleteConversationIdParticipantsParticipantIdCodesAddcommunicationcode');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling deleteConversationIdParticipantsParticipantIdCodesAddcommunicationcode');
        }
        // verify the required parameter 'addCommunicationCode' is set
        if ($addCommunicationCode === null) {
            throw new \InvalidArgumentException('Missing the required parameter $addCommunicationCode when calling deleteConversationIdParticipantsParticipantIdCodesAddcommunicationcode');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/{conversationId}/participants/{participantId}/codes/{addCommunicationCode}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($conversationId !== null) {
            $resourcePath = str_replace(
                "{" . "conversationId" . "}",
                $this->apiClient->getSerializer()->toPathValue($conversationId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // path params
        if ($addCommunicationCode !== null) {
            $resourcePath = str_replace(
                "{" . "addCommunicationCode" . "}",
                $this->apiClient->getSerializer()->toPathValue($addCommunicationCode),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/{conversationId}/participants/{participantId}/codes/{addCommunicationCode}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteEmailsEmailIdMessagesDraftAttachmentsAttachmentId
     *
     * Delete attachment from draft
     *
     * @param string $emailId emailId (required)
     * @param string $attachmentId attachmentId (required)
     * @return string
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteEmailsEmailIdMessagesDraftAttachmentsAttachmentId($emailId, $attachmentId)
    {
        list($response) = $this->deleteEmailsEmailIdMessagesDraftAttachmentsAttachmentIdWithHttpInfo($emailId, $attachmentId);
        return $response;
    }

    /**
     * Operation deleteEmailsEmailIdMessagesDraftAttachmentsAttachmentIdWithHttpInfo
     *
     * Delete attachment from draft
     *
     * @param string $emailId emailId (required)
     * @param string $attachmentId attachmentId (required)
     * @return Array of string, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteEmailsEmailIdMessagesDraftAttachmentsAttachmentIdWithHttpInfo($emailId, $attachmentId)
    {
        // verify the required parameter 'emailId' is set
        if ($emailId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $emailId when calling deleteEmailsEmailIdMessagesDraftAttachmentsAttachmentId');
        }
        // verify the required parameter 'attachmentId' is set
        if ($attachmentId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $attachmentId when calling deleteEmailsEmailIdMessagesDraftAttachmentsAttachmentId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/emails/{emailId}/messages/draft/attachments/{attachmentId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($emailId !== null) {
            $resourcePath = str_replace(
                "{" . "emailId" . "}",
                $this->apiClient->getSerializer()->toPathValue($emailId),
                $resourcePath
            );
        }
        // path params
        if ($attachmentId !== null) {
            $resourcePath = str_replace(
                "{" . "attachmentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($attachmentId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                'string',
                '/api/v2/conversations/emails/{emailId}/messages/draft/attachments/{attachmentId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, 'string', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), 'string', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getCallbacks
     *
     * Get callback conversations
     *
     * @return \PureCloudSDK\CallbackConversationEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallbacks()
    {
        list($response) = $this->getCallbacksWithHttpInfo();
        return $response;
    }

    /**
     * Operation getCallbacksWithHttpInfo
     *
     * Get callback conversations
     *
     * @return Array of \PureCloudSDK\CallbackConversationEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallbacksWithHttpInfo()
    {
        // parse inputs
        $resourcePath = "/api/v2/conversations/callbacks";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\CallbackConversationEntityListing',
                '/api/v2/conversations/callbacks'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\CallbackConversationEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\CallbackConversationEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getCallbacksCallbackId
     *
     * Get callback conversation
     *
     * @param string $callbackId callbackId (required)
     * @return \PureCloudSDK\CallbackConversation
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallbacksCallbackId($callbackId)
    {
        list($response) = $this->getCallbacksCallbackIdWithHttpInfo($callbackId);
        return $response;
    }

    /**
     * Operation getCallbacksCallbackIdWithHttpInfo
     *
     * Get callback conversation
     *
     * @param string $callbackId callbackId (required)
     * @return Array of \PureCloudSDK\CallbackConversation, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallbacksCallbackIdWithHttpInfo($callbackId)
    {
        // verify the required parameter 'callbackId' is set
        if ($callbackId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $callbackId when calling getCallbacksCallbackId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/callbacks/{callbackId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($callbackId !== null) {
            $resourcePath = str_replace(
                "{" . "callbackId" . "}",
                $this->apiClient->getSerializer()->toPathValue($callbackId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\CallbackConversation',
                '/api/v2/conversations/callbacks/{callbackId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\CallbackConversation', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\CallbackConversation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getCallbacksCallbackIdParticipantsParticipantIdWrapup
     *
     * Get the wrap-up for this conversation participant.
     *
     * @param string $callbackId callbackId (required)
     * @param string $participantId participantId (required)
     * @param bool $provisional Indicates if the wrap-up code is provisional. (optional, default to false)
     * @return \PureCloudSDK\Wrapup
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallbacksCallbackIdParticipantsParticipantIdWrapup($callbackId, $participantId, $provisional = null)
    {
        list($response) = $this->getCallbacksCallbackIdParticipantsParticipantIdWrapupWithHttpInfo($callbackId, $participantId, $provisional);
        return $response;
    }

    /**
     * Operation getCallbacksCallbackIdParticipantsParticipantIdWrapupWithHttpInfo
     *
     * Get the wrap-up for this conversation participant.
     *
     * @param string $callbackId callbackId (required)
     * @param string $participantId participantId (required)
     * @param bool $provisional Indicates if the wrap-up code is provisional. (optional, default to false)
     * @return Array of \PureCloudSDK\Wrapup, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallbacksCallbackIdParticipantsParticipantIdWrapupWithHttpInfo($callbackId, $participantId, $provisional = null)
    {
        // verify the required parameter 'callbackId' is set
        if ($callbackId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $callbackId when calling getCallbacksCallbackIdParticipantsParticipantIdWrapup');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling getCallbacksCallbackIdParticipantsParticipantIdWrapup');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/wrapup";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($provisional !== null) {
            $queryParams['provisional'] = $this->apiClient->getSerializer()->toQueryValue($provisional);
        }
        // path params
        if ($callbackId !== null) {
            $resourcePath = str_replace(
                "{" . "callbackId" . "}",
                $this->apiClient->getSerializer()->toPathValue($callbackId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Wrapup',
                '/api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/wrapup'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Wrapup', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Wrapup', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getCallbacksCallbackIdParticipantsParticipantIdWrapupcodes
     *
     * Get list of wrapup codes for this conversation participant
     *
     * @param string $callbackId callbackId (required)
     * @param string $participantId participantId (required)
     * @return \PureCloudSDK\WrapupCode[]
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallbacksCallbackIdParticipantsParticipantIdWrapupcodes($callbackId, $participantId)
    {
        list($response) = $this->getCallbacksCallbackIdParticipantsParticipantIdWrapupcodesWithHttpInfo($callbackId, $participantId);
        return $response;
    }

    /**
     * Operation getCallbacksCallbackIdParticipantsParticipantIdWrapupcodesWithHttpInfo
     *
     * Get list of wrapup codes for this conversation participant
     *
     * @param string $callbackId callbackId (required)
     * @param string $participantId participantId (required)
     * @return Array of \PureCloudSDK\WrapupCode[], HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallbacksCallbackIdParticipantsParticipantIdWrapupcodesWithHttpInfo($callbackId, $participantId)
    {
        // verify the required parameter 'callbackId' is set
        if ($callbackId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $callbackId when calling getCallbacksCallbackIdParticipantsParticipantIdWrapupcodes');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling getCallbacksCallbackIdParticipantsParticipantIdWrapupcodes');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/wrapupcodes";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($callbackId !== null) {
            $resourcePath = str_replace(
                "{" . "callbackId" . "}",
                $this->apiClient->getSerializer()->toPathValue($callbackId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WrapupCode[]',
                '/api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/wrapupcodes'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WrapupCode[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WrapupCode[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getCalls
     *
     * Get recent conversations
     *
     * @return \PureCloudSDK\CallConversationEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCalls()
    {
        list($response) = $this->getCallsWithHttpInfo();
        return $response;
    }

    /**
     * Operation getCallsWithHttpInfo
     *
     * Get recent conversations
     *
     * @return Array of \PureCloudSDK\CallConversationEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallsWithHttpInfo()
    {
        // parse inputs
        $resourcePath = "/api/v2/conversations/calls";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\CallConversationEntityListing',
                '/api/v2/conversations/calls'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\CallConversationEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\CallConversationEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getCallsCallId
     *
     * Get call conversation
     *
     * @param string $callId callId (required)
     * @return \PureCloudSDK\CallConversation
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallsCallId($callId)
    {
        list($response) = $this->getCallsCallIdWithHttpInfo($callId);
        return $response;
    }

    /**
     * Operation getCallsCallIdWithHttpInfo
     *
     * Get call conversation
     *
     * @param string $callId callId (required)
     * @return Array of \PureCloudSDK\CallConversation, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallsCallIdWithHttpInfo($callId)
    {
        // verify the required parameter 'callId' is set
        if ($callId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $callId when calling getCallsCallId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/calls/{callId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($callId !== null) {
            $resourcePath = str_replace(
                "{" . "callId" . "}",
                $this->apiClient->getSerializer()->toPathValue($callId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\CallConversation',
                '/api/v2/conversations/calls/{callId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\CallConversation', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\CallConversation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getCallsCallIdParticipantsParticipantIdWrapup
     *
     * Get the wrap-up for this conversation participant.
     *
     * @param string $callId callId (required)
     * @param string $participantId participantId (required)
     * @param bool $provisional Indicates if the wrap-up code is provisional. (optional, default to false)
     * @return \PureCloudSDK\Wrapup
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallsCallIdParticipantsParticipantIdWrapup($callId, $participantId, $provisional = null)
    {
        list($response) = $this->getCallsCallIdParticipantsParticipantIdWrapupWithHttpInfo($callId, $participantId, $provisional);
        return $response;
    }

    /**
     * Operation getCallsCallIdParticipantsParticipantIdWrapupWithHttpInfo
     *
     * Get the wrap-up for this conversation participant.
     *
     * @param string $callId callId (required)
     * @param string $participantId participantId (required)
     * @param bool $provisional Indicates if the wrap-up code is provisional. (optional, default to false)
     * @return Array of \PureCloudSDK\Wrapup, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallsCallIdParticipantsParticipantIdWrapupWithHttpInfo($callId, $participantId, $provisional = null)
    {
        // verify the required parameter 'callId' is set
        if ($callId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $callId when calling getCallsCallIdParticipantsParticipantIdWrapup');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling getCallsCallIdParticipantsParticipantIdWrapup');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/calls/{callId}/participants/{participantId}/wrapup";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($provisional !== null) {
            $queryParams['provisional'] = $this->apiClient->getSerializer()->toQueryValue($provisional);
        }
        // path params
        if ($callId !== null) {
            $resourcePath = str_replace(
                "{" . "callId" . "}",
                $this->apiClient->getSerializer()->toPathValue($callId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Wrapup',
                '/api/v2/conversations/calls/{callId}/participants/{participantId}/wrapup'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Wrapup', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Wrapup', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getCallsCallIdParticipantsParticipantIdWrapupcodes
     *
     * Get list of wrapup codes for this conversation participant
     *
     * @param string $callId callId (required)
     * @param string $participantId participantId (required)
     * @return \PureCloudSDK\WrapupCode[]
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallsCallIdParticipantsParticipantIdWrapupcodes($callId, $participantId)
    {
        list($response) = $this->getCallsCallIdParticipantsParticipantIdWrapupcodesWithHttpInfo($callId, $participantId);
        return $response;
    }

    /**
     * Operation getCallsCallIdParticipantsParticipantIdWrapupcodesWithHttpInfo
     *
     * Get list of wrapup codes for this conversation participant
     *
     * @param string $callId callId (required)
     * @param string $participantId participantId (required)
     * @return Array of \PureCloudSDK\WrapupCode[], HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallsCallIdParticipantsParticipantIdWrapupcodesWithHttpInfo($callId, $participantId)
    {
        // verify the required parameter 'callId' is set
        if ($callId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $callId when calling getCallsCallIdParticipantsParticipantIdWrapupcodes');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling getCallsCallIdParticipantsParticipantIdWrapupcodes');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/calls/{callId}/participants/{participantId}/wrapupcodes";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($callId !== null) {
            $resourcePath = str_replace(
                "{" . "callId" . "}",
                $this->apiClient->getSerializer()->toPathValue($callId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WrapupCode[]',
                '/api/v2/conversations/calls/{callId}/participants/{participantId}/wrapupcodes'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WrapupCode[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WrapupCode[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getCallsHistory
     *
     * Get call history
     *
     * @param int $pageSize Page size (optional, default to 25)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param string $interval Interval string; format is ISO-8601. Separate start and end times with forward slash &#39;/&#39; (optional)
     * @return \PureCloudSDK\CallConversationEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallsHistory($pageSize = null, $pageNumber = null, $interval = null)
    {
        list($response) = $this->getCallsHistoryWithHttpInfo($pageSize, $pageNumber, $interval);
        return $response;
    }

    /**
     * Operation getCallsHistoryWithHttpInfo
     *
     * Get call history
     *
     * @param int $pageSize Page size (optional, default to 25)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param string $interval Interval string; format is ISO-8601. Separate start and end times with forward slash &#39;/&#39; (optional)
     * @return Array of \PureCloudSDK\CallConversationEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallsHistoryWithHttpInfo($pageSize = null, $pageNumber = null, $interval = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/conversations/calls/history";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($interval !== null) {
            $queryParams['interval'] = $this->apiClient->getSerializer()->toQueryValue($interval);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\CallConversationEntityListing',
                '/api/v2/conversations/calls/history'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\CallConversationEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\CallConversationEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getCallsMaximumconferenceparties
     *
     * Get the maximum number of participants that this user can have on a conference
     *
     * @return \PureCloudSDK\MaxParticipants
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallsMaximumconferenceparties()
    {
        list($response) = $this->getCallsMaximumconferencepartiesWithHttpInfo();
        return $response;
    }

    /**
     * Operation getCallsMaximumconferencepartiesWithHttpInfo
     *
     * Get the maximum number of participants that this user can have on a conference
     *
     * @return Array of \PureCloudSDK\MaxParticipants, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallsMaximumconferencepartiesWithHttpInfo()
    {
        // parse inputs
        $resourcePath = "/api/v2/conversations/calls/maximumconferenceparties";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\MaxParticipants',
                '/api/v2/conversations/calls/maximumconferenceparties'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\MaxParticipants', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\MaxParticipants', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getChats
     *
     * Get recent chat conversations
     *
     * @return \PureCloudSDK\ChatConversationEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getChats()
    {
        list($response) = $this->getChatsWithHttpInfo();
        return $response;
    }

    /**
     * Operation getChatsWithHttpInfo
     *
     * Get recent chat conversations
     *
     * @return Array of \PureCloudSDK\ChatConversationEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getChatsWithHttpInfo()
    {
        // parse inputs
        $resourcePath = "/api/v2/conversations/chats";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ChatConversationEntityListing',
                '/api/v2/conversations/chats'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ChatConversationEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ChatConversationEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getChatsChatId
     *
     * Get chat conversation
     *
     * @param string $chatId chatId (required)
     * @return \PureCloudSDK\ChatConversation
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getChatsChatId($chatId)
    {
        list($response) = $this->getChatsChatIdWithHttpInfo($chatId);
        return $response;
    }

    /**
     * Operation getChatsChatIdWithHttpInfo
     *
     * Get chat conversation
     *
     * @param string $chatId chatId (required)
     * @return Array of \PureCloudSDK\ChatConversation, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getChatsChatIdWithHttpInfo($chatId)
    {
        // verify the required parameter 'chatId' is set
        if ($chatId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $chatId when calling getChatsChatId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/chats/{chatId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($chatId !== null) {
            $resourcePath = str_replace(
                "{" . "chatId" . "}",
                $this->apiClient->getSerializer()->toPathValue($chatId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ChatConversation',
                '/api/v2/conversations/chats/{chatId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ChatConversation', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ChatConversation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getChatsChatIdParticipantsParticipantIdWrapup
     *
     * Get the wrap-up for this conversation participant.
     *
     * @param string $chatId chatId (required)
     * @param string $participantId participantId (required)
     * @param bool $provisional Indicates if the wrap-up code is provisional. (optional, default to false)
     * @return \PureCloudSDK\Wrapup
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getChatsChatIdParticipantsParticipantIdWrapup($chatId, $participantId, $provisional = null)
    {
        list($response) = $this->getChatsChatIdParticipantsParticipantIdWrapupWithHttpInfo($chatId, $participantId, $provisional);
        return $response;
    }

    /**
     * Operation getChatsChatIdParticipantsParticipantIdWrapupWithHttpInfo
     *
     * Get the wrap-up for this conversation participant.
     *
     * @param string $chatId chatId (required)
     * @param string $participantId participantId (required)
     * @param bool $provisional Indicates if the wrap-up code is provisional. (optional, default to false)
     * @return Array of \PureCloudSDK\Wrapup, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getChatsChatIdParticipantsParticipantIdWrapupWithHttpInfo($chatId, $participantId, $provisional = null)
    {
        // verify the required parameter 'chatId' is set
        if ($chatId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $chatId when calling getChatsChatIdParticipantsParticipantIdWrapup');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling getChatsChatIdParticipantsParticipantIdWrapup');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/chats/{chatId}/participants/{participantId}/wrapup";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($provisional !== null) {
            $queryParams['provisional'] = $this->apiClient->getSerializer()->toQueryValue($provisional);
        }
        // path params
        if ($chatId !== null) {
            $resourcePath = str_replace(
                "{" . "chatId" . "}",
                $this->apiClient->getSerializer()->toPathValue($chatId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Wrapup',
                '/api/v2/conversations/chats/{chatId}/participants/{participantId}/wrapup'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Wrapup', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Wrapup', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getChatsChatIdParticipantsParticipantIdWrapupcodes
     *
     * Get list of wrapup codes for this conversation participant
     *
     * @param string $chatId chatId (required)
     * @param string $participantId participantId (required)
     * @return \PureCloudSDK\WrapupCode[]
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getChatsChatIdParticipantsParticipantIdWrapupcodes($chatId, $participantId)
    {
        list($response) = $this->getChatsChatIdParticipantsParticipantIdWrapupcodesWithHttpInfo($chatId, $participantId);
        return $response;
    }

    /**
     * Operation getChatsChatIdParticipantsParticipantIdWrapupcodesWithHttpInfo
     *
     * Get list of wrapup codes for this conversation participant
     *
     * @param string $chatId chatId (required)
     * @param string $participantId participantId (required)
     * @return Array of \PureCloudSDK\WrapupCode[], HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getChatsChatIdParticipantsParticipantIdWrapupcodesWithHttpInfo($chatId, $participantId)
    {
        // verify the required parameter 'chatId' is set
        if ($chatId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $chatId when calling getChatsChatIdParticipantsParticipantIdWrapupcodes');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling getChatsChatIdParticipantsParticipantIdWrapupcodes');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/chats/{chatId}/participants/{participantId}/wrapupcodes";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($chatId !== null) {
            $resourcePath = str_replace(
                "{" . "chatId" . "}",
                $this->apiClient->getSerializer()->toPathValue($chatId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WrapupCode[]',
                '/api/v2/conversations/chats/{chatId}/participants/{participantId}/wrapupcodes'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WrapupCode[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WrapupCode[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getCobrowsesessions
     *
     * Get recent cobrowse conversations
     *
     * @return \PureCloudSDK\CobrowseConversationEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCobrowsesessions()
    {
        list($response) = $this->getCobrowsesessionsWithHttpInfo();
        return $response;
    }

    /**
     * Operation getCobrowsesessionsWithHttpInfo
     *
     * Get recent cobrowse conversations
     *
     * @return Array of \PureCloudSDK\CobrowseConversationEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCobrowsesessionsWithHttpInfo()
    {
        // parse inputs
        $resourcePath = "/api/v2/conversations/cobrowsesessions";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\CobrowseConversationEntityListing',
                '/api/v2/conversations/cobrowsesessions'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\CobrowseConversationEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\CobrowseConversationEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getCobrowsesessionsCobrowseId
     *
     * Get cobrowse conversation
     *
     * @param string $cobrowseId cobrowseId (required)
     * @return \PureCloudSDK\CobrowseConversation
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCobrowsesessionsCobrowseId($cobrowseId)
    {
        list($response) = $this->getCobrowsesessionsCobrowseIdWithHttpInfo($cobrowseId);
        return $response;
    }

    /**
     * Operation getCobrowsesessionsCobrowseIdWithHttpInfo
     *
     * Get cobrowse conversation
     *
     * @param string $cobrowseId cobrowseId (required)
     * @return Array of \PureCloudSDK\CobrowseConversation, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCobrowsesessionsCobrowseIdWithHttpInfo($cobrowseId)
    {
        // verify the required parameter 'cobrowseId' is set
        if ($cobrowseId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $cobrowseId when calling getCobrowsesessionsCobrowseId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/cobrowsesessions/{cobrowseId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($cobrowseId !== null) {
            $resourcePath = str_replace(
                "{" . "cobrowseId" . "}",
                $this->apiClient->getSerializer()->toPathValue($cobrowseId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\CobrowseConversation',
                '/api/v2/conversations/cobrowsesessions/{cobrowseId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\CobrowseConversation', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\CobrowseConversation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapup
     *
     * Get the wrap-up for this conversation participant.
     *
     * @param string $cobrowseId cobrowseId (required)
     * @param string $participantId participantId (required)
     * @param bool $provisional Indicates if the wrap-up code is provisional. (optional, default to false)
     * @return \PureCloudSDK\Wrapup
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapup($cobrowseId, $participantId, $provisional = null)
    {
        list($response) = $this->getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapupWithHttpInfo($cobrowseId, $participantId, $provisional);
        return $response;
    }

    /**
     * Operation getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapupWithHttpInfo
     *
     * Get the wrap-up for this conversation participant.
     *
     * @param string $cobrowseId cobrowseId (required)
     * @param string $participantId participantId (required)
     * @param bool $provisional Indicates if the wrap-up code is provisional. (optional, default to false)
     * @return Array of \PureCloudSDK\Wrapup, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapupWithHttpInfo($cobrowseId, $participantId, $provisional = null)
    {
        // verify the required parameter 'cobrowseId' is set
        if ($cobrowseId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $cobrowseId when calling getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapup');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapup');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/wrapup";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($provisional !== null) {
            $queryParams['provisional'] = $this->apiClient->getSerializer()->toQueryValue($provisional);
        }
        // path params
        if ($cobrowseId !== null) {
            $resourcePath = str_replace(
                "{" . "cobrowseId" . "}",
                $this->apiClient->getSerializer()->toPathValue($cobrowseId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Wrapup',
                '/api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/wrapup'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Wrapup', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Wrapup', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapupcodes
     *
     * Get list of wrapup codes for this conversation participant
     *
     * @param string $cobrowseId cobrowseId (required)
     * @param string $participantId participantId (required)
     * @return \PureCloudSDK\WrapupCode[]
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapupcodes($cobrowseId, $participantId)
    {
        list($response) = $this->getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapupcodesWithHttpInfo($cobrowseId, $participantId);
        return $response;
    }

    /**
     * Operation getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapupcodesWithHttpInfo
     *
     * Get list of wrapup codes for this conversation participant
     *
     * @param string $cobrowseId cobrowseId (required)
     * @param string $participantId participantId (required)
     * @return Array of \PureCloudSDK\WrapupCode[], HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapupcodesWithHttpInfo($cobrowseId, $participantId)
    {
        // verify the required parameter 'cobrowseId' is set
        if ($cobrowseId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $cobrowseId when calling getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapupcodes');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapupcodes');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/wrapupcodes";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($cobrowseId !== null) {
            $resourcePath = str_replace(
                "{" . "cobrowseId" . "}",
                $this->apiClient->getSerializer()->toPathValue($cobrowseId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WrapupCode[]',
                '/api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/wrapupcodes'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WrapupCode[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WrapupCode[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getConversationId
     *
     * Get conversation
     *
     * @param string $conversationId conversation ID (required)
     * @return \PureCloudSDK\Conversation
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getConversationId($conversationId)
    {
        list($response) = $this->getConversationIdWithHttpInfo($conversationId);
        return $response;
    }

    /**
     * Operation getConversationIdWithHttpInfo
     *
     * Get conversation
     *
     * @param string $conversationId conversation ID (required)
     * @return Array of \PureCloudSDK\Conversation, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getConversationIdWithHttpInfo($conversationId)
    {
        // verify the required parameter 'conversationId' is set
        if ($conversationId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $conversationId when calling getConversationId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/{conversationId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($conversationId !== null) {
            $resourcePath = str_replace(
                "{" . "conversationId" . "}",
                $this->apiClient->getSerializer()->toPathValue($conversationId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Conversation',
                '/api/v2/conversations/{conversationId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Conversation', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Conversation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getConversationIdParticipantsParticipantIdWrapup
     *
     * Get the wrap-up for this conversation participant.
     *
     * @param string $conversationId conversation ID (required)
     * @param string $participantId participant ID (required)
     * @param bool $provisional Indicates if the wrap-up code is provisional. (optional, default to false)
     * @return \PureCloudSDK\WrapupCode
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getConversationIdParticipantsParticipantIdWrapup($conversationId, $participantId, $provisional = null)
    {
        list($response) = $this->getConversationIdParticipantsParticipantIdWrapupWithHttpInfo($conversationId, $participantId, $provisional);
        return $response;
    }

    /**
     * Operation getConversationIdParticipantsParticipantIdWrapupWithHttpInfo
     *
     * Get the wrap-up for this conversation participant.
     *
     * @param string $conversationId conversation ID (required)
     * @param string $participantId participant ID (required)
     * @param bool $provisional Indicates if the wrap-up code is provisional. (optional, default to false)
     * @return Array of \PureCloudSDK\WrapupCode, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getConversationIdParticipantsParticipantIdWrapupWithHttpInfo($conversationId, $participantId, $provisional = null)
    {
        // verify the required parameter 'conversationId' is set
        if ($conversationId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $conversationId when calling getConversationIdParticipantsParticipantIdWrapup');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling getConversationIdParticipantsParticipantIdWrapup');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/{conversationId}/participants/{participantId}/wrapup";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($provisional !== null) {
            $queryParams['provisional'] = $this->apiClient->getSerializer()->toQueryValue($provisional);
        }
        // path params
        if ($conversationId !== null) {
            $resourcePath = str_replace(
                "{" . "conversationId" . "}",
                $this->apiClient->getSerializer()->toPathValue($conversationId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WrapupCode',
                '/api/v2/conversations/{conversationId}/participants/{participantId}/wrapup'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WrapupCode', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WrapupCode', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getConversationIdParticipantsParticipantIdWrapupcodes
     *
     * Get list of wrapup codes for this conversation participant
     *
     * @param string $conversationId conversation ID (required)
     * @param string $participantId participant ID (required)
     * @return \PureCloudSDK\WrapupCode[]
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getConversationIdParticipantsParticipantIdWrapupcodes($conversationId, $participantId)
    {
        list($response) = $this->getConversationIdParticipantsParticipantIdWrapupcodesWithHttpInfo($conversationId, $participantId);
        return $response;
    }

    /**
     * Operation getConversationIdParticipantsParticipantIdWrapupcodesWithHttpInfo
     *
     * Get list of wrapup codes for this conversation participant
     *
     * @param string $conversationId conversation ID (required)
     * @param string $participantId participant ID (required)
     * @return Array of \PureCloudSDK\WrapupCode[], HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getConversationIdParticipantsParticipantIdWrapupcodesWithHttpInfo($conversationId, $participantId)
    {
        // verify the required parameter 'conversationId' is set
        if ($conversationId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $conversationId when calling getConversationIdParticipantsParticipantIdWrapupcodes');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling getConversationIdParticipantsParticipantIdWrapupcodes');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/{conversationId}/participants/{participantId}/wrapupcodes";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($conversationId !== null) {
            $resourcePath = str_replace(
                "{" . "conversationId" . "}",
                $this->apiClient->getSerializer()->toPathValue($conversationId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WrapupCode[]',
                '/api/v2/conversations/{conversationId}/participants/{participantId}/wrapupcodes'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WrapupCode[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WrapupCode[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getConversations
     *
     * Get conversations
     *
     * @param string $communicationType Call or Chat communication filtering (optional)
     * @return \PureCloudSDK\ConversationEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getConversations($communicationType = null)
    {
        list($response) = $this->getConversationsWithHttpInfo($communicationType);
        return $response;
    }

    /**
     * Operation getConversationsWithHttpInfo
     *
     * Get conversations
     *
     * @param string $communicationType Call or Chat communication filtering (optional)
     * @return Array of \PureCloudSDK\ConversationEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getConversationsWithHttpInfo($communicationType = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/conversations";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($communicationType !== null) {
            $queryParams['communicationType'] = $this->apiClient->getSerializer()->toQueryValue($communicationType);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ConversationEntityListing',
                '/api/v2/conversations'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ConversationEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ConversationEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getConversationsConversationIdDetails
     *
     * Get a conversation by id
     *
     * @param string $conversationId conversationId (required)
     * @return \PureCloudSDK\AnalyticsConversation
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getConversationsConversationIdDetails($conversationId)
    {
        list($response) = $this->getConversationsConversationIdDetailsWithHttpInfo($conversationId);
        return $response;
    }

    /**
     * Operation getConversationsConversationIdDetailsWithHttpInfo
     *
     * Get a conversation by id
     *
     * @param string $conversationId conversationId (required)
     * @return Array of \PureCloudSDK\AnalyticsConversation, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getConversationsConversationIdDetailsWithHttpInfo($conversationId)
    {
        // verify the required parameter 'conversationId' is set
        if ($conversationId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $conversationId when calling getConversationsConversationIdDetails');
        }
        // parse inputs
        $resourcePath = "/api/v2/analytics/conversations/{conversationId}/details";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($conversationId !== null) {
            $resourcePath = str_replace(
                "{" . "conversationId" . "}",
                $this->apiClient->getSerializer()->toPathValue($conversationId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\AnalyticsConversation',
                '/api/v2/analytics/conversations/{conversationId}/details'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\AnalyticsConversation', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\AnalyticsConversation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getEmails
     *
     * Get recent email conversations
     *
     * @return \PureCloudSDK\EmailConversationEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getEmails()
    {
        list($response) = $this->getEmailsWithHttpInfo();
        return $response;
    }

    /**
     * Operation getEmailsWithHttpInfo
     *
     * Get recent email conversations
     *
     * @return Array of \PureCloudSDK\EmailConversationEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getEmailsWithHttpInfo()
    {
        // parse inputs
        $resourcePath = "/api/v2/conversations/emails";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\EmailConversationEntityListing',
                '/api/v2/conversations/emails'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\EmailConversationEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\EmailConversationEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getEmailsEmailId
     *
     * Get email conversation
     *
     * @param string $emailId emailId (required)
     * @return \PureCloudSDK\EmailConversation
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getEmailsEmailId($emailId)
    {
        list($response) = $this->getEmailsEmailIdWithHttpInfo($emailId);
        return $response;
    }

    /**
     * Operation getEmailsEmailIdWithHttpInfo
     *
     * Get email conversation
     *
     * @param string $emailId emailId (required)
     * @return Array of \PureCloudSDK\EmailConversation, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getEmailsEmailIdWithHttpInfo($emailId)
    {
        // verify the required parameter 'emailId' is set
        if ($emailId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $emailId when calling getEmailsEmailId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/emails/{emailId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($emailId !== null) {
            $resourcePath = str_replace(
                "{" . "emailId" . "}",
                $this->apiClient->getSerializer()->toPathValue($emailId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\EmailConversation',
                '/api/v2/conversations/emails/{emailId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\EmailConversation', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\EmailConversation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getEmailsEmailIdMessages
     *
     * Get conversation messages
     *
     * @param string $emailId emailId (required)
     * @return \PureCloudSDK\EmailMessageListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getEmailsEmailIdMessages($emailId)
    {
        list($response) = $this->getEmailsEmailIdMessagesWithHttpInfo($emailId);
        return $response;
    }

    /**
     * Operation getEmailsEmailIdMessagesWithHttpInfo
     *
     * Get conversation messages
     *
     * @param string $emailId emailId (required)
     * @return Array of \PureCloudSDK\EmailMessageListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getEmailsEmailIdMessagesWithHttpInfo($emailId)
    {
        // verify the required parameter 'emailId' is set
        if ($emailId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $emailId when calling getEmailsEmailIdMessages');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/emails/{emailId}/messages";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($emailId !== null) {
            $resourcePath = str_replace(
                "{" . "emailId" . "}",
                $this->apiClient->getSerializer()->toPathValue($emailId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\EmailMessageListing',
                '/api/v2/conversations/emails/{emailId}/messages'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\EmailMessageListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\EmailMessageListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getEmailsEmailIdMessagesDraft
     *
     * Get conversation draft reply
     *
     * @param string $emailId emailId (required)
     * @return \PureCloudSDK\EmailMessage
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getEmailsEmailIdMessagesDraft($emailId)
    {
        list($response) = $this->getEmailsEmailIdMessagesDraftWithHttpInfo($emailId);
        return $response;
    }

    /**
     * Operation getEmailsEmailIdMessagesDraftWithHttpInfo
     *
     * Get conversation draft reply
     *
     * @param string $emailId emailId (required)
     * @return Array of \PureCloudSDK\EmailMessage, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getEmailsEmailIdMessagesDraftWithHttpInfo($emailId)
    {
        // verify the required parameter 'emailId' is set
        if ($emailId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $emailId when calling getEmailsEmailIdMessagesDraft');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/emails/{emailId}/messages/draft";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($emailId !== null) {
            $resourcePath = str_replace(
                "{" . "emailId" . "}",
                $this->apiClient->getSerializer()->toPathValue($emailId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\EmailMessage',
                '/api/v2/conversations/emails/{emailId}/messages/draft'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\EmailMessage', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\EmailMessage', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getEmailsEmailIdMessagesMessageId
     *
     * Get conversation message
     *
     * @param string $emailId emailId (required)
     * @param string $messageId messageId (required)
     * @return \PureCloudSDK\EmailMessage
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getEmailsEmailIdMessagesMessageId($emailId, $messageId)
    {
        list($response) = $this->getEmailsEmailIdMessagesMessageIdWithHttpInfo($emailId, $messageId);
        return $response;
    }

    /**
     * Operation getEmailsEmailIdMessagesMessageIdWithHttpInfo
     *
     * Get conversation message
     *
     * @param string $emailId emailId (required)
     * @param string $messageId messageId (required)
     * @return Array of \PureCloudSDK\EmailMessage, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getEmailsEmailIdMessagesMessageIdWithHttpInfo($emailId, $messageId)
    {
        // verify the required parameter 'emailId' is set
        if ($emailId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $emailId when calling getEmailsEmailIdMessagesMessageId');
        }
        // verify the required parameter 'messageId' is set
        if ($messageId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $messageId when calling getEmailsEmailIdMessagesMessageId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/emails/{emailId}/messages/{messageId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($emailId !== null) {
            $resourcePath = str_replace(
                "{" . "emailId" . "}",
                $this->apiClient->getSerializer()->toPathValue($emailId),
                $resourcePath
            );
        }
        // path params
        if ($messageId !== null) {
            $resourcePath = str_replace(
                "{" . "messageId" . "}",
                $this->apiClient->getSerializer()->toPathValue($messageId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\EmailMessage',
                '/api/v2/conversations/emails/{emailId}/messages/{messageId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\EmailMessage', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\EmailMessage', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getEmailsEmailIdParticipantsParticipantIdWrapup
     *
     * Get the wrap-up for this conversation participant.
     *
     * @param string $emailId emailId (required)
     * @param string $participantId participantId (required)
     * @param bool $provisional Indicates if the wrap-up code is provisional. (optional, default to false)
     * @return \PureCloudSDK\Wrapup
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getEmailsEmailIdParticipantsParticipantIdWrapup($emailId, $participantId, $provisional = null)
    {
        list($response) = $this->getEmailsEmailIdParticipantsParticipantIdWrapupWithHttpInfo($emailId, $participantId, $provisional);
        return $response;
    }

    /**
     * Operation getEmailsEmailIdParticipantsParticipantIdWrapupWithHttpInfo
     *
     * Get the wrap-up for this conversation participant.
     *
     * @param string $emailId emailId (required)
     * @param string $participantId participantId (required)
     * @param bool $provisional Indicates if the wrap-up code is provisional. (optional, default to false)
     * @return Array of \PureCloudSDK\Wrapup, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getEmailsEmailIdParticipantsParticipantIdWrapupWithHttpInfo($emailId, $participantId, $provisional = null)
    {
        // verify the required parameter 'emailId' is set
        if ($emailId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $emailId when calling getEmailsEmailIdParticipantsParticipantIdWrapup');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling getEmailsEmailIdParticipantsParticipantIdWrapup');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/emails/{emailId}/participants/{participantId}/wrapup";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($provisional !== null) {
            $queryParams['provisional'] = $this->apiClient->getSerializer()->toQueryValue($provisional);
        }
        // path params
        if ($emailId !== null) {
            $resourcePath = str_replace(
                "{" . "emailId" . "}",
                $this->apiClient->getSerializer()->toPathValue($emailId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Wrapup',
                '/api/v2/conversations/emails/{emailId}/participants/{participantId}/wrapup'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Wrapup', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Wrapup', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getEmailsEmailIdParticipantsParticipantIdWrapupcodes
     *
     * Get list of wrapup codes for this conversation participant
     *
     * @param string $emailId emailId (required)
     * @param string $participantId participantId (required)
     * @return \PureCloudSDK\WrapupCode[]
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getEmailsEmailIdParticipantsParticipantIdWrapupcodes($emailId, $participantId)
    {
        list($response) = $this->getEmailsEmailIdParticipantsParticipantIdWrapupcodesWithHttpInfo($emailId, $participantId);
        return $response;
    }

    /**
     * Operation getEmailsEmailIdParticipantsParticipantIdWrapupcodesWithHttpInfo
     *
     * Get list of wrapup codes for this conversation participant
     *
     * @param string $emailId emailId (required)
     * @param string $participantId participantId (required)
     * @return Array of \PureCloudSDK\WrapupCode[], HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getEmailsEmailIdParticipantsParticipantIdWrapupcodesWithHttpInfo($emailId, $participantId)
    {
        // verify the required parameter 'emailId' is set
        if ($emailId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $emailId when calling getEmailsEmailIdParticipantsParticipantIdWrapupcodes');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling getEmailsEmailIdParticipantsParticipantIdWrapupcodes');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/emails/{emailId}/participants/{participantId}/wrapupcodes";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($emailId !== null) {
            $resourcePath = str_replace(
                "{" . "emailId" . "}",
                $this->apiClient->getSerializer()->toPathValue($emailId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WrapupCode[]',
                '/api/v2/conversations/emails/{emailId}/participants/{participantId}/wrapupcodes'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WrapupCode[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WrapupCode[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchCallbacksCallbackId
     *
     * Update a conversation by disconnecting all of the participants
     *
     * @param string $callbackId callbackId (required)
     * @param \PureCloudSDK\Conversation $body Conversation (required)
     * @return \PureCloudSDK\Conversation
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCallbacksCallbackId($callbackId, $body)
    {
        list($response) = $this->patchCallbacksCallbackIdWithHttpInfo($callbackId, $body);
        return $response;
    }

    /**
     * Operation patchCallbacksCallbackIdWithHttpInfo
     *
     * Update a conversation by disconnecting all of the participants
     *
     * @param string $callbackId callbackId (required)
     * @param \PureCloudSDK\Conversation $body Conversation (required)
     * @return Array of \PureCloudSDK\Conversation, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCallbacksCallbackIdWithHttpInfo($callbackId, $body)
    {
        // verify the required parameter 'callbackId' is set
        if ($callbackId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $callbackId when calling patchCallbacksCallbackId');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchCallbacksCallbackId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/callbacks/{callbackId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($callbackId !== null) {
            $resourcePath = str_replace(
                "{" . "callbackId" . "}",
                $this->apiClient->getSerializer()->toPathValue($callbackId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Conversation',
                '/api/v2/conversations/callbacks/{callbackId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Conversation', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Conversation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchCallbacksCallbackIdParticipantsParticipantId
     *
     * Update conversation participant
     *
     * @param string $callbackId callbackId (required)
     * @param string $participantId participantId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Participant (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCallbacksCallbackIdParticipantsParticipantId($callbackId, $participantId, $body)
    {
        list($response) = $this->patchCallbacksCallbackIdParticipantsParticipantIdWithHttpInfo($callbackId, $participantId, $body);
        return $response;
    }

    /**
     * Operation patchCallbacksCallbackIdParticipantsParticipantIdWithHttpInfo
     *
     * Update conversation participant
     *
     * @param string $callbackId callbackId (required)
     * @param string $participantId participantId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Participant (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCallbacksCallbackIdParticipantsParticipantIdWithHttpInfo($callbackId, $participantId, $body)
    {
        // verify the required parameter 'callbackId' is set
        if ($callbackId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $callbackId when calling patchCallbacksCallbackIdParticipantsParticipantId');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling patchCallbacksCallbackIdParticipantsParticipantId');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchCallbacksCallbackIdParticipantsParticipantId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/callbacks/{callbackId}/participants/{participantId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($callbackId !== null) {
            $resourcePath = str_replace(
                "{" . "callbackId" . "}",
                $this->apiClient->getSerializer()->toPathValue($callbackId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/callbacks/{callbackId}/participants/{participantId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchCallbacksCallbackIdParticipantsParticipantIdAttributes
     *
     * Update the attributes on a conversation participant.
     *
     * @param string $callbackId callbackId (required)
     * @param string $participantId participantId (required)
     * @param \PureCloudSDK\ParticipantAttributes $body Attributes (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCallbacksCallbackIdParticipantsParticipantIdAttributes($callbackId, $participantId, $body)
    {
        list($response) = $this->patchCallbacksCallbackIdParticipantsParticipantIdAttributesWithHttpInfo($callbackId, $participantId, $body);
        return $response;
    }

    /**
     * Operation patchCallbacksCallbackIdParticipantsParticipantIdAttributesWithHttpInfo
     *
     * Update the attributes on a conversation participant.
     *
     * @param string $callbackId callbackId (required)
     * @param string $participantId participantId (required)
     * @param \PureCloudSDK\ParticipantAttributes $body Attributes (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCallbacksCallbackIdParticipantsParticipantIdAttributesWithHttpInfo($callbackId, $participantId, $body)
    {
        // verify the required parameter 'callbackId' is set
        if ($callbackId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $callbackId when calling patchCallbacksCallbackIdParticipantsParticipantIdAttributes');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling patchCallbacksCallbackIdParticipantsParticipantIdAttributes');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchCallbacksCallbackIdParticipantsParticipantIdAttributes');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/attributes";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($callbackId !== null) {
            $resourcePath = str_replace(
                "{" . "callbackId" . "}",
                $this->apiClient->getSerializer()->toPathValue($callbackId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/attributes'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchCallbacksCallbackIdParticipantsParticipantIdCommunicationsCommunicationId
     *
     * Update conversation participant's communication by disconnecting it.
     *
     * @param string $callbackId callbackId (required)
     * @param string $participantId participantId (required)
     * @param string $communicationId communicationId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Participant (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCallbacksCallbackIdParticipantsParticipantIdCommunicationsCommunicationId($callbackId, $participantId, $communicationId, $body)
    {
        list($response) = $this->patchCallbacksCallbackIdParticipantsParticipantIdCommunicationsCommunicationIdWithHttpInfo($callbackId, $participantId, $communicationId, $body);
        return $response;
    }

    /**
     * Operation patchCallbacksCallbackIdParticipantsParticipantIdCommunicationsCommunicationIdWithHttpInfo
     *
     * Update conversation participant's communication by disconnecting it.
     *
     * @param string $callbackId callbackId (required)
     * @param string $participantId participantId (required)
     * @param string $communicationId communicationId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Participant (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCallbacksCallbackIdParticipantsParticipantIdCommunicationsCommunicationIdWithHttpInfo($callbackId, $participantId, $communicationId, $body)
    {
        // verify the required parameter 'callbackId' is set
        if ($callbackId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $callbackId when calling patchCallbacksCallbackIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling patchCallbacksCallbackIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // verify the required parameter 'communicationId' is set
        if ($communicationId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $communicationId when calling patchCallbacksCallbackIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchCallbacksCallbackIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/communications/{communicationId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($callbackId !== null) {
            $resourcePath = str_replace(
                "{" . "callbackId" . "}",
                $this->apiClient->getSerializer()->toPathValue($callbackId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // path params
        if ($communicationId !== null) {
            $resourcePath = str_replace(
                "{" . "communicationId" . "}",
                $this->apiClient->getSerializer()->toPathValue($communicationId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/communications/{communicationId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchCallsCallId
     *
     * Update a conversation by setting it's recording state, merging in other conversations to create a conference, or disconnecting all of the participants
     *
     * @param string $callId callId (required)
     * @param \PureCloudSDK\Conversation $body Conversation (required)
     * @return \PureCloudSDK\Conversation
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCallsCallId($callId, $body)
    {
        list($response) = $this->patchCallsCallIdWithHttpInfo($callId, $body);
        return $response;
    }

    /**
     * Operation patchCallsCallIdWithHttpInfo
     *
     * Update a conversation by setting it's recording state, merging in other conversations to create a conference, or disconnecting all of the participants
     *
     * @param string $callId callId (required)
     * @param \PureCloudSDK\Conversation $body Conversation (required)
     * @return Array of \PureCloudSDK\Conversation, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCallsCallIdWithHttpInfo($callId, $body)
    {
        // verify the required parameter 'callId' is set
        if ($callId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $callId when calling patchCallsCallId');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchCallsCallId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/calls/{callId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($callId !== null) {
            $resourcePath = str_replace(
                "{" . "callId" . "}",
                $this->apiClient->getSerializer()->toPathValue($callId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Conversation',
                '/api/v2/conversations/calls/{callId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Conversation', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Conversation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchCallsCallIdParticipantsParticipantId
     *
     * Update conversation participant
     *
     * @param string $callId callId (required)
     * @param string $participantId participantId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Participant request (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCallsCallIdParticipantsParticipantId($callId, $participantId, $body)
    {
        list($response) = $this->patchCallsCallIdParticipantsParticipantIdWithHttpInfo($callId, $participantId, $body);
        return $response;
    }

    /**
     * Operation patchCallsCallIdParticipantsParticipantIdWithHttpInfo
     *
     * Update conversation participant
     *
     * @param string $callId callId (required)
     * @param string $participantId participantId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Participant request (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCallsCallIdParticipantsParticipantIdWithHttpInfo($callId, $participantId, $body)
    {
        // verify the required parameter 'callId' is set
        if ($callId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $callId when calling patchCallsCallIdParticipantsParticipantId');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling patchCallsCallIdParticipantsParticipantId');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchCallsCallIdParticipantsParticipantId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/calls/{callId}/participants/{participantId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($callId !== null) {
            $resourcePath = str_replace(
                "{" . "callId" . "}",
                $this->apiClient->getSerializer()->toPathValue($callId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/calls/{callId}/participants/{participantId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchCallsCallIdParticipantsParticipantIdAttributes
     *
     * Update the attributes on a conversation participant.
     *
     * @param string $callId callId (required)
     * @param string $participantId participantId (required)
     * @param \PureCloudSDK\ParticipantAttributes $body Participant attributes (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCallsCallIdParticipantsParticipantIdAttributes($callId, $participantId, $body)
    {
        list($response) = $this->patchCallsCallIdParticipantsParticipantIdAttributesWithHttpInfo($callId, $participantId, $body);
        return $response;
    }

    /**
     * Operation patchCallsCallIdParticipantsParticipantIdAttributesWithHttpInfo
     *
     * Update the attributes on a conversation participant.
     *
     * @param string $callId callId (required)
     * @param string $participantId participantId (required)
     * @param \PureCloudSDK\ParticipantAttributes $body Participant attributes (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCallsCallIdParticipantsParticipantIdAttributesWithHttpInfo($callId, $participantId, $body)
    {
        // verify the required parameter 'callId' is set
        if ($callId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $callId when calling patchCallsCallIdParticipantsParticipantIdAttributes');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling patchCallsCallIdParticipantsParticipantIdAttributes');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchCallsCallIdParticipantsParticipantIdAttributes');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/calls/{callId}/participants/{participantId}/attributes";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($callId !== null) {
            $resourcePath = str_replace(
                "{" . "callId" . "}",
                $this->apiClient->getSerializer()->toPathValue($callId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/calls/{callId}/participants/{participantId}/attributes'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchCallsCallIdParticipantsParticipantIdCommunicationsCommunicationId
     *
     * Update conversation participant's communication by disconnecting it.
     *
     * @param string $callId callId (required)
     * @param string $participantId participantId (required)
     * @param string $communicationId communicationId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Participant (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCallsCallIdParticipantsParticipantIdCommunicationsCommunicationId($callId, $participantId, $communicationId, $body)
    {
        list($response) = $this->patchCallsCallIdParticipantsParticipantIdCommunicationsCommunicationIdWithHttpInfo($callId, $participantId, $communicationId, $body);
        return $response;
    }

    /**
     * Operation patchCallsCallIdParticipantsParticipantIdCommunicationsCommunicationIdWithHttpInfo
     *
     * Update conversation participant's communication by disconnecting it.
     *
     * @param string $callId callId (required)
     * @param string $participantId participantId (required)
     * @param string $communicationId communicationId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Participant (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCallsCallIdParticipantsParticipantIdCommunicationsCommunicationIdWithHttpInfo($callId, $participantId, $communicationId, $body)
    {
        // verify the required parameter 'callId' is set
        if ($callId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $callId when calling patchCallsCallIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling patchCallsCallIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // verify the required parameter 'communicationId' is set
        if ($communicationId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $communicationId when calling patchCallsCallIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchCallsCallIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/calls/{callId}/participants/{participantId}/communications/{communicationId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($callId !== null) {
            $resourcePath = str_replace(
                "{" . "callId" . "}",
                $this->apiClient->getSerializer()->toPathValue($callId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // path params
        if ($communicationId !== null) {
            $resourcePath = str_replace(
                "{" . "communicationId" . "}",
                $this->apiClient->getSerializer()->toPathValue($communicationId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/calls/{callId}/participants/{participantId}/communications/{communicationId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchCallsCallIdParticipantsParticipantIdConsult
     *
     * Change who can speak
     *
     * @param string $callId callId (required)
     * @param string $participantId participantId (required)
     * @param \PureCloudSDK\ConsultTransferUpdate $body new speak to (required)
     * @return \PureCloudSDK\ConsultTransferResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCallsCallIdParticipantsParticipantIdConsult($callId, $participantId, $body)
    {
        list($response) = $this->patchCallsCallIdParticipantsParticipantIdConsultWithHttpInfo($callId, $participantId, $body);
        return $response;
    }

    /**
     * Operation patchCallsCallIdParticipantsParticipantIdConsultWithHttpInfo
     *
     * Change who can speak
     *
     * @param string $callId callId (required)
     * @param string $participantId participantId (required)
     * @param \PureCloudSDK\ConsultTransferUpdate $body new speak to (required)
     * @return Array of \PureCloudSDK\ConsultTransferResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCallsCallIdParticipantsParticipantIdConsultWithHttpInfo($callId, $participantId, $body)
    {
        // verify the required parameter 'callId' is set
        if ($callId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $callId when calling patchCallsCallIdParticipantsParticipantIdConsult');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling patchCallsCallIdParticipantsParticipantIdConsult');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchCallsCallIdParticipantsParticipantIdConsult');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/calls/{callId}/participants/{participantId}/consult";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($callId !== null) {
            $resourcePath = str_replace(
                "{" . "callId" . "}",
                $this->apiClient->getSerializer()->toPathValue($callId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ConsultTransferResponse',
                '/api/v2/conversations/calls/{callId}/participants/{participantId}/consult'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ConsultTransferResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ConsultTransferResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchChatsChatId
     *
     * Update a conversation by disconnecting all of the participants
     *
     * @param string $chatId chatId (required)
     * @param \PureCloudSDK\Conversation $body Conversation (required)
     * @return \PureCloudSDK\Conversation
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchChatsChatId($chatId, $body)
    {
        list($response) = $this->patchChatsChatIdWithHttpInfo($chatId, $body);
        return $response;
    }

    /**
     * Operation patchChatsChatIdWithHttpInfo
     *
     * Update a conversation by disconnecting all of the participants
     *
     * @param string $chatId chatId (required)
     * @param \PureCloudSDK\Conversation $body Conversation (required)
     * @return Array of \PureCloudSDK\Conversation, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchChatsChatIdWithHttpInfo($chatId, $body)
    {
        // verify the required parameter 'chatId' is set
        if ($chatId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $chatId when calling patchChatsChatId');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchChatsChatId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/chats/{chatId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($chatId !== null) {
            $resourcePath = str_replace(
                "{" . "chatId" . "}",
                $this->apiClient->getSerializer()->toPathValue($chatId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Conversation',
                '/api/v2/conversations/chats/{chatId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Conversation', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Conversation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchChatsChatIdParticipantsParticipantId
     *
     * Update conversation participant
     *
     * @param string $chatId chatId (required)
     * @param string $participantId participantId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Update request (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchChatsChatIdParticipantsParticipantId($chatId, $participantId, $body)
    {
        list($response) = $this->patchChatsChatIdParticipantsParticipantIdWithHttpInfo($chatId, $participantId, $body);
        return $response;
    }

    /**
     * Operation patchChatsChatIdParticipantsParticipantIdWithHttpInfo
     *
     * Update conversation participant
     *
     * @param string $chatId chatId (required)
     * @param string $participantId participantId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Update request (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchChatsChatIdParticipantsParticipantIdWithHttpInfo($chatId, $participantId, $body)
    {
        // verify the required parameter 'chatId' is set
        if ($chatId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $chatId when calling patchChatsChatIdParticipantsParticipantId');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling patchChatsChatIdParticipantsParticipantId');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchChatsChatIdParticipantsParticipantId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/chats/{chatId}/participants/{participantId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($chatId !== null) {
            $resourcePath = str_replace(
                "{" . "chatId" . "}",
                $this->apiClient->getSerializer()->toPathValue($chatId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/chats/{chatId}/participants/{participantId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchChatsChatIdParticipantsParticipantIdAttributes
     *
     * Update the attributes on a conversation participant.
     *
     * @param string $chatId chatId (required)
     * @param string $participantId participantId (required)
     * @param \PureCloudSDK\ParticipantAttributes $body Participant attributes (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchChatsChatIdParticipantsParticipantIdAttributes($chatId, $participantId, $body)
    {
        list($response) = $this->patchChatsChatIdParticipantsParticipantIdAttributesWithHttpInfo($chatId, $participantId, $body);
        return $response;
    }

    /**
     * Operation patchChatsChatIdParticipantsParticipantIdAttributesWithHttpInfo
     *
     * Update the attributes on a conversation participant.
     *
     * @param string $chatId chatId (required)
     * @param string $participantId participantId (required)
     * @param \PureCloudSDK\ParticipantAttributes $body Participant attributes (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchChatsChatIdParticipantsParticipantIdAttributesWithHttpInfo($chatId, $participantId, $body)
    {
        // verify the required parameter 'chatId' is set
        if ($chatId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $chatId when calling patchChatsChatIdParticipantsParticipantIdAttributes');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling patchChatsChatIdParticipantsParticipantIdAttributes');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchChatsChatIdParticipantsParticipantIdAttributes');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/chats/{chatId}/participants/{participantId}/attributes";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($chatId !== null) {
            $resourcePath = str_replace(
                "{" . "chatId" . "}",
                $this->apiClient->getSerializer()->toPathValue($chatId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/chats/{chatId}/participants/{participantId}/attributes'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchChatsChatIdParticipantsParticipantIdCommunicationsCommunicationId
     *
     * Update conversation participant's communication by disconnecting it.
     *
     * @param string $chatId chatId (required)
     * @param string $participantId participantId (required)
     * @param string $communicationId communicationId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Participant (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchChatsChatIdParticipantsParticipantIdCommunicationsCommunicationId($chatId, $participantId, $communicationId, $body)
    {
        list($response) = $this->patchChatsChatIdParticipantsParticipantIdCommunicationsCommunicationIdWithHttpInfo($chatId, $participantId, $communicationId, $body);
        return $response;
    }

    /**
     * Operation patchChatsChatIdParticipantsParticipantIdCommunicationsCommunicationIdWithHttpInfo
     *
     * Update conversation participant's communication by disconnecting it.
     *
     * @param string $chatId chatId (required)
     * @param string $participantId participantId (required)
     * @param string $communicationId communicationId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Participant (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchChatsChatIdParticipantsParticipantIdCommunicationsCommunicationIdWithHttpInfo($chatId, $participantId, $communicationId, $body)
    {
        // verify the required parameter 'chatId' is set
        if ($chatId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $chatId when calling patchChatsChatIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling patchChatsChatIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // verify the required parameter 'communicationId' is set
        if ($communicationId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $communicationId when calling patchChatsChatIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchChatsChatIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/chats/{chatId}/participants/{participantId}/communications/{communicationId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($chatId !== null) {
            $resourcePath = str_replace(
                "{" . "chatId" . "}",
                $this->apiClient->getSerializer()->toPathValue($chatId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // path params
        if ($communicationId !== null) {
            $resourcePath = str_replace(
                "{" . "communicationId" . "}",
                $this->apiClient->getSerializer()->toPathValue($communicationId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/chats/{chatId}/participants/{participantId}/communications/{communicationId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchCobrowsesessionsCobrowseId
     *
     * Update a conversation by disconnecting all of the participants
     *
     * @param string $cobrowseId cobrowseId (required)
     * @param \PureCloudSDK\Conversation $body Conversation (required)
     * @return \PureCloudSDK\Conversation
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCobrowsesessionsCobrowseId($cobrowseId, $body)
    {
        list($response) = $this->patchCobrowsesessionsCobrowseIdWithHttpInfo($cobrowseId, $body);
        return $response;
    }

    /**
     * Operation patchCobrowsesessionsCobrowseIdWithHttpInfo
     *
     * Update a conversation by disconnecting all of the participants
     *
     * @param string $cobrowseId cobrowseId (required)
     * @param \PureCloudSDK\Conversation $body Conversation (required)
     * @return Array of \PureCloudSDK\Conversation, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCobrowsesessionsCobrowseIdWithHttpInfo($cobrowseId, $body)
    {
        // verify the required parameter 'cobrowseId' is set
        if ($cobrowseId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $cobrowseId when calling patchCobrowsesessionsCobrowseId');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchCobrowsesessionsCobrowseId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/cobrowsesessions/{cobrowseId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($cobrowseId !== null) {
            $resourcePath = str_replace(
                "{" . "cobrowseId" . "}",
                $this->apiClient->getSerializer()->toPathValue($cobrowseId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Conversation',
                '/api/v2/conversations/cobrowsesessions/{cobrowseId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Conversation', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Conversation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchCobrowsesessionsCobrowseIdParticipantsParticipantId
     *
     * Update conversation participant
     *
     * @param string $cobrowseId cobrowseId (required)
     * @param string $participantId participantId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body  (optional)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCobrowsesessionsCobrowseIdParticipantsParticipantId($cobrowseId, $participantId, $body = null)
    {
        list($response) = $this->patchCobrowsesessionsCobrowseIdParticipantsParticipantIdWithHttpInfo($cobrowseId, $participantId, $body);
        return $response;
    }

    /**
     * Operation patchCobrowsesessionsCobrowseIdParticipantsParticipantIdWithHttpInfo
     *
     * Update conversation participant
     *
     * @param string $cobrowseId cobrowseId (required)
     * @param string $participantId participantId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body  (optional)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCobrowsesessionsCobrowseIdParticipantsParticipantIdWithHttpInfo($cobrowseId, $participantId, $body = null)
    {
        // verify the required parameter 'cobrowseId' is set
        if ($cobrowseId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $cobrowseId when calling patchCobrowsesessionsCobrowseIdParticipantsParticipantId');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling patchCobrowsesessionsCobrowseIdParticipantsParticipantId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($cobrowseId !== null) {
            $resourcePath = str_replace(
                "{" . "cobrowseId" . "}",
                $this->apiClient->getSerializer()->toPathValue($cobrowseId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchCobrowsesessionsCobrowseIdParticipantsParticipantIdAttributes
     *
     * Update the attributes on a conversation participant.
     *
     * @param string $cobrowseId cobrowseId (required)
     * @param string $participantId participantId (required)
     * @param \PureCloudSDK\ParticipantAttributes $body  (optional)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCobrowsesessionsCobrowseIdParticipantsParticipantIdAttributes($cobrowseId, $participantId, $body = null)
    {
        list($response) = $this->patchCobrowsesessionsCobrowseIdParticipantsParticipantIdAttributesWithHttpInfo($cobrowseId, $participantId, $body);
        return $response;
    }

    /**
     * Operation patchCobrowsesessionsCobrowseIdParticipantsParticipantIdAttributesWithHttpInfo
     *
     * Update the attributes on a conversation participant.
     *
     * @param string $cobrowseId cobrowseId (required)
     * @param string $participantId participantId (required)
     * @param \PureCloudSDK\ParticipantAttributes $body  (optional)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCobrowsesessionsCobrowseIdParticipantsParticipantIdAttributesWithHttpInfo($cobrowseId, $participantId, $body = null)
    {
        // verify the required parameter 'cobrowseId' is set
        if ($cobrowseId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $cobrowseId when calling patchCobrowsesessionsCobrowseIdParticipantsParticipantIdAttributes');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling patchCobrowsesessionsCobrowseIdParticipantsParticipantIdAttributes');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/attributes";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($cobrowseId !== null) {
            $resourcePath = str_replace(
                "{" . "cobrowseId" . "}",
                $this->apiClient->getSerializer()->toPathValue($cobrowseId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/attributes'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchCobrowsesessionsCobrowseIdParticipantsParticipantIdCommunicationsCommunicationId
     *
     * Update conversation participant's communication by disconnecting it.
     *
     * @param string $cobrowseId cobrowseId (required)
     * @param string $participantId participantId (required)
     * @param string $communicationId communicationId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Participant (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCobrowsesessionsCobrowseIdParticipantsParticipantIdCommunicationsCommunicationId($cobrowseId, $participantId, $communicationId, $body)
    {
        list($response) = $this->patchCobrowsesessionsCobrowseIdParticipantsParticipantIdCommunicationsCommunicationIdWithHttpInfo($cobrowseId, $participantId, $communicationId, $body);
        return $response;
    }

    /**
     * Operation patchCobrowsesessionsCobrowseIdParticipantsParticipantIdCommunicationsCommunicationIdWithHttpInfo
     *
     * Update conversation participant's communication by disconnecting it.
     *
     * @param string $cobrowseId cobrowseId (required)
     * @param string $participantId participantId (required)
     * @param string $communicationId communicationId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Participant (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCobrowsesessionsCobrowseIdParticipantsParticipantIdCommunicationsCommunicationIdWithHttpInfo($cobrowseId, $participantId, $communicationId, $body)
    {
        // verify the required parameter 'cobrowseId' is set
        if ($cobrowseId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $cobrowseId when calling patchCobrowsesessionsCobrowseIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling patchCobrowsesessionsCobrowseIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // verify the required parameter 'communicationId' is set
        if ($communicationId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $communicationId when calling patchCobrowsesessionsCobrowseIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchCobrowsesessionsCobrowseIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/communications/{communicationId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($cobrowseId !== null) {
            $resourcePath = str_replace(
                "{" . "cobrowseId" . "}",
                $this->apiClient->getSerializer()->toPathValue($cobrowseId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // path params
        if ($communicationId !== null) {
            $resourcePath = str_replace(
                "{" . "communicationId" . "}",
                $this->apiClient->getSerializer()->toPathValue($communicationId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/communications/{communicationId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchConversationIdParticipantsParticipantId
     *
     * Update a participant.
     *
     * @param string $conversationId conversation ID (required)
     * @param string $participantId participant ID (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Update request (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchConversationIdParticipantsParticipantId($conversationId, $participantId, $body)
    {
        list($response) = $this->patchConversationIdParticipantsParticipantIdWithHttpInfo($conversationId, $participantId, $body);
        return $response;
    }

    /**
     * Operation patchConversationIdParticipantsParticipantIdWithHttpInfo
     *
     * Update a participant.
     *
     * @param string $conversationId conversation ID (required)
     * @param string $participantId participant ID (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Update request (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchConversationIdParticipantsParticipantIdWithHttpInfo($conversationId, $participantId, $body)
    {
        // verify the required parameter 'conversationId' is set
        if ($conversationId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $conversationId when calling patchConversationIdParticipantsParticipantId');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling patchConversationIdParticipantsParticipantId');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchConversationIdParticipantsParticipantId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/{conversationId}/participants/{participantId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($conversationId !== null) {
            $resourcePath = str_replace(
                "{" . "conversationId" . "}",
                $this->apiClient->getSerializer()->toPathValue($conversationId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/{conversationId}/participants/{participantId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchConversationIdParticipantsParticipantIdAttributes
     *
     * Update the attributes on a conversation participant.
     *
     * @param string $conversationId conversation ID (required)
     * @param string $participantId participant ID (required)
     * @param \PureCloudSDK\ParticipantAttributes $body Participant attributes (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchConversationIdParticipantsParticipantIdAttributes($conversationId, $participantId, $body)
    {
        list($response) = $this->patchConversationIdParticipantsParticipantIdAttributesWithHttpInfo($conversationId, $participantId, $body);
        return $response;
    }

    /**
     * Operation patchConversationIdParticipantsParticipantIdAttributesWithHttpInfo
     *
     * Update the attributes on a conversation participant.
     *
     * @param string $conversationId conversation ID (required)
     * @param string $participantId participant ID (required)
     * @param \PureCloudSDK\ParticipantAttributes $body Participant attributes (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchConversationIdParticipantsParticipantIdAttributesWithHttpInfo($conversationId, $participantId, $body)
    {
        // verify the required parameter 'conversationId' is set
        if ($conversationId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $conversationId when calling patchConversationIdParticipantsParticipantIdAttributes');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling patchConversationIdParticipantsParticipantIdAttributes');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchConversationIdParticipantsParticipantIdAttributes');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/{conversationId}/participants/{participantId}/attributes";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($conversationId !== null) {
            $resourcePath = str_replace(
                "{" . "conversationId" . "}",
                $this->apiClient->getSerializer()->toPathValue($conversationId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/{conversationId}/participants/{participantId}/attributes'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchEmailsEmailId
     *
     * Update a conversation by disconnecting all of the participants
     *
     * @param string $emailId emailId (required)
     * @param \PureCloudSDK\Conversation $body Conversation (required)
     * @return \PureCloudSDK\Conversation
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchEmailsEmailId($emailId, $body)
    {
        list($response) = $this->patchEmailsEmailIdWithHttpInfo($emailId, $body);
        return $response;
    }

    /**
     * Operation patchEmailsEmailIdWithHttpInfo
     *
     * Update a conversation by disconnecting all of the participants
     *
     * @param string $emailId emailId (required)
     * @param \PureCloudSDK\Conversation $body Conversation (required)
     * @return Array of \PureCloudSDK\Conversation, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchEmailsEmailIdWithHttpInfo($emailId, $body)
    {
        // verify the required parameter 'emailId' is set
        if ($emailId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $emailId when calling patchEmailsEmailId');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchEmailsEmailId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/emails/{emailId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($emailId !== null) {
            $resourcePath = str_replace(
                "{" . "emailId" . "}",
                $this->apiClient->getSerializer()->toPathValue($emailId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Conversation',
                '/api/v2/conversations/emails/{emailId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Conversation', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Conversation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchEmailsEmailIdParticipantsParticipantId
     *
     * Update conversation participant
     *
     * @param string $emailId emailId (required)
     * @param string $participantId participantId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Update request (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchEmailsEmailIdParticipantsParticipantId($emailId, $participantId, $body)
    {
        list($response) = $this->patchEmailsEmailIdParticipantsParticipantIdWithHttpInfo($emailId, $participantId, $body);
        return $response;
    }

    /**
     * Operation patchEmailsEmailIdParticipantsParticipantIdWithHttpInfo
     *
     * Update conversation participant
     *
     * @param string $emailId emailId (required)
     * @param string $participantId participantId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Update request (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchEmailsEmailIdParticipantsParticipantIdWithHttpInfo($emailId, $participantId, $body)
    {
        // verify the required parameter 'emailId' is set
        if ($emailId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $emailId when calling patchEmailsEmailIdParticipantsParticipantId');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling patchEmailsEmailIdParticipantsParticipantId');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchEmailsEmailIdParticipantsParticipantId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/emails/{emailId}/participants/{participantId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($emailId !== null) {
            $resourcePath = str_replace(
                "{" . "emailId" . "}",
                $this->apiClient->getSerializer()->toPathValue($emailId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/emails/{emailId}/participants/{participantId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchEmailsEmailIdParticipantsParticipantIdAttributes
     *
     * Update the attributes on a conversation participant.
     *
     * @param string $emailId emailId (required)
     * @param string $participantId participantId (required)
     * @param \PureCloudSDK\ParticipantAttributes $body Participant attributes (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchEmailsEmailIdParticipantsParticipantIdAttributes($emailId, $participantId, $body)
    {
        list($response) = $this->patchEmailsEmailIdParticipantsParticipantIdAttributesWithHttpInfo($emailId, $participantId, $body);
        return $response;
    }

    /**
     * Operation patchEmailsEmailIdParticipantsParticipantIdAttributesWithHttpInfo
     *
     * Update the attributes on a conversation participant.
     *
     * @param string $emailId emailId (required)
     * @param string $participantId participantId (required)
     * @param \PureCloudSDK\ParticipantAttributes $body Participant attributes (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchEmailsEmailIdParticipantsParticipantIdAttributesWithHttpInfo($emailId, $participantId, $body)
    {
        // verify the required parameter 'emailId' is set
        if ($emailId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $emailId when calling patchEmailsEmailIdParticipantsParticipantIdAttributes');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling patchEmailsEmailIdParticipantsParticipantIdAttributes');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchEmailsEmailIdParticipantsParticipantIdAttributes');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/emails/{emailId}/participants/{participantId}/attributes";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($emailId !== null) {
            $resourcePath = str_replace(
                "{" . "emailId" . "}",
                $this->apiClient->getSerializer()->toPathValue($emailId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/emails/{emailId}/participants/{participantId}/attributes'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchEmailsEmailIdParticipantsParticipantIdCommunicationsCommunicationId
     *
     * Update conversation participant's communication by disconnecting it.
     *
     * @param string $emailId emailId (required)
     * @param string $participantId participantId (required)
     * @param string $communicationId communicationId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Participant (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchEmailsEmailIdParticipantsParticipantIdCommunicationsCommunicationId($emailId, $participantId, $communicationId, $body)
    {
        list($response) = $this->patchEmailsEmailIdParticipantsParticipantIdCommunicationsCommunicationIdWithHttpInfo($emailId, $participantId, $communicationId, $body);
        return $response;
    }

    /**
     * Operation patchEmailsEmailIdParticipantsParticipantIdCommunicationsCommunicationIdWithHttpInfo
     *
     * Update conversation participant's communication by disconnecting it.
     *
     * @param string $emailId emailId (required)
     * @param string $participantId participantId (required)
     * @param string $communicationId communicationId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Participant (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchEmailsEmailIdParticipantsParticipantIdCommunicationsCommunicationIdWithHttpInfo($emailId, $participantId, $communicationId, $body)
    {
        // verify the required parameter 'emailId' is set
        if ($emailId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $emailId when calling patchEmailsEmailIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling patchEmailsEmailIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // verify the required parameter 'communicationId' is set
        if ($communicationId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $communicationId when calling patchEmailsEmailIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchEmailsEmailIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/emails/{emailId}/participants/{participantId}/communications/{communicationId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($emailId !== null) {
            $resourcePath = str_replace(
                "{" . "emailId" . "}",
                $this->apiClient->getSerializer()->toPathValue($emailId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // path params
        if ($communicationId !== null) {
            $resourcePath = str_replace(
                "{" . "communicationId" . "}",
                $this->apiClient->getSerializer()->toPathValue($communicationId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/emails/{emailId}/participants/{participantId}/communications/{communicationId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postCallbacks
     *
     * Create a Callback
     *
     * @param \PureCloudSDK\CreateCallbackCommand $body Callback (required)
     * @return \PureCloudSDK\CreateCallbackResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postCallbacks($body)
    {
        list($response) = $this->postCallbacksWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postCallbacksWithHttpInfo
     *
     * Create a Callback
     *
     * @param \PureCloudSDK\CreateCallbackCommand $body Callback (required)
     * @return Array of \PureCloudSDK\CreateCallbackResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postCallbacksWithHttpInfo($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postCallbacks');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/callbacks";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\CreateCallbackResponse',
                '/api/v2/conversations/callbacks'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\CreateCallbackResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\CreateCallbackResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postCallbacksCallbackIdParticipantsParticipantIdReplace
     *
     * Replace this participant with the specified user and/or address
     *
     * @param string $callbackId callbackId (required)
     * @param string $participantId participantId (required)
     * @param \PureCloudSDK\TransferRequest $body Transfer request (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postCallbacksCallbackIdParticipantsParticipantIdReplace($callbackId, $participantId, $body)
    {
        list($response) = $this->postCallbacksCallbackIdParticipantsParticipantIdReplaceWithHttpInfo($callbackId, $participantId, $body);
        return $response;
    }

    /**
     * Operation postCallbacksCallbackIdParticipantsParticipantIdReplaceWithHttpInfo
     *
     * Replace this participant with the specified user and/or address
     *
     * @param string $callbackId callbackId (required)
     * @param string $participantId participantId (required)
     * @param \PureCloudSDK\TransferRequest $body Transfer request (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postCallbacksCallbackIdParticipantsParticipantIdReplaceWithHttpInfo($callbackId, $participantId, $body)
    {
        // verify the required parameter 'callbackId' is set
        if ($callbackId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $callbackId when calling postCallbacksCallbackIdParticipantsParticipantIdReplace');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling postCallbacksCallbackIdParticipantsParticipantIdReplace');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postCallbacksCallbackIdParticipantsParticipantIdReplace');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/replace";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($callbackId !== null) {
            $resourcePath = str_replace(
                "{" . "callbackId" . "}",
                $this->apiClient->getSerializer()->toPathValue($callbackId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/replace'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postCalls
     *
     * Create a call conversation
     *
     * @param \PureCloudSDK\CreateCallRequest $body Call request (required)
     * @return \PureCloudSDK\CreateCallResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postCalls($body)
    {
        list($response) = $this->postCallsWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postCallsWithHttpInfo
     *
     * Create a call conversation
     *
     * @param \PureCloudSDK\CreateCallRequest $body Call request (required)
     * @return Array of \PureCloudSDK\CreateCallResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postCallsWithHttpInfo($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postCalls');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/calls";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\CreateCallResponse',
                '/api/v2/conversations/calls'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\CreateCallResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\CreateCallResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postCallsCallId
     *
     * Add a new call to a conversation
     *
     * @param string $callId callId (required)
     * @param \PureCloudSDK\CallCommand $body Conversation (required)
     * @return \PureCloudSDK\Conversation
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postCallsCallId($callId, $body)
    {
        list($response) = $this->postCallsCallIdWithHttpInfo($callId, $body);
        return $response;
    }

    /**
     * Operation postCallsCallIdWithHttpInfo
     *
     * Add a new call to a conversation
     *
     * @param string $callId callId (required)
     * @param \PureCloudSDK\CallCommand $body Conversation (required)
     * @return Array of \PureCloudSDK\Conversation, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postCallsCallIdWithHttpInfo($callId, $body)
    {
        // verify the required parameter 'callId' is set
        if ($callId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $callId when calling postCallsCallId');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postCallsCallId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/calls/{callId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($callId !== null) {
            $resourcePath = str_replace(
                "{" . "callId" . "}",
                $this->apiClient->getSerializer()->toPathValue($callId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Conversation',
                '/api/v2/conversations/calls/{callId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Conversation', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Conversation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postCallsCallIdParticipants
     *
     * Add participants to a conversation
     *
     * @param string $callId callId (required)
     * @param \PureCloudSDK\Conversation $body Conversation (required)
     * @return \PureCloudSDK\Conversation
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postCallsCallIdParticipants($callId, $body)
    {
        list($response) = $this->postCallsCallIdParticipantsWithHttpInfo($callId, $body);
        return $response;
    }

    /**
     * Operation postCallsCallIdParticipantsWithHttpInfo
     *
     * Add participants to a conversation
     *
     * @param string $callId callId (required)
     * @param \PureCloudSDK\Conversation $body Conversation (required)
     * @return Array of \PureCloudSDK\Conversation, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postCallsCallIdParticipantsWithHttpInfo($callId, $body)
    {
        // verify the required parameter 'callId' is set
        if ($callId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $callId when calling postCallsCallIdParticipants');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postCallsCallIdParticipants');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/calls/{callId}/participants";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($callId !== null) {
            $resourcePath = str_replace(
                "{" . "callId" . "}",
                $this->apiClient->getSerializer()->toPathValue($callId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Conversation',
                '/api/v2/conversations/calls/{callId}/participants'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Conversation', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Conversation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postCallsCallIdParticipantsParticipantIdConsult
     *
     * Initiate and update consult transfer
     *
     * @param string $callId callId (required)
     * @param string $participantId participantId (required)
     * @param \PureCloudSDK\ConsultTransfer $body Destination address &amp; initial speak to (required)
     * @return \PureCloudSDK\ConsultTransferResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postCallsCallIdParticipantsParticipantIdConsult($callId, $participantId, $body)
    {
        list($response) = $this->postCallsCallIdParticipantsParticipantIdConsultWithHttpInfo($callId, $participantId, $body);
        return $response;
    }

    /**
     * Operation postCallsCallIdParticipantsParticipantIdConsultWithHttpInfo
     *
     * Initiate and update consult transfer
     *
     * @param string $callId callId (required)
     * @param string $participantId participantId (required)
     * @param \PureCloudSDK\ConsultTransfer $body Destination address &amp; initial speak to (required)
     * @return Array of \PureCloudSDK\ConsultTransferResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postCallsCallIdParticipantsParticipantIdConsultWithHttpInfo($callId, $participantId, $body)
    {
        // verify the required parameter 'callId' is set
        if ($callId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $callId when calling postCallsCallIdParticipantsParticipantIdConsult');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling postCallsCallIdParticipantsParticipantIdConsult');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postCallsCallIdParticipantsParticipantIdConsult');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/calls/{callId}/participants/{participantId}/consult";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($callId !== null) {
            $resourcePath = str_replace(
                "{" . "callId" . "}",
                $this->apiClient->getSerializer()->toPathValue($callId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ConsultTransferResponse',
                '/api/v2/conversations/calls/{callId}/participants/{participantId}/consult'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ConsultTransferResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ConsultTransferResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postCallsCallIdParticipantsParticipantIdMonitor
     *
     * Listen in on the conversation from the point of view of a given participant.
     *
     * @param string $callId callId (required)
     * @param string $participantId participantId (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postCallsCallIdParticipantsParticipantIdMonitor($callId, $participantId)
    {
        list($response) = $this->postCallsCallIdParticipantsParticipantIdMonitorWithHttpInfo($callId, $participantId);
        return $response;
    }

    /**
     * Operation postCallsCallIdParticipantsParticipantIdMonitorWithHttpInfo
     *
     * Listen in on the conversation from the point of view of a given participant.
     *
     * @param string $callId callId (required)
     * @param string $participantId participantId (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postCallsCallIdParticipantsParticipantIdMonitorWithHttpInfo($callId, $participantId)
    {
        // verify the required parameter 'callId' is set
        if ($callId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $callId when calling postCallsCallIdParticipantsParticipantIdMonitor');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling postCallsCallIdParticipantsParticipantIdMonitor');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/calls/{callId}/participants/{participantId}/monitor";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($callId !== null) {
            $resourcePath = str_replace(
                "{" . "callId" . "}",
                $this->apiClient->getSerializer()->toPathValue($callId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/calls/{callId}/participants/{participantId}/monitor'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postCallsCallIdParticipantsParticipantIdReplace
     *
     * Replace this participant with the specified user and/or address
     *
     * @param string $callId callId (required)
     * @param string $participantId participantId (required)
     * @param \PureCloudSDK\TransferRequest $body Transfer request (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postCallsCallIdParticipantsParticipantIdReplace($callId, $participantId, $body)
    {
        list($response) = $this->postCallsCallIdParticipantsParticipantIdReplaceWithHttpInfo($callId, $participantId, $body);
        return $response;
    }

    /**
     * Operation postCallsCallIdParticipantsParticipantIdReplaceWithHttpInfo
     *
     * Replace this participant with the specified user and/or address
     *
     * @param string $callId callId (required)
     * @param string $participantId participantId (required)
     * @param \PureCloudSDK\TransferRequest $body Transfer request (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postCallsCallIdParticipantsParticipantIdReplaceWithHttpInfo($callId, $participantId, $body)
    {
        // verify the required parameter 'callId' is set
        if ($callId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $callId when calling postCallsCallIdParticipantsParticipantIdReplace');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling postCallsCallIdParticipantsParticipantIdReplace');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postCallsCallIdParticipantsParticipantIdReplace');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/calls/{callId}/participants/{participantId}/replace";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($callId !== null) {
            $resourcePath = str_replace(
                "{" . "callId" . "}",
                $this->apiClient->getSerializer()->toPathValue($callId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/calls/{callId}/participants/{participantId}/replace'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postChatsChatIdParticipantsParticipantIdReplace
     *
     * Replace this participant with the specified user and/or address
     *
     * @param string $chatId chatId (required)
     * @param string $participantId participantId (required)
     * @param \PureCloudSDK\TransferRequest $body Transfer request (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postChatsChatIdParticipantsParticipantIdReplace($chatId, $participantId, $body)
    {
        list($response) = $this->postChatsChatIdParticipantsParticipantIdReplaceWithHttpInfo($chatId, $participantId, $body);
        return $response;
    }

    /**
     * Operation postChatsChatIdParticipantsParticipantIdReplaceWithHttpInfo
     *
     * Replace this participant with the specified user and/or address
     *
     * @param string $chatId chatId (required)
     * @param string $participantId participantId (required)
     * @param \PureCloudSDK\TransferRequest $body Transfer request (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postChatsChatIdParticipantsParticipantIdReplaceWithHttpInfo($chatId, $participantId, $body)
    {
        // verify the required parameter 'chatId' is set
        if ($chatId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $chatId when calling postChatsChatIdParticipantsParticipantIdReplace');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling postChatsChatIdParticipantsParticipantIdReplace');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postChatsChatIdParticipantsParticipantIdReplace');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/chats/{chatId}/participants/{participantId}/replace";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($chatId !== null) {
            $resourcePath = str_replace(
                "{" . "chatId" . "}",
                $this->apiClient->getSerializer()->toPathValue($chatId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/chats/{chatId}/participants/{participantId}/replace'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postCobrowsesessionsCobrowseIdParticipantsParticipantIdReplace
     *
     * Replace this participant with the specified user and/or address
     *
     * @param string $cobrowseId cobrowseId (required)
     * @param string $participantId participantId (required)
     * @param \PureCloudSDK\TransferRequest $body  (optional)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postCobrowsesessionsCobrowseIdParticipantsParticipantIdReplace($cobrowseId, $participantId, $body = null)
    {
        list($response) = $this->postCobrowsesessionsCobrowseIdParticipantsParticipantIdReplaceWithHttpInfo($cobrowseId, $participantId, $body);
        return $response;
    }

    /**
     * Operation postCobrowsesessionsCobrowseIdParticipantsParticipantIdReplaceWithHttpInfo
     *
     * Replace this participant with the specified user and/or address
     *
     * @param string $cobrowseId cobrowseId (required)
     * @param string $participantId participantId (required)
     * @param \PureCloudSDK\TransferRequest $body  (optional)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postCobrowsesessionsCobrowseIdParticipantsParticipantIdReplaceWithHttpInfo($cobrowseId, $participantId, $body = null)
    {
        // verify the required parameter 'cobrowseId' is set
        if ($cobrowseId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $cobrowseId when calling postCobrowsesessionsCobrowseIdParticipantsParticipantIdReplace');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling postCobrowsesessionsCobrowseIdParticipantsParticipantIdReplace');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/replace";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($cobrowseId !== null) {
            $resourcePath = str_replace(
                "{" . "cobrowseId" . "}",
                $this->apiClient->getSerializer()->toPathValue($cobrowseId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/replace'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postConversationIdParticipantsParticipantIdCallbacks
     *
     * Create a new callback for the specified participant on the conversation.
     *
     * @param string $conversationId conversation ID (required)
     * @param string $participantId participant ID (required)
     * @param \PureCloudSDK\CreateCallbackCommand $body  (optional)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postConversationIdParticipantsParticipantIdCallbacks($conversationId, $participantId, $body = null)
    {
        list($response) = $this->postConversationIdParticipantsParticipantIdCallbacksWithHttpInfo($conversationId, $participantId, $body);
        return $response;
    }

    /**
     * Operation postConversationIdParticipantsParticipantIdCallbacksWithHttpInfo
     *
     * Create a new callback for the specified participant on the conversation.
     *
     * @param string $conversationId conversation ID (required)
     * @param string $participantId participant ID (required)
     * @param \PureCloudSDK\CreateCallbackCommand $body  (optional)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postConversationIdParticipantsParticipantIdCallbacksWithHttpInfo($conversationId, $participantId, $body = null)
    {
        // verify the required parameter 'conversationId' is set
        if ($conversationId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $conversationId when calling postConversationIdParticipantsParticipantIdCallbacks');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling postConversationIdParticipantsParticipantIdCallbacks');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/{conversationId}/participants/{participantId}/callbacks";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($conversationId !== null) {
            $resourcePath = str_replace(
                "{" . "conversationId" . "}",
                $this->apiClient->getSerializer()->toPathValue($conversationId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/{conversationId}/participants/{participantId}/callbacks'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postConversationIdParticipantsParticipantIdReplace
     *
     * Replace this participant with the specified user and/or address
     *
     * @param string $conversationId conversation ID (required)
     * @param string $participantId participant ID (required)
     * @param \PureCloudSDK\TransferRequest $body Transfer request (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postConversationIdParticipantsParticipantIdReplace($conversationId, $participantId, $body)
    {
        list($response) = $this->postConversationIdParticipantsParticipantIdReplaceWithHttpInfo($conversationId, $participantId, $body);
        return $response;
    }

    /**
     * Operation postConversationIdParticipantsParticipantIdReplaceWithHttpInfo
     *
     * Replace this participant with the specified user and/or address
     *
     * @param string $conversationId conversation ID (required)
     * @param string $participantId participant ID (required)
     * @param \PureCloudSDK\TransferRequest $body Transfer request (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postConversationIdParticipantsParticipantIdReplaceWithHttpInfo($conversationId, $participantId, $body)
    {
        // verify the required parameter 'conversationId' is set
        if ($conversationId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $conversationId when calling postConversationIdParticipantsParticipantIdReplace');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling postConversationIdParticipantsParticipantIdReplace');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postConversationIdParticipantsParticipantIdReplace');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/{conversationId}/participants/{participantId}/replace";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($conversationId !== null) {
            $resourcePath = str_replace(
                "{" . "conversationId" . "}",
                $this->apiClient->getSerializer()->toPathValue($conversationId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/{conversationId}/participants/{participantId}/replace'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postConversationsAggregatesQuery
     *
     * Query for conversation aggregates
     *
     * @param \PureCloudSDK\AggregationQuery $body query (required)
     * @return \PureCloudSDK\AggregateQueryResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postConversationsAggregatesQuery($body)
    {
        list($response) = $this->postConversationsAggregatesQueryWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postConversationsAggregatesQueryWithHttpInfo
     *
     * Query for conversation aggregates
     *
     * @param \PureCloudSDK\AggregationQuery $body query (required)
     * @return Array of \PureCloudSDK\AggregateQueryResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postConversationsAggregatesQueryWithHttpInfo($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postConversationsAggregatesQuery');
        }
        // parse inputs
        $resourcePath = "/api/v2/analytics/conversations/aggregates/query";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\AggregateQueryResponse',
                '/api/v2/analytics/conversations/aggregates/query'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\AggregateQueryResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\AggregateQueryResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postConversationsConversationIdDetailsProperties
     *
     * Index conversation properties
     *
     * @param string $conversationId conversationId (required)
     * @param \PureCloudSDK\PropertyIndexRequest $body request (required)
     * @return \PureCloudSDK\PropertyIndexRequest
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postConversationsConversationIdDetailsProperties($conversationId, $body)
    {
        list($response) = $this->postConversationsConversationIdDetailsPropertiesWithHttpInfo($conversationId, $body);
        return $response;
    }

    /**
     * Operation postConversationsConversationIdDetailsPropertiesWithHttpInfo
     *
     * Index conversation properties
     *
     * @param string $conversationId conversationId (required)
     * @param \PureCloudSDK\PropertyIndexRequest $body request (required)
     * @return Array of \PureCloudSDK\PropertyIndexRequest, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postConversationsConversationIdDetailsPropertiesWithHttpInfo($conversationId, $body)
    {
        // verify the required parameter 'conversationId' is set
        if ($conversationId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $conversationId when calling postConversationsConversationIdDetailsProperties');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postConversationsConversationIdDetailsProperties');
        }
        // parse inputs
        $resourcePath = "/api/v2/analytics/conversations/{conversationId}/details/properties";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($conversationId !== null) {
            $resourcePath = str_replace(
                "{" . "conversationId" . "}",
                $this->apiClient->getSerializer()->toPathValue($conversationId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\PropertyIndexRequest',
                '/api/v2/analytics/conversations/{conversationId}/details/properties'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\PropertyIndexRequest', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\PropertyIndexRequest', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postConversationsDetailsQuery
     *
     * Query for conversation details
     *
     * @param \PureCloudSDK\ConversationQuery $body query (required)
     * @return \PureCloudSDK\AnalyticsConversationQueryResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postConversationsDetailsQuery($body)
    {
        list($response) = $this->postConversationsDetailsQueryWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postConversationsDetailsQueryWithHttpInfo
     *
     * Query for conversation details
     *
     * @param \PureCloudSDK\ConversationQuery $body query (required)
     * @return Array of \PureCloudSDK\AnalyticsConversationQueryResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postConversationsDetailsQueryWithHttpInfo($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postConversationsDetailsQuery');
        }
        // parse inputs
        $resourcePath = "/api/v2/analytics/conversations/details/query";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\AnalyticsConversationQueryResponse',
                '/api/v2/analytics/conversations/details/query'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\AnalyticsConversationQueryResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\AnalyticsConversationQueryResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postEmailsEmailIdMessages
     *
     * Send an email reply
     *
     * @param string $emailId emailId (required)
     * @param \PureCloudSDK\EmailMessage $body Reply (required)
     * @return \PureCloudSDK\EmailMessage
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postEmailsEmailIdMessages($emailId, $body)
    {
        list($response) = $this->postEmailsEmailIdMessagesWithHttpInfo($emailId, $body);
        return $response;
    }

    /**
     * Operation postEmailsEmailIdMessagesWithHttpInfo
     *
     * Send an email reply
     *
     * @param string $emailId emailId (required)
     * @param \PureCloudSDK\EmailMessage $body Reply (required)
     * @return Array of \PureCloudSDK\EmailMessage, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postEmailsEmailIdMessagesWithHttpInfo($emailId, $body)
    {
        // verify the required parameter 'emailId' is set
        if ($emailId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $emailId when calling postEmailsEmailIdMessages');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postEmailsEmailIdMessages');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/emails/{emailId}/messages";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($emailId !== null) {
            $resourcePath = str_replace(
                "{" . "emailId" . "}",
                $this->apiClient->getSerializer()->toPathValue($emailId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\EmailMessage',
                '/api/v2/conversations/emails/{emailId}/messages'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\EmailMessage', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\EmailMessage', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postEmailsEmailIdParticipantsParticipantIdReplace
     *
     * Replace this participant with the specified user and/or address
     *
     * @param string $emailId emailId (required)
     * @param string $participantId participantId (required)
     * @param \PureCloudSDK\TransferRequest $body Transfer request (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postEmailsEmailIdParticipantsParticipantIdReplace($emailId, $participantId, $body)
    {
        list($response) = $this->postEmailsEmailIdParticipantsParticipantIdReplaceWithHttpInfo($emailId, $participantId, $body);
        return $response;
    }

    /**
     * Operation postEmailsEmailIdParticipantsParticipantIdReplaceWithHttpInfo
     *
     * Replace this participant with the specified user and/or address
     *
     * @param string $emailId emailId (required)
     * @param string $participantId participantId (required)
     * @param \PureCloudSDK\TransferRequest $body Transfer request (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postEmailsEmailIdParticipantsParticipantIdReplaceWithHttpInfo($emailId, $participantId, $body)
    {
        // verify the required parameter 'emailId' is set
        if ($emailId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $emailId when calling postEmailsEmailIdParticipantsParticipantIdReplace');
        }
        // verify the required parameter 'participantId' is set
        if ($participantId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participantId when calling postEmailsEmailIdParticipantsParticipantIdReplace');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postEmailsEmailIdParticipantsParticipantIdReplace');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/emails/{emailId}/participants/{participantId}/replace";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($emailId !== null) {
            $resourcePath = str_replace(
                "{" . "emailId" . "}",
                $this->apiClient->getSerializer()->toPathValue($emailId),
                $resourcePath
            );
        }
        // path params
        if ($participantId !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participantId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/emails/{emailId}/participants/{participantId}/replace'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postFaxes
     *
     * Create Fax Conversation
     *
     * @param \PureCloudSDK\FaxSendRequest $body Fax (required)
     * @return \PureCloudSDK\FaxSendResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postFaxes($body)
    {
        list($response) = $this->postFaxesWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postFaxesWithHttpInfo
     *
     * Create Fax Conversation
     *
     * @param \PureCloudSDK\FaxSendRequest $body Fax (required)
     * @return Array of \PureCloudSDK\FaxSendResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postFaxesWithHttpInfo($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postFaxes');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/faxes";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\FaxSendResponse',
                '/api/v2/conversations/faxes'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\FaxSendResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\FaxSendResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation putEmailsEmailIdMessagesDraft
     *
     * Update conversation draft reply
     *
     * @param string $emailId emailId (required)
     * @param \PureCloudSDK\EmailMessage $body Draft (required)
     * @return \PureCloudSDK\EmailMessage
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putEmailsEmailIdMessagesDraft($emailId, $body)
    {
        list($response) = $this->putEmailsEmailIdMessagesDraftWithHttpInfo($emailId, $body);
        return $response;
    }

    /**
     * Operation putEmailsEmailIdMessagesDraftWithHttpInfo
     *
     * Update conversation draft reply
     *
     * @param string $emailId emailId (required)
     * @param \PureCloudSDK\EmailMessage $body Draft (required)
     * @return Array of \PureCloudSDK\EmailMessage, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putEmailsEmailIdMessagesDraftWithHttpInfo($emailId, $body)
    {
        // verify the required parameter 'emailId' is set
        if ($emailId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $emailId when calling putEmailsEmailIdMessagesDraft');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling putEmailsEmailIdMessagesDraft');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/emails/{emailId}/messages/draft";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($emailId !== null) {
            $resourcePath = str_replace(
                "{" . "emailId" . "}",
                $this->apiClient->getSerializer()->toPathValue($emailId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\EmailMessage',
                '/api/v2/conversations/emails/{emailId}/messages/draft'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\EmailMessage', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\EmailMessage', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

}
