<?php
/**
 * ConversationNotificationCobrowse
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * ConversationNotificationCobrowse Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ConversationNotificationCobrowse implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ConversationNotificationCobrowse';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'state' => 'string',
        'disconnectType' => 'string',
        'id' => 'string',
        'self' => '\PureCloudSDK\ConversationNotificationAddress',
        'roomId' => 'string',
        'cobrowseSessionId' => 'string',
        'cobrowseRole' => 'string',
        'controlling' => 'string[]',
        'viewerUrl' => 'string',
        'provider' => 'string',
        'providerEventTime' => '\DateTime',
        'connectedTime' => '\DateTime',
        'disconnectedTime' => '\DateTime',
        'additionalProperties' => 'object'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'state' => 'state',
        'disconnectType' => 'disconnectType',
        'id' => 'id',
        'self' => 'self',
        'roomId' => 'roomId',
        'cobrowseSessionId' => 'cobrowseSessionId',
        'cobrowseRole' => 'cobrowseRole',
        'controlling' => 'controlling',
        'viewerUrl' => 'viewerUrl',
        'provider' => 'provider',
        'providerEventTime' => 'providerEventTime',
        'connectedTime' => 'connectedTime',
        'disconnectedTime' => 'disconnectedTime',
        'additionalProperties' => 'additionalProperties'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'state' => 'setState',
        'disconnectType' => 'setDisconnectType',
        'id' => 'setId',
        'self' => 'setSelf',
        'roomId' => 'setRoomId',
        'cobrowseSessionId' => 'setCobrowseSessionId',
        'cobrowseRole' => 'setCobrowseRole',
        'controlling' => 'setControlling',
        'viewerUrl' => 'setViewerUrl',
        'provider' => 'setProvider',
        'providerEventTime' => 'setProviderEventTime',
        'connectedTime' => 'setConnectedTime',
        'disconnectedTime' => 'setDisconnectedTime',
        'additionalProperties' => 'setAdditionalProperties'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'state' => 'getState',
        'disconnectType' => 'getDisconnectType',
        'id' => 'getId',
        'self' => 'getSelf',
        'roomId' => 'getRoomId',
        'cobrowseSessionId' => 'getCobrowseSessionId',
        'cobrowseRole' => 'getCobrowseRole',
        'controlling' => 'getControlling',
        'viewerUrl' => 'getViewerUrl',
        'provider' => 'getProvider',
        'providerEventTime' => 'getProviderEventTime',
        'connectedTime' => 'getConnectedTime',
        'disconnectedTime' => 'getDisconnectedTime',
        'additionalProperties' => 'getAdditionalProperties'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const STATE_ALERTING = 'alerting';
    const STATE_DIALING = 'dialing';
    const STATE_CONTACTING = 'contacting';
    const STATE_OFFERING = 'offering';
    const STATE_CONNECTED = 'connected';
    const STATE_DISCONNECTED = 'disconnected';
    const STATE_TERMINATED = 'terminated';
    const STATE_NONE = 'none';
    const DISCONNECT_TYPE_ENDPOINT = 'endpoint';
    const DISCONNECT_TYPE_CLIENT = 'client';
    const DISCONNECT_TYPE_SYSTEM = 'system';
    const DISCONNECT_TYPE_TIMEOUT = 'timeout';
    const DISCONNECT_TYPE_TRANSFER = 'transfer';
    const DISCONNECT_TYPE_TRANSFER_CONFERENCE = 'transfer_conference';
    const DISCONNECT_TYPE_TRANSFER_CONSULT = 'transfer_consult';
    const DISCONNECT_TYPE_TRANSFER_FORWARD = 'transfer_forward';
    const DISCONNECT_TYPE_TRANSPORT_FAILURE = 'transport_failure';
    const DISCONNECT_TYPE_ERROR = 'error';
    const DISCONNECT_TYPE_PEER = 'peer';
    const DISCONNECT_TYPE_OTHER = 'other';
    const DISCONNECT_TYPE_SPAM = 'spam';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_ALERTING,
            self::STATE_DIALING,
            self::STATE_CONTACTING,
            self::STATE_OFFERING,
            self::STATE_CONNECTED,
            self::STATE_DISCONNECTED,
            self::STATE_TERMINATED,
            self::STATE_NONE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDisconnectTypeAllowableValues()
    {
        return [
            self::DISCONNECT_TYPE_ENDPOINT,
            self::DISCONNECT_TYPE_CLIENT,
            self::DISCONNECT_TYPE_SYSTEM,
            self::DISCONNECT_TYPE_TIMEOUT,
            self::DISCONNECT_TYPE_TRANSFER,
            self::DISCONNECT_TYPE_TRANSFER_CONFERENCE,
            self::DISCONNECT_TYPE_TRANSFER_CONSULT,
            self::DISCONNECT_TYPE_TRANSFER_FORWARD,
            self::DISCONNECT_TYPE_TRANSPORT_FAILURE,
            self::DISCONNECT_TYPE_ERROR,
            self::DISCONNECT_TYPE_PEER,
            self::DISCONNECT_TYPE_OTHER,
            self::DISCONNECT_TYPE_SPAM,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['disconnectType'] = isset($data['disconnectType']) ? $data['disconnectType'] : null;
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['self'] = isset($data['self']) ? $data['self'] : null;
        $this->container['roomId'] = isset($data['roomId']) ? $data['roomId'] : null;
        $this->container['cobrowseSessionId'] = isset($data['cobrowseSessionId']) ? $data['cobrowseSessionId'] : null;
        $this->container['cobrowseRole'] = isset($data['cobrowseRole']) ? $data['cobrowseRole'] : null;
        $this->container['controlling'] = isset($data['controlling']) ? $data['controlling'] : null;
        $this->container['viewerUrl'] = isset($data['viewerUrl']) ? $data['viewerUrl'] : null;
        $this->container['provider'] = isset($data['provider']) ? $data['provider'] : null;
        $this->container['providerEventTime'] = isset($data['providerEventTime']) ? $data['providerEventTime'] : null;
        $this->container['connectedTime'] = isset($data['connectedTime']) ? $data['connectedTime'] : null;
        $this->container['disconnectedTime'] = isset($data['disconnectedTime']) ? $data['disconnectedTime'] : null;
        $this->container['additionalProperties'] = isset($data['additionalProperties']) ? $data['additionalProperties'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("alerting", "dialing", "contacting", "offering", "connected", "disconnected", "terminated", "none");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        $allowed_values = array("endpoint", "client", "system", "timeout", "transfer", "transfer_conference", "transfer_consult", "transfer_forward", "transport_failure", "error", "peer", "other", "spam");
        if (!in_array($this->container['disconnectType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'disconnectType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("alerting", "dialing", "contacting", "offering", "connected", "disconnected", "terminated", "none");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("endpoint", "client", "system", "timeout", "transfer", "transfer_conference", "transfer_consult", "transfer_forward", "transport_failure", "error", "peer", "other", "spam");
        if (!in_array($this->container['disconnectType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('alerting', 'dialing', 'contacting', 'offering', 'connected', 'disconnected', 'terminated', 'none');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'alerting', 'dialing', 'contacting', 'offering', 'connected', 'disconnected', 'terminated', 'none'");
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets disconnectType
     * @return string
     */
    public function getDisconnectType()
    {
        return $this->container['disconnectType'];
    }

    /**
     * Sets disconnectType
     * @param string $disconnectType
     * @return $this
     */
    public function setDisconnectType($disconnectType)
    {
        $allowed_values = array('endpoint', 'client', 'system', 'timeout', 'transfer', 'transfer_conference', 'transfer_consult', 'transfer_forward', 'transport_failure', 'error', 'peer', 'other', 'spam');
        if (!in_array($disconnectType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'disconnectType', must be one of 'endpoint', 'client', 'system', 'timeout', 'transfer', 'transfer_conference', 'transfer_consult', 'transfer_forward', 'transport_failure', 'error', 'peer', 'other', 'spam'");
        }
        $this->container['disconnectType'] = $disconnectType;

        return $this;
    }

    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets self
     * @return \PureCloudSDK\ConversationNotificationAddress
     */
    public function getSelf()
    {
        return $this->container['self'];
    }

    /**
     * Sets self
     * @param \PureCloudSDK\ConversationNotificationAddress $self
     * @return $this
     */
    public function setSelf($self)
    {
        $this->container['self'] = $self;

        return $this;
    }

    /**
     * Gets roomId
     * @return string
     */
    public function getRoomId()
    {
        return $this->container['roomId'];
    }

    /**
     * Sets roomId
     * @param string $roomId
     * @return $this
     */
    public function setRoomId($roomId)
    {
        $this->container['roomId'] = $roomId;

        return $this;
    }

    /**
     * Gets cobrowseSessionId
     * @return string
     */
    public function getCobrowseSessionId()
    {
        return $this->container['cobrowseSessionId'];
    }

    /**
     * Sets cobrowseSessionId
     * @param string $cobrowseSessionId
     * @return $this
     */
    public function setCobrowseSessionId($cobrowseSessionId)
    {
        $this->container['cobrowseSessionId'] = $cobrowseSessionId;

        return $this;
    }

    /**
     * Gets cobrowseRole
     * @return string
     */
    public function getCobrowseRole()
    {
        return $this->container['cobrowseRole'];
    }

    /**
     * Sets cobrowseRole
     * @param string $cobrowseRole
     * @return $this
     */
    public function setCobrowseRole($cobrowseRole)
    {
        $this->container['cobrowseRole'] = $cobrowseRole;

        return $this;
    }

    /**
     * Gets controlling
     * @return string[]
     */
    public function getControlling()
    {
        return $this->container['controlling'];
    }

    /**
     * Sets controlling
     * @param string[] $controlling
     * @return $this
     */
    public function setControlling($controlling)
    {
        $this->container['controlling'] = $controlling;

        return $this;
    }

    /**
     * Gets viewerUrl
     * @return string
     */
    public function getViewerUrl()
    {
        return $this->container['viewerUrl'];
    }

    /**
     * Sets viewerUrl
     * @param string $viewerUrl
     * @return $this
     */
    public function setViewerUrl($viewerUrl)
    {
        $this->container['viewerUrl'] = $viewerUrl;

        return $this;
    }

    /**
     * Gets provider
     * @return string
     */
    public function getProvider()
    {
        return $this->container['provider'];
    }

    /**
     * Sets provider
     * @param string $provider
     * @return $this
     */
    public function setProvider($provider)
    {
        $this->container['provider'] = $provider;

        return $this;
    }

    /**
     * Gets providerEventTime
     * @return \DateTime
     */
    public function getProviderEventTime()
    {
        return $this->container['providerEventTime'];
    }

    /**
     * Sets providerEventTime
     * @param \DateTime $providerEventTime
     * @return $this
     */
    public function setProviderEventTime($providerEventTime)
    {
        $this->container['providerEventTime'] = $providerEventTime;

        return $this;
    }

    /**
     * Gets connectedTime
     * @return \DateTime
     */
    public function getConnectedTime()
    {
        return $this->container['connectedTime'];
    }

    /**
     * Sets connectedTime
     * @param \DateTime $connectedTime
     * @return $this
     */
    public function setConnectedTime($connectedTime)
    {
        $this->container['connectedTime'] = $connectedTime;

        return $this;
    }

    /**
     * Gets disconnectedTime
     * @return \DateTime
     */
    public function getDisconnectedTime()
    {
        return $this->container['disconnectedTime'];
    }

    /**
     * Sets disconnectedTime
     * @param \DateTime $disconnectedTime
     * @return $this
     */
    public function setDisconnectedTime($disconnectedTime)
    {
        $this->container['disconnectedTime'] = $disconnectedTime;

        return $this;
    }

    /**
     * Gets additionalProperties
     * @return object
     */
    public function getAdditionalProperties()
    {
        return $this->container['additionalProperties'];
    }

    /**
     * Sets additionalProperties
     * @param object $additionalProperties
     * @return $this
     */
    public function setAdditionalProperties($additionalProperties)
    {
        $this->container['additionalProperties'] = $additionalProperties;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


