<?php
/**
 * EdgeInterface
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * EdgeInterface Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class EdgeInterface implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'EdgeInterface';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'type' => 'string',
        'ipAddress' => 'string',
        'name' => 'string',
        'macAddress' => 'string',
        'ifName' => 'string',
        'endpoints' => '\PureCloudSDK\UriReference[]',
        'lineTypes' => 'string[]',
        'addressFamilyId' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'type' => 'type',
        'ipAddress' => 'ipAddress',
        'name' => 'name',
        'macAddress' => 'macAddress',
        'ifName' => 'ifName',
        'endpoints' => 'endpoints',
        'lineTypes' => 'lineTypes',
        'addressFamilyId' => 'addressFamilyId'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'type' => 'setType',
        'ipAddress' => 'setIpAddress',
        'name' => 'setName',
        'macAddress' => 'setMacAddress',
        'ifName' => 'setIfName',
        'endpoints' => 'setEndpoints',
        'lineTypes' => 'setLineTypes',
        'addressFamilyId' => 'setAddressFamilyId'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'type' => 'getType',
        'ipAddress' => 'getIpAddress',
        'name' => 'getName',
        'macAddress' => 'getMacAddress',
        'ifName' => 'getIfName',
        'endpoints' => 'getEndpoints',
        'lineTypes' => 'getLineTypes',
        'addressFamilyId' => 'getAddressFamilyId'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const LINE_TYPES_TIE = 'tie';
    const LINE_TYPES_NETWORK = 'network';
    const LINE_TYPES_TRUNK = 'trunk';
    const LINE_TYPES_STATION = 'station';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getLineTypesAllowableValues()
    {
        return [
            self::LINE_TYPES_TIE,
            self::LINE_TYPES_NETWORK,
            self::LINE_TYPES_TRUNK,
            self::LINE_TYPES_STATION,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['ipAddress'] = isset($data['ipAddress']) ? $data['ipAddress'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['macAddress'] = isset($data['macAddress']) ? $data['macAddress'] : null;
        $this->container['ifName'] = isset($data['ifName']) ? $data['ifName'] : null;
        $this->container['endpoints'] = isset($data['endpoints']) ? $data['endpoints'] : null;
        $this->container['lineTypes'] = isset($data['lineTypes']) ? $data['lineTypes'] : null;
        $this->container['addressFamilyId'] = isset($data['addressFamilyId']) ? $data['addressFamilyId'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type
     * @return $this
     */
    public function setType($type)
    {
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets ipAddress
     * @return string
     */
    public function getIpAddress()
    {
        return $this->container['ipAddress'];
    }

    /**
     * Sets ipAddress
     * @param string $ipAddress
     * @return $this
     */
    public function setIpAddress($ipAddress)
    {
        $this->container['ipAddress'] = $ipAddress;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets macAddress
     * @return string
     */
    public function getMacAddress()
    {
        return $this->container['macAddress'];
    }

    /**
     * Sets macAddress
     * @param string $macAddress
     * @return $this
     */
    public function setMacAddress($macAddress)
    {
        $this->container['macAddress'] = $macAddress;

        return $this;
    }

    /**
     * Gets ifName
     * @return string
     */
    public function getIfName()
    {
        return $this->container['ifName'];
    }

    /**
     * Sets ifName
     * @param string $ifName
     * @return $this
     */
    public function setIfName($ifName)
    {
        $this->container['ifName'] = $ifName;

        return $this;
    }

    /**
     * Gets endpoints
     * @return \PureCloudSDK\UriReference[]
     */
    public function getEndpoints()
    {
        return $this->container['endpoints'];
    }

    /**
     * Sets endpoints
     * @param \PureCloudSDK\UriReference[] $endpoints
     * @return $this
     */
    public function setEndpoints($endpoints)
    {
        $this->container['endpoints'] = $endpoints;

        return $this;
    }

    /**
     * Gets lineTypes
     * @return string[]
     */
    public function getLineTypes()
    {
        return $this->container['lineTypes'];
    }

    /**
     * Sets lineTypes
     * @param string[] $lineTypes
     * @return $this
     */
    public function setLineTypes($lineTypes)
    {
        $allowed_values = array('tie', 'network', 'trunk', 'station');
        if (!in_array($lineTypes, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'lineTypes', must be one of 'tie', 'network', 'trunk', 'station'");
        }
        $this->container['lineTypes'] = $lineTypes;

        return $this;
    }

    /**
     * Gets addressFamilyId
     * @return string
     */
    public function getAddressFamilyId()
    {
        return $this->container['addressFamilyId'];
    }

    /**
     * Sets addressFamilyId
     * @param string $addressFamilyId
     * @return $this
     */
    public function setAddressFamilyId($addressFamilyId)
    {
        $this->container['addressFamilyId'] = $addressFamilyId;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


