<?php
/**
 * HeartBeatRule
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * HeartBeatRule Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class HeartBeatRule implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'HeartBeatRule';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'senderId' => 'string',
        'heartBeatTimeoutInMinutes' => 'int',
        'enabled' => 'bool',
        'inAlarm' => 'bool',
        'notificationUsers' => '\PureCloudSDK\User[]',
        'alertTypes' => 'string[]',
        'ruleType' => 'string',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'senderId' => 'senderId',
        'heartBeatTimeoutInMinutes' => 'heartBeatTimeoutInMinutes',
        'enabled' => 'enabled',
        'inAlarm' => 'inAlarm',
        'notificationUsers' => 'notificationUsers',
        'alertTypes' => 'alertTypes',
        'ruleType' => 'ruleType',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'senderId' => 'setSenderId',
        'heartBeatTimeoutInMinutes' => 'setHeartBeatTimeoutInMinutes',
        'enabled' => 'setEnabled',
        'inAlarm' => 'setInAlarm',
        'notificationUsers' => 'setNotificationUsers',
        'alertTypes' => 'setAlertTypes',
        'ruleType' => 'setRuleType',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'senderId' => 'getSenderId',
        'heartBeatTimeoutInMinutes' => 'getHeartBeatTimeoutInMinutes',
        'enabled' => 'getEnabled',
        'inAlarm' => 'getInAlarm',
        'notificationUsers' => 'getNotificationUsers',
        'alertTypes' => 'getAlertTypes',
        'ruleType' => 'getRuleType',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const ALERT_TYPES_SMS = 'sms';
    const ALERT_TYPES_DEVICE = 'device';
    const ALERT_TYPES_EMAIL = 'email';
    const RULE_TYPE_EDGE = 'edge';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getAlertTypesAllowableValues()
    {
        return [
            self::ALERT_TYPES_SMS,
            self::ALERT_TYPES_DEVICE,
            self::ALERT_TYPES_EMAIL,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getRuleTypeAllowableValues()
    {
        return [
            self::RULE_TYPE_EDGE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['senderId'] = isset($data['senderId']) ? $data['senderId'] : null;
        $this->container['heartBeatTimeoutInMinutes'] = isset($data['heartBeatTimeoutInMinutes']) ? $data['heartBeatTimeoutInMinutes'] : null;
        $this->container['enabled'] = isset($data['enabled']) ? $data['enabled'] : false;
        $this->container['inAlarm'] = isset($data['inAlarm']) ? $data['inAlarm'] : false;
        $this->container['notificationUsers'] = isset($data['notificationUsers']) ? $data['notificationUsers'] : null;
        $this->container['alertTypes'] = isset($data['alertTypes']) ? $data['alertTypes'] : null;
        $this->container['ruleType'] = isset($data['ruleType']) ? $data['ruleType'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['name'] === null) {
            $invalid_properties[] = "'name' can't be null";
        }
        if ($this->container['senderId'] === null) {
            $invalid_properties[] = "'senderId' can't be null";
        }
        if ($this->container['heartBeatTimeoutInMinutes'] === null) {
            $invalid_properties[] = "'heartBeatTimeoutInMinutes' can't be null";
        }
        if ($this->container['enabled'] === null) {
            $invalid_properties[] = "'enabled' can't be null";
        }
        if ($this->container['notificationUsers'] === null) {
            $invalid_properties[] = "'notificationUsers' can't be null";
        }
        if ($this->container['alertTypes'] === null) {
            $invalid_properties[] = "'alertTypes' can't be null";
        }
        if ($this->container['ruleType'] === null) {
            $invalid_properties[] = "'ruleType' can't be null";
        }
        $allowed_values = array("edge");
        if (!in_array($this->container['ruleType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'ruleType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['name'] === null) {
            return false;
        }
        if ($this->container['senderId'] === null) {
            return false;
        }
        if ($this->container['heartBeatTimeoutInMinutes'] === null) {
            return false;
        }
        if ($this->container['enabled'] === null) {
            return false;
        }
        if ($this->container['notificationUsers'] === null) {
            return false;
        }
        if ($this->container['alertTypes'] === null) {
            return false;
        }
        if ($this->container['ruleType'] === null) {
            return false;
        }
        $allowed_values = array("edge");
        if (!in_array($this->container['ruleType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name Name of the rule
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets senderId
     * @return string
     */
    public function getSenderId()
    {
        return $this->container['senderId'];
    }

    /**
     * Sets senderId
     * @param string $senderId The value that identifies the sender of the heartbeat.
     * @return $this
     */
    public function setSenderId($senderId)
    {
        $this->container['senderId'] = $senderId;

        return $this;
    }

    /**
     * Gets heartBeatTimeoutInMinutes
     * @return int
     */
    public function getHeartBeatTimeoutInMinutes()
    {
        return $this->container['heartBeatTimeoutInMinutes'];
    }

    /**
     * Sets heartBeatTimeoutInMinutes
     * @param int $heartBeatTimeoutInMinutes The number of minutes to wait before alerting missing heartbeats.
     * @return $this
     */
    public function setHeartBeatTimeoutInMinutes($heartBeatTimeoutInMinutes)
    {
        $this->container['heartBeatTimeoutInMinutes'] = $heartBeatTimeoutInMinutes;

        return $this;
    }

    /**
     * Gets enabled
     * @return bool
     */
    public function getEnabled()
    {
        return $this->container['enabled'];
    }

    /**
     * Sets enabled
     * @param bool $enabled Indicates if the rule is enabled.
     * @return $this
     */
    public function setEnabled($enabled)
    {
        $this->container['enabled'] = $enabled;

        return $this;
    }

    /**
     * Gets inAlarm
     * @return bool
     */
    public function getInAlarm()
    {
        return $this->container['inAlarm'];
    }

    /**
     * Sets inAlarm
     * @param bool $inAlarm Indicates if the rule is in alarm state.
     * @return $this
     */
    public function setInAlarm($inAlarm)
    {
        $this->container['inAlarm'] = $inAlarm;

        return $this;
    }

    /**
     * Gets notificationUsers
     * @return \PureCloudSDK\User[]
     */
    public function getNotificationUsers()
    {
        return $this->container['notificationUsers'];
    }

    /**
     * Sets notificationUsers
     * @param \PureCloudSDK\User[] $notificationUsers The ids of users who will be notified of alarm state change.
     * @return $this
     */
    public function setNotificationUsers($notificationUsers)
    {
        $this->container['notificationUsers'] = $notificationUsers;

        return $this;
    }

    /**
     * Gets alertTypes
     * @return string[]
     */
    public function getAlertTypes()
    {
        return $this->container['alertTypes'];
    }

    /**
     * Sets alertTypes
     * @param string[] $alertTypes A collection of notification methods. = ['SMS', 'DEVICE', 'EMAIL'].
     * @return $this
     */
    public function setAlertTypes($alertTypes)
    {
        $allowed_values = array('sms', 'device', 'email');
        if (!in_array($alertTypes, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'alertTypes', must be one of 'sms', 'device', 'email'");
        }
        $this->container['alertTypes'] = $alertTypes;

        return $this;
    }

    /**
     * Gets ruleType
     * @return string
     */
    public function getRuleType()
    {
        return $this->container['ruleType'];
    }

    /**
     * Sets ruleType
     * @param string $ruleType The type of system the will be generating the heartbeat.
     * @return $this
     */
    public function setRuleType($ruleType)
    {
        $allowed_values = array('edge');
        if (!in_array($ruleType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'ruleType', must be one of 'edge'");
        }
        $this->container['ruleType'] = $ruleType;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


