<?php
/**
 * RuleSetDiagnostic
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * RuleSetDiagnostic Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class RuleSetDiagnostic implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'RuleSetDiagnostic';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'ruleSet' => '\PureCloudSDK\UriReference',
        'warnings' => 'string[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'ruleSet' => 'ruleSet',
        'warnings' => 'warnings'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'ruleSet' => 'setRuleSet',
        'warnings' => 'setWarnings'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'ruleSet' => 'getRuleSet',
        'warnings' => 'getWarnings'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const WARNINGS_WRAPUP_CODE_NOT_IN_QUEUE = 'wrapup_code_not_in_queue';
    const WARNINGS_CONTACT_ATTRIBUTE_NOT_IN_CONTACT_LIST = 'contact_attribute_not_in_contact_list';
    const WARNINGS_NO_DNC_LIST_FOR_APPEND = 'no_dnc_list_for_append';
    const WARNINGS_PHONE_CONDITIONS_WITH_MULTICOLUMN_PREVIEW = 'phone_conditions_with_multicolumn_preview';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getWarningsAllowableValues()
    {
        return [
            self::WARNINGS_WRAPUP_CODE_NOT_IN_QUEUE,
            self::WARNINGS_CONTACT_ATTRIBUTE_NOT_IN_CONTACT_LIST,
            self::WARNINGS_NO_DNC_LIST_FOR_APPEND,
            self::WARNINGS_PHONE_CONDITIONS_WITH_MULTICOLUMN_PREVIEW,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['ruleSet'] = isset($data['ruleSet']) ? $data['ruleSet'] : null;
        $this->container['warnings'] = isset($data['warnings']) ? $data['warnings'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets ruleSet
     * @return \PureCloudSDK\UriReference
     */
    public function getRuleSet()
    {
        return $this->container['ruleSet'];
    }

    /**
     * Sets ruleSet
     * @param \PureCloudSDK\UriReference $ruleSet A campaign rule set
     * @return $this
     */
    public function setRuleSet($ruleSet)
    {
        $this->container['ruleSet'] = $ruleSet;

        return $this;
    }

    /**
     * Gets warnings
     * @return string[]
     */
    public function getWarnings()
    {
        return $this->container['warnings'];
    }

    /**
     * Sets warnings
     * @param string[] $warnings Diagnostic warnings for the rule set
     * @return $this
     */
    public function setWarnings($warnings)
    {
        $allowed_values = array('wrapup_code_not_in_queue', 'contact_attribute_not_in_contact_list', 'no_dnc_list_for_append', 'phone_conditions_with_multicolumn_preview');
        if (!in_array($warnings, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'warnings', must be one of 'wrapup_code_not_in_queue', 'contact_attribute_not_in_contact_list', 'no_dnc_list_for_append', 'phone_conditions_with_multicolumn_preview'");
        }
        $this->container['warnings'] = $warnings;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


