# PureCloudSDK
With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.

This PHP package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: v2
- Build date: 2016-11-24T14:03:04.814+01:00
- Build package: class io.swagger.codegen.languages.PhpClientCodegen
For more information, please visit [https://developer.mypurecloud.com](https://developer.mypurecloud.com)

## Requirements

PHP 5.4.0 and later

## Installation & Usage
### Composer

To install the bindings via [Composer](http://getcomposer.org/), add the following to `composer.json`:

```
{
  "repositories": [
    {
      "type": "git",
      "url": "https://github.com/DealerDirect/PureCloudSDK/PureCloudSDK.git"
    }
  ],
  "require": {
    "DealerDirect/PureCloudSDK/PureCloudSDK": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
    require_once('/path/to/PureCloudSDK/autoload.php');
```

## Tests

To run the unit tests:

```
composer install
./vendor/bin/phpunit lib/Tests
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$alertId = "alertId_example"; // string | Alert ID

try {
    $api_instance->deleteHeartbeatAlertsAlertId($alertId);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->deleteHeartbeatAlertsAlertId: ', $e->getMessage(), PHP_EOL;
}

?>
```

## Documentation for API Endpoints

All URIs are relative to *https://api.mypurecloud.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AlertingApi* | [**deleteHeartbeatAlertsAlertId**](docs/Api/AlertingApi.md#deleteheartbeatalertsalertid) | **DELETE** /api/v2/alerting/heartbeat/alerts/{alertId} | Delete a heart beat alert
*AlertingApi* | [**deleteHeartbeatRulesRuleId**](docs/Api/AlertingApi.md#deleteheartbeatrulesruleid) | **DELETE** /api/v2/alerting/heartbeat/rules/{ruleId} | Delete a heart beat rule.
*AlertingApi* | [**deleteInteractionstatsAlertsAlertId**](docs/Api/AlertingApi.md#deleteinteractionstatsalertsalertid) | **DELETE** /api/v2/alerting/interactionstats/alerts/{alertId} | Delete an interaction stats alert
*AlertingApi* | [**deleteInteractionstatsRulesRuleId**](docs/Api/AlertingApi.md#deleteinteractionstatsrulesruleid) | **DELETE** /api/v2/alerting/interactionstats/rules/{ruleId} | Delete an interaction stats rule.
*AlertingApi* | [**getHeartbeatAlerts**](docs/Api/AlertingApi.md#getheartbeatalerts) | **GET** /api/v2/alerting/heartbeat/alerts | Get heart beat alert list.
*AlertingApi* | [**getHeartbeatAlertsAlertId**](docs/Api/AlertingApi.md#getheartbeatalertsalertid) | **GET** /api/v2/alerting/heartbeat/alerts/{alertId} | Get a heart beat alert
*AlertingApi* | [**getHeartbeatRules**](docs/Api/AlertingApi.md#getheartbeatrules) | **GET** /api/v2/alerting/heartbeat/rules | Get a heart beat rule list.
*AlertingApi* | [**getHeartbeatRulesRuleId**](docs/Api/AlertingApi.md#getheartbeatrulesruleid) | **GET** /api/v2/alerting/heartbeat/rules/{ruleId} | Get a heart beat rule.
*AlertingApi* | [**getInteractionstatsAlerts**](docs/Api/AlertingApi.md#getinteractionstatsalerts) | **GET** /api/v2/alerting/interactionstats/alerts | Get interaction stats alert list.
*AlertingApi* | [**getInteractionstatsAlertsAlertId**](docs/Api/AlertingApi.md#getinteractionstatsalertsalertid) | **GET** /api/v2/alerting/interactionstats/alerts/{alertId} | Get an interaction stats alert
*AlertingApi* | [**getInteractionstatsAlertsUnread**](docs/Api/AlertingApi.md#getinteractionstatsalertsunread) | **GET** /api/v2/alerting/interactionstats/alerts/unread | Gets user unread count of interaction stats alerts.
*AlertingApi* | [**getInteractionstatsRules**](docs/Api/AlertingApi.md#getinteractionstatsrules) | **GET** /api/v2/alerting/interactionstats/rules | Get an interaction stats rule list.
*AlertingApi* | [**getInteractionstatsRulesRuleId**](docs/Api/AlertingApi.md#getinteractionstatsrulesruleid) | **GET** /api/v2/alerting/interactionstats/rules/{ruleId} | Get an interaction stats rule.
*AlertingApi* | [**postHeartbeatRules**](docs/Api/AlertingApi.md#postheartbeatrules) | **POST** /api/v2/alerting/heartbeat/rules | Create a heart beat rule.
*AlertingApi* | [**postInteractionstatsRules**](docs/Api/AlertingApi.md#postinteractionstatsrules) | **POST** /api/v2/alerting/interactionstats/rules | Create an interaction stats rule.
*AlertingApi* | [**putHeartbeatRulesRuleId**](docs/Api/AlertingApi.md#putheartbeatrulesruleid) | **PUT** /api/v2/alerting/heartbeat/rules/{ruleId} | Update a heart beat rule
*AlertingApi* | [**putInteractionstatsAlertsAlertId**](docs/Api/AlertingApi.md#putinteractionstatsalertsalertid) | **PUT** /api/v2/alerting/interactionstats/alerts/{alertId} | Update an interaction stats alert read status
*AlertingApi* | [**putInteractionstatsRulesRuleId**](docs/Api/AlertingApi.md#putinteractionstatsrulesruleid) | **PUT** /api/v2/alerting/interactionstats/rules/{ruleId} | Update an interaction stats rule
*AnalyticsApi* | [**deleteReportingSchedulesScheduleId**](docs/Api/AnalyticsApi.md#deletereportingschedulesscheduleid) | **DELETE** /api/v2/analytics/reporting/schedules/{scheduleId} | Delete a scheduled report job.
*AnalyticsApi* | [**getConversationsConversationIdDetails**](docs/Api/AnalyticsApi.md#getconversationsconversationiddetails) | **GET** /api/v2/analytics/conversations/{conversationId}/details | Get a conversation by id
*AnalyticsApi* | [**getReportingMetadata**](docs/Api/AnalyticsApi.md#getreportingmetadata) | **GET** /api/v2/analytics/reporting/metadata | Get list of reporting metadata.
*AnalyticsApi* | [**getReportingReportIdMetadata**](docs/Api/AnalyticsApi.md#getreportingreportidmetadata) | **GET** /api/v2/analytics/reporting/{reportId}/metadata | Get a reporting metadata.
*AnalyticsApi* | [**getReportingReportformats**](docs/Api/AnalyticsApi.md#getreportingreportformats) | **GET** /api/v2/analytics/reporting/reportformats | Get a list of report formats
*AnalyticsApi* | [**getReportingSchedules**](docs/Api/AnalyticsApi.md#getreportingschedules) | **GET** /api/v2/analytics/reporting/schedules | Get a list of scheduled report jobs
*AnalyticsApi* | [**getReportingSchedulesScheduleId**](docs/Api/AnalyticsApi.md#getreportingschedulesscheduleid) | **GET** /api/v2/analytics/reporting/schedules/{scheduleId} | Get a scheduled report job.
*AnalyticsApi* | [**getReportingSchedulesScheduleIdHistory**](docs/Api/AnalyticsApi.md#getreportingschedulesscheduleidhistory) | **GET** /api/v2/analytics/reporting/schedules/{scheduleId}/history | Get list of completed scheduled report jobs.
*AnalyticsApi* | [**getReportingSchedulesScheduleIdHistoryLatest**](docs/Api/AnalyticsApi.md#getreportingschedulesscheduleidhistorylatest) | **GET** /api/v2/analytics/reporting/schedules/{scheduleId}/history/latest | Get most recently completed scheduled report job.
*AnalyticsApi* | [**getReportingSchedulesScheduleIdHistoryRunId**](docs/Api/AnalyticsApi.md#getreportingschedulesscheduleidhistoryrunid) | **GET** /api/v2/analytics/reporting/schedules/{scheduleId}/history/{runId} | A completed scheduled report job
*AnalyticsApi* | [**getReportingTimeperiods**](docs/Api/AnalyticsApi.md#getreportingtimeperiods) | **GET** /api/v2/analytics/reporting/timeperiods | Get a list of report time periods.
*AnalyticsApi* | [**postConversationsAggregatesQuery**](docs/Api/AnalyticsApi.md#postconversationsaggregatesquery) | **POST** /api/v2/analytics/conversations/aggregates/query | Query for conversation aggregates
*AnalyticsApi* | [**postConversationsConversationIdDetailsProperties**](docs/Api/AnalyticsApi.md#postconversationsconversationiddetailsproperties) | **POST** /api/v2/analytics/conversations/{conversationId}/details/properties | Index conversation properties
*AnalyticsApi* | [**postConversationsDetailsQuery**](docs/Api/AnalyticsApi.md#postconversationsdetailsquery) | **POST** /api/v2/analytics/conversations/details/query | Query for conversation details
*AnalyticsApi* | [**postEvaluationsAggregatesQuery**](docs/Api/AnalyticsApi.md#postevaluationsaggregatesquery) | **POST** /api/v2/analytics/evaluations/aggregates/query | Query for evaluation aggregates
*AnalyticsApi* | [**postQueuesObservationsQuery**](docs/Api/AnalyticsApi.md#postqueuesobservationsquery) | **POST** /api/v2/analytics/queues/observations/query | Query for queue observations
*AnalyticsApi* | [**postReportingSchedules**](docs/Api/AnalyticsApi.md#postreportingschedules) | **POST** /api/v2/analytics/reporting/schedules | Create a scheduled report job
*AnalyticsApi* | [**postReportingSchedulesScheduleIdRunreport**](docs/Api/AnalyticsApi.md#postreportingschedulesscheduleidrunreport) | **POST** /api/v2/analytics/reporting/schedules/{scheduleId}/runreport | Place a scheduled report immediately into the reporting queue
*AnalyticsApi* | [**postUsersAggregatesQuery**](docs/Api/AnalyticsApi.md#postusersaggregatesquery) | **POST** /api/v2/analytics/users/aggregates/query | Query for user aggregates
*AnalyticsApi* | [**postUsersObservationsQuery**](docs/Api/AnalyticsApi.md#postusersobservationsquery) | **POST** /api/v2/analytics/users/observations/query | Query for user observations
*AnalyticsApi* | [**putReportingSchedulesScheduleId**](docs/Api/AnalyticsApi.md#putreportingschedulesscheduleid) | **PUT** /api/v2/analytics/reporting/schedules/{scheduleId} | Update a scheduled report job.
*AttributesApi* | [**deleteAttributeId**](docs/Api/AttributesApi.md#deleteattributeid) | **DELETE** /api/v2/attributes/{attributeId} | Delete an existing Attribute.
*AttributesApi* | [**getAttributeId**](docs/Api/AttributesApi.md#getattributeid) | **GET** /api/v2/attributes/{attributeId} | Get details about an existing attribute.
*AttributesApi* | [**getAttributes**](docs/Api/AttributesApi.md#getattributes) | **GET** /api/v2/attributes | Gets a list of existing attributes.
*AttributesApi* | [**postAttributes**](docs/Api/AttributesApi.md#postattributes) | **POST** /api/v2/attributes | Create an attribute.
*AttributesApi* | [**postQuery**](docs/Api/AttributesApi.md#postquery) | **POST** /api/v2/attributes/query | Query attributes
*AttributesApi* | [**putAttributeId**](docs/Api/AttributesApi.md#putattributeid) | **PUT** /api/v2/attributes/{attributeId} | Update an existing attribute.
*AuthorizationApi* | [**deleteRolesRoleId**](docs/Api/AuthorizationApi.md#deleterolesroleid) | **DELETE** /api/v2/authorization/roles/{roleId} | Delete an organization role.
*AuthorizationApi* | [**deleteUserIdRoles**](docs/Api/AuthorizationApi.md#deleteuseridroles) | **DELETE** /api/v2/users/{userId}/roles | Removes all the roles from the user.
*AuthorizationApi* | [**getPermissions**](docs/Api/AuthorizationApi.md#getpermissions) | **GET** /api/v2/authorization/permissions | Get all permissions.
*AuthorizationApi* | [**getProducts**](docs/Api/AuthorizationApi.md#getproducts) | **GET** /api/v2/authorization/products | Get the list of enabled products
*AuthorizationApi* | [**getRoles**](docs/Api/AuthorizationApi.md#getroles) | **GET** /api/v2/authorization/roles | Retrieve a list of all roles defined for the organization
*AuthorizationApi* | [**getRolesLeftroleIdComparedefaultRightroleId**](docs/Api/AuthorizationApi.md#getrolesleftroleidcomparedefaultrightroleid) | **GET** /api/v2/authorization/roles/{leftRoleId}/comparedefault/{rightRoleId} | Get an org role to default role comparison comparison
*AuthorizationApi* | [**getRolesRoleId**](docs/Api/AuthorizationApi.md#getrolesroleid) | **GET** /api/v2/authorization/roles/{roleId} | Get a single organization role.
*AuthorizationApi* | [**getUserIdRoles**](docs/Api/AuthorizationApi.md#getuseridroles) | **GET** /api/v2/users/{userId}/roles | Returns a listing of roles and permissions for a user.
*AuthorizationApi* | [**patchRolesRoleId**](docs/Api/AuthorizationApi.md#patchrolesroleid) | **PATCH** /api/v2/authorization/roles/{roleId} | Patch Organization Role for needsUpdate Field
*AuthorizationApi* | [**postRoles**](docs/Api/AuthorizationApi.md#postroles) | **POST** /api/v2/authorization/roles | Create an organization role.
*AuthorizationApi* | [**postRolesDefault**](docs/Api/AuthorizationApi.md#postrolesdefault) | **POST** /api/v2/authorization/roles/default | Restores all default roles
*AuthorizationApi* | [**postRolesLeftroleIdComparedefaultRightroleId**](docs/Api/AuthorizationApi.md#postrolesleftroleidcomparedefaultrightroleid) | **POST** /api/v2/authorization/roles/{leftRoleId}/comparedefault/{rightRoleId} | Get an unsaved org role to default role comparison
*AuthorizationApi* | [**putRolesDefault**](docs/Api/AuthorizationApi.md#putrolesdefault) | **PUT** /api/v2/authorization/roles/default | Restore specified default roles
*AuthorizationApi* | [**putRolesRoleId**](docs/Api/AuthorizationApi.md#putrolesroleid) | **PUT** /api/v2/authorization/roles/{roleId} | Update an organization role.
*AuthorizationApi* | [**putRolesRoleIdUsersAdd**](docs/Api/AuthorizationApi.md#putrolesroleidusersadd) | **PUT** /api/v2/authorization/roles/{roleId}/users/add | Sets the users for the role
*AuthorizationApi* | [**putRolesRoleIdUsersRemove**](docs/Api/AuthorizationApi.md#putrolesroleidusersremove) | **PUT** /api/v2/authorization/roles/{roleId}/users/remove | Removes the users from the role
*AuthorizationApi* | [**putUserIdRoles**](docs/Api/AuthorizationApi.md#putuseridroles) | **PUT** /api/v2/users/{userId}/roles | Sets the user&#39;s roles
*ContentManagementApi* | [**deleteDocumentsDocumentId**](docs/Api/ContentManagementApi.md#deletedocumentsdocumentid) | **DELETE** /api/v2/contentmanagement/documents/{documentId} | Delete a document.
*ContentManagementApi* | [**deleteSharesShareId**](docs/Api/ContentManagementApi.md#deletesharesshareid) | **DELETE** /api/v2/contentmanagement/shares/{shareId} | Deletes an existing share.
*ContentManagementApi* | [**deleteStatusStatusId**](docs/Api/ContentManagementApi.md#deletestatusstatusid) | **DELETE** /api/v2/contentmanagement/status/{statusId} | Cancel the command for this status
*ContentManagementApi* | [**deleteWorkspacesWorkspaceId**](docs/Api/ContentManagementApi.md#deleteworkspacesworkspaceid) | **DELETE** /api/v2/contentmanagement/workspaces/{workspaceId} | Delete a workspace
*ContentManagementApi* | [**deleteWorkspacesWorkspaceIdMembersMemberId**](docs/Api/ContentManagementApi.md#deleteworkspacesworkspaceidmembersmemberid) | **DELETE** /api/v2/contentmanagement/workspaces/{workspaceId}/members/{memberId} | Delete a member from a workspace
*ContentManagementApi* | [**deleteWorkspacesWorkspaceIdTagvaluesTagId**](docs/Api/ContentManagementApi.md#deleteworkspacesworkspaceidtagvaluestagid) | **DELETE** /api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues/{tagId} | Delete workspace tag
*ContentManagementApi* | [**getDocuments**](docs/Api/ContentManagementApi.md#getdocuments) | **GET** /api/v2/contentmanagement/documents | Get a list of documents.
*ContentManagementApi* | [**getDocumentsDocumentId**](docs/Api/ContentManagementApi.md#getdocumentsdocumentid) | **GET** /api/v2/contentmanagement/documents/{documentId} | Get a document.
*ContentManagementApi* | [**getDocumentsDocumentIdAudits**](docs/Api/ContentManagementApi.md#getdocumentsdocumentidaudits) | **GET** /api/v2/contentmanagement/documents/{documentId}/audits | Get a list of audits for a document.
*ContentManagementApi* | [**getDocumentsDocumentIdContent**](docs/Api/ContentManagementApi.md#getdocumentsdocumentidcontent) | **GET** /api/v2/contentmanagement/documents/{documentId}/content | Download a document.
*ContentManagementApi* | [**getQuery**](docs/Api/ContentManagementApi.md#getquery) | **GET** /api/v2/contentmanagement/query | Query content
*ContentManagementApi* | [**getSecurityprofiles**](docs/Api/ContentManagementApi.md#getsecurityprofiles) | **GET** /api/v2/contentmanagement/securityprofiles | Get a List of Security Profiles
*ContentManagementApi* | [**getSecurityprofilesSecurityprofileId**](docs/Api/ContentManagementApi.md#getsecurityprofilessecurityprofileid) | **GET** /api/v2/contentmanagement/securityprofiles/{securityProfileId} | Get a Security Profile
*ContentManagementApi* | [**getSharedSharedId**](docs/Api/ContentManagementApi.md#getsharedsharedid) | **GET** /api/v2/contentmanagement/shared/{sharedId} | Get shared documents. Securely download a shared document.
*ContentManagementApi* | [**getShares**](docs/Api/ContentManagementApi.md#getshares) | **GET** /api/v2/contentmanagement/shares | Gets a list of shares.  You must specify at least one filter (e.g. entityId).
*ContentManagementApi* | [**getSharesShareId**](docs/Api/ContentManagementApi.md#getsharesshareid) | **GET** /api/v2/contentmanagement/shares/{shareId} | Retrieve details about an existing share.
*ContentManagementApi* | [**getStatus**](docs/Api/ContentManagementApi.md#getstatus) | **GET** /api/v2/contentmanagement/status | Get a list of statuses for pending operations
*ContentManagementApi* | [**getStatusStatusId**](docs/Api/ContentManagementApi.md#getstatusstatusid) | **GET** /api/v2/contentmanagement/status/{statusId} | Get a status.
*ContentManagementApi* | [**getUsage**](docs/Api/ContentManagementApi.md#getusage) | **GET** /api/v2/contentmanagement/usage | Get usage details.
*ContentManagementApi* | [**getWorkspaces**](docs/Api/ContentManagementApi.md#getworkspaces) | **GET** /api/v2/contentmanagement/workspaces | Get a list of workspaces.
*ContentManagementApi* | [**getWorkspacesWorkspaceId**](docs/Api/ContentManagementApi.md#getworkspacesworkspaceid) | **GET** /api/v2/contentmanagement/workspaces/{workspaceId} | Get a workspace.
*ContentManagementApi* | [**getWorkspacesWorkspaceIdMembers**](docs/Api/ContentManagementApi.md#getworkspacesworkspaceidmembers) | **GET** /api/v2/contentmanagement/workspaces/{workspaceId}/members | Get a list workspace members
*ContentManagementApi* | [**getWorkspacesWorkspaceIdMembersMemberId**](docs/Api/ContentManagementApi.md#getworkspacesworkspaceidmembersmemberid) | **GET** /api/v2/contentmanagement/workspaces/{workspaceId}/members/{memberId} | Get a workspace member
*ContentManagementApi* | [**getWorkspacesWorkspaceIdTagvalues**](docs/Api/ContentManagementApi.md#getworkspacesworkspaceidtagvalues) | **GET** /api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues | Get a list of workspace tags
*ContentManagementApi* | [**getWorkspacesWorkspaceIdTagvaluesTagId**](docs/Api/ContentManagementApi.md#getworkspacesworkspaceidtagvaluestagid) | **GET** /api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues/{tagId} | Get a workspace tag
*ContentManagementApi* | [**postAuditquery**](docs/Api/ContentManagementApi.md#postauditquery) | **POST** /api/v2/contentmanagement/auditquery | Query audits
*ContentManagementApi* | [**postDocuments**](docs/Api/ContentManagementApi.md#postdocuments) | **POST** /api/v2/contentmanagement/documents | Add a document.
*ContentManagementApi* | [**postDocumentsDocumentId**](docs/Api/ContentManagementApi.md#postdocumentsdocumentid) | **POST** /api/v2/contentmanagement/documents/{documentId} | Update a document.
*ContentManagementApi* | [**postDocumentsDocumentIdContent**](docs/Api/ContentManagementApi.md#postdocumentsdocumentidcontent) | **POST** /api/v2/contentmanagement/documents/{documentId}/content | Replace the contents of a document.
*ContentManagementApi* | [**postQuery**](docs/Api/ContentManagementApi.md#postquery) | **POST** /api/v2/contentmanagement/query | Query content
*ContentManagementApi* | [**postShares**](docs/Api/ContentManagementApi.md#postshares) | **POST** /api/v2/contentmanagement/shares | Creates a new share or updates an existing share if the entity has already been shared
*ContentManagementApi* | [**postWorkspaces**](docs/Api/ContentManagementApi.md#postworkspaces) | **POST** /api/v2/contentmanagement/workspaces | Create a group workspace
*ContentManagementApi* | [**postWorkspacesWorkspaceIdTagvalues**](docs/Api/ContentManagementApi.md#postworkspacesworkspaceidtagvalues) | **POST** /api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues | Create a workspace tag
*ContentManagementApi* | [**postWorkspacesWorkspaceIdTagvaluesQuery**](docs/Api/ContentManagementApi.md#postworkspacesworkspaceidtagvaluesquery) | **POST** /api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues/query | Perform a prefix query on tags in the workspace
*ContentManagementApi* | [**putWorkspacesWorkspaceId**](docs/Api/ContentManagementApi.md#putworkspacesworkspaceid) | **PUT** /api/v2/contentmanagement/workspaces/{workspaceId} | Update a workspace
*ContentManagementApi* | [**putWorkspacesWorkspaceIdMembersMemberId**](docs/Api/ContentManagementApi.md#putworkspacesworkspaceidmembersmemberid) | **PUT** /api/v2/contentmanagement/workspaces/{workspaceId}/members/{memberId} | Add a member to a workspace
*ContentManagementApi* | [**putWorkspacesWorkspaceIdTagvaluesTagId**](docs/Api/ContentManagementApi.md#putworkspacesworkspaceidtagvaluestagid) | **PUT** /api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues/{tagId} | Update a workspace tag. Will update all documents with the new tag value.
*ConversationsApi* | [**deleteCallsCallIdParticipantsParticipantIdConsult**](docs/Api/ConversationsApi.md#deletecallscallidparticipantsparticipantidconsult) | **DELETE** /api/v2/conversations/calls/{callId}/participants/{participantId}/consult | Cancel the transfer
*ConversationsApi* | [**deleteConversationIdParticipantsParticipantIdCodesAddcommunicationcode**](docs/Api/ConversationsApi.md#deleteconversationidparticipantsparticipantidcodesaddcommunicationcode) | **DELETE** /api/v2/conversations/{conversationId}/participants/{participantId}/codes/{addCommunicationCode} | Delete a code used to add a communication to this participant
*ConversationsApi* | [**deleteEmailsEmailIdMessagesDraftAttachmentsAttachmentId**](docs/Api/ConversationsApi.md#deleteemailsemailidmessagesdraftattachmentsattachmentid) | **DELETE** /api/v2/conversations/emails/{emailId}/messages/draft/attachments/{attachmentId} | Delete attachment from draft
*ConversationsApi* | [**getCallbacks**](docs/Api/ConversationsApi.md#getcallbacks) | **GET** /api/v2/conversations/callbacks | Get callback conversations
*ConversationsApi* | [**getCallbacksCallbackId**](docs/Api/ConversationsApi.md#getcallbackscallbackid) | **GET** /api/v2/conversations/callbacks/{callbackId} | Get callback conversation
*ConversationsApi* | [**getCallbacksCallbackIdParticipantsParticipantIdWrapup**](docs/Api/ConversationsApi.md#getcallbackscallbackidparticipantsparticipantidwrapup) | **GET** /api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/wrapup | Get the wrap-up for this conversation participant.
*ConversationsApi* | [**getCallbacksCallbackIdParticipantsParticipantIdWrapupcodes**](docs/Api/ConversationsApi.md#getcallbackscallbackidparticipantsparticipantidwrapupcodes) | **GET** /api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/wrapupcodes | Get list of wrapup codes for this conversation participant
*ConversationsApi* | [**getCalls**](docs/Api/ConversationsApi.md#getcalls) | **GET** /api/v2/conversations/calls | Get recent conversations
*ConversationsApi* | [**getCallsCallId**](docs/Api/ConversationsApi.md#getcallscallid) | **GET** /api/v2/conversations/calls/{callId} | Get call conversation
*ConversationsApi* | [**getCallsCallIdParticipantsParticipantIdWrapup**](docs/Api/ConversationsApi.md#getcallscallidparticipantsparticipantidwrapup) | **GET** /api/v2/conversations/calls/{callId}/participants/{participantId}/wrapup | Get the wrap-up for this conversation participant.
*ConversationsApi* | [**getCallsCallIdParticipantsParticipantIdWrapupcodes**](docs/Api/ConversationsApi.md#getcallscallidparticipantsparticipantidwrapupcodes) | **GET** /api/v2/conversations/calls/{callId}/participants/{participantId}/wrapupcodes | Get list of wrapup codes for this conversation participant
*ConversationsApi* | [**getCallsHistory**](docs/Api/ConversationsApi.md#getcallshistory) | **GET** /api/v2/conversations/calls/history | Get call history
*ConversationsApi* | [**getCallsMaximumconferenceparties**](docs/Api/ConversationsApi.md#getcallsmaximumconferenceparties) | **GET** /api/v2/conversations/calls/maximumconferenceparties | Get the maximum number of participants that this user can have on a conference
*ConversationsApi* | [**getChats**](docs/Api/ConversationsApi.md#getchats) | **GET** /api/v2/conversations/chats | Get recent chat conversations
*ConversationsApi* | [**getChatsChatId**](docs/Api/ConversationsApi.md#getchatschatid) | **GET** /api/v2/conversations/chats/{chatId} | Get chat conversation
*ConversationsApi* | [**getChatsChatIdParticipantsParticipantIdWrapup**](docs/Api/ConversationsApi.md#getchatschatidparticipantsparticipantidwrapup) | **GET** /api/v2/conversations/chats/{chatId}/participants/{participantId}/wrapup | Get the wrap-up for this conversation participant.
*ConversationsApi* | [**getChatsChatIdParticipantsParticipantIdWrapupcodes**](docs/Api/ConversationsApi.md#getchatschatidparticipantsparticipantidwrapupcodes) | **GET** /api/v2/conversations/chats/{chatId}/participants/{participantId}/wrapupcodes | Get list of wrapup codes for this conversation participant
*ConversationsApi* | [**getCobrowsesessions**](docs/Api/ConversationsApi.md#getcobrowsesessions) | **GET** /api/v2/conversations/cobrowsesessions | Get recent cobrowse conversations
*ConversationsApi* | [**getCobrowsesessionsCobrowseId**](docs/Api/ConversationsApi.md#getcobrowsesessionscobrowseid) | **GET** /api/v2/conversations/cobrowsesessions/{cobrowseId} | Get cobrowse conversation
*ConversationsApi* | [**getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapup**](docs/Api/ConversationsApi.md#getcobrowsesessionscobrowseidparticipantsparticipantidwrapup) | **GET** /api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/wrapup | Get the wrap-up for this conversation participant.
*ConversationsApi* | [**getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapupcodes**](docs/Api/ConversationsApi.md#getcobrowsesessionscobrowseidparticipantsparticipantidwrapupcodes) | **GET** /api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/wrapupcodes | Get list of wrapup codes for this conversation participant
*ConversationsApi* | [**getConversationId**](docs/Api/ConversationsApi.md#getconversationid) | **GET** /api/v2/conversations/{conversationId} | Get conversation
*ConversationsApi* | [**getConversationIdParticipantsParticipantIdWrapup**](docs/Api/ConversationsApi.md#getconversationidparticipantsparticipantidwrapup) | **GET** /api/v2/conversations/{conversationId}/participants/{participantId}/wrapup | Get the wrap-up for this conversation participant.
*ConversationsApi* | [**getConversationIdParticipantsParticipantIdWrapupcodes**](docs/Api/ConversationsApi.md#getconversationidparticipantsparticipantidwrapupcodes) | **GET** /api/v2/conversations/{conversationId}/participants/{participantId}/wrapupcodes | Get list of wrapup codes for this conversation participant
*ConversationsApi* | [**getConversations**](docs/Api/ConversationsApi.md#getconversations) | **GET** /api/v2/conversations | Get conversations
*ConversationsApi* | [**getConversationsConversationIdDetails**](docs/Api/ConversationsApi.md#getconversationsconversationiddetails) | **GET** /api/v2/analytics/conversations/{conversationId}/details | Get a conversation by id
*ConversationsApi* | [**getEmails**](docs/Api/ConversationsApi.md#getemails) | **GET** /api/v2/conversations/emails | Get recent email conversations
*ConversationsApi* | [**getEmailsEmailId**](docs/Api/ConversationsApi.md#getemailsemailid) | **GET** /api/v2/conversations/emails/{emailId} | Get email conversation
*ConversationsApi* | [**getEmailsEmailIdMessages**](docs/Api/ConversationsApi.md#getemailsemailidmessages) | **GET** /api/v2/conversations/emails/{emailId}/messages | Get conversation messages
*ConversationsApi* | [**getEmailsEmailIdMessagesDraft**](docs/Api/ConversationsApi.md#getemailsemailidmessagesdraft) | **GET** /api/v2/conversations/emails/{emailId}/messages/draft | Get conversation draft reply
*ConversationsApi* | [**getEmailsEmailIdMessagesMessageId**](docs/Api/ConversationsApi.md#getemailsemailidmessagesmessageid) | **GET** /api/v2/conversations/emails/{emailId}/messages/{messageId} | Get conversation message
*ConversationsApi* | [**getEmailsEmailIdParticipantsParticipantIdWrapup**](docs/Api/ConversationsApi.md#getemailsemailidparticipantsparticipantidwrapup) | **GET** /api/v2/conversations/emails/{emailId}/participants/{participantId}/wrapup | Get the wrap-up for this conversation participant.
*ConversationsApi* | [**getEmailsEmailIdParticipantsParticipantIdWrapupcodes**](docs/Api/ConversationsApi.md#getemailsemailidparticipantsparticipantidwrapupcodes) | **GET** /api/v2/conversations/emails/{emailId}/participants/{participantId}/wrapupcodes | Get list of wrapup codes for this conversation participant
*ConversationsApi* | [**patchCallbacksCallbackId**](docs/Api/ConversationsApi.md#patchcallbackscallbackid) | **PATCH** /api/v2/conversations/callbacks/{callbackId} | Update a conversation by disconnecting all of the participants
*ConversationsApi* | [**patchCallbacksCallbackIdParticipantsParticipantId**](docs/Api/ConversationsApi.md#patchcallbackscallbackidparticipantsparticipantid) | **PATCH** /api/v2/conversations/callbacks/{callbackId}/participants/{participantId} | Update conversation participant
*ConversationsApi* | [**patchCallbacksCallbackIdParticipantsParticipantIdAttributes**](docs/Api/ConversationsApi.md#patchcallbackscallbackidparticipantsparticipantidattributes) | **PATCH** /api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/attributes | Update the attributes on a conversation participant.
*ConversationsApi* | [**patchCallbacksCallbackIdParticipantsParticipantIdCommunicationsCommunicationId**](docs/Api/ConversationsApi.md#patchcallbackscallbackidparticipantsparticipantidcommunicationscommunicationid) | **PATCH** /api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/communications/{communicationId} | Update conversation participant&#39;s communication by disconnecting it.
*ConversationsApi* | [**patchCallsCallId**](docs/Api/ConversationsApi.md#patchcallscallid) | **PATCH** /api/v2/conversations/calls/{callId} | Update a conversation by setting it&#39;s recording state, merging in other conversations to create a conference, or disconnecting all of the participants
*ConversationsApi* | [**patchCallsCallIdParticipantsParticipantId**](docs/Api/ConversationsApi.md#patchcallscallidparticipantsparticipantid) | **PATCH** /api/v2/conversations/calls/{callId}/participants/{participantId} | Update conversation participant
*ConversationsApi* | [**patchCallsCallIdParticipantsParticipantIdAttributes**](docs/Api/ConversationsApi.md#patchcallscallidparticipantsparticipantidattributes) | **PATCH** /api/v2/conversations/calls/{callId}/participants/{participantId}/attributes | Update the attributes on a conversation participant.
*ConversationsApi* | [**patchCallsCallIdParticipantsParticipantIdCommunicationsCommunicationId**](docs/Api/ConversationsApi.md#patchcallscallidparticipantsparticipantidcommunicationscommunicationid) | **PATCH** /api/v2/conversations/calls/{callId}/participants/{participantId}/communications/{communicationId} | Update conversation participant&#39;s communication by disconnecting it.
*ConversationsApi* | [**patchCallsCallIdParticipantsParticipantIdConsult**](docs/Api/ConversationsApi.md#patchcallscallidparticipantsparticipantidconsult) | **PATCH** /api/v2/conversations/calls/{callId}/participants/{participantId}/consult | Change who can speak
*ConversationsApi* | [**patchChatsChatId**](docs/Api/ConversationsApi.md#patchchatschatid) | **PATCH** /api/v2/conversations/chats/{chatId} | Update a conversation by disconnecting all of the participants
*ConversationsApi* | [**patchChatsChatIdParticipantsParticipantId**](docs/Api/ConversationsApi.md#patchchatschatidparticipantsparticipantid) | **PATCH** /api/v2/conversations/chats/{chatId}/participants/{participantId} | Update conversation participant
*ConversationsApi* | [**patchChatsChatIdParticipantsParticipantIdAttributes**](docs/Api/ConversationsApi.md#patchchatschatidparticipantsparticipantidattributes) | **PATCH** /api/v2/conversations/chats/{chatId}/participants/{participantId}/attributes | Update the attributes on a conversation participant.
*ConversationsApi* | [**patchChatsChatIdParticipantsParticipantIdCommunicationsCommunicationId**](docs/Api/ConversationsApi.md#patchchatschatidparticipantsparticipantidcommunicationscommunicationid) | **PATCH** /api/v2/conversations/chats/{chatId}/participants/{participantId}/communications/{communicationId} | Update conversation participant&#39;s communication by disconnecting it.
*ConversationsApi* | [**patchCobrowsesessionsCobrowseId**](docs/Api/ConversationsApi.md#patchcobrowsesessionscobrowseid) | **PATCH** /api/v2/conversations/cobrowsesessions/{cobrowseId} | Update a conversation by disconnecting all of the participants
*ConversationsApi* | [**patchCobrowsesessionsCobrowseIdParticipantsParticipantId**](docs/Api/ConversationsApi.md#patchcobrowsesessionscobrowseidparticipantsparticipantid) | **PATCH** /api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId} | Update conversation participant
*ConversationsApi* | [**patchCobrowsesessionsCobrowseIdParticipantsParticipantIdAttributes**](docs/Api/ConversationsApi.md#patchcobrowsesessionscobrowseidparticipantsparticipantidattributes) | **PATCH** /api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/attributes | Update the attributes on a conversation participant.
*ConversationsApi* | [**patchCobrowsesessionsCobrowseIdParticipantsParticipantIdCommunicationsCommunicationId**](docs/Api/ConversationsApi.md#patchcobrowsesessionscobrowseidparticipantsparticipantidcommunicationscommunicationid) | **PATCH** /api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/communications/{communicationId} | Update conversation participant&#39;s communication by disconnecting it.
*ConversationsApi* | [**patchConversationIdParticipantsParticipantId**](docs/Api/ConversationsApi.md#patchconversationidparticipantsparticipantid) | **PATCH** /api/v2/conversations/{conversationId}/participants/{participantId} | Update a participant.
*ConversationsApi* | [**patchConversationIdParticipantsParticipantIdAttributes**](docs/Api/ConversationsApi.md#patchconversationidparticipantsparticipantidattributes) | **PATCH** /api/v2/conversations/{conversationId}/participants/{participantId}/attributes | Update the attributes on a conversation participant.
*ConversationsApi* | [**patchEmailsEmailId**](docs/Api/ConversationsApi.md#patchemailsemailid) | **PATCH** /api/v2/conversations/emails/{emailId} | Update a conversation by disconnecting all of the participants
*ConversationsApi* | [**patchEmailsEmailIdParticipantsParticipantId**](docs/Api/ConversationsApi.md#patchemailsemailidparticipantsparticipantid) | **PATCH** /api/v2/conversations/emails/{emailId}/participants/{participantId} | Update conversation participant
*ConversationsApi* | [**patchEmailsEmailIdParticipantsParticipantIdAttributes**](docs/Api/ConversationsApi.md#patchemailsemailidparticipantsparticipantidattributes) | **PATCH** /api/v2/conversations/emails/{emailId}/participants/{participantId}/attributes | Update the attributes on a conversation participant.
*ConversationsApi* | [**patchEmailsEmailIdParticipantsParticipantIdCommunicationsCommunicationId**](docs/Api/ConversationsApi.md#patchemailsemailidparticipantsparticipantidcommunicationscommunicationid) | **PATCH** /api/v2/conversations/emails/{emailId}/participants/{participantId}/communications/{communicationId} | Update conversation participant&#39;s communication by disconnecting it.
*ConversationsApi* | [**postCallbacks**](docs/Api/ConversationsApi.md#postcallbacks) | **POST** /api/v2/conversations/callbacks | Create a Callback
*ConversationsApi* | [**postCallbacksCallbackIdParticipantsParticipantIdReplace**](docs/Api/ConversationsApi.md#postcallbackscallbackidparticipantsparticipantidreplace) | **POST** /api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/replace | Replace this participant with the specified user and/or address
*ConversationsApi* | [**postCalls**](docs/Api/ConversationsApi.md#postcalls) | **POST** /api/v2/conversations/calls | Create a call conversation
*ConversationsApi* | [**postCallsCallId**](docs/Api/ConversationsApi.md#postcallscallid) | **POST** /api/v2/conversations/calls/{callId} | Add a new call to a conversation
*ConversationsApi* | [**postCallsCallIdParticipants**](docs/Api/ConversationsApi.md#postcallscallidparticipants) | **POST** /api/v2/conversations/calls/{callId}/participants | Add participants to a conversation
*ConversationsApi* | [**postCallsCallIdParticipantsParticipantIdConsult**](docs/Api/ConversationsApi.md#postcallscallidparticipantsparticipantidconsult) | **POST** /api/v2/conversations/calls/{callId}/participants/{participantId}/consult | Initiate and update consult transfer
*ConversationsApi* | [**postCallsCallIdParticipantsParticipantIdMonitor**](docs/Api/ConversationsApi.md#postcallscallidparticipantsparticipantidmonitor) | **POST** /api/v2/conversations/calls/{callId}/participants/{participantId}/monitor | Listen in on the conversation from the point of view of a given participant.
*ConversationsApi* | [**postCallsCallIdParticipantsParticipantIdReplace**](docs/Api/ConversationsApi.md#postcallscallidparticipantsparticipantidreplace) | **POST** /api/v2/conversations/calls/{callId}/participants/{participantId}/replace | Replace this participant with the specified user and/or address
*ConversationsApi* | [**postChatsChatIdParticipantsParticipantIdReplace**](docs/Api/ConversationsApi.md#postchatschatidparticipantsparticipantidreplace) | **POST** /api/v2/conversations/chats/{chatId}/participants/{participantId}/replace | Replace this participant with the specified user and/or address
*ConversationsApi* | [**postCobrowsesessionsCobrowseIdParticipantsParticipantIdReplace**](docs/Api/ConversationsApi.md#postcobrowsesessionscobrowseidparticipantsparticipantidreplace) | **POST** /api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/replace | Replace this participant with the specified user and/or address
*ConversationsApi* | [**postConversationIdParticipantsParticipantIdCallbacks**](docs/Api/ConversationsApi.md#postconversationidparticipantsparticipantidcallbacks) | **POST** /api/v2/conversations/{conversationId}/participants/{participantId}/callbacks | Create a new callback for the specified participant on the conversation.
*ConversationsApi* | [**postConversationIdParticipantsParticipantIdReplace**](docs/Api/ConversationsApi.md#postconversationidparticipantsparticipantidreplace) | **POST** /api/v2/conversations/{conversationId}/participants/{participantId}/replace | Replace this participant with the specified user and/or address
*ConversationsApi* | [**postConversationsAggregatesQuery**](docs/Api/ConversationsApi.md#postconversationsaggregatesquery) | **POST** /api/v2/analytics/conversations/aggregates/query | Query for conversation aggregates
*ConversationsApi* | [**postConversationsConversationIdDetailsProperties**](docs/Api/ConversationsApi.md#postconversationsconversationiddetailsproperties) | **POST** /api/v2/analytics/conversations/{conversationId}/details/properties | Index conversation properties
*ConversationsApi* | [**postConversationsDetailsQuery**](docs/Api/ConversationsApi.md#postconversationsdetailsquery) | **POST** /api/v2/analytics/conversations/details/query | Query for conversation details
*ConversationsApi* | [**postEmailsEmailIdMessages**](docs/Api/ConversationsApi.md#postemailsemailidmessages) | **POST** /api/v2/conversations/emails/{emailId}/messages | Send an email reply
*ConversationsApi* | [**postEmailsEmailIdParticipantsParticipantIdReplace**](docs/Api/ConversationsApi.md#postemailsemailidparticipantsparticipantidreplace) | **POST** /api/v2/conversations/emails/{emailId}/participants/{participantId}/replace | Replace this participant with the specified user and/or address
*ConversationsApi* | [**postFaxes**](docs/Api/ConversationsApi.md#postfaxes) | **POST** /api/v2/conversations/faxes | Create Fax Conversation
*ConversationsApi* | [**putEmailsEmailIdMessagesDraft**](docs/Api/ConversationsApi.md#putemailsemailidmessagesdraft) | **PUT** /api/v2/conversations/emails/{emailId}/messages/draft | Update conversation draft reply
*FaxApi* | [**deleteDocumentsDocumentId**](docs/Api/FaxApi.md#deletedocumentsdocumentid) | **DELETE** /api/v2/fax/documents/{documentId} | Delete a fax document.
*FaxApi* | [**getDocuments**](docs/Api/FaxApi.md#getdocuments) | **GET** /api/v2/fax/documents | Get a list of fax documents.
*FaxApi* | [**getDocumentsDocumentId**](docs/Api/FaxApi.md#getdocumentsdocumentid) | **GET** /api/v2/fax/documents/{documentId} | Get a document.
*FaxApi* | [**getDocumentsDocumentIdContent**](docs/Api/FaxApi.md#getdocumentsdocumentidcontent) | **GET** /api/v2/fax/documents/{documentId}/content | Download a fax document.
*FaxApi* | [**getSummary**](docs/Api/FaxApi.md#getsummary) | **GET** /api/v2/fax/summary | Get fax summary
*FaxApi* | [**putDocumentsDocumentId**](docs/Api/FaxApi.md#putdocumentsdocumentid) | **PUT** /api/v2/fax/documents/{documentId} | Update a fax document.
*GeolocationApi* | [**getSettings**](docs/Api/GeolocationApi.md#getsettings) | **GET** /api/v2/geolocations/settings | Get a organization&#39;s GeolocationSettings
*GeolocationApi* | [**getUserIdGeolocationsClientId**](docs/Api/GeolocationApi.md#getuseridgeolocationsclientid) | **GET** /api/v2/users/{userId}/geolocations/{clientId} | Get a user&#39;s Geolocation
*GeolocationApi* | [**patchSettings**](docs/Api/GeolocationApi.md#patchsettings) | **PATCH** /api/v2/geolocations/settings | Patch a organization&#39;s GeolocationSettings
*GeolocationApi* | [**patchUserIdGeolocationsClientId**](docs/Api/GeolocationApi.md#patchuseridgeolocationsclientid) | **PATCH** /api/v2/users/{userId}/geolocations/{clientId} | Patch a user&#39;s Geolocation
*GreetingsApi* | [**deleteGreetingId**](docs/Api/GreetingsApi.md#deletegreetingid) | **DELETE** /api/v2/greetings/{greetingId} | Deletes a Greeting with the given GreetingId
*GreetingsApi* | [**getDefaults**](docs/Api/GreetingsApi.md#getdefaults) | **GET** /api/v2/greetings/defaults | Get an Organization&#39;s DefaultGreetingList
*GreetingsApi* | [**getGreetingId**](docs/Api/GreetingsApi.md#getgreetingid) | **GET** /api/v2/greetings/{greetingId} | Get a Greeting with the given GreetingId
*GreetingsApi* | [**getGreetingIdMedia**](docs/Api/GreetingsApi.md#getgreetingidmedia) | **GET** /api/v2/greetings/{greetingId}/media | Get media playback URI for this greeting
*GreetingsApi* | [**getGreetings**](docs/Api/GreetingsApi.md#getgreetings) | **GET** /api/v2/greetings | Gets an Organization&#39;s Greetings
*GreetingsApi* | [**getUserIdGreetings**](docs/Api/GreetingsApi.md#getuseridgreetings) | **GET** /api/v2/users/{userId}/greetings | Get a list of the User&#39;s Greetings
*GreetingsApi* | [**getUserIdGreetingsDefaults**](docs/Api/GreetingsApi.md#getuseridgreetingsdefaults) | **GET** /api/v2/users/{userId}/greetings/defaults | Grabs the list of Default Greetings given a User&#39;s ID
*GreetingsApi* | [**postGreetings**](docs/Api/GreetingsApi.md#postgreetings) | **POST** /api/v2/greetings | Create a Greeting for an Organization
*GreetingsApi* | [**postUserIdGreetings**](docs/Api/GreetingsApi.md#postuseridgreetings) | **POST** /api/v2/users/{userId}/greetings | Creates a Greeting for a User
*GreetingsApi* | [**putDefaults**](docs/Api/GreetingsApi.md#putdefaults) | **PUT** /api/v2/greetings/defaults | Update an Organization&#39;s DefaultGreetingList
*GreetingsApi* | [**putGreetingId**](docs/Api/GreetingsApi.md#putgreetingid) | **PUT** /api/v2/greetings/{greetingId} | Updates the Greeting with the given GreetingId
*GreetingsApi* | [**putUserIdGreetingsDefaults**](docs/Api/GreetingsApi.md#putuseridgreetingsdefaults) | **PUT** /api/v2/users/{userId}/greetings/defaults | Updates the DefaultGreetingList of the specified User
*GroupsApi* | [**deleteGroupId**](docs/Api/GroupsApi.md#deletegroupid) | **DELETE** /api/v2/groups/{groupId} | Delete group
*GroupsApi* | [**deleteGroupIdMembers**](docs/Api/GroupsApi.md#deletegroupidmembers) | **DELETE** /api/v2/groups/{groupId}/members | Remove members
*GroupsApi* | [**getFieldconfig**](docs/Api/GroupsApi.md#getfieldconfig) | **GET** /api/v2/fieldconfig | Fetch field config for an entity type
*GroupsApi* | [**getGroupId**](docs/Api/GroupsApi.md#getgroupid) | **GET** /api/v2/groups/{groupId} | Get group
*GroupsApi* | [**getGroupIdMembers**](docs/Api/GroupsApi.md#getgroupidmembers) | **GET** /api/v2/groups/{groupId}/members | Get group members
*GroupsApi* | [**getGroups**](docs/Api/GroupsApi.md#getgroups) | **GET** /api/v2/groups | Get a group list
*GroupsApi* | [**getSearch**](docs/Api/GroupsApi.md#getsearch) | **GET** /api/v2/groups/search | Search groups using the q64 value returned from a previous search
*GroupsApi* | [**postGroupIdMembers**](docs/Api/GroupsApi.md#postgroupidmembers) | **POST** /api/v2/groups/{groupId}/members | Add members
*GroupsApi* | [**postGroups**](docs/Api/GroupsApi.md#postgroups) | **POST** /api/v2/groups | Create a group
*GroupsApi* | [**postSearch**](docs/Api/GroupsApi.md#postsearch) | **POST** /api/v2/groups/search | Search groups
*GroupsApi* | [**putGroupId**](docs/Api/GroupsApi.md#putgroupid) | **PUT** /api/v2/groups/{groupId} | Update group
*IdentityProviderApi* | [**deleteAdfs**](docs/Api/IdentityProviderApi.md#deleteadfs) | **DELETE** /api/v2/identityproviders/adfs | Delete ADFS Identity Provider
*IdentityProviderApi* | [**deleteCic**](docs/Api/IdentityProviderApi.md#deletecic) | **DELETE** /api/v2/identityproviders/cic | Delete Customer Interaction Center (CIC) Identity Provider
*IdentityProviderApi* | [**deleteOkta**](docs/Api/IdentityProviderApi.md#deleteokta) | **DELETE** /api/v2/identityproviders/okta | Delete Okta Identity Provider
*IdentityProviderApi* | [**deleteOnelogin**](docs/Api/IdentityProviderApi.md#deleteonelogin) | **DELETE** /api/v2/identityproviders/onelogin | Delete OneLogin Identity Provider
*IdentityProviderApi* | [**deleteProviderId**](docs/Api/IdentityProviderApi.md#deleteproviderid) | **DELETE** /api/v2/identityproviders/{providerId} | Delete an identity provider
*IdentityProviderApi* | [**deletePurecloud**](docs/Api/IdentityProviderApi.md#deletepurecloud) | **DELETE** /api/v2/identityproviders/purecloud | Delete PureCloud Identity Provider
*IdentityProviderApi* | [**deleteSalesforce**](docs/Api/IdentityProviderApi.md#deletesalesforce) | **DELETE** /api/v2/identityproviders/salesforce | Delete Salesforce Identity Provider
*IdentityProviderApi* | [**getAdfs**](docs/Api/IdentityProviderApi.md#getadfs) | **GET** /api/v2/identityproviders/adfs | Get ADFS Identity Provider
*IdentityProviderApi* | [**getCic**](docs/Api/IdentityProviderApi.md#getcic) | **GET** /api/v2/identityproviders/cic | Get Customer Interaction Center (CIC) Identity Provider
*IdentityProviderApi* | [**getIdentityproviders**](docs/Api/IdentityProviderApi.md#getidentityproviders) | **GET** /api/v2/identityproviders | The list of identity providers
*IdentityProviderApi* | [**getOkta**](docs/Api/IdentityProviderApi.md#getokta) | **GET** /api/v2/identityproviders/okta | Get Okta Identity Provider
*IdentityProviderApi* | [**getOnelogin**](docs/Api/IdentityProviderApi.md#getonelogin) | **GET** /api/v2/identityproviders/onelogin | Get OneLogin Identity Provider
*IdentityProviderApi* | [**getProviderId**](docs/Api/IdentityProviderApi.md#getproviderid) | **GET** /api/v2/identityproviders/{providerId} | Get an identity provider
*IdentityProviderApi* | [**getPurecloud**](docs/Api/IdentityProviderApi.md#getpurecloud) | **GET** /api/v2/identityproviders/purecloud | Get PureCloud Identity Provider
*IdentityProviderApi* | [**getSalesforce**](docs/Api/IdentityProviderApi.md#getsalesforce) | **GET** /api/v2/identityproviders/salesforce | Get Salesforce Identity Provider
*IdentityProviderApi* | [**putAdfs**](docs/Api/IdentityProviderApi.md#putadfs) | **PUT** /api/v2/identityproviders/adfs | Update/Create ADFS Identity Provider
*IdentityProviderApi* | [**putCic**](docs/Api/IdentityProviderApi.md#putcic) | **PUT** /api/v2/identityproviders/cic | Update/Create Customer Interaction Center (CIC) Identity Provider
*IdentityProviderApi* | [**putOkta**](docs/Api/IdentityProviderApi.md#putokta) | **PUT** /api/v2/identityproviders/okta | Update/Create Okta Identity Provider
*IdentityProviderApi* | [**putOnelogin**](docs/Api/IdentityProviderApi.md#putonelogin) | **PUT** /api/v2/identityproviders/onelogin | Update/Create OneLogin Identity Provider
*IdentityProviderApi* | [**putProviderId**](docs/Api/IdentityProviderApi.md#putproviderid) | **PUT** /api/v2/identityproviders/{providerId} | Update an identity provider
*IdentityProviderApi* | [**putPurecloud**](docs/Api/IdentityProviderApi.md#putpurecloud) | **PUT** /api/v2/identityproviders/purecloud | Update/Create PureCloud Identity Provider
*IdentityProviderApi* | [**putSalesforce**](docs/Api/IdentityProviderApi.md#putsalesforce) | **PUT** /api/v2/identityproviders/salesforce | Update/Create Salesforce Identity Provider
*LanguagesApi* | [**deleteLanguageId**](docs/Api/LanguagesApi.md#deletelanguageid) | **DELETE** /api/v2/languages/{languageId} | Delete Language
*LanguagesApi* | [**getLanguageId**](docs/Api/LanguagesApi.md#getlanguageid) | **GET** /api/v2/languages/{languageId} | Get language
*LanguagesApi* | [**getLanguages**](docs/Api/LanguagesApi.md#getlanguages) | **GET** /api/v2/languages | Get the list of supported languages.
*LanguagesApi* | [**getTranslations**](docs/Api/LanguagesApi.md#gettranslations) | **GET** /api/v2/languages/translations | Get all available languages for translation
*LanguagesApi* | [**getTranslationsBuiltin**](docs/Api/LanguagesApi.md#gettranslationsbuiltin) | **GET** /api/v2/languages/translations/builtin | Get the builtin translation for a language
*LanguagesApi* | [**getTranslationsOrganization**](docs/Api/LanguagesApi.md#gettranslationsorganization) | **GET** /api/v2/languages/translations/organization | Get effective translation for an organization by language
*LanguagesApi* | [**getTranslationsUsersUserId**](docs/Api/LanguagesApi.md#gettranslationsusersuserid) | **GET** /api/v2/languages/translations/users/{userId} | Get effective language translation for a user
*LanguagesApi* | [**postLanguages**](docs/Api/LanguagesApi.md#postlanguages) | **POST** /api/v2/languages | Create Language
*LanguagesApi* | [**putLanguageId**](docs/Api/LanguagesApi.md#putlanguageid) | **PUT** /api/v2/languages/{languageId} | Update Language
*LocationsApi* | [**getLocationId**](docs/Api/LocationsApi.md#getlocationid) | **GET** /api/v2/locations/{locationId} | Get Location by ID.
*LocationsApi* | [**getLocations**](docs/Api/LocationsApi.md#getlocations) | **GET** /api/v2/locations | Get a list of all locations.
*LocationsApi* | [**getSearch**](docs/Api/LocationsApi.md#getsearch) | **GET** /api/v2/locations/search | Search locations using the q64 value returned from a previous search
*LocationsApi* | [**postSearch**](docs/Api/LocationsApi.md#postsearch) | **POST** /api/v2/locations/search | Search locations
*NotificationsApi* | [**deleteChannelsChannelIdSubscriptions**](docs/Api/NotificationsApi.md#deletechannelschannelidsubscriptions) | **DELETE** /api/v2/notifications/channels/{channelId}/subscriptions | Remove all subscriptions
*NotificationsApi* | [**getAvailabletopics**](docs/Api/NotificationsApi.md#getavailabletopics) | **GET** /api/v2/notifications/availabletopics | Get available notification topics.
*NotificationsApi* | [**getChannels**](docs/Api/NotificationsApi.md#getchannels) | **GET** /api/v2/notifications/channels | The list of existing channels
*NotificationsApi* | [**getChannelsChannelIdSubscriptions**](docs/Api/NotificationsApi.md#getchannelschannelidsubscriptions) | **GET** /api/v2/notifications/channels/{channelId}/subscriptions | The list of all subscriptions for this channel
*NotificationsApi* | [**postChannels**](docs/Api/NotificationsApi.md#postchannels) | **POST** /api/v2/notifications/channels | Create a new channel
*NotificationsApi* | [**postChannelsChannelIdSubscriptions**](docs/Api/NotificationsApi.md#postchannelschannelidsubscriptions) | **POST** /api/v2/notifications/channels/{channelId}/subscriptions | Add a list of subscriptions to the existing list of subscriptions
*NotificationsApi* | [**putChannelsChannelIdSubscriptions**](docs/Api/NotificationsApi.md#putchannelschannelidsubscriptions) | **PUT** /api/v2/notifications/channels/{channelId}/subscriptions | Replace the current list of subscriptions with a new list.
*OAuthApi* | [**deleteClientsClientId**](docs/Api/OAuthApi.md#deleteclientsclientid) | **DELETE** /api/v2/oauth/clients/{clientId} | Delete OAuth Client
*OAuthApi* | [**getClients**](docs/Api/OAuthApi.md#getclients) | **GET** /api/v2/oauth/clients | The list of OAuth clients
*OAuthApi* | [**getClientsClientId**](docs/Api/OAuthApi.md#getclientsclientid) | **GET** /api/v2/oauth/clients/{clientId} | Get OAuth Client
*OAuthApi* | [**postClients**](docs/Api/OAuthApi.md#postclients) | **POST** /api/v2/oauth/clients | Create OAuth client
*OAuthApi* | [**postClientsClientIdSecret**](docs/Api/OAuthApi.md#postclientsclientidsecret) | **POST** /api/v2/oauth/clients/{clientId}/secret | Regenerate Client Secret
*OAuthApi* | [**putClientsClientId**](docs/Api/OAuthApi.md#putclientsclientid) | **PUT** /api/v2/oauth/clients/{clientId} | Update OAuth Client
*OrganizationApi* | [**getFieldconfig**](docs/Api/OrganizationApi.md#getfieldconfig) | **GET** /api/v2/fieldconfig | Fetch field config for an entity type
*OrganizationApi* | [**getMe**](docs/Api/OrganizationApi.md#getme) | **GET** /api/v2/organizations/me | Get organization.
*OutboundApi* | [**deleteAttemptlimitsAttemptlimitsId**](docs/Api/OutboundApi.md#deleteattemptlimitsattemptlimitsid) | **DELETE** /api/v2/outbound/attemptlimits/{attemptLimitsId} | Delete attempt limits
*OutboundApi* | [**deleteCallabletimesetsCallabletimesetId**](docs/Api/OutboundApi.md#deletecallabletimesetscallabletimesetid) | **DELETE** /api/v2/outbound/callabletimesets/{callableTimeSetId} | Delete callable time set
*OutboundApi* | [**deleteCallanalysisresponsesetsCallanalysissetId**](docs/Api/OutboundApi.md#deletecallanalysisresponsesetscallanalysissetid) | **DELETE** /api/v2/outbound/callanalysisresponsesets/{callAnalysisSetId} | Delete a dialer call analysis response set.
*OutboundApi* | [**deleteCampaignsCampaignId**](docs/Api/OutboundApi.md#deletecampaignscampaignid) | **DELETE** /api/v2/outbound/campaigns/{campaignId} | Delete a campaign.
*OutboundApi* | [**deleteCampaignsCampaignIdProgress**](docs/Api/OutboundApi.md#deletecampaignscampaignidprogress) | **DELETE** /api/v2/outbound/campaigns/{campaignId}/progress | Reset campaign progress and recycle the campaign
*OutboundApi* | [**deleteContactlistsContactlistId**](docs/Api/OutboundApi.md#deletecontactlistscontactlistid) | **DELETE** /api/v2/outbound/contactlists/{contactListId} | Delete a contact list.
*OutboundApi* | [**deleteContactlistsContactlistIdContactsContactId**](docs/Api/OutboundApi.md#deletecontactlistscontactlistidcontactscontactid) | **DELETE** /api/v2/outbound/contactlists/{contactListId}/contacts/{contactId} | Delete a contact.
*OutboundApi* | [**deleteDnclistsDnclistId**](docs/Api/OutboundApi.md#deletednclistsdnclistid) | **DELETE** /api/v2/outbound/dnclists/{dncListId} | Delete dialer DNC list
*OutboundApi* | [**deleteRulesetsRulesetId**](docs/Api/OutboundApi.md#deleterulesetsrulesetid) | **DELETE** /api/v2/outbound/rulesets/{ruleSetId} | Delete a Rule set.
*OutboundApi* | [**deleteSchedulesCampaignsCampaignId**](docs/Api/OutboundApi.md#deleteschedulescampaignscampaignid) | **DELETE** /api/v2/outbound/schedules/campaigns/{campaignId} | Delete a dialer campaign schedule.
*OutboundApi* | [**deleteSchedulesSequencesSequenceId**](docs/Api/OutboundApi.md#deleteschedulessequencessequenceid) | **DELETE** /api/v2/outbound/schedules/sequences/{sequenceId} | Delete a dialer sequence schedule.
*OutboundApi* | [**deleteSequencesSequenceId**](docs/Api/OutboundApi.md#deletesequencessequenceid) | **DELETE** /api/v2/outbound/sequences/{sequenceId} | Delete a dialer campaign sequence.
*OutboundApi* | [**getAttemptlimits**](docs/Api/OutboundApi.md#getattemptlimits) | **GET** /api/v2/outbound/attemptlimits | Query attempt limits list
*OutboundApi* | [**getAttemptlimitsAttemptlimitsId**](docs/Api/OutboundApi.md#getattemptlimitsattemptlimitsid) | **GET** /api/v2/outbound/attemptlimits/{attemptLimitsId} | Get attempt limits
*OutboundApi* | [**getCallabletimesets**](docs/Api/OutboundApi.md#getcallabletimesets) | **GET** /api/v2/outbound/callabletimesets | Query callable time set list
*OutboundApi* | [**getCallabletimesetsCallabletimesetId**](docs/Api/OutboundApi.md#getcallabletimesetscallabletimesetid) | **GET** /api/v2/outbound/callabletimesets/{callableTimeSetId} | Get callable time set
*OutboundApi* | [**getCallanalysisresponsesets**](docs/Api/OutboundApi.md#getcallanalysisresponsesets) | **GET** /api/v2/outbound/callanalysisresponsesets | Query a list of dialer call analysis response sets.
*OutboundApi* | [**getCallanalysisresponsesetsCallanalysissetId**](docs/Api/OutboundApi.md#getcallanalysisresponsesetscallanalysissetid) | **GET** /api/v2/outbound/callanalysisresponsesets/{callAnalysisSetId} | Get a dialer call analysis response set.
*OutboundApi* | [**getCampaigns**](docs/Api/OutboundApi.md#getcampaigns) | **GET** /api/v2/outbound/campaigns | Query a list of dialer campaigns.
*OutboundApi* | [**getCampaignsCampaignId**](docs/Api/OutboundApi.md#getcampaignscampaignid) | **GET** /api/v2/outbound/campaigns/{campaignId} | Get dialer campaign.
*OutboundApi* | [**getCampaignsCampaignIdDiagnostics**](docs/Api/OutboundApi.md#getcampaignscampaigniddiagnostics) | **GET** /api/v2/outbound/campaigns/{campaignId}/diagnostics | Get campaign diagnostics
*OutboundApi* | [**getCampaignsCampaignIdInteractions**](docs/Api/OutboundApi.md#getcampaignscampaignidinteractions) | **GET** /api/v2/outbound/campaigns/{campaignId}/interactions | Get dialer campaign interactions.
*OutboundApi* | [**getCampaignsCampaignIdProgress**](docs/Api/OutboundApi.md#getcampaignscampaignidprogress) | **GET** /api/v2/outbound/campaigns/{campaignId}/progress | Get campaign progress
*OutboundApi* | [**getCampaignsCampaignIdStats**](docs/Api/OutboundApi.md#getcampaignscampaignidstats) | **GET** /api/v2/outbound/campaigns/{campaignId}/stats | Get statistics about a Dialer Campaign
*OutboundApi* | [**getContactlists**](docs/Api/OutboundApi.md#getcontactlists) | **GET** /api/v2/outbound/contactlists | Query a list of contact lists.
*OutboundApi* | [**getContactlistsContactlistId**](docs/Api/OutboundApi.md#getcontactlistscontactlistid) | **GET** /api/v2/outbound/contactlists/{contactListId} | Get a dialer contact list.
*OutboundApi* | [**getContactlistsContactlistIdContactsContactId**](docs/Api/OutboundApi.md#getcontactlistscontactlistidcontactscontactid) | **GET** /api/v2/outbound/contactlists/{contactListId}/contacts/{contactId} | Get a contact.
*OutboundApi* | [**getContactlistsContactlistIdExport**](docs/Api/OutboundApi.md#getcontactlistscontactlistidexport) | **GET** /api/v2/outbound/contactlists/{contactListId}/export | Get the URI of a contact list export.
*OutboundApi* | [**getContactlistsContactlistIdImportstatus**](docs/Api/OutboundApi.md#getcontactlistscontactlistidimportstatus) | **GET** /api/v2/outbound/contactlists/{contactListId}/importstatus | Get dialer contactList import status.
*OutboundApi* | [**getDnclists**](docs/Api/OutboundApi.md#getdnclists) | **GET** /api/v2/outbound/dnclists | Query dialer DNC lists
*OutboundApi* | [**getDnclistsDnclistId**](docs/Api/OutboundApi.md#getdnclistsdnclistid) | **GET** /api/v2/outbound/dnclists/{dncListId} | Get dialer DNC list
*OutboundApi* | [**getDnclistsDnclistIdExport**](docs/Api/OutboundApi.md#getdnclistsdnclistidexport) | **GET** /api/v2/outbound/dnclists/{dncListId}/export | Get the URI of a DNC list export.
*OutboundApi* | [**getDnclistsDnclistIdImportstatus**](docs/Api/OutboundApi.md#getdnclistsdnclistidimportstatus) | **GET** /api/v2/outbound/dnclists/{dncListId}/importstatus | Get dialer dncList import status.
*OutboundApi* | [**getRulesets**](docs/Api/OutboundApi.md#getrulesets) | **GET** /api/v2/outbound/rulesets | Query a list of Rule Sets.
*OutboundApi* | [**getRulesetsRulesetId**](docs/Api/OutboundApi.md#getrulesetsrulesetid) | **GET** /api/v2/outbound/rulesets/{ruleSetId} | Get a Rule Set by ID.
*OutboundApi* | [**getSchedulesCampaigns**](docs/Api/OutboundApi.md#getschedulescampaigns) | **GET** /api/v2/outbound/schedules/campaigns | Query for a list of dialer campaign schedules.
*OutboundApi* | [**getSchedulesCampaignsCampaignId**](docs/Api/OutboundApi.md#getschedulescampaignscampaignid) | **GET** /api/v2/outbound/schedules/campaigns/{campaignId} | Get a dialer campaign schedule.
*OutboundApi* | [**getSchedulesSequences**](docs/Api/OutboundApi.md#getschedulessequences) | **GET** /api/v2/outbound/schedules/sequences | Query for a list of dialer sequence schedules.
*OutboundApi* | [**getSchedulesSequencesSequenceId**](docs/Api/OutboundApi.md#getschedulessequencessequenceid) | **GET** /api/v2/outbound/schedules/sequences/{sequenceId} | Get a dialer sequence schedule.
*OutboundApi* | [**getSequences**](docs/Api/OutboundApi.md#getsequences) | **GET** /api/v2/outbound/sequences | Query a list of dialer campaign sequences.
*OutboundApi* | [**getSequencesSequenceId**](docs/Api/OutboundApi.md#getsequencessequenceid) | **GET** /api/v2/outbound/sequences/{sequenceId} | Get a dialer campaign sequence.
*OutboundApi* | [**getWrapupcodemappings**](docs/Api/OutboundApi.md#getwrapupcodemappings) | **GET** /api/v2/outbound/wrapupcodemappings | Get the Dialer wrap up code mapping.
*OutboundApi* | [**postAttemptlimits**](docs/Api/OutboundApi.md#postattemptlimits) | **POST** /api/v2/outbound/attemptlimits | Create attempt limits
*OutboundApi* | [**postAudits**](docs/Api/OutboundApi.md#postaudits) | **POST** /api/v2/outbound/audits | Retrieves audits for dialer.
*OutboundApi* | [**postCallabletimesets**](docs/Api/OutboundApi.md#postcallabletimesets) | **POST** /api/v2/outbound/callabletimesets | Create callable time set
*OutboundApi* | [**postCallanalysisresponsesets**](docs/Api/OutboundApi.md#postcallanalysisresponsesets) | **POST** /api/v2/outbound/callanalysisresponsesets | Create a dialer call analysis response set.
*OutboundApi* | [**postCampaigns**](docs/Api/OutboundApi.md#postcampaigns) | **POST** /api/v2/outbound/campaigns | Create a campaign.
*OutboundApi* | [**postCampaignsCampaignIdCallbackSchedule**](docs/Api/OutboundApi.md#postcampaignscampaignidcallbackschedule) | **POST** /api/v2/outbound/campaigns/{campaignId}/callback/schedule | Schedule a Callback for a Dialer Campaign (Deprecated)
*OutboundApi* | [**postCampaignsProgress**](docs/Api/OutboundApi.md#postcampaignsprogress) | **POST** /api/v2/outbound/campaigns/progress | Get progress for a list of campaigns
*OutboundApi* | [**postContactlists**](docs/Api/OutboundApi.md#postcontactlists) | **POST** /api/v2/outbound/contactlists | Create a contact List.
*OutboundApi* | [**postContactlistsContactlistIdContacts**](docs/Api/OutboundApi.md#postcontactlistscontactlistidcontacts) | **POST** /api/v2/outbound/contactlists/{contactListId}/contacts | Add contacts to a contact list.
*OutboundApi* | [**postContactlistsContactlistIdExport**](docs/Api/OutboundApi.md#postcontactlistscontactlistidexport) | **POST** /api/v2/outbound/contactlists/{contactListId}/export | Initiate the export of a contact list.
*OutboundApi* | [**postConversationsConversationIdDnc**](docs/Api/OutboundApi.md#postconversationsconversationiddnc) | **POST** /api/v2/outbound/conversations/{conversationId}/dnc | Add phone numbers to a Dialer DNC list.
*OutboundApi* | [**postDnclists**](docs/Api/OutboundApi.md#postdnclists) | **POST** /api/v2/outbound/dnclists | Create dialer DNC list
*OutboundApi* | [**postDnclistsDnclistIdExport**](docs/Api/OutboundApi.md#postdnclistsdnclistidexport) | **POST** /api/v2/outbound/dnclists/{dncListId}/export | Initiate the export of a dnc list.
*OutboundApi* | [**postDnclistsDnclistIdPhonenumbers**](docs/Api/OutboundApi.md#postdnclistsdnclistidphonenumbers) | **POST** /api/v2/outbound/dnclists/{dncListId}/phonenumbers | Add phone numbers to a Dialer DNC list.
*OutboundApi* | [**postRulesets**](docs/Api/OutboundApi.md#postrulesets) | **POST** /api/v2/outbound/rulesets | Create a Dialer Call Analysis Response Set.
*OutboundApi* | [**postSequences**](docs/Api/OutboundApi.md#postsequences) | **POST** /api/v2/outbound/sequences | Create a new campaign sequence.
*OutboundApi* | [**putAttemptlimitsAttemptlimitsId**](docs/Api/OutboundApi.md#putattemptlimitsattemptlimitsid) | **PUT** /api/v2/outbound/attemptlimits/{attemptLimitsId} | Update attempt limits
*OutboundApi* | [**putCallabletimesetsCallabletimesetId**](docs/Api/OutboundApi.md#putcallabletimesetscallabletimesetid) | **PUT** /api/v2/outbound/callabletimesets/{callableTimeSetId} | Update callable time set
*OutboundApi* | [**putCallanalysisresponsesetsCallanalysissetId**](docs/Api/OutboundApi.md#putcallanalysisresponsesetscallanalysissetid) | **PUT** /api/v2/outbound/callanalysisresponsesets/{callAnalysisSetId} | Update a dialer call analysis response set.
*OutboundApi* | [**putCampaignsCampaignId**](docs/Api/OutboundApi.md#putcampaignscampaignid) | **PUT** /api/v2/outbound/campaigns/{campaignId} | Update a campaign.
*OutboundApi* | [**putCampaignsCampaignIdAgentsUserId**](docs/Api/OutboundApi.md#putcampaignscampaignidagentsuserid) | **PUT** /api/v2/outbound/campaigns/{campaignId}/agents/{userId} | Send notification that an agent&#39;s state changed
*OutboundApi* | [**putContactlistsContactlistId**](docs/Api/OutboundApi.md#putcontactlistscontactlistid) | **PUT** /api/v2/outbound/contactlists/{contactListId} | Update a contact list.
*OutboundApi* | [**putContactlistsContactlistIdContactsContactId**](docs/Api/OutboundApi.md#putcontactlistscontactlistidcontactscontactid) | **PUT** /api/v2/outbound/contactlists/{contactListId}/contacts/{contactId} | Update a contact.
*OutboundApi* | [**putDnclistsDnclistId**](docs/Api/OutboundApi.md#putdnclistsdnclistid) | **PUT** /api/v2/outbound/dnclists/{dncListId} | Update dialer DNC list
*OutboundApi* | [**putRulesetsRulesetId**](docs/Api/OutboundApi.md#putrulesetsrulesetid) | **PUT** /api/v2/outbound/rulesets/{ruleSetId} | Update a RuleSet.
*OutboundApi* | [**putSchedulesCampaignsCampaignId**](docs/Api/OutboundApi.md#putschedulescampaignscampaignid) | **PUT** /api/v2/outbound/schedules/campaigns/{campaignId} | Update a new campaign schedule.
*OutboundApi* | [**putSchedulesSequencesSequenceId**](docs/Api/OutboundApi.md#putschedulessequencessequenceid) | **PUT** /api/v2/outbound/schedules/sequences/{sequenceId} | Update a new sequence schedule.
*OutboundApi* | [**putSequencesSequenceId**](docs/Api/OutboundApi.md#putsequencessequenceid) | **PUT** /api/v2/outbound/sequences/{sequenceId} | Update a new campaign sequence.
*OutboundApi* | [**putWrapupcodemappings**](docs/Api/OutboundApi.md#putwrapupcodemappings) | **PUT** /api/v2/outbound/wrapupcodemappings | Update the Dialer wrap up code mapping.
*PresenceApi* | [**deletePresenceId**](docs/Api/PresenceApi.md#deletepresenceid) | **DELETE** /api/v2/presencedefinitions/{presenceId} | Delete a Presence Definition
*PresenceApi* | [**getPresenceId**](docs/Api/PresenceApi.md#getpresenceid) | **GET** /api/v2/presencedefinitions/{presenceId} | Get a Presence Definition
*PresenceApi* | [**getPresencedefinitions**](docs/Api/PresenceApi.md#getpresencedefinitions) | **GET** /api/v2/presencedefinitions | Get an Organization&#39;s list of Presence Definitions
*PresenceApi* | [**getSystempresences**](docs/Api/PresenceApi.md#getsystempresences) | **GET** /api/v2/systempresences | Get the list of SystemPresences
*PresenceApi* | [**getUserIdPresencesSourceId**](docs/Api/PresenceApi.md#getuseridpresencessourceid) | **GET** /api/v2/users/{userId}/presences/{sourceId} | Get a user&#39;s Presence
*PresenceApi* | [**patchUserIdPresencesSourceId**](docs/Api/PresenceApi.md#patchuseridpresencessourceid) | **PATCH** /api/v2/users/{userId}/presences/{sourceId} | Patch a user&#39;s Presence
*PresenceApi* | [**postPresencedefinitions**](docs/Api/PresenceApi.md#postpresencedefinitions) | **POST** /api/v2/presencedefinitions | Create a Presence Definition
*PresenceApi* | [**putPresenceId**](docs/Api/PresenceApi.md#putpresenceid) | **PUT** /api/v2/presencedefinitions/{presenceId} | Update a Presence Definition
*QualityApi* | [**deleteCalibrationsCalibrationId**](docs/Api/QualityApi.md#deletecalibrationscalibrationid) | **DELETE** /api/v2/quality/calibrations/{calibrationId} | Delete a calibration by id.
*QualityApi* | [**deleteConversationsConversationIdEvaluationsEvaluationId**](docs/Api/QualityApi.md#deleteconversationsconversationidevaluationsevaluationid) | **DELETE** /api/v2/quality/conversations/{conversationId}/evaluations/{evaluationId} | Delete an evaluation
*QualityApi* | [**deleteFormsFormId**](docs/Api/QualityApi.md#deleteformsformid) | **DELETE** /api/v2/quality/forms/{formId} | Delete an evaluation form.
*QualityApi* | [**deleteKeywordsets**](docs/Api/QualityApi.md#deletekeywordsets) | **DELETE** /api/v2/quality/keywordsets | Delete keyword sets
*QualityApi* | [**deleteKeywordsetsKeywordsetId**](docs/Api/QualityApi.md#deletekeywordsetskeywordsetid) | **DELETE** /api/v2/quality/keywordsets/{keywordSetId} | Delete a keywordSet by id.
*QualityApi* | [**getAgentsActivity**](docs/Api/QualityApi.md#getagentsactivity) | **GET** /api/v2/quality/agents/activity | Gets a list of Agent Activities
*QualityApi* | [**getCalibrations**](docs/Api/QualityApi.md#getcalibrations) | **GET** /api/v2/quality/calibrations | Get the list of calibrations
*QualityApi* | [**getCalibrationsCalibrationId**](docs/Api/QualityApi.md#getcalibrationscalibrationid) | **GET** /api/v2/quality/calibrations/{calibrationId} | Get a calibration by id.
*QualityApi* | [**getConversationsConversationIdAudits**](docs/Api/QualityApi.md#getconversationsconversationidaudits) | **GET** /api/v2/quality/conversations/{conversationId}/audits | Get audits for conversation or recording
*QualityApi* | [**getConversationsConversationIdEvaluationsEvaluationId**](docs/Api/QualityApi.md#getconversationsconversationidevaluationsevaluationid) | **GET** /api/v2/quality/conversations/{conversationId}/evaluations/{evaluationId} | Get an evaluation
*QualityApi* | [**getEvaluationsQuery**](docs/Api/QualityApi.md#getevaluationsquery) | **GET** /api/v2/quality/evaluations/query | Queries Evaluations and returns a paged list
*QualityApi* | [**getEvaluatorsActivity**](docs/Api/QualityApi.md#getevaluatorsactivity) | **GET** /api/v2/quality/evaluators/activity | Get an evaluator activity
*QualityApi* | [**getForms**](docs/Api/QualityApi.md#getforms) | **GET** /api/v2/quality/forms | Get the list of evaluation forms
*QualityApi* | [**getFormsFormId**](docs/Api/QualityApi.md#getformsformid) | **GET** /api/v2/quality/forms/{formId} | Get an evaluation form
*QualityApi* | [**getFormsFormIdVersions**](docs/Api/QualityApi.md#getformsformidversions) | **GET** /api/v2/quality/forms/{formId}/versions | Gets all the revisions for a specific evaluation.
*QualityApi* | [**getKeywordsets**](docs/Api/QualityApi.md#getkeywordsets) | **GET** /api/v2/quality/keywordsets | Get the list of keyword sets
*QualityApi* | [**getKeywordsetsKeywordsetId**](docs/Api/QualityApi.md#getkeywordsetskeywordsetid) | **GET** /api/v2/quality/keywordsets/{keywordSetId} | Get a keywordSet by id.
*QualityApi* | [**getPublishedforms**](docs/Api/QualityApi.md#getpublishedforms) | **GET** /api/v2/quality/publishedforms | Get the published evaluation forms.
*QualityApi* | [**getPublishedformsFormId**](docs/Api/QualityApi.md#getpublishedformsformid) | **GET** /api/v2/quality/publishedforms/{formId} | Get the published evaluation forms.
*QualityApi* | [**postCalibrations**](docs/Api/QualityApi.md#postcalibrations) | **POST** /api/v2/quality/calibrations | Create a calibration
*QualityApi* | [**postConversationsConversationIdEvaluations**](docs/Api/QualityApi.md#postconversationsconversationidevaluations) | **POST** /api/v2/quality/conversations/{conversationId}/evaluations | Create an evaluation
*QualityApi* | [**postEvaluationsAggregatesQuery**](docs/Api/QualityApi.md#postevaluationsaggregatesquery) | **POST** /api/v2/analytics/evaluations/aggregates/query | Query for evaluation aggregates
*QualityApi* | [**postEvaluationsScoring**](docs/Api/QualityApi.md#postevaluationsscoring) | **POST** /api/v2/quality/evaluations/scoring | Score evaluation
*QualityApi* | [**postForms**](docs/Api/QualityApi.md#postforms) | **POST** /api/v2/quality/forms | Create an evaluation form.
*QualityApi* | [**postKeywordsets**](docs/Api/QualityApi.md#postkeywordsets) | **POST** /api/v2/quality/keywordsets | Create a Keyword Set
*QualityApi* | [**postPublishedforms**](docs/Api/QualityApi.md#postpublishedforms) | **POST** /api/v2/quality/publishedforms | Publish an evaluation form.
*QualityApi* | [**postSpotability**](docs/Api/QualityApi.md#postspotability) | **POST** /api/v2/quality/spotability | Retrieve the spotability statistic
*QualityApi* | [**putCalibrationsCalibrationId**](docs/Api/QualityApi.md#putcalibrationscalibrationid) | **PUT** /api/v2/quality/calibrations/{calibrationId} | Update a calibration to the specified calibration via PUT.  Editable fields include: evaluators, expertEvaluator, and scoringIndex
*QualityApi* | [**putConversationsConversationIdEvaluationsEvaluationId**](docs/Api/QualityApi.md#putconversationsconversationidevaluationsevaluationid) | **PUT** /api/v2/quality/conversations/{conversationId}/evaluations/{evaluationId} | Update an evaluation
*QualityApi* | [**putFormsFormId**](docs/Api/QualityApi.md#putformsformid) | **PUT** /api/v2/quality/forms/{formId} | Update an evaluation form.
*QualityApi* | [**putKeywordsetsKeywordsetId**](docs/Api/QualityApi.md#putkeywordsetskeywordsetid) | **PUT** /api/v2/quality/keywordsets/{keywordSetId} | Update a keywordSet to the specified keywordSet via PUT.
*RecordingApi* | [**deleteConversationIdRecordingsRecordingIdAnnotationsAnnotationId**](docs/Api/RecordingApi.md#deleteconversationidrecordingsrecordingidannotationsannotationid) | **DELETE** /api/v2/conversations/{conversationId}/recordings/{recordingId}/annotations/{annotationId} | Delete annotation
*RecordingApi* | [**deleteMediaretentionpolicies**](docs/Api/RecordingApi.md#deletemediaretentionpolicies) | **DELETE** /api/v2/recording/mediaretentionpolicies | Delete media retention policies
*RecordingApi* | [**deleteMediaretentionpoliciesPolicyId**](docs/Api/RecordingApi.md#deletemediaretentionpoliciespolicyid) | **DELETE** /api/v2/recording/mediaretentionpolicies/{policyId} | Delete a media retention policy
*RecordingApi* | [**deleteOrphanId**](docs/Api/RecordingApi.md#deleteorphanid) | **DELETE** /api/v2/orphanrecordings/{orphanId} | deletes a single orphan recording
*RecordingApi* | [**getConversationIdRecordings**](docs/Api/RecordingApi.md#getconversationidrecordings) | **GET** /api/v2/conversations/{conversationId}/recordings | Get all of a Conversation&#39;s Recordings.
*RecordingApi* | [**getConversationIdRecordingsRecordingId**](docs/Api/RecordingApi.md#getconversationidrecordingsrecordingid) | **GET** /api/v2/conversations/{conversationId}/recordings/{recordingId} | Gets a specific recording.
*RecordingApi* | [**getConversationIdRecordingsRecordingIdAnnotations**](docs/Api/RecordingApi.md#getconversationidrecordingsrecordingidannotations) | **GET** /api/v2/conversations/{conversationId}/recordings/{recordingId}/annotations | Get annotations for recording
*RecordingApi* | [**getConversationIdRecordingsRecordingIdAnnotationsAnnotationId**](docs/Api/RecordingApi.md#getconversationidrecordingsrecordingidannotationsannotationid) | **GET** /api/v2/conversations/{conversationId}/recordings/{recordingId}/annotations/{annotationId} | Get annotation
*RecordingApi* | [**getLocalkeysSettings**](docs/Api/RecordingApi.md#getlocalkeyssettings) | **GET** /api/v2/recording/localkeys/settings | gets a list local key settings data
*RecordingApi* | [**getLocalkeysSettingsSettingsId**](docs/Api/RecordingApi.md#getlocalkeyssettingssettingsid) | **GET** /api/v2/recording/localkeys/settings/{settingsId} | Get the local encryption settings
*RecordingApi* | [**getMediaretentionpolicies**](docs/Api/RecordingApi.md#getmediaretentionpolicies) | **GET** /api/v2/recording/mediaretentionpolicies | Gets media retention policy list with query options to filter on name and enabled.
*RecordingApi* | [**getMediaretentionpoliciesPolicyId**](docs/Api/RecordingApi.md#getmediaretentionpoliciespolicyid) | **GET** /api/v2/recording/mediaretentionpolicies/{policyId} | Get a media retention policy
*RecordingApi* | [**getOrphanId**](docs/Api/RecordingApi.md#getorphanid) | **GET** /api/v2/orphanrecordings/{orphanId} | Gets a single orphan recording
*RecordingApi* | [**getOrphanrecordings**](docs/Api/RecordingApi.md#getorphanrecordings) | **GET** /api/v2/orphanrecordings | Gets all orphan recordings
*RecordingApi* | [**getRecordingkeys**](docs/Api/RecordingApi.md#getrecordingkeys) | **GET** /api/v2/recording/recordingkeys | Get encryption key list
*RecordingApi* | [**getRecordingkeysRotationschedule**](docs/Api/RecordingApi.md#getrecordingkeysrotationschedule) | **GET** /api/v2/recording/recordingkeys/rotationschedule | Get key rotation schedule
*RecordingApi* | [**getSettings**](docs/Api/RecordingApi.md#getsettings) | **GET** /api/v2/recording/settings | Get the Recording Settings for the Organization
*RecordingApi* | [**getsScreensessions**](docs/Api/RecordingApi.md#getsscreensessions) | **GET** /api/v2/recordings/screensessions | Retrieves a paged listing of screen recording sessions
*RecordingApi* | [**patchMediaretentionpoliciesPolicyId**](docs/Api/RecordingApi.md#patchmediaretentionpoliciespolicyid) | **PATCH** /api/v2/recording/mediaretentionpolicies/{policyId} | Patch a media retention policy
*RecordingApi* | [**patchsScreensessionsRecordingsessionId**](docs/Api/RecordingApi.md#patchsscreensessionsrecordingsessionid) | **PATCH** /api/v2/recordings/screensessions/{recordingSessionId} | Update a screen recording session
*RecordingApi* | [**postConversationIdRecordingsRecordingIdAnnotations**](docs/Api/RecordingApi.md#postconversationidrecordingsrecordingidannotations) | **POST** /api/v2/conversations/{conversationId}/recordings/{recordingId}/annotations | Create annotation
*RecordingApi* | [**postLocalkeys**](docs/Api/RecordingApi.md#postlocalkeys) | **POST** /api/v2/recording/localkeys | create a local recording key
*RecordingApi* | [**postLocalkeysSettings**](docs/Api/RecordingApi.md#postlocalkeyssettings) | **POST** /api/v2/recording/localkeys/settings | create settings for local key creation
*RecordingApi* | [**postMediaretentionpolicies**](docs/Api/RecordingApi.md#postmediaretentionpolicies) | **POST** /api/v2/recording/mediaretentionpolicies | Create media retention policy
*RecordingApi* | [**postRecordingkeys**](docs/Api/RecordingApi.md#postrecordingkeys) | **POST** /api/v2/recording/recordingkeys | Create encryption key
*RecordingApi* | [**putConversationIdRecordingsRecordingId**](docs/Api/RecordingApi.md#putconversationidrecordingsrecordingid) | **PUT** /api/v2/conversations/{conversationId}/recordings/{recordingId} | Updates the retention records on a recording.
*RecordingApi* | [**putConversationIdRecordingsRecordingIdAnnotationsAnnotationId**](docs/Api/RecordingApi.md#putconversationidrecordingsrecordingidannotationsannotationid) | **PUT** /api/v2/conversations/{conversationId}/recordings/{recordingId}/annotations/{annotationId} | Update annotation
*RecordingApi* | [**putLocalkeysSettingsSettingsId**](docs/Api/RecordingApi.md#putlocalkeyssettingssettingsid) | **PUT** /api/v2/recording/localkeys/settings/{settingsId} | Update the local encryption settings
*RecordingApi* | [**putMediaretentionpoliciesPolicyId**](docs/Api/RecordingApi.md#putmediaretentionpoliciespolicyid) | **PUT** /api/v2/recording/mediaretentionpolicies/{policyId} | Update a media retention policy
*RecordingApi* | [**putRecordingkeysRotationschedule**](docs/Api/RecordingApi.md#putrecordingkeysrotationschedule) | **PUT** /api/v2/recording/recordingkeys/rotationschedule | Update key rotation schedule
*RecordingApi* | [**putSettings**](docs/Api/RecordingApi.md#putsettings) | **PUT** /api/v2/recording/settings | Update the Recording Settings for the Organization
*ResponseManagementApi* | [**deleteLibrariesLibraryId**](docs/Api/ResponseManagementApi.md#deletelibrarieslibraryid) | **DELETE** /api/v2/responsemanagement/libraries/{libraryId} | Delete an existing response library.
*ResponseManagementApi* | [**deleteResponsesResponseId**](docs/Api/ResponseManagementApi.md#deleteresponsesresponseid) | **DELETE** /api/v2/responsemanagement/responses/{responseId} | Delete an existing response.
*ResponseManagementApi* | [**getLibraries**](docs/Api/ResponseManagementApi.md#getlibraries) | **GET** /api/v2/responsemanagement/libraries | Gets a list of existing response libraries.
*ResponseManagementApi* | [**getLibrariesLibraryId**](docs/Api/ResponseManagementApi.md#getlibrarieslibraryid) | **GET** /api/v2/responsemanagement/libraries/{libraryId} | Get details about an existing response library.
*ResponseManagementApi* | [**getResponses**](docs/Api/ResponseManagementApi.md#getresponses) | **GET** /api/v2/responsemanagement/responses | Gets a list of existing responses.
*ResponseManagementApi* | [**getResponsesResponseId**](docs/Api/ResponseManagementApi.md#getresponsesresponseid) | **GET** /api/v2/responsemanagement/responses/{responseId} | Get details about an existing response.
*ResponseManagementApi* | [**postLibraries**](docs/Api/ResponseManagementApi.md#postlibraries) | **POST** /api/v2/responsemanagement/libraries | Create a response library.
*ResponseManagementApi* | [**postResponses**](docs/Api/ResponseManagementApi.md#postresponses) | **POST** /api/v2/responsemanagement/responses | Create a response.
*ResponseManagementApi* | [**postResponsesQuery**](docs/Api/ResponseManagementApi.md#postresponsesquery) | **POST** /api/v2/responsemanagement/responses/query | Query responses
*ResponseManagementApi* | [**putLibrariesLibraryId**](docs/Api/ResponseManagementApi.md#putlibrarieslibraryid) | **PUT** /api/v2/responsemanagement/libraries/{libraryId} | Update an existing response library.
*ResponseManagementApi* | [**putResponsesResponseId**](docs/Api/ResponseManagementApi.md#putresponsesresponseid) | **PUT** /api/v2/responsemanagement/responses/{responseId} | Update an existing response.
*RoutingApi* | [**deleteEmailDomainsDomainId**](docs/Api/RoutingApi.md#deleteemaildomainsdomainid) | **DELETE** /api/v2/routing/email/domains/{domainId} | Delete a domain
*RoutingApi* | [**deleteEmailDomainsDomainnameRoutesRouteId**](docs/Api/RoutingApi.md#deleteemaildomainsdomainnameroutesrouteid) | **DELETE** /api/v2/routing/email/domains/{domainName}/routes/{routeId} | Delete a route
*RoutingApi* | [**deleteQueuesQueueId**](docs/Api/RoutingApi.md#deletequeuesqueueid) | **DELETE** /api/v2/routing/queues/{queueId} | Delete a queue
*RoutingApi* | [**deleteQueuesQueueIdUsersMemberId**](docs/Api/RoutingApi.md#deletequeuesqueueidusersmemberid) | **DELETE** /api/v2/routing/queues/{queueId}/users/{memberId} | Delete queue member
*RoutingApi* | [**deleteQueuesQueueIdWrapupcodesCodeId**](docs/Api/RoutingApi.md#deletequeuesqueueidwrapupcodescodeid) | **DELETE** /api/v2/routing/queues/{queueId}/wrapupcodes/{codeId} | Delete a wrap-up code from a queue
*RoutingApi* | [**deleteSkillsSkillId**](docs/Api/RoutingApi.md#deleteskillsskillid) | **DELETE** /api/v2/routing/skills/{skillId} | Delete Routing Skill
*RoutingApi* | [**deleteUserIdRoutingskillsSkillId**](docs/Api/RoutingApi.md#deleteuseridroutingskillsskillid) | **DELETE** /api/v2/users/{userId}/routingskills/{skillId} | Remove routing skill from user
*RoutingApi* | [**deleteUtilization**](docs/Api/RoutingApi.md#deleteutilization) | **DELETE** /api/v2/routing/utilization | Delete utilization settings and revert to system defaults.
*RoutingApi* | [**deleteWrapupcodesCodeId**](docs/Api/RoutingApi.md#deletewrapupcodescodeid) | **DELETE** /api/v2/routing/wrapupcodes/{codeId} | Delete wrap-up code
*RoutingApi* | [**getEmailDomains**](docs/Api/RoutingApi.md#getemaildomains) | **GET** /api/v2/routing/email/domains | Get domains
*RoutingApi* | [**getEmailDomainsDomainId**](docs/Api/RoutingApi.md#getemaildomainsdomainid) | **GET** /api/v2/routing/email/domains/{domainId} | Get domain
*RoutingApi* | [**getEmailDomainsDomainnameRoutes**](docs/Api/RoutingApi.md#getemaildomainsdomainnameroutes) | **GET** /api/v2/routing/email/domains/{domainName}/routes | Get routes
*RoutingApi* | [**getEmailDomainsDomainnameRoutesRouteId**](docs/Api/RoutingApi.md#getemaildomainsdomainnameroutesrouteid) | **GET** /api/v2/routing/email/domains/{domainName}/routes/{routeId} | Get a route
*RoutingApi* | [**getEmailSetup**](docs/Api/RoutingApi.md#getemailsetup) | **GET** /api/v2/routing/email/setup | Get email setup
*RoutingApi* | [**getQueues**](docs/Api/RoutingApi.md#getqueues) | **GET** /api/v2/routing/queues | Get list of queues.
*RoutingApi* | [**getQueuesQueueId**](docs/Api/RoutingApi.md#getqueuesqueueid) | **GET** /api/v2/routing/queues/{queueId} | Get details about this queue.
*RoutingApi* | [**getQueuesQueueIdConversations**](docs/Api/RoutingApi.md#getqueuesqueueidconversations) | **GET** /api/v2/routing/queues/{queueId}/conversations | Get recent conversations that are still active
*RoutingApi* | [**getQueuesQueueIdConversationsCallbacks**](docs/Api/RoutingApi.md#getqueuesqueueidconversationscallbacks) | **GET** /api/v2/routing/queues/{queueId}/conversations/callbacks | Get recent callback conversations that are still active
*RoutingApi* | [**getQueuesQueueIdConversationsCalls**](docs/Api/RoutingApi.md#getqueuesqueueidconversationscalls) | **GET** /api/v2/routing/queues/{queueId}/conversations/calls | Get recent call conversations that are still active
*RoutingApi* | [**getQueuesQueueIdConversationsChats**](docs/Api/RoutingApi.md#getqueuesqueueidconversationschats) | **GET** /api/v2/routing/queues/{queueId}/conversations/chats | Get recent chat conversations that are still active
*RoutingApi* | [**getQueuesQueueIdConversationsEmails**](docs/Api/RoutingApi.md#getqueuesqueueidconversationsemails) | **GET** /api/v2/routing/queues/{queueId}/conversations/emails | Get recent email conversations that are still active
*RoutingApi* | [**getQueuesQueueIdEstimatedwaittime**](docs/Api/RoutingApi.md#getqueuesqueueidestimatedwaittime) | **GET** /api/v2/routing/queues/{queueId}/estimatedwaittime | Get Estimated Wait Time
*RoutingApi* | [**getQueuesQueueIdUsers**](docs/Api/RoutingApi.md#getqueuesqueueidusers) | **GET** /api/v2/routing/queues/{queueId}/users | Get the members of this queue
*RoutingApi* | [**getQueuesQueueIdWrapupcodes**](docs/Api/RoutingApi.md#getqueuesqueueidwrapupcodes) | **GET** /api/v2/routing/queues/{queueId}/wrapupcodes | Get the wrap-up codes for a queue
*RoutingApi* | [**getSkills**](docs/Api/RoutingApi.md#getskills) | **GET** /api/v2/routing/skills | Get the list of routing skills.
*RoutingApi* | [**getSkillsSkillId**](docs/Api/RoutingApi.md#getskillsskillid) | **GET** /api/v2/routing/skills/{skillId} | Get Routing Skill
*RoutingApi* | [**getUserIdRoutingskills**](docs/Api/RoutingApi.md#getuseridroutingskills) | **GET** /api/v2/users/{userId}/routingskills | List routing skills for user
*RoutingApi* | [**getUtilization**](docs/Api/RoutingApi.md#getutilization) | **GET** /api/v2/routing/utilization | Get the utilization settings.
*RoutingApi* | [**getWrapupcodes**](docs/Api/RoutingApi.md#getwrapupcodes) | **GET** /api/v2/routing/wrapupcodes | Get list of wrapup codes.
*RoutingApi* | [**getWrapupcodesCodeId**](docs/Api/RoutingApi.md#getwrapupcodescodeid) | **GET** /api/v2/routing/wrapupcodes/{codeId} | Get details about this wrap-up code.
*RoutingApi* | [**patchQueuesQueueIdUsers**](docs/Api/RoutingApi.md#patchqueuesqueueidusers) | **PATCH** /api/v2/routing/queues/{queueId}/users | Join or unjoin a set of users for a queue
*RoutingApi* | [**patchQueuesQueueIdUsersMemberId**](docs/Api/RoutingApi.md#patchqueuesqueueidusersmemberid) | **PATCH** /api/v2/routing/queues/{queueId}/users/{memberId} | Update the ring number of joined status for a User in a Queue
*RoutingApi* | [**postEmailDomains**](docs/Api/RoutingApi.md#postemaildomains) | **POST** /api/v2/routing/email/domains | Create a domain
*RoutingApi* | [**postEmailDomainsDomainnameRoutes**](docs/Api/RoutingApi.md#postemaildomainsdomainnameroutes) | **POST** /api/v2/routing/email/domains/{domainName}/routes | Create a route
*RoutingApi* | [**postQueues**](docs/Api/RoutingApi.md#postqueues) | **POST** /api/v2/routing/queues | Create queue
*RoutingApi* | [**postQueuesObservationsQuery**](docs/Api/RoutingApi.md#postqueuesobservationsquery) | **POST** /api/v2/analytics/queues/observations/query | Query for queue observations
*RoutingApi* | [**postQueuesQueueIdUsers**](docs/Api/RoutingApi.md#postqueuesqueueidusers) | **POST** /api/v2/routing/queues/{queueId}/users | Bulk add or delete up to 100 queue members
*RoutingApi* | [**postQueuesQueueIdWrapupcodes**](docs/Api/RoutingApi.md#postqueuesqueueidwrapupcodes) | **POST** /api/v2/routing/queues/{queueId}/wrapupcodes | Add up to 100 wrap-up codes to a queue
*RoutingApi* | [**postSkills**](docs/Api/RoutingApi.md#postskills) | **POST** /api/v2/routing/skills | Create Skill
*RoutingApi* | [**postUserIdRoutingskills**](docs/Api/RoutingApi.md#postuseridroutingskills) | **POST** /api/v2/users/{userId}/routingskills | Add routing skill to user
*RoutingApi* | [**postWrapupcodes**](docs/Api/RoutingApi.md#postwrapupcodes) | **POST** /api/v2/routing/wrapupcodes | Create a wrap-up code
*RoutingApi* | [**putEmailDomainsDomainnameRoutesRouteId**](docs/Api/RoutingApi.md#putemaildomainsdomainnameroutesrouteid) | **PUT** /api/v2/routing/email/domains/{domainName}/routes/{routeId} | Update a route
*RoutingApi* | [**putQueuesQueueId**](docs/Api/RoutingApi.md#putqueuesqueueid) | **PUT** /api/v2/routing/queues/{queueId} | Update a queue
*RoutingApi* | [**putUserIdRoutingskillsSkillId**](docs/Api/RoutingApi.md#putuseridroutingskillsskillid) | **PUT** /api/v2/users/{userId}/routingskills/{skillId} | Update routing skill proficiency or state.
*RoutingApi* | [**putUtilization**](docs/Api/RoutingApi.md#pututilization) | **PUT** /api/v2/routing/utilization | Update the utilization settings.
*RoutingApi* | [**putWrapupcodesCodeId**](docs/Api/RoutingApi.md#putwrapupcodescodeid) | **PUT** /api/v2/routing/wrapupcodes/{codeId} | Update wrap-up code
*SearchApi* | [**getSearch**](docs/Api/SearchApi.md#getsearch) | **GET** /api/v2/groups/search | Search groups using the q64 value returned from a previous search
*SearchApi* | [**getSearch_0**](docs/Api/SearchApi.md#getsearch_0) | **GET** /api/v2/locations/search | Search locations using the q64 value returned from a previous search
*SearchApi* | [**getSearch_1**](docs/Api/SearchApi.md#getsearch_1) | **GET** /api/v2/search | Search using the q64 value returned from a previous search.
*SearchApi* | [**getSearch_2**](docs/Api/SearchApi.md#getsearch_2) | **GET** /api/v2/users/search | Search users using the q64 value returned from a previous search
*SearchApi* | [**getSuggest**](docs/Api/SearchApi.md#getsuggest) | **GET** /api/v2/search/suggest | Suggest resources using the q64 value returned from a previous suggest query.
*SearchApi* | [**postSearch**](docs/Api/SearchApi.md#postsearch) | **POST** /api/v2/groups/search | Search groups
*SearchApi* | [**postSearch_0**](docs/Api/SearchApi.md#postsearch_0) | **POST** /api/v2/locations/search | Search locations
*SearchApi* | [**postSearch_1**](docs/Api/SearchApi.md#postsearch_1) | **POST** /api/v2/search | Search resources.
*SearchApi* | [**postSearch_2**](docs/Api/SearchApi.md#postsearch_2) | **POST** /api/v2/users/search | Search users
*SearchApi* | [**postSuggest**](docs/Api/SearchApi.md#postsuggest) | **POST** /api/v2/search/suggest | Suggest resources.
*StationsApi* | [**deleteStationIdAssociateduser**](docs/Api/StationsApi.md#deletestationidassociateduser) | **DELETE** /api/v2/stations/{stationId}/associateduser | Unassigns the user assigned to this station
*StationsApi* | [**getStationId**](docs/Api/StationsApi.md#getstationid) | **GET** /api/v2/stations/{stationId} | Get station.
*StationsApi* | [**getStations**](docs/Api/StationsApi.md#getstations) | **GET** /api/v2/stations | Get the list of available stations.
*SuggestApi* | [**getSearch**](docs/Api/SuggestApi.md#getsearch) | **GET** /api/v2/search | Search using the q64 value returned from a previous search.
*SuggestApi* | [**getSuggest**](docs/Api/SuggestApi.md#getsuggest) | **GET** /api/v2/search/suggest | Suggest resources using the q64 value returned from a previous suggest query.
*SuggestApi* | [**postSearch**](docs/Api/SuggestApi.md#postsearch) | **POST** /api/v2/search | Search resources.
*SuggestApi* | [**postSuggest**](docs/Api/SuggestApi.md#postsuggest) | **POST** /api/v2/search/suggest | Suggest resources.
*TelephonyProvidersEdgeApi* | [**deleteProvidersEdgesCertificateauthoritiesCertificateId**](docs/Api/TelephonyProvidersEdgeApi.md#deleteprovidersedgescertificateauthoritiescertificateid) | **DELETE** /api/v2/telephony/providers/edges/certificateauthorities/{certificateId} | Delete a certificate authority.
*TelephonyProvidersEdgeApi* | [**deleteProvidersEdgesDidpoolsDidpoolId**](docs/Api/TelephonyProvidersEdgeApi.md#deleteprovidersedgesdidpoolsdidpoolid) | **DELETE** /api/v2/telephony/providers/edges/didpools/{didPoolId} | Delete a DID Pool by ID.
*TelephonyProvidersEdgeApi* | [**deleteProvidersEdgesEdgeId**](docs/Api/TelephonyProvidersEdgeApi.md#deleteprovidersedgesedgeid) | **DELETE** /api/v2/telephony/providers/edges/{edgeId} | Delete a edge.
*TelephonyProvidersEdgeApi* | [**deleteProvidersEdgesEdgeIdLogicalinterfacesInterfaceId**](docs/Api/TelephonyProvidersEdgeApi.md#deleteprovidersedgesedgeidlogicalinterfacesinterfaceid) | **DELETE** /api/v2/telephony/providers/edges/{edgeId}/logicalinterfaces/{interfaceId} | Delete an edge logical interface
*TelephonyProvidersEdgeApi* | [**deleteProvidersEdgesEdgeIdSoftwareupdate**](docs/Api/TelephonyProvidersEdgeApi.md#deleteprovidersedgesedgeidsoftwareupdate) | **DELETE** /api/v2/telephony/providers/edges/{edgeId}/softwareupdate | Cancels any in-progress update for this edge.
*TelephonyProvidersEdgeApi* | [**deleteProvidersEdgesEdgegroupsEdgegroupId**](docs/Api/TelephonyProvidersEdgeApi.md#deleteprovidersedgesedgegroupsedgegroupid) | **DELETE** /api/v2/telephony/providers/edges/edgegroups/{edgeGroupId} | Delete an edge group.
*TelephonyProvidersEdgeApi* | [**deleteProvidersEdgesEndpointsEndpointId**](docs/Api/TelephonyProvidersEdgeApi.md#deleteprovidersedgesendpointsendpointid) | **DELETE** /api/v2/telephony/providers/edges/endpoints/{endpointId} | Delete endpoint
*TelephonyProvidersEdgeApi* | [**deleteProvidersEdgesExtensionpoolsExtensionpoolId**](docs/Api/TelephonyProvidersEdgeApi.md#deleteprovidersedgesextensionpoolsextensionpoolid) | **DELETE** /api/v2/telephony/providers/edges/extensionpools/{extensionPoolId} | Delete an extension pool by ID
*TelephonyProvidersEdgeApi* | [**deleteProvidersEdgesOutboundroutesOutboundrouteId**](docs/Api/TelephonyProvidersEdgeApi.md#deleteprovidersedgesoutboundroutesoutboundrouteid) | **DELETE** /api/v2/telephony/providers/edges/outboundroutes/{outboundRouteId} | Delete Outbound Route
*TelephonyProvidersEdgeApi* | [**deleteProvidersEdgesPhonebasesettingsPhonebaseId**](docs/Api/TelephonyProvidersEdgeApi.md#deleteprovidersedgesphonebasesettingsphonebaseid) | **DELETE** /api/v2/telephony/providers/edges/phonebasesettings/{phoneBaseId} | Delete a Phone Base Settings by ID
*TelephonyProvidersEdgeApi* | [**deleteProvidersEdgesPhonesPhoneId**](docs/Api/TelephonyProvidersEdgeApi.md#deleteprovidersedgesphonesphoneid) | **DELETE** /api/v2/telephony/providers/edges/phones/{phoneId} | Delete a Phone by ID
*TelephonyProvidersEdgeApi* | [**deleteProvidersEdgesSitesSiteId**](docs/Api/TelephonyProvidersEdgeApi.md#deleteprovidersedgessitessiteid) | **DELETE** /api/v2/telephony/providers/edges/sites/{siteId} | Delete a Site by ID
*TelephonyProvidersEdgeApi* | [**deleteProvidersEdgesTrunkbasesettingsTrunkbasesettingsId**](docs/Api/TelephonyProvidersEdgeApi.md#deleteprovidersedgestrunkbasesettingstrunkbasesettingsid) | **DELETE** /api/v2/telephony/providers/edges/trunkbasesettings/{trunkBaseSettingsId} | Delete a Trunk Base Settings object by ID
*TelephonyProvidersEdgeApi* | [**getProvidersEdges**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedges) | **GET** /api/v2/telephony/providers/edges | Get the list of edges.
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesAvailablelanguages**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgesavailablelanguages) | **GET** /api/v2/telephony/providers/edges/availablelanguages | Get the list of available languages.
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesCertificateauthorities**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgescertificateauthorities) | **GET** /api/v2/telephony/providers/edges/certificateauthorities | Get the list of certificate authorities.
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesCertificateauthoritiesCertificateId**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgescertificateauthoritiescertificateid) | **GET** /api/v2/telephony/providers/edges/certificateauthorities/{certificateId} | Get a certificate authority.
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesDidpools**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgesdidpools) | **GET** /api/v2/telephony/providers/edges/didpools | Get a listing of DID Pools
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesDidpoolsDidpoolId**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgesdidpoolsdidpoolid) | **GET** /api/v2/telephony/providers/edges/didpools/{didPoolId} | Get a DID Pool by ID.
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesDids**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgesdids) | **GET** /api/v2/telephony/providers/edges/dids | Get a listing of DIDs
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesDidsDidId**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgesdidsdidid) | **GET** /api/v2/telephony/providers/edges/dids/{didId} | Get a DID by ID.
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesEdgeId**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgesedgeid) | **GET** /api/v2/telephony/providers/edges/{edgeId} | Get edge.
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesEdgeIdLines**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgesedgeidlines) | **GET** /api/v2/telephony/providers/edges/{edgeId}/lines | Get the list of lines.
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesEdgeIdLinesLineId**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgesedgeidlineslineid) | **GET** /api/v2/telephony/providers/edges/{edgeId}/lines/{lineId} | Get line
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesEdgeIdLogicalinterfaces**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgesedgeidlogicalinterfaces) | **GET** /api/v2/telephony/providers/edges/{edgeId}/logicalinterfaces | Get edge logical interfaces.
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesEdgeIdLogicalinterfacesInterfaceId**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgesedgeidlogicalinterfacesinterfaceid) | **GET** /api/v2/telephony/providers/edges/{edgeId}/logicalinterfaces/{interfaceId} | Get an edge logical interface
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesEdgeIdLogsJobsJobId**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgesedgeidlogsjobsjobid) | **GET** /api/v2/telephony/providers/edges/{edgeId}/logs/jobs/{jobId} | Get an Edge logs job.
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesEdgeIdPhysicalinterfaces**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgesedgeidphysicalinterfaces) | **GET** /api/v2/telephony/providers/edges/{edgeId}/physicalinterfaces | Retrieve a list of all configured physical interfaces from a specific edge.
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesEdgeIdPhysicalinterfacesInterfaceId**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgesedgeidphysicalinterfacesinterfaceid) | **GET** /api/v2/telephony/providers/edges/{edgeId}/physicalinterfaces/{interfaceId} | Get edge physical interface.
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesEdgeIdSetuppackage**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgesedgeidsetuppackage) | **GET** /api/v2/telephony/providers/edges/{edgeId}/setuppackage | Get the setup package for a locally deployed edge device. This is needed to complete the setup process for the virtual edge.
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesEdgeIdSoftwareupdate**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgesedgeidsoftwareupdate) | **GET** /api/v2/telephony/providers/edges/{edgeId}/softwareupdate | Gets software update status information about any edge.
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesEdgeIdSoftwareversions**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgesedgeidsoftwareversions) | **GET** /api/v2/telephony/providers/edges/{edgeId}/softwareversions | Gets all the available software versions for this edge.
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesEdgegroups**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgesedgegroups) | **GET** /api/v2/telephony/providers/edges/edgegroups | Get the list of edge groups.
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesEdgegroupsEdgegroupId**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgesedgegroupsedgegroupid) | **GET** /api/v2/telephony/providers/edges/edgegroups/{edgeGroupId} | Get edge group.
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesEdgeversionreport**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgesedgeversionreport) | **GET** /api/v2/telephony/providers/edges/edgeversionreport | Get the edge version report.
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesEndpoints**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgesendpoints) | **GET** /api/v2/telephony/providers/edges/endpoints | Get endpoints
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesEndpointsEndpointId**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgesendpointsendpointid) | **GET** /api/v2/telephony/providers/edges/endpoints/{endpointId} | Get endpoint
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesExtensionpools**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgesextensionpools) | **GET** /api/v2/telephony/providers/edges/extensionpools | Get a listing of extension pools
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesExtensionpoolsExtensionpoolId**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgesextensionpoolsextensionpoolid) | **GET** /api/v2/telephony/providers/edges/extensionpools/{extensionPoolId} | Get an extension pool by ID
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesExtensions**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgesextensions) | **GET** /api/v2/telephony/providers/edges/extensions | Get a listing of extensions
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesExtensionsExtensionId**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgesextensionsextensionid) | **GET** /api/v2/telephony/providers/edges/extensions/{extensionId} | Get an extension by ID.
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesLinebasesettings**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgeslinebasesettings) | **GET** /api/v2/telephony/providers/edges/linebasesettings | Get a listing of line base settings objects
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesLinebasesettingsLinebaseId**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgeslinebasesettingslinebaseid) | **GET** /api/v2/telephony/providers/edges/linebasesettings/{lineBaseId} | Get a line base settings object by ID
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesLines**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgeslines) | **GET** /api/v2/telephony/providers/edges/lines | Get a list of Lines
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesLinesLineId**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgeslineslineid) | **GET** /api/v2/telephony/providers/edges/lines/{lineId} | Get a Line by ID
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesLinesTemplate**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgeslinestemplate) | **GET** /api/v2/telephony/providers/edges/lines/template | Get a Line instance template based on a Line Base Settings object. This object can then be modified and saved as a new Line instance
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesOutboundroutes**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgesoutboundroutes) | **GET** /api/v2/telephony/providers/edges/outboundroutes | Get outbound routes
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesOutboundroutesOutboundrouteId**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgesoutboundroutesoutboundrouteid) | **GET** /api/v2/telephony/providers/edges/outboundroutes/{outboundRouteId} | Get outbound route
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesPhonebasesettings**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgesphonebasesettings) | **GET** /api/v2/telephony/providers/edges/phonebasesettings | Get a list of Phone Base Settings objects
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesPhonebasesettingsAvailablemetabases**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgesphonebasesettingsavailablemetabases) | **GET** /api/v2/telephony/providers/edges/phonebasesettings/availablemetabases | Get a list of available makes and models to create a new Phone Base Settings
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesPhonebasesettingsPhonebaseId**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgesphonebasesettingsphonebaseid) | **GET** /api/v2/telephony/providers/edges/phonebasesettings/{phoneBaseId} | Get a Phone Base Settings object by ID
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesPhonebasesettingsTemplate**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgesphonebasesettingstemplate) | **GET** /api/v2/telephony/providers/edges/phonebasesettings/template | Get a Phone Base Settings instance template from a given make and model. This object can then be modified and saved as a new Phone Base Settings instance
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesPhones**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgesphones) | **GET** /api/v2/telephony/providers/edges/phones | Get a list of Phone Instances
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesPhonesPhoneId**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgesphonesphoneid) | **GET** /api/v2/telephony/providers/edges/phones/{phoneId} | Get a Phone by ID
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesPhonesTemplate**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgesphonestemplate) | **GET** /api/v2/telephony/providers/edges/phones/template | Get a Phone instance template based on a Phone Base Settings object. This object can then be modified and saved as a new Phone instance
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesSites**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgessites) | **GET** /api/v2/telephony/providers/edges/sites | Get the list of Sites.
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesSitesSiteId**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgessitessiteid) | **GET** /api/v2/telephony/providers/edges/sites/{siteId} | Get a Site by ID.
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesSitesSiteIdNumberplans**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgessitessiteidnumberplans) | **GET** /api/v2/telephony/providers/edges/sites/{siteId}/numberplans | Get the list of Number Plans for this Site.
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesSitesSiteIdNumberplansClassifications**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgessitessiteidnumberplansclassifications) | **GET** /api/v2/telephony/providers/edges/sites/{siteId}/numberplans/classifications | Get a list of Classifications for this Site
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesSitesSiteIdNumberplansNumberplanId**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgessitessiteidnumberplansnumberplanid) | **GET** /api/v2/telephony/providers/edges/sites/{siteId}/numberplans/{numberPlanId} | Get a Number Plan by ID.
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesTimezones**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgestimezones) | **GET** /api/v2/telephony/providers/edges/timezones | Get a list of Edge-compatible time zones
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesTrunkbasesettings**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgestrunkbasesettings) | **GET** /api/v2/telephony/providers/edges/trunkbasesettings | Get Trunk Base Settings listing
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesTrunkbasesettingsAvailablemetabases**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgestrunkbasesettingsavailablemetabases) | **GET** /api/v2/telephony/providers/edges/trunkbasesettings/availablemetabases | Get a list of available makes and models to create a new Trunk Base Settings
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesTrunkbasesettingsTemplate**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgestrunkbasesettingstemplate) | **GET** /api/v2/telephony/providers/edges/trunkbasesettings/template | Get a Trunk Base Settings instance template from a given make and model. This object can then be modified and saved as a new Trunk Base Settings instance
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesTrunkbasesettingsTrunkbasesettingsId**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgestrunkbasesettingstrunkbasesettingsid) | **GET** /api/v2/telephony/providers/edges/trunkbasesettings/{trunkBaseSettingsId} | Get a Trunk Base Settings object by ID
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesTrunks**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgestrunks) | **GET** /api/v2/telephony/providers/edges/trunks | Get the list of available trunks.
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesTrunksTrunkId**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgestrunkstrunkid) | **GET** /api/v2/telephony/providers/edges/trunks/{trunkId} | Get a Trunk by ID
*TelephonyProvidersEdgeApi* | [**getProvidersEdgesTrunkswithrecording**](docs/Api/TelephonyProvidersEdgeApi.md#getprovidersedgestrunkswithrecording) | **GET** /api/v2/telephony/providers/edges/trunkswithrecording | Get Counts of trunks that have recording disabled or enabled
*TelephonyProvidersEdgeApi* | [**getSchemasEdgesVnext**](docs/Api/TelephonyProvidersEdgeApi.md#getschemasedgesvnext) | **GET** /api/v2/configuration/schemas/edges/vnext | Lists available schema categories
*TelephonyProvidersEdgeApi* | [**getSchemasEdgesVnextSchemacategory**](docs/Api/TelephonyProvidersEdgeApi.md#getschemasedgesvnextschemacategory) | **GET** /api/v2/configuration/schemas/edges/vnext/{schemaCategory} | List schemas of a specific category
*TelephonyProvidersEdgeApi* | [**getSchemasEdgesVnextSchemacategorySchematype**](docs/Api/TelephonyProvidersEdgeApi.md#getschemasedgesvnextschemacategoryschematype) | **GET** /api/v2/configuration/schemas/edges/vnext/{schemaCategory}/{schemaType} | List schemas of a specific category
*TelephonyProvidersEdgeApi* | [**getSchemasEdgesVnextSchemacategorySchematypeSchemaId**](docs/Api/TelephonyProvidersEdgeApi.md#getschemasedgesvnextschemacategoryschematypeschemaid) | **GET** /api/v2/configuration/schemas/edges/vnext/{schemaCategory}/{schemaType}/{schemaId} | Get a json schema
*TelephonyProvidersEdgeApi* | [**getSchemasEdgesVnextSchemacategorySchematypeSchemaIdExtensiontypeMetadataId**](docs/Api/TelephonyProvidersEdgeApi.md#getschemasedgesvnextschemacategoryschematypeschemaidextensiontypemetadataid) | **GET** /api/v2/configuration/schemas/edges/vnext/{schemaCategory}/{schemaType}/{schemaId}/{extensionType}/{metadataId} | Get metadata for a schema
*TelephonyProvidersEdgeApi* | [**postProvidersEdges**](docs/Api/TelephonyProvidersEdgeApi.md#postprovidersedges) | **POST** /api/v2/telephony/providers/edges | Create an edge.
*TelephonyProvidersEdgeApi* | [**postProvidersEdgesAddressvalidation**](docs/Api/TelephonyProvidersEdgeApi.md#postprovidersedgesaddressvalidation) | **POST** /api/v2/telephony/providers/edges/addressvalidation | Validates a street address
*TelephonyProvidersEdgeApi* | [**postProvidersEdgesCertificateauthorities**](docs/Api/TelephonyProvidersEdgeApi.md#postprovidersedgescertificateauthorities) | **POST** /api/v2/telephony/providers/edges/certificateauthorities | Create a certificate authority.
*TelephonyProvidersEdgeApi* | [**postProvidersEdgesDidpools**](docs/Api/TelephonyProvidersEdgeApi.md#postprovidersedgesdidpools) | **POST** /api/v2/telephony/providers/edges/didpools | Create a new DID pool
*TelephonyProvidersEdgeApi* | [**postProvidersEdgesEdgeIdLogicalinterfaces**](docs/Api/TelephonyProvidersEdgeApi.md#postprovidersedgesedgeidlogicalinterfaces) | **POST** /api/v2/telephony/providers/edges/{edgeId}/logicalinterfaces | Create an edge logical interface.
*TelephonyProvidersEdgeApi* | [**postProvidersEdgesEdgeIdLogsJobs**](docs/Api/TelephonyProvidersEdgeApi.md#postprovidersedgesedgeidlogsjobs) | **POST** /api/v2/telephony/providers/edges/{edgeId}/logs/jobs | Create a job to upload a list of Edge logs.
*TelephonyProvidersEdgeApi* | [**postProvidersEdgesEdgeIdLogsJobsJobIdUpload**](docs/Api/TelephonyProvidersEdgeApi.md#postprovidersedgesedgeidlogsjobsjobidupload) | **POST** /api/v2/telephony/providers/edges/{edgeId}/logs/jobs/{jobId}/upload | Request that the specified fileIds be uploaded from the Edge.
*TelephonyProvidersEdgeApi* | [**postProvidersEdgesEdgeIdReboot**](docs/Api/TelephonyProvidersEdgeApi.md#postprovidersedgesedgeidreboot) | **POST** /api/v2/telephony/providers/edges/{edgeId}/reboot | Reboot an Edge
*TelephonyProvidersEdgeApi* | [**postProvidersEdgesEdgeIdSoftwareupdate**](docs/Api/TelephonyProvidersEdgeApi.md#postprovidersedgesedgeidsoftwareupdate) | **POST** /api/v2/telephony/providers/edges/{edgeId}/softwareupdate | Starts a software update for this edge.
*TelephonyProvidersEdgeApi* | [**postProvidersEdgesEdgeIdUnpair**](docs/Api/TelephonyProvidersEdgeApi.md#postprovidersedgesedgeidunpair) | **POST** /api/v2/telephony/providers/edges/{edgeId}/unpair | Unpair an Edge
*TelephonyProvidersEdgeApi* | [**postProvidersEdgesEdgegroups**](docs/Api/TelephonyProvidersEdgeApi.md#postprovidersedgesedgegroups) | **POST** /api/v2/telephony/providers/edges/edgegroups | Create an edge group.
*TelephonyProvidersEdgeApi* | [**postProvidersEdgesEndpoints**](docs/Api/TelephonyProvidersEdgeApi.md#postprovidersedgesendpoints) | **POST** /api/v2/telephony/providers/edges/endpoints | Create endpoint
*TelephonyProvidersEdgeApi* | [**postProvidersEdgesExtensionpools**](docs/Api/TelephonyProvidersEdgeApi.md#postprovidersedgesextensionpools) | **POST** /api/v2/telephony/providers/edges/extensionpools | Create a new extension pool
*TelephonyProvidersEdgeApi* | [**postProvidersEdgesOfflineconfiguration**](docs/Api/TelephonyProvidersEdgeApi.md#postprovidersedgesofflineconfiguration) | **POST** /api/v2/telephony/providers/edges/offlineconfiguration | Create a file that can be used to configure a hardware Edge&#39;s settings.
*TelephonyProvidersEdgeApi* | [**postProvidersEdgesOutboundroutes**](docs/Api/TelephonyProvidersEdgeApi.md#postprovidersedgesoutboundroutes) | **POST** /api/v2/telephony/providers/edges/outboundroutes | Create outbound rule
*TelephonyProvidersEdgeApi* | [**postProvidersEdgesPhonebasesettings**](docs/Api/TelephonyProvidersEdgeApi.md#postprovidersedgesphonebasesettings) | **POST** /api/v2/telephony/providers/edges/phonebasesettings | Create a new Phone Base Settings object
*TelephonyProvidersEdgeApi* | [**postProvidersEdgesPhones**](docs/Api/TelephonyProvidersEdgeApi.md#postprovidersedgesphones) | **POST** /api/v2/telephony/providers/edges/phones | Create a new Phone
*TelephonyProvidersEdgeApi* | [**postProvidersEdgesPhonesPhoneIdReboot**](docs/Api/TelephonyProvidersEdgeApi.md#postprovidersedgesphonesphoneidreboot) | **POST** /api/v2/telephony/providers/edges/phones/{phoneId}/reboot | Reboot a Phone
*TelephonyProvidersEdgeApi* | [**postProvidersEdgesPhonesReboot**](docs/Api/TelephonyProvidersEdgeApi.md#postprovidersedgesphonesreboot) | **POST** /api/v2/telephony/providers/edges/phones/reboot | Reboot Multiple Phones
*TelephonyProvidersEdgeApi* | [**postProvidersEdgesSites**](docs/Api/TelephonyProvidersEdgeApi.md#postprovidersedgessites) | **POST** /api/v2/telephony/providers/edges/sites | Create a Site.
*TelephonyProvidersEdgeApi* | [**postProvidersEdgesSitesSiteIdRebalance**](docs/Api/TelephonyProvidersEdgeApi.md#postprovidersedgessitessiteidrebalance) | **POST** /api/v2/telephony/providers/edges/sites/{siteId}/rebalance | Triggers the rebalance operation.
*TelephonyProvidersEdgeApi* | [**postProvidersEdgesTrunkbasesettings**](docs/Api/TelephonyProvidersEdgeApi.md#postprovidersedgestrunkbasesettings) | **POST** /api/v2/telephony/providers/edges/trunkbasesettings | Create a Trunk Base Settings object
*TelephonyProvidersEdgeApi* | [**putProvidersEdgesCertificateauthoritiesCertificateId**](docs/Api/TelephonyProvidersEdgeApi.md#putprovidersedgescertificateauthoritiescertificateid) | **PUT** /api/v2/telephony/providers/edges/certificateauthorities/{certificateId} | Update a certificate authority.
*TelephonyProvidersEdgeApi* | [**putProvidersEdgesDidpoolsDidpoolId**](docs/Api/TelephonyProvidersEdgeApi.md#putprovidersedgesdidpoolsdidpoolid) | **PUT** /api/v2/telephony/providers/edges/didpools/{didPoolId} | Update a DID Pool by ID.
*TelephonyProvidersEdgeApi* | [**putProvidersEdgesDidsDidId**](docs/Api/TelephonyProvidersEdgeApi.md#putprovidersedgesdidsdidid) | **PUT** /api/v2/telephony/providers/edges/dids/{didId} | Update a DID by ID.
*TelephonyProvidersEdgeApi* | [**putProvidersEdgesEdgeId**](docs/Api/TelephonyProvidersEdgeApi.md#putprovidersedgesedgeid) | **PUT** /api/v2/telephony/providers/edges/{edgeId} | Update a edge.
*TelephonyProvidersEdgeApi* | [**putProvidersEdgesEdgeIdLinesLineId**](docs/Api/TelephonyProvidersEdgeApi.md#putprovidersedgesedgeidlineslineid) | **PUT** /api/v2/telephony/providers/edges/{edgeId}/lines/{lineId} | Update a line.
*TelephonyProvidersEdgeApi* | [**putProvidersEdgesEdgeIdLogicalinterfacesInterfaceId**](docs/Api/TelephonyProvidersEdgeApi.md#putprovidersedgesedgeidlogicalinterfacesinterfaceid) | **PUT** /api/v2/telephony/providers/edges/{edgeId}/logicalinterfaces/{interfaceId} | Update an edge logical interface.
*TelephonyProvidersEdgeApi* | [**putProvidersEdgesEdgegroupsEdgegroupId**](docs/Api/TelephonyProvidersEdgeApi.md#putprovidersedgesedgegroupsedgegroupid) | **PUT** /api/v2/telephony/providers/edges/edgegroups/{edgeGroupId} | Update an edge group.
*TelephonyProvidersEdgeApi* | [**putProvidersEdgesEndpointsEndpointId**](docs/Api/TelephonyProvidersEdgeApi.md#putprovidersedgesendpointsendpointid) | **PUT** /api/v2/telephony/providers/edges/endpoints/{endpointId} | Update endpoint
*TelephonyProvidersEdgeApi* | [**putProvidersEdgesExtensionpoolsExtensionpoolId**](docs/Api/TelephonyProvidersEdgeApi.md#putprovidersedgesextensionpoolsextensionpoolid) | **PUT** /api/v2/telephony/providers/edges/extensionpools/{extensionPoolId} | Update an extension pool by ID
*TelephonyProvidersEdgeApi* | [**putProvidersEdgesExtensionsExtensionId**](docs/Api/TelephonyProvidersEdgeApi.md#putprovidersedgesextensionsextensionid) | **PUT** /api/v2/telephony/providers/edges/extensions/{extensionId} | Update an extension by ID.
*TelephonyProvidersEdgeApi* | [**putProvidersEdgesOutboundroutesOutboundrouteId**](docs/Api/TelephonyProvidersEdgeApi.md#putprovidersedgesoutboundroutesoutboundrouteid) | **PUT** /api/v2/telephony/providers/edges/outboundroutes/{outboundRouteId} | Update outbound route
*TelephonyProvidersEdgeApi* | [**putProvidersEdgesPhonebasesettingsPhonebaseId**](docs/Api/TelephonyProvidersEdgeApi.md#putprovidersedgesphonebasesettingsphonebaseid) | **PUT** /api/v2/telephony/providers/edges/phonebasesettings/{phoneBaseId} | Update a Phone Base Settings by ID
*TelephonyProvidersEdgeApi* | [**putProvidersEdgesPhonesPhoneId**](docs/Api/TelephonyProvidersEdgeApi.md#putprovidersedgesphonesphoneid) | **PUT** /api/v2/telephony/providers/edges/phones/{phoneId} | Update a Phone by ID
*TelephonyProvidersEdgeApi* | [**putProvidersEdgesSitesSiteId**](docs/Api/TelephonyProvidersEdgeApi.md#putprovidersedgessitessiteid) | **PUT** /api/v2/telephony/providers/edges/sites/{siteId} | Update a Site by ID.
*TelephonyProvidersEdgeApi* | [**putProvidersEdgesSitesSiteIdNumberplans**](docs/Api/TelephonyProvidersEdgeApi.md#putprovidersedgessitessiteidnumberplans) | **PUT** /api/v2/telephony/providers/edges/sites/{siteId}/numberplans | Update the list of Number Plans.
*TelephonyProvidersEdgeApi* | [**putProvidersEdgesTrunkbasesettingsTrunkbasesettingsId**](docs/Api/TelephonyProvidersEdgeApi.md#putprovidersedgestrunkbasesettingstrunkbasesettingsid) | **PUT** /api/v2/telephony/providers/edges/trunkbasesettings/{trunkBaseSettingsId} | Update a Trunk Base Settings object by ID
*TokensApi* | [**deleteMe**](docs/Api/TokensApi.md#deleteme) | **DELETE** /api/v2/tokens/me | Delete  auth token used to make the request.
*UserRecordingsApi* | [**deleteRecordingId**](docs/Api/UserRecordingsApi.md#deleterecordingid) | **DELETE** /api/v2/userrecordings/{recordingId} | Delete a user recording.
*UserRecordingsApi* | [**getRecordingId**](docs/Api/UserRecordingsApi.md#getrecordingid) | **GET** /api/v2/userrecordings/{recordingId} | Get a user recording.
*UserRecordingsApi* | [**getRecordingIdMedia**](docs/Api/UserRecordingsApi.md#getrecordingidmedia) | **GET** /api/v2/userrecordings/{recordingId}/media | Download a user recording.
*UserRecordingsApi* | [**getSummary**](docs/Api/UserRecordingsApi.md#getsummary) | **GET** /api/v2/userrecordings/summary | Get user recording summary
*UserRecordingsApi* | [**getUserrecordings**](docs/Api/UserRecordingsApi.md#getuserrecordings) | **GET** /api/v2/userrecordings | Get a list of user recordings.
*UserRecordingsApi* | [**putRecordingId**](docs/Api/UserRecordingsApi.md#putrecordingid) | **PUT** /api/v2/userrecordings/{recordingId} | Update a user recording.
*UsersApi* | [**deleteUserId**](docs/Api/UsersApi.md#deleteuserid) | **DELETE** /api/v2/users/{userId} | Delete user
*UsersApi* | [**deleteUserIdRoles**](docs/Api/UsersApi.md#deleteuseridroles) | **DELETE** /api/v2/users/{userId}/roles | Removes all the roles from the user.
*UsersApi* | [**deleteUserIdRoutingskillsSkillId**](docs/Api/UsersApi.md#deleteuseridroutingskillsskillid) | **DELETE** /api/v2/users/{userId}/routingskills/{skillId} | Remove routing skill from user
*UsersApi* | [**deleteUserIdStationAssociatedstation**](docs/Api/UsersApi.md#deleteuseridstationassociatedstation) | **DELETE** /api/v2/users/{userId}/station/associatedstation | Clear associated station
*UsersApi* | [**deleteUserIdStationDefaultstation**](docs/Api/UsersApi.md#deleteuseridstationdefaultstation) | **DELETE** /api/v2/users/{userId}/station/defaultstation | Clear default station
*UsersApi* | [**getFieldconfig**](docs/Api/UsersApi.md#getfieldconfig) | **GET** /api/v2/fieldconfig | Fetch field config for an entity type
*UsersApi* | [**getMe**](docs/Api/UsersApi.md#getme) | **GET** /api/v2/users/me | Get current user details.
*UsersApi* | [**getSearch**](docs/Api/UsersApi.md#getsearch) | **GET** /api/v2/users/search | Search users using the q64 value returned from a previous search
*UsersApi* | [**getUserId**](docs/Api/UsersApi.md#getuserid) | **GET** /api/v2/users/{userId} | Get user.
*UsersApi* | [**getUserIdAdjacents**](docs/Api/UsersApi.md#getuseridadjacents) | **GET** /api/v2/users/{userId}/adjacents | Get adjacents
*UsersApi* | [**getUserIdCallforwarding**](docs/Api/UsersApi.md#getuseridcallforwarding) | **GET** /api/v2/users/{userId}/callforwarding | Get a user&#39;s CallForwarding
*UsersApi* | [**getUserIdDirectreports**](docs/Api/UsersApi.md#getuseriddirectreports) | **GET** /api/v2/users/{userId}/directreports | Get direct reports
*UsersApi* | [**getUserIdFavorites**](docs/Api/UsersApi.md#getuseridfavorites) | **GET** /api/v2/users/{userId}/favorites | Get favorites
*UsersApi* | [**getUserIdGeolocationsClientId**](docs/Api/UsersApi.md#getuseridgeolocationsclientid) | **GET** /api/v2/users/{userId}/geolocations/{clientId} | Get a user&#39;s Geolocation
*UsersApi* | [**getUserIdOutofoffice**](docs/Api/UsersApi.md#getuseridoutofoffice) | **GET** /api/v2/users/{userId}/outofoffice | Get a OutOfOffice
*UsersApi* | [**getUserIdProfileskills**](docs/Api/UsersApi.md#getuseridprofileskills) | **GET** /api/v2/users/{userId}/profileskills | List profile skills for a user
*UsersApi* | [**getUserIdQueues**](docs/Api/UsersApi.md#getuseridqueues) | **GET** /api/v2/users/{userId}/queues | Get queues for user
*UsersApi* | [**getUserIdRoles**](docs/Api/UsersApi.md#getuseridroles) | **GET** /api/v2/users/{userId}/roles | Returns a listing of roles and permissions for a user.
*UsersApi* | [**getUserIdRoutingskills**](docs/Api/UsersApi.md#getuseridroutingskills) | **GET** /api/v2/users/{userId}/routingskills | List routing skills for user
*UsersApi* | [**getUserIdRoutingstatus**](docs/Api/UsersApi.md#getuseridroutingstatus) | **GET** /api/v2/users/{userId}/routingstatus | Fetch the routing status of a user
*UsersApi* | [**getUserIdStation**](docs/Api/UsersApi.md#getuseridstation) | **GET** /api/v2/users/{userId}/station | Get station information for user
*UsersApi* | [**getUserIdSuperiors**](docs/Api/UsersApi.md#getuseridsuperiors) | **GET** /api/v2/users/{userId}/superiors | Get superiors
*UsersApi* | [**getUsers**](docs/Api/UsersApi.md#getusers) | **GET** /api/v2/users | Get the list of available users.
*UsersApi* | [**patchUserId**](docs/Api/UsersApi.md#patchuserid) | **PATCH** /api/v2/users/{userId} | Update user
*UsersApi* | [**patchUserIdCallforwarding**](docs/Api/UsersApi.md#patchuseridcallforwarding) | **PATCH** /api/v2/users/{userId}/callforwarding | Patch a user&#39;s CallForwarding
*UsersApi* | [**patchUserIdGeolocationsClientId**](docs/Api/UsersApi.md#patchuseridgeolocationsclientid) | **PATCH** /api/v2/users/{userId}/geolocations/{clientId} | Patch a user&#39;s Geolocation
*UsersApi* | [**patchUserIdQueues**](docs/Api/UsersApi.md#patchuseridqueues) | **PATCH** /api/v2/users/{userId}/queues | Join or unjoin a set of queues for a user
*UsersApi* | [**patchUserIdQueuesQueueId**](docs/Api/UsersApi.md#patchuseridqueuesqueueid) | **PATCH** /api/v2/users/{userId}/queues/{queueId} | Join or unjoin a queue for a user
*UsersApi* | [**postSearch**](docs/Api/UsersApi.md#postsearch) | **POST** /api/v2/users/search | Search users
*UsersApi* | [**postUserIdRoutingskills**](docs/Api/UsersApi.md#postuseridroutingskills) | **POST** /api/v2/users/{userId}/routingskills | Add routing skill to user
*UsersApi* | [**postUsers**](docs/Api/UsersApi.md#postusers) | **POST** /api/v2/users | Create user
*UsersApi* | [**postUsersAggregatesQuery**](docs/Api/UsersApi.md#postusersaggregatesquery) | **POST** /api/v2/analytics/users/aggregates/query | Query for user aggregates
*UsersApi* | [**postUsersObservationsQuery**](docs/Api/UsersApi.md#postusersobservationsquery) | **POST** /api/v2/analytics/users/observations/query | Query for user observations
*UsersApi* | [**putUserIdCallforwarding**](docs/Api/UsersApi.md#putuseridcallforwarding) | **PUT** /api/v2/users/{userId}/callforwarding | Update a user&#39;s CallForwarding
*UsersApi* | [**putUserIdOutofoffice**](docs/Api/UsersApi.md#putuseridoutofoffice) | **PUT** /api/v2/users/{userId}/outofoffice | Update an OutOfOffice
*UsersApi* | [**putUserIdProfileskills**](docs/Api/UsersApi.md#putuseridprofileskills) | **PUT** /api/v2/users/{userId}/profileskills | Update profile skills for a user
*UsersApi* | [**putUserIdRoles**](docs/Api/UsersApi.md#putuseridroles) | **PUT** /api/v2/users/{userId}/roles | Sets the user&#39;s roles
*UsersApi* | [**putUserIdRoutingskillsSkillId**](docs/Api/UsersApi.md#putuseridroutingskillsskillid) | **PUT** /api/v2/users/{userId}/routingskills/{skillId} | Update routing skill proficiency or state.
*UsersApi* | [**putUserIdRoutingstatus**](docs/Api/UsersApi.md#putuseridroutingstatus) | **PUT** /api/v2/users/{userId}/routingstatus | Update the routing status of a user
*UsersApi* | [**putUserIdStationAssociatedstationStationId**](docs/Api/UsersApi.md#putuseridstationassociatedstationstationid) | **PUT** /api/v2/users/{userId}/station/associatedstation/{stationId} | Set associated station
*UsersApi* | [**putUserIdStationDefaultstationStationId**](docs/Api/UsersApi.md#putuseridstationdefaultstationstationid) | **PUT** /api/v2/users/{userId}/station/defaultstation/{stationId} | Set default station
*UtilitiesApi* | [**getDate**](docs/Api/UtilitiesApi.md#getdate) | **GET** /api/v2/date | Get the current system date/time
*UtilitiesApi* | [**getTimezones**](docs/Api/UtilitiesApi.md#gettimezones) | **GET** /api/v2/timezones | Get time zones list
*UtilitiesApi* | [**postDetails**](docs/Api/UtilitiesApi.md#postdetails) | **POST** /api/v2/certificate/details | Returns the information about an X509 PEM encoded certificate or certificate chain.
*VoicemailApi* | [**deleteMessages**](docs/Api/VoicemailApi.md#deletemessages) | **DELETE** /api/v2/voicemail/messages | Delete all voicemail messages
*VoicemailApi* | [**deleteMessagesMessageId**](docs/Api/VoicemailApi.md#deletemessagesmessageid) | **DELETE** /api/v2/voicemail/messages/{messageId} | Delete a message.
*VoicemailApi* | [**getMailbox**](docs/Api/VoicemailApi.md#getmailbox) | **GET** /api/v2/voicemail/mailbox | Get mailbox information
*VoicemailApi* | [**getMessages**](docs/Api/VoicemailApi.md#getmessages) | **GET** /api/v2/voicemail/messages | List voicemail messages
*VoicemailApi* | [**getMessagesMessageId**](docs/Api/VoicemailApi.md#getmessagesmessageid) | **GET** /api/v2/voicemail/messages/{messageId} | Get message.
*VoicemailApi* | [**getMessagesMessageIdMedia**](docs/Api/VoicemailApi.md#getmessagesmessageidmedia) | **GET** /api/v2/voicemail/messages/{messageId}/media | Get media playback URI for this message
*VoicemailApi* | [**getPolicy**](docs/Api/VoicemailApi.md#getpolicy) | **GET** /api/v2/voicemail/policy | Get a policy
*VoicemailApi* | [**getUserpoliciesUserId**](docs/Api/VoicemailApi.md#getuserpoliciesuserid) | **GET** /api/v2/voicemail/userpolicies/{userId} | Get a user&#39;s voicemail policy
*VoicemailApi* | [**patchUserpoliciesUserId**](docs/Api/VoicemailApi.md#patchuserpoliciesuserid) | **PATCH** /api/v2/voicemail/userpolicies/{userId} | Update a user&#39;s voicemail policy
*VoicemailApi* | [**putMessagesMessageId**](docs/Api/VoicemailApi.md#putmessagesmessageid) | **PUT** /api/v2/voicemail/messages/{messageId} | Update a message.
*VoicemailApi* | [**putPolicy**](docs/Api/VoicemailApi.md#putpolicy) | **PUT** /api/v2/voicemail/policy | Update a policy
*WorkforceManagementApi* | [**getAdherence**](docs/Api/WorkforceManagementApi.md#getadherence) | **GET** /api/v2/workforcemanagement/adherence | Get a list of UserScheduleAdherence records for the requested users
*WorkforceManagementApi* | [**postLongtermforecasts**](docs/Api/WorkforceManagementApi.md#postlongtermforecasts) | **POST** /api/v2/workforcemanagement/longtermforecasts | Create a forecast


## Documentation For Models

 - [ADFS](docs/Model/ADFS.md)
 - [Actions](docs/Model/Actions.md)
 - [AcwSettings](docs/Model/AcwSettings.md)
 - [Address](docs/Model/Address.md)
 - [Adjacents](docs/Model/Adjacents.md)
 - [Agent](docs/Model/Agent.md)
 - [AgentActivity](docs/Model/AgentActivity.md)
 - [AgentActivityEntityListing](docs/Model/AgentActivityEntityListing.md)
 - [AgentEvaluatorActivity](docs/Model/AgentEvaluatorActivity.md)
 - [AggregateDataContainer](docs/Model/AggregateDataContainer.md)
 - [AggregateMetricData](docs/Model/AggregateMetricData.md)
 - [AggregateQueryResponse](docs/Model/AggregateQueryResponse.md)
 - [AggregationQuery](docs/Model/AggregationQuery.md)
 - [AggregationRange](docs/Model/AggregationRange.md)
 - [AggregationResult](docs/Model/AggregationResult.md)
 - [AggregationResultEntry](docs/Model/AggregationResultEntry.md)
 - [AnalyticsConversation](docs/Model/AnalyticsConversation.md)
 - [AnalyticsConversationQueryResponse](docs/Model/AnalyticsConversationQueryResponse.md)
 - [AnalyticsConversationSegment](docs/Model/AnalyticsConversationSegment.md)
 - [AnalyticsEvaluation](docs/Model/AnalyticsEvaluation.md)
 - [AnalyticsParticipant](docs/Model/AnalyticsParticipant.md)
 - [AnalyticsProperty](docs/Model/AnalyticsProperty.md)
 - [AnalyticsQueryAggregation](docs/Model/AnalyticsQueryAggregation.md)
 - [AnalyticsQueryClause](docs/Model/AnalyticsQueryClause.md)
 - [AnalyticsQueryFilter](docs/Model/AnalyticsQueryFilter.md)
 - [AnalyticsQueryPredicate](docs/Model/AnalyticsQueryPredicate.md)
 - [AnalyticsSession](docs/Model/AnalyticsSession.md)
 - [Annotation](docs/Model/Annotation.md)
 - [ArchiveRetention](docs/Model/ArchiveRetention.md)
 - [Attachment](docs/Model/Attachment.md)
 - [AttemptLimits](docs/Model/AttemptLimits.md)
 - [AttemptLimitsEntityListing](docs/Model/AttemptLimitsEntityListing.md)
 - [Attribute](docs/Model/Attribute.md)
 - [AttributeEntityListing](docs/Model/AttributeEntityListing.md)
 - [AttributeFilterItem](docs/Model/AttributeFilterItem.md)
 - [AttributeQueryRequest](docs/Model/AttributeQueryRequest.md)
 - [AuditChange](docs/Model/AuditChange.md)
 - [AuditEntity](docs/Model/AuditEntity.md)
 - [AuditEntityReference](docs/Model/AuditEntityReference.md)
 - [AuditFacet](docs/Model/AuditFacet.md)
 - [AuditFilter](docs/Model/AuditFilter.md)
 - [AuditMessage](docs/Model/AuditMessage.md)
 - [AuditSearchResult](docs/Model/AuditSearchResult.md)
 - [AuditUser](docs/Model/AuditUser.md)
 - [AvailableLanguageList](docs/Model/AvailableLanguageList.md)
 - [AvailableTopic](docs/Model/AvailableTopic.md)
 - [AvailableTopicEntityListing](docs/Model/AvailableTopicEntityListing.md)
 - [AvailableTranslations](docs/Model/AvailableTranslations.md)
 - [Bullseye](docs/Model/Bullseye.md)
 - [Calibration](docs/Model/Calibration.md)
 - [CalibrationAssignment](docs/Model/CalibrationAssignment.md)
 - [CalibrationCreate](docs/Model/CalibrationCreate.md)
 - [CalibrationEntityListing](docs/Model/CalibrationEntityListing.md)
 - [Call](docs/Model/Call.md)
 - [CallCommand](docs/Model/CallCommand.md)
 - [CallConversation](docs/Model/CallConversation.md)
 - [CallConversationEntityListing](docs/Model/CallConversationEntityListing.md)
 - [CallConversationNotification](docs/Model/CallConversationNotification.md)
 - [CallConversationNotificationCallMediaParticipant](docs/Model/CallConversationNotificationCallMediaParticipant.md)
 - [CallConversationNotificationDetail](docs/Model/CallConversationNotificationDetail.md)
 - [CallConversationNotificationErrorBody](docs/Model/CallConversationNotificationErrorBody.md)
 - [CallConversationNotificationErrorInfo](docs/Model/CallConversationNotificationErrorInfo.md)
 - [CallConversationNotificationFaxStatus](docs/Model/CallConversationNotificationFaxStatus.md)
 - [CallConversationNotificationParticipants](docs/Model/CallConversationNotificationParticipants.md)
 - [CallConversationNotificationUriReference](docs/Model/CallConversationNotificationUriReference.md)
 - [CallForwarding](docs/Model/CallForwarding.md)
 - [CallMediaParticipant](docs/Model/CallMediaParticipant.md)
 - [CallMediaPolicy](docs/Model/CallMediaPolicy.md)
 - [CallMediaPolicyConditions](docs/Model/CallMediaPolicyConditions.md)
 - [CallRecord](docs/Model/CallRecord.md)
 - [CallableContactsDiagnostic](docs/Model/CallableContactsDiagnostic.md)
 - [CallableTime](docs/Model/CallableTime.md)
 - [CallableTimeSet](docs/Model/CallableTimeSet.md)
 - [CallableTimeSetEntityListing](docs/Model/CallableTimeSetEntityListing.md)
 - [Callback](docs/Model/Callback.md)
 - [CallbackConversation](docs/Model/CallbackConversation.md)
 - [CallbackConversationEntityListing](docs/Model/CallbackConversationEntityListing.md)
 - [CallbackConversationNotification](docs/Model/CallbackConversationNotification.md)
 - [CallbackConversationNotificationCallbackMediaParticipant](docs/Model/CallbackConversationNotificationCallbackMediaParticipant.md)
 - [CallbackConversationNotificationDetail](docs/Model/CallbackConversationNotificationDetail.md)
 - [CallbackConversationNotificationDialerPreview](docs/Model/CallbackConversationNotificationDialerPreview.md)
 - [CallbackConversationNotificationErrorBody](docs/Model/CallbackConversationNotificationErrorBody.md)
 - [CallbackConversationNotificationErrorInfo](docs/Model/CallbackConversationNotificationErrorInfo.md)
 - [CallbackConversationNotificationErrorInfoDetails](docs/Model/CallbackConversationNotificationErrorInfoDetails.md)
 - [CallbackConversationNotificationParticipants](docs/Model/CallbackConversationNotificationParticipants.md)
 - [CallbackConversationNotificationPhoneNumberColumn](docs/Model/CallbackConversationNotificationPhoneNumberColumn.md)
 - [CallbackConversationNotificationUriReference](docs/Model/CallbackConversationNotificationUriReference.md)
 - [CallbackConversationNotificationUser](docs/Model/CallbackConversationNotificationUser.md)
 - [CallbackIdentifier](docs/Model/CallbackIdentifier.md)
 - [CallbackMediaParticipant](docs/Model/CallbackMediaParticipant.md)
 - [Campaign](docs/Model/Campaign.md)
 - [CampaignDiagnostics](docs/Model/CampaignDiagnostics.md)
 - [CampaignEntityListing](docs/Model/CampaignEntityListing.md)
 - [CampaignInteraction](docs/Model/CampaignInteraction.md)
 - [CampaignInteractions](docs/Model/CampaignInteractions.md)
 - [CampaignProgress](docs/Model/CampaignProgress.md)
 - [CampaignSchedule](docs/Model/CampaignSchedule.md)
 - [CampaignSequence](docs/Model/CampaignSequence.md)
 - [CampaignSequenceEntityListing](docs/Model/CampaignSequenceEntityListing.md)
 - [CampaignStats](docs/Model/CampaignStats.md)
 - [CampaignTimeSlot](docs/Model/CampaignTimeSlot.md)
 - [Certificate](docs/Model/Certificate.md)
 - [CertificateAuthorityEntityListing](docs/Model/CertificateAuthorityEntityListing.md)
 - [CertificateDetails](docs/Model/CertificateDetails.md)
 - [Change](docs/Model/Change.md)
 - [Channel](docs/Model/Channel.md)
 - [ChannelEntityListing](docs/Model/ChannelEntityListing.md)
 - [ChannelTopic](docs/Model/ChannelTopic.md)
 - [ChannelTopicEntityListing](docs/Model/ChannelTopicEntityListing.md)
 - [Chat](docs/Model/Chat.md)
 - [ChatConversation](docs/Model/ChatConversation.md)
 - [ChatConversationEntityListing](docs/Model/ChatConversationEntityListing.md)
 - [ChatConversationNotification](docs/Model/ChatConversationNotification.md)
 - [ChatConversationNotificationChatMediaParticipant](docs/Model/ChatConversationNotificationChatMediaParticipant.md)
 - [ChatConversationNotificationDetail](docs/Model/ChatConversationNotificationDetail.md)
 - [ChatConversationNotificationErrorBody](docs/Model/ChatConversationNotificationErrorBody.md)
 - [ChatConversationNotificationErrorInfo](docs/Model/ChatConversationNotificationErrorInfo.md)
 - [ChatConversationNotificationParticipants](docs/Model/ChatConversationNotificationParticipants.md)
 - [ChatConversationNotificationUriReference](docs/Model/ChatConversationNotificationUriReference.md)
 - [ChatMediaParticipant](docs/Model/ChatMediaParticipant.md)
 - [ChatMediaPolicy](docs/Model/ChatMediaPolicy.md)
 - [ChatMediaPolicyConditions](docs/Model/ChatMediaPolicyConditions.md)
 - [ChatMessage](docs/Model/ChatMessage.md)
 - [ChatMessageUser](docs/Model/ChatMessageUser.md)
 - [CobrowseConversation](docs/Model/CobrowseConversation.md)
 - [CobrowseConversationEntityListing](docs/Model/CobrowseConversationEntityListing.md)
 - [CobrowseConversationNotification](docs/Model/CobrowseConversationNotification.md)
 - [CobrowseConversationNotificationCobrowseMediaParticipant](docs/Model/CobrowseConversationNotificationCobrowseMediaParticipant.md)
 - [CobrowseConversationNotificationDetail](docs/Model/CobrowseConversationNotificationDetail.md)
 - [CobrowseConversationNotificationErrorBody](docs/Model/CobrowseConversationNotificationErrorBody.md)
 - [CobrowseConversationNotificationErrorInfo](docs/Model/CobrowseConversationNotificationErrorInfo.md)
 - [CobrowseConversationNotificationParticipants](docs/Model/CobrowseConversationNotificationParticipants.md)
 - [CobrowseConversationNotificationUriReference](docs/Model/CobrowseConversationNotificationUriReference.md)
 - [CobrowseMediaParticipant](docs/Model/CobrowseMediaParticipant.md)
 - [Cobrowsesession](docs/Model/Cobrowsesession.md)
 - [CommandStatus](docs/Model/CommandStatus.md)
 - [CommandStatusEntityListing](docs/Model/CommandStatusEntityListing.md)
 - [Condition](docs/Model/Condition.md)
 - [ConnectRate](docs/Model/ConnectRate.md)
 - [ConsultTransfer](docs/Model/ConsultTransfer.md)
 - [ConsultTransferResponse](docs/Model/ConsultTransferResponse.md)
 - [ConsultTransferUpdate](docs/Model/ConsultTransferUpdate.md)
 - [Contact](docs/Model/Contact.md)
 - [ContactCallbackRequest](docs/Model/ContactCallbackRequest.md)
 - [ContactList](docs/Model/ContactList.md)
 - [ContactListEntityListing](docs/Model/ContactListEntityListing.md)
 - [ContactPhoneNumberColumn](docs/Model/ContactPhoneNumberColumn.md)
 - [ContactSort](docs/Model/ContactSort.md)
 - [ContentAttributeFilterItem](docs/Model/ContentAttributeFilterItem.md)
 - [ContentFacetFilterItem](docs/Model/ContentFacetFilterItem.md)
 - [ContentFilterItem](docs/Model/ContentFilterItem.md)
 - [ContentQueryRequest](docs/Model/ContentQueryRequest.md)
 - [ContentSortItem](docs/Model/ContentSortItem.md)
 - [Conversation](docs/Model/Conversation.md)
 - [ConversationChat](docs/Model/ConversationChat.md)
 - [ConversationEntityListing](docs/Model/ConversationEntityListing.md)
 - [ConversationNotification](docs/Model/ConversationNotification.md)
 - [ConversationNotificationAddress](docs/Model/ConversationNotificationAddress.md)
 - [ConversationNotificationCall](docs/Model/ConversationNotificationCall.md)
 - [ConversationNotificationCallback](docs/Model/ConversationNotificationCallback.md)
 - [ConversationNotificationCallbacks](docs/Model/ConversationNotificationCallbacks.md)
 - [ConversationNotificationCalls](docs/Model/ConversationNotificationCalls.md)
 - [ConversationNotificationChat](docs/Model/ConversationNotificationChat.md)
 - [ConversationNotificationChats](docs/Model/ConversationNotificationChats.md)
 - [ConversationNotificationCobrowse](docs/Model/ConversationNotificationCobrowse.md)
 - [ConversationNotificationCobrowsesessions](docs/Model/ConversationNotificationCobrowsesessions.md)
 - [ConversationNotificationDialerPreview](docs/Model/ConversationNotificationDialerPreview.md)
 - [ConversationNotificationDialerPreviewPhoneNumberColumns](docs/Model/ConversationNotificationDialerPreviewPhoneNumberColumns.md)
 - [ConversationNotificationDisconnectReason](docs/Model/ConversationNotificationDisconnectReason.md)
 - [ConversationNotificationDisconnectReasons](docs/Model/ConversationNotificationDisconnectReasons.md)
 - [ConversationNotificationEmail](docs/Model/ConversationNotificationEmail.md)
 - [ConversationNotificationEmails](docs/Model/ConversationNotificationEmails.md)
 - [ConversationNotificationErrorDetails](docs/Model/ConversationNotificationErrorDetails.md)
 - [ConversationNotificationErrorInfo](docs/Model/ConversationNotificationErrorInfo.md)
 - [ConversationNotificationFaxStatus](docs/Model/ConversationNotificationFaxStatus.md)
 - [ConversationNotificationParticipant](docs/Model/ConversationNotificationParticipant.md)
 - [ConversationNotificationParticipants](docs/Model/ConversationNotificationParticipants.md)
 - [ConversationNotificationPhoneNumberColumn](docs/Model/ConversationNotificationPhoneNumberColumn.md)
 - [ConversationNotificationScreenShare](docs/Model/ConversationNotificationScreenShare.md)
 - [ConversationNotificationScreenShares](docs/Model/ConversationNotificationScreenShares.md)
 - [ConversationNotificationSelf](docs/Model/ConversationNotificationSelf.md)
 - [ConversationNotificationSocialExpression](docs/Model/ConversationNotificationSocialExpression.md)
 - [ConversationNotificationSocialExpressions](docs/Model/ConversationNotificationSocialExpressions.md)
 - [ConversationNotificationVideo](docs/Model/ConversationNotificationVideo.md)
 - [ConversationNotificationVideos](docs/Model/ConversationNotificationVideos.md)
 - [ConversationNotificationWrapup](docs/Model/ConversationNotificationWrapup.md)
 - [ConversationQuery](docs/Model/ConversationQuery.md)
 - [CoverSheet](docs/Model/CoverSheet.md)
 - [CreateCallRequest](docs/Model/CreateCallRequest.md)
 - [CreateCallResponse](docs/Model/CreateCallResponse.md)
 - [CreateCallbackCommand](docs/Model/CreateCallbackCommand.md)
 - [CreateCallbackResponse](docs/Model/CreateCallbackResponse.md)
 - [CreateQueueRequest](docs/Model/CreateQueueRequest.md)
 - [CreateShareRequest](docs/Model/CreateShareRequest.md)
 - [CreateShareRequestMember](docs/Model/CreateShareRequestMember.md)
 - [CreateShareResponse](docs/Model/CreateShareResponse.md)
 - [CreateUser](docs/Model/CreateUser.md)
 - [CustomerInteractionCenter](docs/Model/CustomerInteractionCenter.md)
 - [DID](docs/Model/DID.md)
 - [DIDEntityListing](docs/Model/DIDEntityListing.md)
 - [DIDPool](docs/Model/DIDPool.md)
 - [DIDPoolEntityListing](docs/Model/DIDPoolEntityListing.md)
 - [DefaultGreetingList](docs/Model/DefaultGreetingList.md)
 - [DeleteRetention](docs/Model/DeleteRetention.md)
 - [Destination](docs/Model/Destination.md)
 - [Detail](docs/Model/Detail.md)
 - [DialerAction](docs/Model/DialerAction.md)
 - [DialerAuditRequest](docs/Model/DialerAuditRequest.md)
 - [DialerContact](docs/Model/DialerContact.md)
 - [DialerPreview](docs/Model/DialerPreview.md)
 - [DialerRule](docs/Model/DialerRule.md)
 - [DigitLength](docs/Model/DigitLength.md)
 - [DisconnectReason](docs/Model/DisconnectReason.md)
 - [DncList](docs/Model/DncList.md)
 - [DncListEntityListing](docs/Model/DncListEntityListing.md)
 - [Document](docs/Model/Document.md)
 - [DocumentAttribute](docs/Model/DocumentAttribute.md)
 - [DocumentAudit](docs/Model/DocumentAudit.md)
 - [DocumentAuditEntityListing](docs/Model/DocumentAuditEntityListing.md)
 - [DocumentEntityListing](docs/Model/DocumentEntityListing.md)
 - [DocumentThumbnail](docs/Model/DocumentThumbnail.md)
 - [DocumentUpdate](docs/Model/DocumentUpdate.md)
 - [DocumentUpload](docs/Model/DocumentUpload.md)
 - [DomainCapabilities](docs/Model/DomainCapabilities.md)
 - [DomainCertificateAuthority](docs/Model/DomainCertificateAuthority.md)
 - [DomainEdgeSoftwareUpdateDto](docs/Model/DomainEdgeSoftwareUpdateDto.md)
 - [DomainEdgeSoftwareVersionDto](docs/Model/DomainEdgeSoftwareVersionDto.md)
 - [DomainEdgeSoftwareVersionDtoEntityListing](docs/Model/DomainEdgeSoftwareVersionDtoEntityListing.md)
 - [DomainEntity](docs/Model/DomainEntity.md)
 - [DomainEntityListing](docs/Model/DomainEntityListing.md)
 - [DomainEntityListingEvaluationForm](docs/Model/DomainEntityListingEvaluationForm.md)
 - [DomainEntityListingQueryResult](docs/Model/DomainEntityListingQueryResult.md)
 - [DomainLogicalInterface](docs/Model/DomainLogicalInterface.md)
 - [DomainNetworkAddress](docs/Model/DomainNetworkAddress.md)
 - [DomainNetworkCommandResponse](docs/Model/DomainNetworkCommandResponse.md)
 - [DomainNetworkRoute](docs/Model/DomainNetworkRoute.md)
 - [DomainOrgRoleDifference](docs/Model/DomainOrgRoleDifference.md)
 - [DomainOrganizationProduct](docs/Model/DomainOrganizationProduct.md)
 - [DomainOrganizationRole](docs/Model/DomainOrganizationRole.md)
 - [DomainOrganizationRoleCreate](docs/Model/DomainOrganizationRoleCreate.md)
 - [DomainOrganizationRoleUpdate](docs/Model/DomainOrganizationRoleUpdate.md)
 - [DomainPermission](docs/Model/DomainPermission.md)
 - [DomainPermissionCollection](docs/Model/DomainPermissionCollection.md)
 - [DomainPermissionPolicy](docs/Model/DomainPermissionPolicy.md)
 - [DomainPhysicalCapabilities](docs/Model/DomainPhysicalCapabilities.md)
 - [DomainPhysicalInterface](docs/Model/DomainPhysicalInterface.md)
 - [DomainResourceConditionNode](docs/Model/DomainResourceConditionNode.md)
 - [DomainResourceConditionValue](docs/Model/DomainResourceConditionValue.md)
 - [DomainRole](docs/Model/DomainRole.md)
 - [DomainSchemaReference](docs/Model/DomainSchemaReference.md)
 - [DownloadResponse](docs/Model/DownloadResponse.md)
 - [DurationCondition](docs/Model/DurationCondition.md)
 - [Edge](docs/Model/Edge.md)
 - [EdgeAutoUpdateConfig](docs/Model/EdgeAutoUpdateConfig.md)
 - [EdgeEntityListing](docs/Model/EdgeEntityListing.md)
 - [EdgeGroup](docs/Model/EdgeGroup.md)
 - [EdgeGroupEntityListing](docs/Model/EdgeGroupEntityListing.md)
 - [EdgeInterface](docs/Model/EdgeInterface.md)
 - [EdgeLine](docs/Model/EdgeLine.md)
 - [EdgeLineEntityListing](docs/Model/EdgeLineEntityListing.md)
 - [EdgeLogsJob](docs/Model/EdgeLogsJob.md)
 - [EdgeLogsJobFile](docs/Model/EdgeLogsJobFile.md)
 - [EdgeLogsJobRequest](docs/Model/EdgeLogsJobRequest.md)
 - [EdgeLogsJobResponse](docs/Model/EdgeLogsJobResponse.md)
 - [EdgeLogsJobUploadRequest](docs/Model/EdgeLogsJobUploadRequest.md)
 - [EdgeOfflineConfiguration](docs/Model/EdgeOfflineConfiguration.md)
 - [EdgeOfflineConfigurationInterface](docs/Model/EdgeOfflineConfigurationInterface.md)
 - [EdgeOfflineConfigurationNetwork](docs/Model/EdgeOfflineConfigurationNetwork.md)
 - [EdgeOfflineConfigurationResponse](docs/Model/EdgeOfflineConfigurationResponse.md)
 - [EdgeVersionInformation](docs/Model/EdgeVersionInformation.md)
 - [EdgeVersionReport](docs/Model/EdgeVersionReport.md)
 - [Email](docs/Model/Email.md)
 - [EmailAddress](docs/Model/EmailAddress.md)
 - [EmailAttachment](docs/Model/EmailAttachment.md)
 - [EmailConversation](docs/Model/EmailConversation.md)
 - [EmailConversationEntityListing](docs/Model/EmailConversationEntityListing.md)
 - [EmailConversationNotification](docs/Model/EmailConversationNotification.md)
 - [EmailConversationNotificationDetail](docs/Model/EmailConversationNotificationDetail.md)
 - [EmailConversationNotificationEmailMediaParticipant](docs/Model/EmailConversationNotificationEmailMediaParticipant.md)
 - [EmailConversationNotificationErrorBody](docs/Model/EmailConversationNotificationErrorBody.md)
 - [EmailConversationNotificationErrorInfo](docs/Model/EmailConversationNotificationErrorInfo.md)
 - [EmailConversationNotificationParticipants](docs/Model/EmailConversationNotificationParticipants.md)
 - [EmailConversationNotificationUriReference](docs/Model/EmailConversationNotificationUriReference.md)
 - [EmailMediaParticipant](docs/Model/EmailMediaParticipant.md)
 - [EmailMediaPolicy](docs/Model/EmailMediaPolicy.md)
 - [EmailMediaPolicyConditions](docs/Model/EmailMediaPolicyConditions.md)
 - [EmailMessage](docs/Model/EmailMessage.md)
 - [EmailMessageListing](docs/Model/EmailMessageListing.md)
 - [EmailSetup](docs/Model/EmailSetup.md)
 - [EncryptionKey](docs/Model/EncryptionKey.md)
 - [EncryptionKeyEntityListing](docs/Model/EncryptionKeyEntityListing.md)
 - [Endpoint](docs/Model/Endpoint.md)
 - [EndpointEntityListing](docs/Model/EndpointEntityListing.md)
 - [Entry](docs/Model/Entry.md)
 - [ErrorBody](docs/Model/ErrorBody.md)
 - [ErrorDetails](docs/Model/ErrorDetails.md)
 - [EstimatedWaitTimePredictions](docs/Model/EstimatedWaitTimePredictions.md)
 - [Evaluation](docs/Model/Evaluation.md)
 - [EvaluationAssignment](docs/Model/EvaluationAssignment.md)
 - [EvaluationEntityListing](docs/Model/EvaluationEntityListing.md)
 - [EvaluationForm](docs/Model/EvaluationForm.md)
 - [EvaluationFormAndScoringSet](docs/Model/EvaluationFormAndScoringSet.md)
 - [EvaluationFormEntityListing](docs/Model/EvaluationFormEntityListing.md)
 - [EvaluationScoringSet](docs/Model/EvaluationScoringSet.md)
 - [EvaluatorActivity](docs/Model/EvaluatorActivity.md)
 - [EvaluatorActivityEntityListing](docs/Model/EvaluatorActivityEntityListing.md)
 - [ExpansionCriterium](docs/Model/ExpansionCriterium.md)
 - [ExportUri](docs/Model/ExportUri.md)
 - [Extension](docs/Model/Extension.md)
 - [ExtensionEntityListing](docs/Model/ExtensionEntityListing.md)
 - [ExtensionPool](docs/Model/ExtensionPool.md)
 - [ExtensionPoolEntityListing](docs/Model/ExtensionPoolEntityListing.md)
 - [FacetEntry](docs/Model/FacetEntry.md)
 - [FacetInfo](docs/Model/FacetInfo.md)
 - [FacetKeyAttribute](docs/Model/FacetKeyAttribute.md)
 - [FacetStatistics](docs/Model/FacetStatistics.md)
 - [FacetTerm](docs/Model/FacetTerm.md)
 - [FaxDocument](docs/Model/FaxDocument.md)
 - [FaxDocumentEntityListing](docs/Model/FaxDocumentEntityListing.md)
 - [FaxSendRequest](docs/Model/FaxSendRequest.md)
 - [FaxSendResponse](docs/Model/FaxSendResponse.md)
 - [FaxStatus](docs/Model/FaxStatus.md)
 - [FaxSummary](docs/Model/FaxSummary.md)
 - [FieldConfig](docs/Model/FieldConfig.md)
 - [FieldList](docs/Model/FieldList.md)
 - [ForecastCreation](docs/Model/ForecastCreation.md)
 - [ForecastCreationCompletion](docs/Model/ForecastCreationCompletion.md)
 - [Geolocation](docs/Model/Geolocation.md)
 - [GeolocationSettings](docs/Model/GeolocationSettings.md)
 - [Greeting](docs/Model/Greeting.md)
 - [GreetingAudioFile](docs/Model/GreetingAudioFile.md)
 - [GreetingMediaInfo](docs/Model/GreetingMediaInfo.md)
 - [GreetingOwner](docs/Model/GreetingOwner.md)
 - [Group](docs/Model/Group.md)
 - [GroupEntityListing](docs/Model/GroupEntityListing.md)
 - [GroupMembersUpdate](docs/Model/GroupMembersUpdate.md)
 - [GroupSearchCriteria](docs/Model/GroupSearchCriteria.md)
 - [GroupSearchRequest](docs/Model/GroupSearchRequest.md)
 - [GroupUpdate](docs/Model/GroupUpdate.md)
 - [GroupsSearchResponse](docs/Model/GroupsSearchResponse.md)
 - [HeartBeatAlert](docs/Model/HeartBeatAlert.md)
 - [HeartBeatAlertContainer](docs/Model/HeartBeatAlertContainer.md)
 - [HeartBeatAlertNotification](docs/Model/HeartBeatAlertNotification.md)
 - [HeartBeatAlertNotificationNotificationUser](docs/Model/HeartBeatAlertNotificationNotificationUser.md)
 - [HeartBeatAlertNotificationNotificationUsers](docs/Model/HeartBeatAlertNotificationNotificationUsers.md)
 - [HeartBeatRule](docs/Model/HeartBeatRule.md)
 - [HeartBeatRuleContainer](docs/Model/HeartBeatRuleContainer.md)
 - [HeartBeatRuleNotification](docs/Model/HeartBeatRuleNotification.md)
 - [HeartBeatRuleNotificationNotificationUser](docs/Model/HeartBeatRuleNotificationNotificationUser.md)
 - [ImportStatus](docs/Model/ImportStatus.md)
 - [InboundDomain](docs/Model/InboundDomain.md)
 - [InboundDomainEntityListing](docs/Model/InboundDomainEntityListing.md)
 - [InboundRoute](docs/Model/InboundRoute.md)
 - [InboundRouteEntityListing](docs/Model/InboundRouteEntityListing.md)
 - [InitiateScreenRecording](docs/Model/InitiateScreenRecording.md)
 - [InteractionStatAlertNotification](docs/Model/InteractionStatAlertNotification.md)
 - [InteractionStatAlertNotificationNotificationUser](docs/Model/InteractionStatAlertNotificationNotificationUser.md)
 - [InteractionStatRuleNotification](docs/Model/InteractionStatRuleNotification.md)
 - [InteractionStatRuleNotificationNotificationUser](docs/Model/InteractionStatRuleNotificationNotificationUser.md)
 - [InteractionStatsAlert](docs/Model/InteractionStatsAlert.md)
 - [InteractionStatsAlertContainer](docs/Model/InteractionStatsAlertContainer.md)
 - [InteractionStatsRule](docs/Model/InteractionStatsRule.md)
 - [InteractionStatsRuleContainer](docs/Model/InteractionStatsRuleContainer.md)
 - [JsonNode](docs/Model/JsonNode.md)
 - [JsonNodeSearchResponse](docs/Model/JsonNodeSearchResponse.md)
 - [KeyRotationSchedule](docs/Model/KeyRotationSchedule.md)
 - [Keyword](docs/Model/Keyword.md)
 - [KeywordSet](docs/Model/KeywordSet.md)
 - [KeywordSetEntityListing](docs/Model/KeywordSetEntityListing.md)
 - [Language](docs/Model/Language.md)
 - [LanguageEntityListing](docs/Model/LanguageEntityListing.md)
 - [Library](docs/Model/Library.md)
 - [LibraryEntityListing](docs/Model/LibraryEntityListing.md)
 - [Line](docs/Model/Line.md)
 - [LineBase](docs/Model/LineBase.md)
 - [LineBaseEntityListing](docs/Model/LineBaseEntityListing.md)
 - [LineEntityListing](docs/Model/LineEntityListing.md)
 - [LineStatus](docs/Model/LineStatus.md)
 - [LocalEncryptionConfiguration](docs/Model/LocalEncryptionConfiguration.md)
 - [LocalEncryptionConfigurationListing](docs/Model/LocalEncryptionConfigurationListing.md)
 - [LocalEncryptionKeyRequest](docs/Model/LocalEncryptionKeyRequest.md)
 - [Location](docs/Model/Location.md)
 - [LocationAddress](docs/Model/LocationAddress.md)
 - [LocationDefinition](docs/Model/LocationDefinition.md)
 - [LocationEmergencyNumber](docs/Model/LocationEmergencyNumber.md)
 - [LocationSearchCriteria](docs/Model/LocationSearchCriteria.md)
 - [LocationSearchRequest](docs/Model/LocationSearchRequest.md)
 - [LocationsSearchResponse](docs/Model/LocationsSearchResponse.md)
 - [LockInfo](docs/Model/LockInfo.md)
 - [LogicalInterfaceEntityListing](docs/Model/LogicalInterfaceEntityListing.md)
 - [ManagementUnit](docs/Model/ManagementUnit.md)
 - [MaxParticipants](docs/Model/MaxParticipants.md)
 - [MediaParticipantRequest](docs/Model/MediaParticipantRequest.md)
 - [MediaPolicies](docs/Model/MediaPolicies.md)
 - [MediaResult](docs/Model/MediaResult.md)
 - [MediaSetting](docs/Model/MediaSetting.md)
 - [MediaSummary](docs/Model/MediaSummary.md)
 - [MediaSummaryDetail](docs/Model/MediaSummaryDetail.md)
 - [MemberEntity](docs/Model/MemberEntity.md)
 - [MetaData](docs/Model/MetaData.md)
 - [Metabase](docs/Model/Metabase.md)
 - [MeteredEvaluationAssignment](docs/Model/MeteredEvaluationAssignment.md)
 - [Number](docs/Model/Number.md)
 - [NumberPlan](docs/Model/NumberPlan.md)
 - [NumericRange](docs/Model/NumericRange.md)
 - [OAuthClient](docs/Model/OAuthClient.md)
 - [OAuthClientEntityListing](docs/Model/OAuthClientEntityListing.md)
 - [OAuthProvider](docs/Model/OAuthProvider.md)
 - [OAuthProviderEntityListing](docs/Model/OAuthProviderEntityListing.md)
 - [ObservationDataContainer](docs/Model/ObservationDataContainer.md)
 - [ObservationQuery](docs/Model/ObservationQuery.md)
 - [ObservationQueryResponse](docs/Model/ObservationQueryResponse.md)
 - [Okta](docs/Model/Okta.md)
 - [OneLogin](docs/Model/OneLogin.md)
 - [OrgMediaUtilization](docs/Model/OrgMediaUtilization.md)
 - [Organization](docs/Model/Organization.md)
 - [OrganizationPresence](docs/Model/OrganizationPresence.md)
 - [OrganizationPresenceEntityListing](docs/Model/OrganizationPresenceEntityListing.md)
 - [OrganizationProductEntityListing](docs/Model/OrganizationProductEntityListing.md)
 - [OrganizationRoleEntityListing](docs/Model/OrganizationRoleEntityListing.md)
 - [OrphanRecording](docs/Model/OrphanRecording.md)
 - [OrphanRecordingListing](docs/Model/OrphanRecordingListing.md)
 - [OutOfOffice](docs/Model/OutOfOffice.md)
 - [OutOfOfficeNotification](docs/Model/OutOfOfficeNotification.md)
 - [OutOfOfficeNotificationUser](docs/Model/OutOfOfficeNotificationUser.md)
 - [OutboundRoute](docs/Model/OutboundRoute.md)
 - [OutboundRouteEntityListing](docs/Model/OutboundRouteEntityListing.md)
 - [PINConfiguration](docs/Model/PINConfiguration.md)
 - [PagingSpec](docs/Model/PagingSpec.md)
 - [Parameter](docs/Model/Parameter.md)
 - [ParsedCertificate](docs/Model/ParsedCertificate.md)
 - [Participant](docs/Model/Participant.md)
 - [ParticipantAttributes](docs/Model/ParticipantAttributes.md)
 - [PermissionCollectionEntityListing](docs/Model/PermissionCollectionEntityListing.md)
 - [Phone](docs/Model/Phone.md)
 - [PhoneBase](docs/Model/PhoneBase.md)
 - [PhoneBaseEntityListing](docs/Model/PhoneBaseEntityListing.md)
 - [PhoneCapabilities](docs/Model/PhoneCapabilities.md)
 - [PhoneColumn](docs/Model/PhoneColumn.md)
 - [PhoneEntityListing](docs/Model/PhoneEntityListing.md)
 - [PhoneMetaBaseEntityListing](docs/Model/PhoneMetaBaseEntityListing.md)
 - [PhoneNumberColumn](docs/Model/PhoneNumberColumn.md)
 - [PhoneNumberStatus](docs/Model/PhoneNumberStatus.md)
 - [PhoneStatus](docs/Model/PhoneStatus.md)
 - [PhonesReboot](docs/Model/PhonesReboot.md)
 - [PhysicalInterfaceEntityListing](docs/Model/PhysicalInterfaceEntityListing.md)
 - [Policy](docs/Model/Policy.md)
 - [PolicyActions](docs/Model/PolicyActions.md)
 - [PolicyConditions](docs/Model/PolicyConditions.md)
 - [PolicyCreate](docs/Model/PolicyCreate.md)
 - [PolicyEntityListing](docs/Model/PolicyEntityListing.md)
 - [PolicyErrorMessage](docs/Model/PolicyErrorMessage.md)
 - [PolicyErrors](docs/Model/PolicyErrors.md)
 - [Predicate](docs/Model/Predicate.md)
 - [PredictionResults](docs/Model/PredictionResults.md)
 - [PresenceQueryResponse](docs/Model/PresenceQueryResponse.md)
 - [PropertyIndexRequest](docs/Model/PropertyIndexRequest.md)
 - [ProvisionInfo](docs/Model/ProvisionInfo.md)
 - [PureCloud](docs/Model/PureCloud.md)
 - [QualifierMappingObservationQueryResponse](docs/Model/QualifierMappingObservationQueryResponse.md)
 - [QualityAudit](docs/Model/QualityAudit.md)
 - [QualityAuditPage](docs/Model/QualityAuditPage.md)
 - [QueryFacetInfo](docs/Model/QueryFacetInfo.md)
 - [QueryRequest](docs/Model/QueryRequest.md)
 - [QueryResult](docs/Model/QueryResult.md)
 - [QueryResults](docs/Model/QueryResults.md)
 - [QuestionGroup](docs/Model/QuestionGroup.md)
 - [QuestionGroupScore](docs/Model/QuestionGroupScore.md)
 - [QuestionScore](docs/Model/QuestionScore.md)
 - [Queue](docs/Model/Queue.md)
 - [QueueEmailAddress](docs/Model/QueueEmailAddress.md)
 - [QueueEntityListing](docs/Model/QueueEntityListing.md)
 - [QueueMember](docs/Model/QueueMember.md)
 - [QueueMemberEntityListing](docs/Model/QueueMemberEntityListing.md)
 - [QueueMemberNotification](docs/Model/QueueMemberNotification.md)
 - [QueueUtilizationDiagnostic](docs/Model/QueueUtilizationDiagnostic.md)
 - [Reaction](docs/Model/Reaction.md)
 - [Recording](docs/Model/Recording.md)
 - [RecordingEmailMessage](docs/Model/RecordingEmailMessage.md)
 - [RecordingSettings](docs/Model/RecordingSettings.md)
 - [ReplaceRequest](docs/Model/ReplaceRequest.md)
 - [ReplaceResponse](docs/Model/ReplaceResponse.md)
 - [ReportMetaData](docs/Model/ReportMetaData.md)
 - [ReportMetaDataEntityListing](docs/Model/ReportMetaDataEntityListing.md)
 - [ReportRunEntry](docs/Model/ReportRunEntry.md)
 - [ReportRunEntryEntityDomainListing](docs/Model/ReportRunEntryEntityDomainListing.md)
 - [ReportSchedule](docs/Model/ReportSchedule.md)
 - [ReportScheduleEntityListing](docs/Model/ReportScheduleEntityListing.md)
 - [ResourceConditionNode](docs/Model/ResourceConditionNode.md)
 - [ResourceConditionValue](docs/Model/ResourceConditionValue.md)
 - [ResourcePermissionPolicy](docs/Model/ResourcePermissionPolicy.md)
 - [Response](docs/Model/Response.md)
 - [ResponseEntityList](docs/Model/ResponseEntityList.md)
 - [ResponseEntityListing](docs/Model/ResponseEntityListing.md)
 - [ResponseFilter](docs/Model/ResponseFilter.md)
 - [ResponseQueryRequest](docs/Model/ResponseQueryRequest.md)
 - [ResponseQueryResults](docs/Model/ResponseQueryResults.md)
 - [ResponseSet](docs/Model/ResponseSet.md)
 - [ResponseSetEntityListing](docs/Model/ResponseSetEntityListing.md)
 - [ResponseText](docs/Model/ResponseText.md)
 - [RestErrorDetail](docs/Model/RestErrorDetail.md)
 - [RetentionDuration](docs/Model/RetentionDuration.md)
 - [Ring](docs/Model/Ring.md)
 - [RoutingData](docs/Model/RoutingData.md)
 - [RoutingSkill](docs/Model/RoutingSkill.md)
 - [RoutingStatus](docs/Model/RoutingStatus.md)
 - [RuleSet](docs/Model/RuleSet.md)
 - [RuleSetDiagnostic](docs/Model/RuleSetDiagnostic.md)
 - [RuleSetEntityListing](docs/Model/RuleSetEntityListing.md)
 - [RunNowResponse](docs/Model/RunNowResponse.md)
 - [Salesforce](docs/Model/Salesforce.md)
 - [ScheduleInterval](docs/Model/ScheduleInterval.md)
 - [SchemaCategory](docs/Model/SchemaCategory.md)
 - [SchemaCategoryEntityListing](docs/Model/SchemaCategoryEntityListing.md)
 - [SchemaReferenceEntityListing](docs/Model/SchemaReferenceEntityListing.md)
 - [ScreenRecordingSession](docs/Model/ScreenRecordingSession.md)
 - [ScreenRecordingSessionListing](docs/Model/ScreenRecordingSessionListing.md)
 - [ScreenRecordingSessionRequest](docs/Model/ScreenRecordingSessionRequest.md)
 - [ScreenShareConversationNotification](docs/Model/ScreenShareConversationNotification.md)
 - [ScreenShareConversationNotificationDetail](docs/Model/ScreenShareConversationNotificationDetail.md)
 - [ScreenShareConversationNotificationErrorBody](docs/Model/ScreenShareConversationNotificationErrorBody.md)
 - [ScreenShareConversationNotificationErrorInfo](docs/Model/ScreenShareConversationNotificationErrorInfo.md)
 - [ScreenShareConversationNotificationParticipants](docs/Model/ScreenShareConversationNotificationParticipants.md)
 - [ScreenShareConversationNotificationScreenShareMediaParticipant](docs/Model/ScreenShareConversationNotificationScreenShareMediaParticipant.md)
 - [ScreenShareConversationNotificationUriReference](docs/Model/ScreenShareConversationNotificationUriReference.md)
 - [Screenshare](docs/Model/Screenshare.md)
 - [SearchAggregation](docs/Model/SearchAggregation.md)
 - [SearchCriteria](docs/Model/SearchCriteria.md)
 - [SearchRequest](docs/Model/SearchRequest.md)
 - [Section](docs/Model/Section.md)
 - [SecurityProfile](docs/Model/SecurityProfile.md)
 - [SecurityProfileEntityListing](docs/Model/SecurityProfileEntityListing.md)
 - [Segment](docs/Model/Segment.md)
 - [SequenceSchedule](docs/Model/SequenceSchedule.md)
 - [ServerDate](docs/Model/ServerDate.md)
 - [ServiceContext](docs/Model/ServiceContext.md)
 - [ServiceLevel](docs/Model/ServiceLevel.md)
 - [Share](docs/Model/Share.md)
 - [ShareEntityListing](docs/Model/ShareEntityListing.md)
 - [SharedEntity](docs/Model/SharedEntity.md)
 - [Site](docs/Model/Site.md)
 - [SiteEntityListing](docs/Model/SiteEntityListing.md)
 - [SkillEntityListing](docs/Model/SkillEntityListing.md)
 - [SkillsToRemove](docs/Model/SkillsToRemove.md)
 - [SocialConversationNotification](docs/Model/SocialConversationNotification.md)
 - [SocialConversationNotificationDetail](docs/Model/SocialConversationNotificationDetail.md)
 - [SocialConversationNotificationErrorBody](docs/Model/SocialConversationNotificationErrorBody.md)
 - [SocialConversationNotificationErrorInfo](docs/Model/SocialConversationNotificationErrorInfo.md)
 - [SocialConversationNotificationParticipants](docs/Model/SocialConversationNotificationParticipants.md)
 - [SocialConversationNotificationSocialMediaParticipant](docs/Model/SocialConversationNotificationSocialMediaParticipant.md)
 - [SocialConversationNotificationUriReference](docs/Model/SocialConversationNotificationUriReference.md)
 - [SocialExpression](docs/Model/SocialExpression.md)
 - [SortItem](docs/Model/SortItem.md)
 - [Station](docs/Model/Station.md)
 - [StationEntityListing](docs/Model/StationEntityListing.md)
 - [StatisticalResponse](docs/Model/StatisticalResponse.md)
 - [StatisticalSummary](docs/Model/StatisticalSummary.md)
 - [StreetAddress](docs/Model/StreetAddress.md)
 - [SubscriberResponse](docs/Model/SubscriberResponse.md)
 - [SuggestSearchCriteria](docs/Model/SuggestSearchCriteria.md)
 - [SuggestSearchRequest](docs/Model/SuggestSearchRequest.md)
 - [SystemPresence](docs/Model/SystemPresence.md)
 - [TagQueryRequest](docs/Model/TagQueryRequest.md)
 - [TagValue](docs/Model/TagValue.md)
 - [TagValueEntityListing](docs/Model/TagValueEntityListing.md)
 - [TermAttribute](docs/Model/TermAttribute.md)
 - [TimeAllowed](docs/Model/TimeAllowed.md)
 - [TimeInterval](docs/Model/TimeInterval.md)
 - [TimeSlot](docs/Model/TimeSlot.md)
 - [TimeZone](docs/Model/TimeZone.md)
 - [TimeZoneEntityListing](docs/Model/TimeZoneEntityListing.md)
 - [TransferRequest](docs/Model/TransferRequest.md)
 - [Trunk](docs/Model/Trunk.md)
 - [TrunkBase](docs/Model/TrunkBase.md)
 - [TrunkBaseAssignment](docs/Model/TrunkBaseAssignment.md)
 - [TrunkBaseEntityListing](docs/Model/TrunkBaseEntityListing.md)
 - [TrunkEntityListing](docs/Model/TrunkEntityListing.md)
 - [TrunkMetabaseEntityListing](docs/Model/TrunkMetabaseEntityListing.md)
 - [TrunkRecordingEnabledCount](docs/Model/TrunkRecordingEnabledCount.md)
 - [UnreadMetric](docs/Model/UnreadMetric.md)
 - [UnreadStatus](docs/Model/UnreadStatus.md)
 - [UriReference](docs/Model/UriReference.md)
 - [Usage](docs/Model/Usage.md)
 - [UsageItem](docs/Model/UsageItem.md)
 - [User](docs/Model/User.md)
 - [UserAgentInfo](docs/Model/UserAgentInfo.md)
 - [UserAuthorization](docs/Model/UserAuthorization.md)
 - [UserConversationSummary](docs/Model/UserConversationSummary.md)
 - [UserConversationSummaryNotification](docs/Model/UserConversationSummaryNotification.md)
 - [UserConversationSummaryNotificationCall](docs/Model/UserConversationSummaryNotificationCall.md)
 - [UserConversationSummaryNotificationCallContactCenter](docs/Model/UserConversationSummaryNotificationCallContactCenter.md)
 - [UserConversationSummaryNotificationMediaSummary](docs/Model/UserConversationSummaryNotificationMediaSummary.md)
 - [UserConversationSummaryNotificationMediaSummaryDetail](docs/Model/UserConversationSummaryNotificationMediaSummaryDetail.md)
 - [UserEntityListing](docs/Model/UserEntityListing.md)
 - [UserImage](docs/Model/UserImage.md)
 - [UserMe](docs/Model/UserMe.md)
 - [UserParam](docs/Model/UserParam.md)
 - [UserPresence](docs/Model/UserPresence.md)
 - [UserPresenceNotification](docs/Model/UserPresenceNotification.md)
 - [UserPresenceNotificationOrganizationPresence](docs/Model/UserPresenceNotificationOrganizationPresence.md)
 - [UserPresenceNotificationPresenceDefinition](docs/Model/UserPresenceNotificationPresenceDefinition.md)
 - [UserQueue](docs/Model/UserQueue.md)
 - [UserQueueEntityListing](docs/Model/UserQueueEntityListing.md)
 - [UserRecording](docs/Model/UserRecording.md)
 - [UserRecordingEntityListing](docs/Model/UserRecordingEntityListing.md)
 - [UserRoutingSkill](docs/Model/UserRoutingSkill.md)
 - [UserRoutingSkillPost](docs/Model/UserRoutingSkillPost.md)
 - [UserRoutingStatusNotification](docs/Model/UserRoutingStatusNotification.md)
 - [UserRoutingStatusNotificationRoutingStatus](docs/Model/UserRoutingStatusNotificationRoutingStatus.md)
 - [UserScheduleAdherence](docs/Model/UserScheduleAdherence.md)
 - [UserSearchCriteria](docs/Model/UserSearchCriteria.md)
 - [UserSearchRequest](docs/Model/UserSearchRequest.md)
 - [UserSkillEntityListing](docs/Model/UserSkillEntityListing.md)
 - [UserStation](docs/Model/UserStation.md)
 - [UserStations](docs/Model/UserStations.md)
 - [UsersEntityListing](docs/Model/UsersEntityListing.md)
 - [UsersSearchResponse](docs/Model/UsersSearchResponse.md)
 - [Utilization](docs/Model/Utilization.md)
 - [ValidateAddressRequest](docs/Model/ValidateAddressRequest.md)
 - [ValidateAddressResponse](docs/Model/ValidateAddressResponse.md)
 - [Video](docs/Model/Video.md)
 - [VideoConversationNotification](docs/Model/VideoConversationNotification.md)
 - [VideoConversationNotificationDetail](docs/Model/VideoConversationNotificationDetail.md)
 - [VideoConversationNotificationErrorBody](docs/Model/VideoConversationNotificationErrorBody.md)
 - [VideoConversationNotificationErrorInfo](docs/Model/VideoConversationNotificationErrorInfo.md)
 - [VideoConversationNotificationParticipants](docs/Model/VideoConversationNotificationParticipants.md)
 - [VideoConversationNotificationUriReference](docs/Model/VideoConversationNotificationUriReference.md)
 - [VideoConversationNotificationVideoMediaParticipant](docs/Model/VideoConversationNotificationVideoMediaParticipant.md)
 - [VisibilityCondition](docs/Model/VisibilityCondition.md)
 - [VmPairingInfo](docs/Model/VmPairingInfo.md)
 - [VoicemailMailboxInfo](docs/Model/VoicemailMailboxInfo.md)
 - [VoicemailMediaInfo](docs/Model/VoicemailMediaInfo.md)
 - [VoicemailMessage](docs/Model/VoicemailMessage.md)
 - [VoicemailMessageEntityListing](docs/Model/VoicemailMessageEntityListing.md)
 - [VoicemailMessageNotification](docs/Model/VoicemailMessageNotification.md)
 - [VoicemailOrganizationPolicy](docs/Model/VoicemailOrganizationPolicy.md)
 - [VoicemailUserPolicy](docs/Model/VoicemailUserPolicy.md)
 - [Workspace](docs/Model/Workspace.md)
 - [WorkspaceCreate](docs/Model/WorkspaceCreate.md)
 - [WorkspaceEntityListing](docs/Model/WorkspaceEntityListing.md)
 - [WorkspaceMember](docs/Model/WorkspaceMember.md)
 - [WorkspaceMemberEntityListing](docs/Model/WorkspaceMemberEntityListing.md)
 - [WorkspaceSummary](docs/Model/WorkspaceSummary.md)
 - [WrapUpCodeMapping](docs/Model/WrapUpCodeMapping.md)
 - [Wrapup](docs/Model/Wrapup.md)
 - [WrapupCode](docs/Model/WrapupCode.md)
 - [WrapupCodeEntityListing](docs/Model/WrapupCodeEntityListing.md)


## Documentation For Authorization


## PureCloud Auth

- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: https://auth.us-east-1.mypurecloud.com/authorize
- **Scopes**: 
 - **all**: All the scopes


## Author

DeveloperEvangelists@inin.com


