# PureCloudSDK\IdentityProviderApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteAdfs**](IdentityProviderApi.md#deleteAdfs) | **DELETE** /api/v2/identityproviders/adfs | Delete ADFS Identity Provider
[**deleteCic**](IdentityProviderApi.md#deleteCic) | **DELETE** /api/v2/identityproviders/cic | Delete Customer Interaction Center (CIC) Identity Provider
[**deleteOkta**](IdentityProviderApi.md#deleteOkta) | **DELETE** /api/v2/identityproviders/okta | Delete Okta Identity Provider
[**deleteOnelogin**](IdentityProviderApi.md#deleteOnelogin) | **DELETE** /api/v2/identityproviders/onelogin | Delete OneLogin Identity Provider
[**deleteProviderId**](IdentityProviderApi.md#deleteProviderId) | **DELETE** /api/v2/identityproviders/{providerId} | Delete an identity provider
[**deletePurecloud**](IdentityProviderApi.md#deletePurecloud) | **DELETE** /api/v2/identityproviders/purecloud | Delete PureCloud Identity Provider
[**deleteSalesforce**](IdentityProviderApi.md#deleteSalesforce) | **DELETE** /api/v2/identityproviders/salesforce | Delete Salesforce Identity Provider
[**getAdfs**](IdentityProviderApi.md#getAdfs) | **GET** /api/v2/identityproviders/adfs | Get ADFS Identity Provider
[**getCic**](IdentityProviderApi.md#getCic) | **GET** /api/v2/identityproviders/cic | Get Customer Interaction Center (CIC) Identity Provider
[**getIdentityproviders**](IdentityProviderApi.md#getIdentityproviders) | **GET** /api/v2/identityproviders | The list of identity providers
[**getOkta**](IdentityProviderApi.md#getOkta) | **GET** /api/v2/identityproviders/okta | Get Okta Identity Provider
[**getOnelogin**](IdentityProviderApi.md#getOnelogin) | **GET** /api/v2/identityproviders/onelogin | Get OneLogin Identity Provider
[**getProviderId**](IdentityProviderApi.md#getProviderId) | **GET** /api/v2/identityproviders/{providerId} | Get an identity provider
[**getPurecloud**](IdentityProviderApi.md#getPurecloud) | **GET** /api/v2/identityproviders/purecloud | Get PureCloud Identity Provider
[**getSalesforce**](IdentityProviderApi.md#getSalesforce) | **GET** /api/v2/identityproviders/salesforce | Get Salesforce Identity Provider
[**putAdfs**](IdentityProviderApi.md#putAdfs) | **PUT** /api/v2/identityproviders/adfs | Update/Create ADFS Identity Provider
[**putCic**](IdentityProviderApi.md#putCic) | **PUT** /api/v2/identityproviders/cic | Update/Create Customer Interaction Center (CIC) Identity Provider
[**putOkta**](IdentityProviderApi.md#putOkta) | **PUT** /api/v2/identityproviders/okta | Update/Create Okta Identity Provider
[**putOnelogin**](IdentityProviderApi.md#putOnelogin) | **PUT** /api/v2/identityproviders/onelogin | Update/Create OneLogin Identity Provider
[**putProviderId**](IdentityProviderApi.md#putProviderId) | **PUT** /api/v2/identityproviders/{providerId} | Update an identity provider
[**putPurecloud**](IdentityProviderApi.md#putPurecloud) | **PUT** /api/v2/identityproviders/purecloud | Update/Create PureCloud Identity Provider
[**putSalesforce**](IdentityProviderApi.md#putSalesforce) | **PUT** /api/v2/identityproviders/salesforce | Update/Create Salesforce Identity Provider


# **deleteAdfs**
> deleteAdfs()

Delete ADFS Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $api_instance->deleteAdfs();
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->deleteAdfs: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteCic**
> deleteCic()

Delete Customer Interaction Center (CIC) Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $api_instance->deleteCic();
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->deleteCic: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteOkta**
> deleteOkta()

Delete Okta Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $api_instance->deleteOkta();
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->deleteOkta: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteOnelogin**
> deleteOnelogin()

Delete OneLogin Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $api_instance->deleteOnelogin();
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->deleteOnelogin: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProviderId**
> deleteProviderId()

Delete an identity provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $api_instance->deleteProviderId();
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->deleteProviderId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deletePurecloud**
> deletePurecloud()

Delete PureCloud Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $api_instance->deletePurecloud();
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->deletePurecloud: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteSalesforce**
> deleteSalesforce()

Delete Salesforce Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $api_instance->deleteSalesforce();
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->deleteSalesforce: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAdfs**
> \PureCloudSDK\ADFS getAdfs()

Get ADFS Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $result = $api_instance->getAdfs();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->getAdfs: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\ADFS**](../Model/ADFS.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCic**
> \PureCloudSDK\CustomerInteractionCenter getCic()

Get Customer Interaction Center (CIC) Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $result = $api_instance->getCic();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->getCic: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\CustomerInteractionCenter**](../Model/CustomerInteractionCenter.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getIdentityproviders**
> \PureCloudSDK\OAuthProviderEntityListing getIdentityproviders()

The list of identity providers



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $result = $api_instance->getIdentityproviders();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->getIdentityproviders: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\OAuthProviderEntityListing**](../Model/OAuthProviderEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOkta**
> \PureCloudSDK\Okta getOkta()

Get Okta Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $result = $api_instance->getOkta();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->getOkta: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\Okta**](../Model/Okta.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOnelogin**
> \PureCloudSDK\OneLogin getOnelogin()

Get OneLogin Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $result = $api_instance->getOnelogin();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->getOnelogin: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\OneLogin**](../Model/OneLogin.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProviderId**
> \PureCloudSDK\OAuthProvider getProviderId()

Get an identity provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $result = $api_instance->getProviderId();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->getProviderId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\OAuthProvider**](../Model/OAuthProvider.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getPurecloud**
> \PureCloudSDK\PureCloud getPurecloud()

Get PureCloud Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $result = $api_instance->getPurecloud();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->getPurecloud: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\PureCloud**](../Model/PureCloud.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSalesforce**
> \PureCloudSDK\Salesforce getSalesforce()

Get Salesforce Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();

try {
    $result = $api_instance->getSalesforce();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->getSalesforce: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\Salesforce**](../Model/Salesforce.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putAdfs**
> putAdfs($body)

Update/Create ADFS Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();
$body = new \PureCloudSDK\ADFS(); // \PureCloudSDK\ADFS | Provider

try {
    $api_instance->putAdfs($body);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->putAdfs: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ADFS**](../Model/\PureCloudSDK\ADFS.md)| Provider |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putCic**
> putCic($body)

Update/Create Customer Interaction Center (CIC) Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();
$body = new \PureCloudSDK\CustomerInteractionCenter(); // \PureCloudSDK\CustomerInteractionCenter | Provider

try {
    $api_instance->putCic($body);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->putCic: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\CustomerInteractionCenter**](../Model/\PureCloudSDK\CustomerInteractionCenter.md)| Provider |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putOkta**
> putOkta($body)

Update/Create Okta Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();
$body = new \PureCloudSDK\Okta(); // \PureCloudSDK\Okta | Provider

try {
    $api_instance->putOkta($body);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->putOkta: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Okta**](../Model/\PureCloudSDK\Okta.md)| Provider |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putOnelogin**
> putOnelogin($body)

Update/Create OneLogin Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();
$body = new \PureCloudSDK\OneLogin(); // \PureCloudSDK\OneLogin | Provider

try {
    $api_instance->putOnelogin($body);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->putOnelogin: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\OneLogin**](../Model/\PureCloudSDK\OneLogin.md)| Provider |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProviderId**
> putProviderId($body)

Update an identity provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();
$body = new \PureCloudSDK\OAuthProvider(); // \PureCloudSDK\OAuthProvider | Provider

try {
    $api_instance->putProviderId($body);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->putProviderId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\OAuthProvider**](../Model/\PureCloudSDK\OAuthProvider.md)| Provider |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putPurecloud**
> putPurecloud($body)

Update/Create PureCloud Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();
$body = new \PureCloudSDK\PureCloud(); // \PureCloudSDK\PureCloud | Provider

try {
    $api_instance->putPurecloud($body);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->putPurecloud: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\PureCloud**](../Model/\PureCloudSDK\PureCloud.md)| Provider |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putSalesforce**
> putSalesforce($body)

Update/Create Salesforce Identity Provider



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\IdentityProviderApi();
$body = new \PureCloudSDK\Salesforce(); // \PureCloudSDK\Salesforce | Provider

try {
    $api_instance->putSalesforce($body);
} catch (Exception $e) {
    echo 'Exception when calling IdentityProviderApi->putSalesforce: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Salesforce**](../Model/\PureCloudSDK\Salesforce.md)| Provider |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

