<?php

/**
 * AnalyticsConversationWithoutAttributes
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * AnalyticsConversationWithoutAttributes Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class AnalyticsConversationWithoutAttributes implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'AnalyticsConversationWithoutAttributes';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'conversationId' => 'string',
        'conversationStart' => '\DateTime',
        'conversationEnd' => '\DateTime',
        'mediaStatsMinConversationMos' => 'double',
        'mediaStatsMinConversationRFactor' => 'double',
        'originatingDirection' => 'string',
        'evaluations' => '\PureCloudSDK\AnalyticsEvaluation[]',
        'surveys' => '\PureCloudSDK\AnalyticsSurvey[]',
        'divisionIds' => 'string[]',
        'participants' => '\PureCloudSDK\AnalyticsParticipantWithoutAttributes[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'conversationId' => 'conversationId',
        'conversationStart' => 'conversationStart',
        'conversationEnd' => 'conversationEnd',
        'mediaStatsMinConversationMos' => 'mediaStatsMinConversationMos',
        'mediaStatsMinConversationRFactor' => 'mediaStatsMinConversationRFactor',
        'originatingDirection' => 'originatingDirection',
        'evaluations' => 'evaluations',
        'surveys' => 'surveys',
        'divisionIds' => 'divisionIds',
        'participants' => 'participants'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'conversationId' => 'setConversationId',
        'conversationStart' => 'setConversationStart',
        'conversationEnd' => 'setConversationEnd',
        'mediaStatsMinConversationMos' => 'setMediaStatsMinConversationMos',
        'mediaStatsMinConversationRFactor' => 'setMediaStatsMinConversationRFactor',
        'originatingDirection' => 'setOriginatingDirection',
        'evaluations' => 'setEvaluations',
        'surveys' => 'setSurveys',
        'divisionIds' => 'setDivisionIds',
        'participants' => 'setParticipants'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'conversationId' => 'getConversationId',
        'conversationStart' => 'getConversationStart',
        'conversationEnd' => 'getConversationEnd',
        'mediaStatsMinConversationMos' => 'getMediaStatsMinConversationMos',
        'mediaStatsMinConversationRFactor' => 'getMediaStatsMinConversationRFactor',
        'originatingDirection' => 'getOriginatingDirection',
        'evaluations' => 'getEvaluations',
        'surveys' => 'getSurveys',
        'divisionIds' => 'getDivisionIds',
        'participants' => 'getParticipants'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const ORIGINATING_DIRECTION_INBOUND = 'inbound';
    public const ORIGINATING_DIRECTION_OUTBOUND = 'outbound';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getOriginatingDirectionAllowableValues()
    {
        return [
            self::ORIGINATING_DIRECTION_INBOUND,
            self::ORIGINATING_DIRECTION_OUTBOUND,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['conversationId'] = isset($data['conversationId']) ? $data['conversationId'] : null;
        $this->container['conversationStart'] = isset($data['conversationStart']) ? $data['conversationStart'] : null;
        $this->container['conversationEnd'] = isset($data['conversationEnd']) ? $data['conversationEnd'] : null;
        $this->container['mediaStatsMinConversationMos'] = isset($data['mediaStatsMinConversationMos']) ? $data['mediaStatsMinConversationMos'] : null;
        $this->container['mediaStatsMinConversationRFactor'] = isset($data['mediaStatsMinConversationRFactor']) ? $data['mediaStatsMinConversationRFactor'] : null;
        $this->container['originatingDirection'] = isset($data['originatingDirection']) ? $data['originatingDirection'] : null;
        $this->container['evaluations'] = isset($data['evaluations']) ? $data['evaluations'] : null;
        $this->container['surveys'] = isset($data['surveys']) ? $data['surveys'] : null;
        $this->container['divisionIds'] = isset($data['divisionIds']) ? $data['divisionIds'] : null;
        $this->container['participants'] = isset($data['participants']) ? $data['participants'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("inbound", "outbound");
        if (!in_array($this->container['originatingDirection'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'originatingDirection', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("inbound", "outbound");
        if (!in_array($this->container['originatingDirection'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets conversationId
     * @return string
     */
    public function getConversationId()
    {
        return $this->container['conversationId'];
    }

    /**
     * Sets conversationId
     * @param string $conversationId Unique identifier for the conversation
     * @return $this
     */
    public function setConversationId($conversationId)
    {
        $this->container['conversationId'] = $conversationId;

        return $this;
    }

    /**
     * Gets conversationStart
     * @return \DateTime
     */
    public function getConversationStart()
    {
        return $this->container['conversationStart'];
    }

    /**
     * Sets conversationStart
     * @param \DateTime $conversationStart Date/time the conversation started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setConversationStart($conversationStart)
    {
        $this->container['conversationStart'] = $conversationStart;

        return $this;
    }

    /**
     * Gets conversationEnd
     * @return \DateTime
     */
    public function getConversationEnd()
    {
        return $this->container['conversationEnd'];
    }

    /**
     * Sets conversationEnd
     * @param \DateTime $conversationEnd Date/time the conversation ended. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setConversationEnd($conversationEnd)
    {
        $this->container['conversationEnd'] = $conversationEnd;

        return $this;
    }

    /**
     * Gets mediaStatsMinConversationMos
     * @return double
     */
    public function getMediaStatsMinConversationMos()
    {
        return $this->container['mediaStatsMinConversationMos'];
    }

    /**
     * Sets mediaStatsMinConversationMos
     * @param double $mediaStatsMinConversationMos The lowest estimated average MOS among all the audio streams belonging to this conversation
     * @return $this
     */
    public function setMediaStatsMinConversationMos($mediaStatsMinConversationMos)
    {
        $this->container['mediaStatsMinConversationMos'] = $mediaStatsMinConversationMos;

        return $this;
    }

    /**
     * Gets mediaStatsMinConversationRFactor
     * @return double
     */
    public function getMediaStatsMinConversationRFactor()
    {
        return $this->container['mediaStatsMinConversationRFactor'];
    }

    /**
     * Sets mediaStatsMinConversationRFactor
     * @param double $mediaStatsMinConversationRFactor The lowest R-factor value among all of the audio streams belonging to this conversation
     * @return $this
     */
    public function setMediaStatsMinConversationRFactor($mediaStatsMinConversationRFactor)
    {
        $this->container['mediaStatsMinConversationRFactor'] = $mediaStatsMinConversationRFactor;

        return $this;
    }

    /**
     * Gets originatingDirection
     * @return string
     */
    public function getOriginatingDirection()
    {
        return $this->container['originatingDirection'];
    }

    /**
     * Sets originatingDirection
     * @param string $originatingDirection The original direction of the conversation
     * @return $this
     */
    public function setOriginatingDirection($originatingDirection)
    {
        $allowed_values = array('inbound', 'outbound');
        if (!in_array($originatingDirection, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'originatingDirection', must be one of 'inbound', 'outbound'");
        }
        $this->container['originatingDirection'] = $originatingDirection;

        return $this;
    }

    /**
     * Gets evaluations
     * @return \PureCloudSDK\AnalyticsEvaluation[]
     */
    public function getEvaluations()
    {
        return $this->container['evaluations'];
    }

    /**
     * Sets evaluations
     * @param \PureCloudSDK\AnalyticsEvaluation[] $evaluations Evaluations tied to this conversation
     * @return $this
     */
    public function setEvaluations($evaluations)
    {
        $this->container['evaluations'] = $evaluations;

        return $this;
    }

    /**
     * Gets surveys
     * @return \PureCloudSDK\AnalyticsSurvey[]
     */
    public function getSurveys()
    {
        return $this->container['surveys'];
    }

    /**
     * Sets surveys
     * @param \PureCloudSDK\AnalyticsSurvey[] $surveys Surveys tied to this conversation
     * @return $this
     */
    public function setSurveys($surveys)
    {
        $this->container['surveys'] = $surveys;

        return $this;
    }

    /**
     * Gets divisionIds
     * @return string[]
     */
    public function getDivisionIds()
    {
        return $this->container['divisionIds'];
    }

    /**
     * Sets divisionIds
     * @param string[] $divisionIds Identifiers of divisions associated with this conversation
     * @return $this
     */
    public function setDivisionIds($divisionIds)
    {
        $this->container['divisionIds'] = $divisionIds;

        return $this;
    }

    /**
     * Gets participants
     * @return \PureCloudSDK\AnalyticsParticipantWithoutAttributes[]
     */
    public function getParticipants()
    {
        return $this->container['participants'];
    }

    /**
     * Sets participants
     * @param \PureCloudSDK\AnalyticsParticipantWithoutAttributes[] $participants Participants in the conversation
     * @return $this
     */
    public function setParticipants($participants)
    {
        $this->container['participants'] = $participants;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
