<?php

/**
 * AuditLogMessage
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * AuditLogMessage Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class AuditLogMessage implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'AuditLogMessage';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'user' => '\PureCloudSDK\DomainEntityRef',
        'client' => '\PureCloudSDK\AddressableEntityRef',
        'remoteIp' => 'string[]',
        'serviceName' => 'string',
        'eventDate' => '\DateTime',
        'message' => '\PureCloudSDK\MessageInfo',
        'action' => 'string',
        'entity' => '\PureCloudSDK\AddressableEntityRef',
        'entityType' => 'string',
        'propertyChanges' => '\PureCloudSDK\PropertyChange[]',
        'context' => 'map[string,string]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'user' => 'user',
        'client' => 'client',
        'remoteIp' => 'remoteIp',
        'serviceName' => 'serviceName',
        'eventDate' => 'eventDate',
        'message' => 'message',
        'action' => 'action',
        'entity' => 'entity',
        'entityType' => 'entityType',
        'propertyChanges' => 'propertyChanges',
        'context' => 'context'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'user' => 'setUser',
        'client' => 'setClient',
        'remoteIp' => 'setRemoteIp',
        'serviceName' => 'setServiceName',
        'eventDate' => 'setEventDate',
        'message' => 'setMessage',
        'action' => 'setAction',
        'entity' => 'setEntity',
        'entityType' => 'setEntityType',
        'propertyChanges' => 'setPropertyChanges',
        'context' => 'setContext'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'user' => 'getUser',
        'client' => 'getClient',
        'remoteIp' => 'getRemoteIp',
        'serviceName' => 'getServiceName',
        'eventDate' => 'getEventDate',
        'message' => 'getMessage',
        'action' => 'getAction',
        'entity' => 'getEntity',
        'entityType' => 'getEntityType',
        'propertyChanges' => 'getPropertyChanges',
        'context' => 'getContext'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const SERVICE_NAME_CONTACT_CENTER = 'ContactCenter';
    public const SERVICE_NAME_CONTENT_MANAGEMENT = 'ContentManagement';
    public const SERVICE_NAME_PEOPLE_PERMISSIONS = 'PeoplePermissions';
    public const SERVICE_NAME_QUALITY = 'Quality';
    public const SERVICE_NAME_LANGUAGE_UNDERSTANDING = 'LanguageUnderstanding';
    public const SERVICE_NAME_TOPICS_DEFINITIONS = 'TopicsDefinitions';
    public const SERVICE_NAME_PREDICTIVE_ENGAGEMENT = 'PredictiveEngagement';
    public const SERVICE_NAME_WORKFORCE_MANAGEMENT = 'WorkforceManagement';
    public const SERVICE_NAME_TRIGGERS = 'Triggers';
    public const SERVICE_NAME_RESPONSE_MANAGEMENT = 'ResponseManagement';
    public const ACTION_CREATE = 'Create';
    public const ACTION_VIEW = 'View';
    public const ACTION_UPDATE = 'Update';
    public const ACTION_DELETE = 'Delete';
    public const ACTION_DOWNLOAD = 'Download';
    public const ACTION_MEMBER_ADD = 'MemberAdd';
    public const ACTION_MEMBER_UPDATE = 'MemberUpdate';
    public const ACTION_MEMBER_REMOVE = 'MemberRemove';
    public const ACTION_READ = 'Read';
    public const ACTION_APPLY_PROTECTION = 'ApplyProtection';
    public const ACTION_REVOKE_PROTECTION = 'RevokeProtection';
    public const ACTION_UPDATE_RETENTION = 'UpdateRetention';
    public const ACTION_READ_ALL = 'ReadAll';
    public const ACTION_EXECUTE = 'Execute';
    public const ACTION_PUBLISH = 'Publish';
    public const ACTION_UNPUBLISH = 'Unpublish';
    public const ACTION_ENABLE = 'Enable';
    public const ACTION_DISABLE = 'Disable';
    public const ACTION_AUTHORIZE = 'Authorize';
    public const ACTION_DEAUTHORIZE = 'Deauthorize';
    public const ACTION_AUTHENTICATE = 'Authenticate';
    public const ACTION_CHANGE_PASSWORD = 'ChangePassword';
    public const ENTITY_TYPE_DOCUMENT = 'Document';
    public const ENTITY_TYPE_QUEUE = 'Queue';
    public const ENTITY_TYPE_RECORDING = 'Recording';
    public const ENTITY_TYPE_ROLE = 'Role';
    public const ENTITY_TYPE_VOICEMAIL_USER_POLICY = 'VoicemailUserPolicy';
    public const ENTITY_TYPE_WRAPUP_CODE = 'WrapupCode';
    public const ENTITY_TYPE_ACCESS_TOKEN = 'AccessToken';
    public const ENTITY_TYPE_O_AUTH_CLIENT = 'OAuthClient';
    public const ENTITY_TYPE_O_AUTH_CLIENT_AUTHORIZATION = 'OAuthClientAuthorization';
    public const ENTITY_TYPE_AUTH_ORGANIZATION = 'AuthOrganization';
    public const ENTITY_TYPE_AUTH_USER = 'AuthUser';
    public const ENTITY_TYPE_BULK_ACTIONS = 'BulkActions';
    public const ENTITY_TYPE_FEEDBACK = 'Feedback';
    public const ENTITY_TYPE_TOPIC = 'Topic';
    public const ENTITY_TYPE_PROGRAM = 'Program';
    public const ENTITY_TYPE_SEGMENT = 'Segment';
    public const ENTITY_TYPE_OUTCOME = 'Outcome';
    public const ENTITY_TYPE_SESSION_TYPE = 'SessionType';
    public const ENTITY_TYPE_EVENT_TYPE = 'EventType';
    public const ENTITY_TYPE_CLICKSTREAM_SETTINGS = 'ClickstreamSettings';
    public const ENTITY_TYPE_SCHEDULE = 'Schedule';
    public const ENTITY_TYPE_TRIGGER = 'Trigger';
    public const ENTITY_TYPE_RESPONSE = 'Response';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getServiceNameAllowableValues()
    {
        return [
            self::SERVICE_NAME_CONTACT_CENTER,
            self::SERVICE_NAME_CONTENT_MANAGEMENT,
            self::SERVICE_NAME_PEOPLE_PERMISSIONS,
            self::SERVICE_NAME_QUALITY,
            self::SERVICE_NAME_LANGUAGE_UNDERSTANDING,
            self::SERVICE_NAME_TOPICS_DEFINITIONS,
            self::SERVICE_NAME_PREDICTIVE_ENGAGEMENT,
            self::SERVICE_NAME_WORKFORCE_MANAGEMENT,
            self::SERVICE_NAME_TRIGGERS,
            self::SERVICE_NAME_RESPONSE_MANAGEMENT,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getActionAllowableValues()
    {
        return [
            self::ACTION_CREATE,
            self::ACTION_VIEW,
            self::ACTION_UPDATE,
            self::ACTION_DELETE,
            self::ACTION_DOWNLOAD,
            self::ACTION_MEMBER_ADD,
            self::ACTION_MEMBER_UPDATE,
            self::ACTION_MEMBER_REMOVE,
            self::ACTION_READ,
            self::ACTION_APPLY_PROTECTION,
            self::ACTION_REVOKE_PROTECTION,
            self::ACTION_UPDATE_RETENTION,
            self::ACTION_READ_ALL,
            self::ACTION_EXECUTE,
            self::ACTION_PUBLISH,
            self::ACTION_UNPUBLISH,
            self::ACTION_ENABLE,
            self::ACTION_DISABLE,
            self::ACTION_AUTHORIZE,
            self::ACTION_DEAUTHORIZE,
            self::ACTION_AUTHENTICATE,
            self::ACTION_CHANGE_PASSWORD,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getEntityTypeAllowableValues()
    {
        return [
            self::ENTITY_TYPE_DOCUMENT,
            self::ENTITY_TYPE_QUEUE,
            self::ENTITY_TYPE_RECORDING,
            self::ENTITY_TYPE_ROLE,
            self::ENTITY_TYPE_VOICEMAIL_USER_POLICY,
            self::ENTITY_TYPE_WRAPUP_CODE,
            self::ENTITY_TYPE_ACCESS_TOKEN,
            self::ENTITY_TYPE_O_AUTH_CLIENT,
            self::ENTITY_TYPE_O_AUTH_CLIENT_AUTHORIZATION,
            self::ENTITY_TYPE_AUTH_ORGANIZATION,
            self::ENTITY_TYPE_AUTH_USER,
            self::ENTITY_TYPE_BULK_ACTIONS,
            self::ENTITY_TYPE_FEEDBACK,
            self::ENTITY_TYPE_TOPIC,
            self::ENTITY_TYPE_PROGRAM,
            self::ENTITY_TYPE_SEGMENT,
            self::ENTITY_TYPE_OUTCOME,
            self::ENTITY_TYPE_SESSION_TYPE,
            self::ENTITY_TYPE_EVENT_TYPE,
            self::ENTITY_TYPE_CLICKSTREAM_SETTINGS,
            self::ENTITY_TYPE_SCHEDULE,
            self::ENTITY_TYPE_TRIGGER,
            self::ENTITY_TYPE_RESPONSE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['user'] = isset($data['user']) ? $data['user'] : null;
        $this->container['client'] = isset($data['client']) ? $data['client'] : null;
        $this->container['remoteIp'] = isset($data['remoteIp']) ? $data['remoteIp'] : null;
        $this->container['serviceName'] = isset($data['serviceName']) ? $data['serviceName'] : null;
        $this->container['eventDate'] = isset($data['eventDate']) ? $data['eventDate'] : null;
        $this->container['message'] = isset($data['message']) ? $data['message'] : null;
        $this->container['action'] = isset($data['action']) ? $data['action'] : null;
        $this->container['entity'] = isset($data['entity']) ? $data['entity'] : null;
        $this->container['entityType'] = isset($data['entityType']) ? $data['entityType'] : null;
        $this->container['propertyChanges'] = isset($data['propertyChanges']) ? $data['propertyChanges'] : null;
        $this->container['context'] = isset($data['context']) ? $data['context'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("ContactCenter", "ContentManagement", "PeoplePermissions", "Quality", "LanguageUnderstanding", "TopicsDefinitions", "PredictiveEngagement", "WorkforceManagement", "Triggers", "ResponseManagement");
        if (!in_array($this->container['serviceName'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'serviceName', must be one of #{allowed_values}.";
        }

        $allowed_values = array("Create", "View", "Update", "Delete", "Download", "MemberAdd", "MemberUpdate", "MemberRemove", "Read", "ApplyProtection", "RevokeProtection", "UpdateRetention", "ReadAll", "Execute", "Publish", "Unpublish", "Enable", "Disable", "Authorize", "Deauthorize", "Authenticate", "ChangePassword");
        if (!in_array($this->container['action'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'action', must be one of #{allowed_values}.";
        }

        $allowed_values = array("Document", "Queue", "Recording", "Role", "VoicemailUserPolicy", "WrapupCode", "AccessToken", "OAuthClient", "OAuthClientAuthorization", "AuthOrganization", "AuthUser", "BulkActions", "Feedback", "Topic", "Program", "Segment", "Outcome", "SessionType", "EventType", "ClickstreamSettings", "Schedule", "Trigger", "Response");
        if (!in_array($this->container['entityType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'entityType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("ContactCenter", "ContentManagement", "PeoplePermissions", "Quality", "LanguageUnderstanding", "TopicsDefinitions", "PredictiveEngagement", "WorkforceManagement", "Triggers", "ResponseManagement");
        if (!in_array($this->container['serviceName'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("Create", "View", "Update", "Delete", "Download", "MemberAdd", "MemberUpdate", "MemberRemove", "Read", "ApplyProtection", "RevokeProtection", "UpdateRetention", "ReadAll", "Execute", "Publish", "Unpublish", "Enable", "Disable", "Authorize", "Deauthorize", "Authenticate", "ChangePassword");
        if (!in_array($this->container['action'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("Document", "Queue", "Recording", "Role", "VoicemailUserPolicy", "WrapupCode", "AccessToken", "OAuthClient", "OAuthClientAuthorization", "AuthOrganization", "AuthUser", "BulkActions", "Feedback", "Topic", "Program", "Segment", "Outcome", "SessionType", "EventType", "ClickstreamSettings", "Schedule", "Trigger", "Response");
        if (!in_array($this->container['entityType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id Id of the audit message.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets user
     * @return \PureCloudSDK\DomainEntityRef
     */
    public function getUser()
    {
        return $this->container['user'];
    }

    /**
     * Sets user
     * @param \PureCloudSDK\DomainEntityRef $user User associated with this audit message.
     * @return $this
     */
    public function setUser($user)
    {
        $this->container['user'] = $user;

        return $this;
    }

    /**
     * Gets client
     * @return \PureCloudSDK\AddressableEntityRef
     */
    public function getClient()
    {
        return $this->container['client'];
    }

    /**
     * Sets client
     * @param \PureCloudSDK\AddressableEntityRef $client Client associated with this audit message.
     * @return $this
     */
    public function setClient($client)
    {
        $this->container['client'] = $client;

        return $this;
    }

    /**
     * Gets remoteIp
     * @return string[]
     */
    public function getRemoteIp()
    {
        return $this->container['remoteIp'];
    }

    /**
     * Sets remoteIp
     * @param string[] $remoteIp List of IP addresses of systems that originated or handled the request.
     * @return $this
     */
    public function setRemoteIp($remoteIp)
    {
        $this->container['remoteIp'] = $remoteIp;

        return $this;
    }

    /**
     * Gets serviceName
     * @return string
     */
    public function getServiceName()
    {
        return $this->container['serviceName'];
    }

    /**
     * Sets serviceName
     * @param string $serviceName Name of the service that logged this audit message.
     * @return $this
     */
    public function setServiceName($serviceName)
    {
        $allowed_values = array('ContactCenter', 'ContentManagement', 'PeoplePermissions', 'Quality', 'LanguageUnderstanding', 'TopicsDefinitions', 'PredictiveEngagement', 'WorkforceManagement', 'Triggers', 'ResponseManagement');
        if (!in_array($serviceName, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'serviceName', must be one of 'ContactCenter', 'ContentManagement', 'PeoplePermissions', 'Quality', 'LanguageUnderstanding', 'TopicsDefinitions', 'PredictiveEngagement', 'WorkforceManagement', 'Triggers', 'ResponseManagement'");
        }
        $this->container['serviceName'] = $serviceName;

        return $this;
    }

    /**
     * Gets eventDate
     * @return \DateTime
     */
    public function getEventDate()
    {
        return $this->container['eventDate'];
    }

    /**
     * Sets eventDate
     * @param \DateTime $eventDate Date and time of when the audit message was logged. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setEventDate($eventDate)
    {
        $this->container['eventDate'] = $eventDate;

        return $this;
    }

    /**
     * Gets message
     * @return \PureCloudSDK\MessageInfo
     */
    public function getMessage()
    {
        return $this->container['message'];
    }

    /**
     * Sets message
     * @param \PureCloudSDK\MessageInfo $message Message describing the event being audited.
     * @return $this
     */
    public function setMessage($message)
    {
        $this->container['message'] = $message;

        return $this;
    }

    /**
     * Gets action
     * @return string
     */
    public function getAction()
    {
        return $this->container['action'];
    }

    /**
     * Sets action
     * @param string $action Action that took place.
     * @return $this
     */
    public function setAction($action)
    {
        $allowed_values = array('Create', 'View', 'Update', 'Delete', 'Download', 'MemberAdd', 'MemberUpdate', 'MemberRemove', 'Read', 'ApplyProtection', 'RevokeProtection', 'UpdateRetention', 'ReadAll', 'Execute', 'Publish', 'Unpublish', 'Enable', 'Disable', 'Authorize', 'Deauthorize', 'Authenticate', 'ChangePassword');
        if (!in_array($action, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'action', must be one of 'Create', 'View', 'Update', 'Delete', 'Download', 'MemberAdd', 'MemberUpdate', 'MemberRemove', 'Read', 'ApplyProtection', 'RevokeProtection', 'UpdateRetention', 'ReadAll', 'Execute', 'Publish', 'Unpublish', 'Enable', 'Disable', 'Authorize', 'Deauthorize', 'Authenticate', 'ChangePassword'");
        }
        $this->container['action'] = $action;

        return $this;
    }

    /**
     * Gets entity
     * @return \PureCloudSDK\AddressableEntityRef
     */
    public function getEntity()
    {
        return $this->container['entity'];
    }

    /**
     * Sets entity
     * @param \PureCloudSDK\AddressableEntityRef $entity Entity that was impacted.
     * @return $this
     */
    public function setEntity($entity)
    {
        $this->container['entity'] = $entity;

        return $this;
    }

    /**
     * Gets entityType
     * @return string
     */
    public function getEntityType()
    {
        return $this->container['entityType'];
    }

    /**
     * Sets entityType
     * @param string $entityType Type of the entity that was impacted.
     * @return $this
     */
    public function setEntityType($entityType)
    {
        $allowed_values = array('Document', 'Queue', 'Recording', 'Role', 'VoicemailUserPolicy', 'WrapupCode', 'AccessToken', 'OAuthClient', 'OAuthClientAuthorization', 'AuthOrganization', 'AuthUser', 'BulkActions', 'Feedback', 'Topic', 'Program', 'Segment', 'Outcome', 'SessionType', 'EventType', 'ClickstreamSettings', 'Schedule', 'Trigger', 'Response');
        if (!in_array($entityType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'entityType', must be one of 'Document', 'Queue', 'Recording', 'Role', 'VoicemailUserPolicy', 'WrapupCode', 'AccessToken', 'OAuthClient', 'OAuthClientAuthorization', 'AuthOrganization', 'AuthUser', 'BulkActions', 'Feedback', 'Topic', 'Program', 'Segment', 'Outcome', 'SessionType', 'EventType', 'ClickstreamSettings', 'Schedule', 'Trigger', 'Response'");
        }
        $this->container['entityType'] = $entityType;

        return $this;
    }

    /**
     * Gets propertyChanges
     * @return \PureCloudSDK\PropertyChange[]
     */
    public function getPropertyChanges()
    {
        return $this->container['propertyChanges'];
    }

    /**
     * Sets propertyChanges
     * @param \PureCloudSDK\PropertyChange[] $propertyChanges List of properties that were changed and changes made to those properties.
     * @return $this
     */
    public function setPropertyChanges($propertyChanges)
    {
        $this->container['propertyChanges'] = $propertyChanges;

        return $this;
    }

    /**
     * Gets context
     * @return map[string,string]
     */
    public function getContext()
    {
        return $this->container['context'];
    }

    /**
     * Sets context
     * @param map[string,string] $context Additional context for this message.
     * @return $this
     */
    public function setContext($context)
    {
        $this->container['context'] = $context;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
