<?php

/**
 * AuditQueryEntity
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * AuditQueryEntity Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class AuditQueryEntity implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'AuditQueryEntity';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'name' => 'string',
        'actions' => 'string[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'name' => 'name',
        'actions' => 'actions'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'name' => 'setName',
        'actions' => 'setActions'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'name' => 'getName',
        'actions' => 'getActions'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const NAME_DOCUMENT = 'Document';
    public const NAME_QUEUE = 'Queue';
    public const NAME_RECORDING = 'Recording';
    public const NAME_ROLE = 'Role';
    public const NAME_VOICEMAIL_USER_POLICY = 'VoicemailUserPolicy';
    public const NAME_WRAPUP_CODE = 'WrapupCode';
    public const NAME_ACCESS_TOKEN = 'AccessToken';
    public const NAME_O_AUTH_CLIENT = 'OAuthClient';
    public const NAME_O_AUTH_CLIENT_AUTHORIZATION = 'OAuthClientAuthorization';
    public const NAME_AUTH_ORGANIZATION = 'AuthOrganization';
    public const NAME_AUTH_USER = 'AuthUser';
    public const NAME_BULK_ACTIONS = 'BulkActions';
    public const NAME_FEEDBACK = 'Feedback';
    public const NAME_TOPIC = 'Topic';
    public const NAME_PROGRAM = 'Program';
    public const NAME_SEGMENT = 'Segment';
    public const NAME_OUTCOME = 'Outcome';
    public const NAME_SESSION_TYPE = 'SessionType';
    public const NAME_EVENT_TYPE = 'EventType';
    public const NAME_CLICKSTREAM_SETTINGS = 'ClickstreamSettings';
    public const NAME_SCHEDULE = 'Schedule';
    public const NAME_TRIGGER = 'Trigger';
    public const NAME_RESPONSE = 'Response';
    public const ACTIONS_CREATE = 'Create';
    public const ACTIONS_VIEW = 'View';
    public const ACTIONS_UPDATE = 'Update';
    public const ACTIONS_DELETE = 'Delete';
    public const ACTIONS_DOWNLOAD = 'Download';
    public const ACTIONS_MEMBER_ADD = 'MemberAdd';
    public const ACTIONS_MEMBER_UPDATE = 'MemberUpdate';
    public const ACTIONS_MEMBER_REMOVE = 'MemberRemove';
    public const ACTIONS_READ = 'Read';
    public const ACTIONS_APPLY_PROTECTION = 'ApplyProtection';
    public const ACTIONS_REVOKE_PROTECTION = 'RevokeProtection';
    public const ACTIONS_UPDATE_RETENTION = 'UpdateRetention';
    public const ACTIONS_READ_ALL = 'ReadAll';
    public const ACTIONS_EXECUTE = 'Execute';
    public const ACTIONS_PUBLISH = 'Publish';
    public const ACTIONS_UNPUBLISH = 'Unpublish';
    public const ACTIONS_ENABLE = 'Enable';
    public const ACTIONS_DISABLE = 'Disable';
    public const ACTIONS_AUTHORIZE = 'Authorize';
    public const ACTIONS_DEAUTHORIZE = 'Deauthorize';
    public const ACTIONS_AUTHENTICATE = 'Authenticate';
    public const ACTIONS_CHANGE_PASSWORD = 'ChangePassword';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getNameAllowableValues()
    {
        return [
            self::NAME_DOCUMENT,
            self::NAME_QUEUE,
            self::NAME_RECORDING,
            self::NAME_ROLE,
            self::NAME_VOICEMAIL_USER_POLICY,
            self::NAME_WRAPUP_CODE,
            self::NAME_ACCESS_TOKEN,
            self::NAME_O_AUTH_CLIENT,
            self::NAME_O_AUTH_CLIENT_AUTHORIZATION,
            self::NAME_AUTH_ORGANIZATION,
            self::NAME_AUTH_USER,
            self::NAME_BULK_ACTIONS,
            self::NAME_FEEDBACK,
            self::NAME_TOPIC,
            self::NAME_PROGRAM,
            self::NAME_SEGMENT,
            self::NAME_OUTCOME,
            self::NAME_SESSION_TYPE,
            self::NAME_EVENT_TYPE,
            self::NAME_CLICKSTREAM_SETTINGS,
            self::NAME_SCHEDULE,
            self::NAME_TRIGGER,
            self::NAME_RESPONSE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getActionsAllowableValues()
    {
        return [
            self::ACTIONS_CREATE,
            self::ACTIONS_VIEW,
            self::ACTIONS_UPDATE,
            self::ACTIONS_DELETE,
            self::ACTIONS_DOWNLOAD,
            self::ACTIONS_MEMBER_ADD,
            self::ACTIONS_MEMBER_UPDATE,
            self::ACTIONS_MEMBER_REMOVE,
            self::ACTIONS_READ,
            self::ACTIONS_APPLY_PROTECTION,
            self::ACTIONS_REVOKE_PROTECTION,
            self::ACTIONS_UPDATE_RETENTION,
            self::ACTIONS_READ_ALL,
            self::ACTIONS_EXECUTE,
            self::ACTIONS_PUBLISH,
            self::ACTIONS_UNPUBLISH,
            self::ACTIONS_ENABLE,
            self::ACTIONS_DISABLE,
            self::ACTIONS_AUTHORIZE,
            self::ACTIONS_DEAUTHORIZE,
            self::ACTIONS_AUTHENTICATE,
            self::ACTIONS_CHANGE_PASSWORD,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['actions'] = isset($data['actions']) ? $data['actions'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("Document", "Queue", "Recording", "Role", "VoicemailUserPolicy", "WrapupCode", "AccessToken", "OAuthClient", "OAuthClientAuthorization", "AuthOrganization", "AuthUser", "BulkActions", "Feedback", "Topic", "Program", "Segment", "Outcome", "SessionType", "EventType", "ClickstreamSettings", "Schedule", "Trigger", "Response");
        if (!in_array($this->container['name'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'name', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("Document", "Queue", "Recording", "Role", "VoicemailUserPolicy", "WrapupCode", "AccessToken", "OAuthClient", "OAuthClientAuthorization", "AuthOrganization", "AuthUser", "BulkActions", "Feedback", "Topic", "Program", "Segment", "Outcome", "SessionType", "EventType", "ClickstreamSettings", "Schedule", "Trigger", "Response");
        if (!in_array($this->container['name'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name Name of the Entity
     * @return $this
     */
    public function setName($name)
    {
        $allowed_values = array('Document', 'Queue', 'Recording', 'Role', 'VoicemailUserPolicy', 'WrapupCode', 'AccessToken', 'OAuthClient', 'OAuthClientAuthorization', 'AuthOrganization', 'AuthUser', 'BulkActions', 'Feedback', 'Topic', 'Program', 'Segment', 'Outcome', 'SessionType', 'EventType', 'ClickstreamSettings', 'Schedule', 'Trigger', 'Response');
        if (!in_array($name, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'name', must be one of 'Document', 'Queue', 'Recording', 'Role', 'VoicemailUserPolicy', 'WrapupCode', 'AccessToken', 'OAuthClient', 'OAuthClientAuthorization', 'AuthOrganization', 'AuthUser', 'BulkActions', 'Feedback', 'Topic', 'Program', 'Segment', 'Outcome', 'SessionType', 'EventType', 'ClickstreamSettings', 'Schedule', 'Trigger', 'Response'");
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets actions
     * @return string[]
     */
    public function getActions()
    {
        return $this->container['actions'];
    }

    /**
     * Sets actions
     * @param string[] $actions List of Actions
     * @return $this
     */
    public function setActions($actions)
    {
        $allowed_values = array('Create', 'View', 'Update', 'Delete', 'Download', 'MemberAdd', 'MemberUpdate', 'MemberRemove', 'Read', 'ApplyProtection', 'RevokeProtection', 'UpdateRetention', 'ReadAll', 'Execute', 'Publish', 'Unpublish', 'Enable', 'Disable', 'Authorize', 'Deauthorize', 'Authenticate', 'ChangePassword');
        if (!in_array($actions, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'actions', must be one of 'Create', 'View', 'Update', 'Delete', 'Download', 'MemberAdd', 'MemberUpdate', 'MemberRemove', 'Read', 'ApplyProtection', 'RevokeProtection', 'UpdateRetention', 'ReadAll', 'Execute', 'Publish', 'Unpublish', 'Enable', 'Disable', 'Authorize', 'Deauthorize', 'Authenticate', 'ChangePassword'");
        }
        $this->container['actions'] = $actions;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
