<?php

/**
 * CallbackBasic
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * CallbackBasic Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CallbackBasic implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CallbackBasic';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'state' => 'string',
        'id' => 'string',
        'segments' => '\PureCloudSDK\Segment[]',
        'direction' => 'string',
        'held' => 'bool',
        'disconnectType' => 'string',
        'startHoldTime' => '\DateTime',
        'dialerPreview' => '\PureCloudSDK\DialerPreview',
        'voicemail' => '\PureCloudSDK\Voicemail',
        'callbackNumbers' => 'string[]',
        'callbackUserName' => 'string',
        'scriptId' => 'string',
        'externalCampaign' => 'bool',
        'skipEnabled' => 'bool',
        'timeoutSeconds' => 'int',
        'startAlertingTime' => '\DateTime',
        'connectedTime' => '\DateTime',
        'disconnectedTime' => '\DateTime',
        'callbackScheduledTime' => '\DateTime',
        'automatedCallbackConfigId' => 'string',
        'provider' => 'string',
        'peerId' => 'string',
        'wrapup' => '\PureCloudSDK\Wrapup',
        'afterCallWork' => '\PureCloudSDK\AfterCallWork',
        'afterCallWorkRequired' => 'bool'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'state' => 'state',
        'id' => 'id',
        'segments' => 'segments',
        'direction' => 'direction',
        'held' => 'held',
        'disconnectType' => 'disconnectType',
        'startHoldTime' => 'startHoldTime',
        'dialerPreview' => 'dialerPreview',
        'voicemail' => 'voicemail',
        'callbackNumbers' => 'callbackNumbers',
        'callbackUserName' => 'callbackUserName',
        'scriptId' => 'scriptId',
        'externalCampaign' => 'externalCampaign',
        'skipEnabled' => 'skipEnabled',
        'timeoutSeconds' => 'timeoutSeconds',
        'startAlertingTime' => 'startAlertingTime',
        'connectedTime' => 'connectedTime',
        'disconnectedTime' => 'disconnectedTime',
        'callbackScheduledTime' => 'callbackScheduledTime',
        'automatedCallbackConfigId' => 'automatedCallbackConfigId',
        'provider' => 'provider',
        'peerId' => 'peerId',
        'wrapup' => 'wrapup',
        'afterCallWork' => 'afterCallWork',
        'afterCallWorkRequired' => 'afterCallWorkRequired'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'state' => 'setState',
        'id' => 'setId',
        'segments' => 'setSegments',
        'direction' => 'setDirection',
        'held' => 'setHeld',
        'disconnectType' => 'setDisconnectType',
        'startHoldTime' => 'setStartHoldTime',
        'dialerPreview' => 'setDialerPreview',
        'voicemail' => 'setVoicemail',
        'callbackNumbers' => 'setCallbackNumbers',
        'callbackUserName' => 'setCallbackUserName',
        'scriptId' => 'setScriptId',
        'externalCampaign' => 'setExternalCampaign',
        'skipEnabled' => 'setSkipEnabled',
        'timeoutSeconds' => 'setTimeoutSeconds',
        'startAlertingTime' => 'setStartAlertingTime',
        'connectedTime' => 'setConnectedTime',
        'disconnectedTime' => 'setDisconnectedTime',
        'callbackScheduledTime' => 'setCallbackScheduledTime',
        'automatedCallbackConfigId' => 'setAutomatedCallbackConfigId',
        'provider' => 'setProvider',
        'peerId' => 'setPeerId',
        'wrapup' => 'setWrapup',
        'afterCallWork' => 'setAfterCallWork',
        'afterCallWorkRequired' => 'setAfterCallWorkRequired'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'state' => 'getState',
        'id' => 'getId',
        'segments' => 'getSegments',
        'direction' => 'getDirection',
        'held' => 'getHeld',
        'disconnectType' => 'getDisconnectType',
        'startHoldTime' => 'getStartHoldTime',
        'dialerPreview' => 'getDialerPreview',
        'voicemail' => 'getVoicemail',
        'callbackNumbers' => 'getCallbackNumbers',
        'callbackUserName' => 'getCallbackUserName',
        'scriptId' => 'getScriptId',
        'externalCampaign' => 'getExternalCampaign',
        'skipEnabled' => 'getSkipEnabled',
        'timeoutSeconds' => 'getTimeoutSeconds',
        'startAlertingTime' => 'getStartAlertingTime',
        'connectedTime' => 'getConnectedTime',
        'disconnectedTime' => 'getDisconnectedTime',
        'callbackScheduledTime' => 'getCallbackScheduledTime',
        'automatedCallbackConfigId' => 'getAutomatedCallbackConfigId',
        'provider' => 'getProvider',
        'peerId' => 'getPeerId',
        'wrapup' => 'getWrapup',
        'afterCallWork' => 'getAfterCallWork',
        'afterCallWorkRequired' => 'getAfterCallWorkRequired'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const STATE_ALERTING = 'alerting';
    public const STATE_DIALING = 'dialing';
    public const STATE_CONTACTING = 'contacting';
    public const STATE_OFFERING = 'offering';
    public const STATE_CONNECTED = 'connected';
    public const STATE_DISCONNECTED = 'disconnected';
    public const STATE_TERMINATED = 'terminated';
    public const STATE_SCHEDULED = 'scheduled';
    public const STATE_NONE = 'none';
    public const DIRECTION_INBOUND = 'inbound';
    public const DIRECTION_OUTBOUND = 'outbound';
    public const DISCONNECT_TYPE_ENDPOINT = 'endpoint';
    public const DISCONNECT_TYPE_CLIENT = 'client';
    public const DISCONNECT_TYPE_SYSTEM = 'system';
    public const DISCONNECT_TYPE_TIMEOUT = 'timeout';
    public const DISCONNECT_TYPE_TRANSFER = 'transfer';
    public const DISCONNECT_TYPE_TRANSFERCONFERENCE = 'transfer.conference';
    public const DISCONNECT_TYPE_TRANSFERCONSULT = 'transfer.consult';
    public const DISCONNECT_TYPE_TRANSFERFORWARD = 'transfer.forward';
    public const DISCONNECT_TYPE_TRANSFERNOANSWER = 'transfer.noanswer';
    public const DISCONNECT_TYPE_TRANSFERNOTAVAILABLE = 'transfer.notavailable';
    public const DISCONNECT_TYPE_TRANSPORTFAILURE = 'transport.failure';
    public const DISCONNECT_TYPE_ERROR = 'error';
    public const DISCONNECT_TYPE_PEER = 'peer';
    public const DISCONNECT_TYPE_OTHER = 'other';
    public const DISCONNECT_TYPE_SPAM = 'spam';
    public const DISCONNECT_TYPE_UNCALLABLE = 'uncallable';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_ALERTING,
            self::STATE_DIALING,
            self::STATE_CONTACTING,
            self::STATE_OFFERING,
            self::STATE_CONNECTED,
            self::STATE_DISCONNECTED,
            self::STATE_TERMINATED,
            self::STATE_SCHEDULED,
            self::STATE_NONE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDirectionAllowableValues()
    {
        return [
            self::DIRECTION_INBOUND,
            self::DIRECTION_OUTBOUND,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDisconnectTypeAllowableValues()
    {
        return [
            self::DISCONNECT_TYPE_ENDPOINT,
            self::DISCONNECT_TYPE_CLIENT,
            self::DISCONNECT_TYPE_SYSTEM,
            self::DISCONNECT_TYPE_TIMEOUT,
            self::DISCONNECT_TYPE_TRANSFER,
            self::DISCONNECT_TYPE_TRANSFERCONFERENCE,
            self::DISCONNECT_TYPE_TRANSFERCONSULT,
            self::DISCONNECT_TYPE_TRANSFERFORWARD,
            self::DISCONNECT_TYPE_TRANSFERNOANSWER,
            self::DISCONNECT_TYPE_TRANSFERNOTAVAILABLE,
            self::DISCONNECT_TYPE_TRANSPORTFAILURE,
            self::DISCONNECT_TYPE_ERROR,
            self::DISCONNECT_TYPE_PEER,
            self::DISCONNECT_TYPE_OTHER,
            self::DISCONNECT_TYPE_SPAM,
            self::DISCONNECT_TYPE_UNCALLABLE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['segments'] = isset($data['segments']) ? $data['segments'] : null;
        $this->container['direction'] = isset($data['direction']) ? $data['direction'] : null;
        $this->container['held'] = isset($data['held']) ? $data['held'] : null;
        $this->container['disconnectType'] = isset($data['disconnectType']) ? $data['disconnectType'] : null;
        $this->container['startHoldTime'] = isset($data['startHoldTime']) ? $data['startHoldTime'] : null;
        $this->container['dialerPreview'] = isset($data['dialerPreview']) ? $data['dialerPreview'] : null;
        $this->container['voicemail'] = isset($data['voicemail']) ? $data['voicemail'] : null;
        $this->container['callbackNumbers'] = isset($data['callbackNumbers']) ? $data['callbackNumbers'] : null;
        $this->container['callbackUserName'] = isset($data['callbackUserName']) ? $data['callbackUserName'] : null;
        $this->container['scriptId'] = isset($data['scriptId']) ? $data['scriptId'] : null;
        $this->container['externalCampaign'] = isset($data['externalCampaign']) ? $data['externalCampaign'] : null;
        $this->container['skipEnabled'] = isset($data['skipEnabled']) ? $data['skipEnabled'] : null;
        $this->container['timeoutSeconds'] = isset($data['timeoutSeconds']) ? $data['timeoutSeconds'] : null;
        $this->container['startAlertingTime'] = isset($data['startAlertingTime']) ? $data['startAlertingTime'] : null;
        $this->container['connectedTime'] = isset($data['connectedTime']) ? $data['connectedTime'] : null;
        $this->container['disconnectedTime'] = isset($data['disconnectedTime']) ? $data['disconnectedTime'] : null;
        $this->container['callbackScheduledTime'] = isset($data['callbackScheduledTime']) ? $data['callbackScheduledTime'] : null;
        $this->container['automatedCallbackConfigId'] = isset($data['automatedCallbackConfigId']) ? $data['automatedCallbackConfigId'] : null;
        $this->container['provider'] = isset($data['provider']) ? $data['provider'] : null;
        $this->container['peerId'] = isset($data['peerId']) ? $data['peerId'] : null;
        $this->container['wrapup'] = isset($data['wrapup']) ? $data['wrapup'] : null;
        $this->container['afterCallWork'] = isset($data['afterCallWork']) ? $data['afterCallWork'] : null;
        $this->container['afterCallWorkRequired'] = isset($data['afterCallWorkRequired']) ? $data['afterCallWorkRequired'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("alerting", "dialing", "contacting", "offering", "connected", "disconnected", "terminated", "scheduled", "none");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        $allowed_values = array("inbound", "outbound");
        if (!in_array($this->container['direction'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'direction', must be one of #{allowed_values}.";
        }

        $allowed_values = array("endpoint", "client", "system", "timeout", "transfer", "transfer.conference", "transfer.consult", "transfer.forward", "transfer.noanswer", "transfer.notavailable", "transport.failure", "error", "peer", "other", "spam", "uncallable");
        if (!in_array($this->container['disconnectType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'disconnectType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("alerting", "dialing", "contacting", "offering", "connected", "disconnected", "terminated", "scheduled", "none");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("inbound", "outbound");
        if (!in_array($this->container['direction'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("endpoint", "client", "system", "timeout", "transfer", "transfer.conference", "transfer.consult", "transfer.forward", "transfer.noanswer", "transfer.notavailable", "transport.failure", "error", "peer", "other", "spam", "uncallable");
        if (!in_array($this->container['disconnectType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state The connection state of this communication.
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('alerting', 'dialing', 'contacting', 'offering', 'connected', 'disconnected', 'terminated', 'scheduled', 'none');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'alerting', 'dialing', 'contacting', 'offering', 'connected', 'disconnected', 'terminated', 'scheduled', 'none'");
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id A globally unique identifier for this communication.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets segments
     * @return \PureCloudSDK\Segment[]
     */
    public function getSegments()
    {
        return $this->container['segments'];
    }

    /**
     * Sets segments
     * @param \PureCloudSDK\Segment[] $segments The time line of the participant's callback, divided into activity segments.
     * @return $this
     */
    public function setSegments($segments)
    {
        $this->container['segments'] = $segments;

        return $this;
    }

    /**
     * Gets direction
     * @return string
     */
    public function getDirection()
    {
        return $this->container['direction'];
    }

    /**
     * Sets direction
     * @param string $direction The direction of the call
     * @return $this
     */
    public function setDirection($direction)
    {
        $allowed_values = array('inbound', 'outbound');
        if (!in_array($direction, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'direction', must be one of 'inbound', 'outbound'");
        }
        $this->container['direction'] = $direction;

        return $this;
    }

    /**
     * Gets held
     * @return bool
     */
    public function getHeld()
    {
        return $this->container['held'];
    }

    /**
     * Sets held
     * @param bool $held True if this call is held and the person on this side hears silence.
     * @return $this
     */
    public function setHeld($held)
    {
        $this->container['held'] = $held;

        return $this;
    }

    /**
     * Gets disconnectType
     * @return string
     */
    public function getDisconnectType()
    {
        return $this->container['disconnectType'];
    }

    /**
     * Sets disconnectType
     * @param string $disconnectType System defined string indicating what caused the communication to disconnect. Will be null until the communication disconnects.
     * @return $this
     */
    public function setDisconnectType($disconnectType)
    {
        $allowed_values = array('endpoint', 'client', 'system', 'timeout', 'transfer', 'transfer.conference', 'transfer.consult', 'transfer.forward', 'transfer.noanswer', 'transfer.notavailable', 'transport.failure', 'error', 'peer', 'other', 'spam', 'uncallable');
        if (!in_array($disconnectType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'disconnectType', must be one of 'endpoint', 'client', 'system', 'timeout', 'transfer', 'transfer.conference', 'transfer.consult', 'transfer.forward', 'transfer.noanswer', 'transfer.notavailable', 'transport.failure', 'error', 'peer', 'other', 'spam', 'uncallable'");
        }
        $this->container['disconnectType'] = $disconnectType;

        return $this;
    }

    /**
     * Gets startHoldTime
     * @return \DateTime
     */
    public function getStartHoldTime()
    {
        return $this->container['startHoldTime'];
    }

    /**
     * Sets startHoldTime
     * @param \DateTime $startHoldTime The timestamp the callback was placed on hold in the cloud clock if the callback is currently on hold. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setStartHoldTime($startHoldTime)
    {
        $this->container['startHoldTime'] = $startHoldTime;

        return $this;
    }

    /**
     * Gets dialerPreview
     * @return \PureCloudSDK\DialerPreview
     */
    public function getDialerPreview()
    {
        return $this->container['dialerPreview'];
    }

    /**
     * Sets dialerPreview
     * @param \PureCloudSDK\DialerPreview $dialerPreview The preview data to be used when this callback is a Preview.
     * @return $this
     */
    public function setDialerPreview($dialerPreview)
    {
        $this->container['dialerPreview'] = $dialerPreview;

        return $this;
    }

    /**
     * Gets voicemail
     * @return \PureCloudSDK\Voicemail
     */
    public function getVoicemail()
    {
        return $this->container['voicemail'];
    }

    /**
     * Sets voicemail
     * @param \PureCloudSDK\Voicemail $voicemail The voicemail data to be used when this callback is an ACD voicemail.
     * @return $this
     */
    public function setVoicemail($voicemail)
    {
        $this->container['voicemail'] = $voicemail;

        return $this;
    }

    /**
     * Gets callbackNumbers
     * @return string[]
     */
    public function getCallbackNumbers()
    {
        return $this->container['callbackNumbers'];
    }

    /**
     * Sets callbackNumbers
     * @param string[] $callbackNumbers The phone number(s) to use to place the callback.
     * @return $this
     */
    public function setCallbackNumbers($callbackNumbers)
    {
        $this->container['callbackNumbers'] = $callbackNumbers;

        return $this;
    }

    /**
     * Gets callbackUserName
     * @return string
     */
    public function getCallbackUserName()
    {
        return $this->container['callbackUserName'];
    }

    /**
     * Sets callbackUserName
     * @param string $callbackUserName The name of the user requesting a callback.
     * @return $this
     */
    public function setCallbackUserName($callbackUserName)
    {
        $this->container['callbackUserName'] = $callbackUserName;

        return $this;
    }

    /**
     * Gets scriptId
     * @return string
     */
    public function getScriptId()
    {
        return $this->container['scriptId'];
    }

    /**
     * Sets scriptId
     * @param string $scriptId The UUID of the script to use.
     * @return $this
     */
    public function setScriptId($scriptId)
    {
        $this->container['scriptId'] = $scriptId;

        return $this;
    }

    /**
     * Gets externalCampaign
     * @return bool
     */
    public function getExternalCampaign()
    {
        return $this->container['externalCampaign'];
    }

    /**
     * Sets externalCampaign
     * @param bool $externalCampaign True if the call for the callback uses external dialing.
     * @return $this
     */
    public function setExternalCampaign($externalCampaign)
    {
        $this->container['externalCampaign'] = $externalCampaign;

        return $this;
    }

    /**
     * Gets skipEnabled
     * @return bool
     */
    public function getSkipEnabled()
    {
        return $this->container['skipEnabled'];
    }

    /**
     * Sets skipEnabled
     * @param bool $skipEnabled True if the ability to skip a callback should be enabled.
     * @return $this
     */
    public function setSkipEnabled($skipEnabled)
    {
        $this->container['skipEnabled'] = $skipEnabled;

        return $this;
    }

    /**
     * Gets timeoutSeconds
     * @return int
     */
    public function getTimeoutSeconds()
    {
        return $this->container['timeoutSeconds'];
    }

    /**
     * Sets timeoutSeconds
     * @param int $timeoutSeconds The number of seconds before the system automatically places a call for a callback.  0 means the automatic placement is disabled.
     * @return $this
     */
    public function setTimeoutSeconds($timeoutSeconds)
    {
        $this->container['timeoutSeconds'] = $timeoutSeconds;

        return $this;
    }

    /**
     * Gets startAlertingTime
     * @return \DateTime
     */
    public function getStartAlertingTime()
    {
        return $this->container['startAlertingTime'];
    }

    /**
     * Sets startAlertingTime
     * @param \DateTime $startAlertingTime The timestamp the communication has when it is first put into an alerting state. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setStartAlertingTime($startAlertingTime)
    {
        $this->container['startAlertingTime'] = $startAlertingTime;

        return $this;
    }

    /**
     * Gets connectedTime
     * @return \DateTime
     */
    public function getConnectedTime()
    {
        return $this->container['connectedTime'];
    }

    /**
     * Sets connectedTime
     * @param \DateTime $connectedTime The timestamp when this communication was connected in the cloud clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setConnectedTime($connectedTime)
    {
        $this->container['connectedTime'] = $connectedTime;

        return $this;
    }

    /**
     * Gets disconnectedTime
     * @return \DateTime
     */
    public function getDisconnectedTime()
    {
        return $this->container['disconnectedTime'];
    }

    /**
     * Sets disconnectedTime
     * @param \DateTime $disconnectedTime The timestamp when this communication disconnected from the conversation in the provider clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDisconnectedTime($disconnectedTime)
    {
        $this->container['disconnectedTime'] = $disconnectedTime;

        return $this;
    }

    /**
     * Gets callbackScheduledTime
     * @return \DateTime
     */
    public function getCallbackScheduledTime()
    {
        return $this->container['callbackScheduledTime'];
    }

    /**
     * Sets callbackScheduledTime
     * @param \DateTime $callbackScheduledTime The timestamp when this communication is scheduled in the provider clock. If this value is missing it indicates the callback will be placed immediately. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setCallbackScheduledTime($callbackScheduledTime)
    {
        $this->container['callbackScheduledTime'] = $callbackScheduledTime;

        return $this;
    }

    /**
     * Gets automatedCallbackConfigId
     * @return string
     */
    public function getAutomatedCallbackConfigId()
    {
        return $this->container['automatedCallbackConfigId'];
    }

    /**
     * Sets automatedCallbackConfigId
     * @param string $automatedCallbackConfigId The id of the config for automatically placing the callback (and handling the disposition). If null, the callback will not be placed automatically but routed to an agent as per normal.
     * @return $this
     */
    public function setAutomatedCallbackConfigId($automatedCallbackConfigId)
    {
        $this->container['automatedCallbackConfigId'] = $automatedCallbackConfigId;

        return $this;
    }

    /**
     * Gets provider
     * @return string
     */
    public function getProvider()
    {
        return $this->container['provider'];
    }

    /**
     * Sets provider
     * @param string $provider The source provider for the callback.
     * @return $this
     */
    public function setProvider($provider)
    {
        $this->container['provider'] = $provider;

        return $this;
    }

    /**
     * Gets peerId
     * @return string
     */
    public function getPeerId()
    {
        return $this->container['peerId'];
    }

    /**
     * Sets peerId
     * @param string $peerId The id of the peer communication corresponding to a matching leg for this communication.
     * @return $this
     */
    public function setPeerId($peerId)
    {
        $this->container['peerId'] = $peerId;

        return $this;
    }

    /**
     * Gets wrapup
     * @return \PureCloudSDK\Wrapup
     */
    public function getWrapup()
    {
        return $this->container['wrapup'];
    }

    /**
     * Sets wrapup
     * @param \PureCloudSDK\Wrapup $wrapup Call wrap up or disposition data.
     * @return $this
     */
    public function setWrapup($wrapup)
    {
        $this->container['wrapup'] = $wrapup;

        return $this;
    }

    /**
     * Gets afterCallWork
     * @return \PureCloudSDK\AfterCallWork
     */
    public function getAfterCallWork()
    {
        return $this->container['afterCallWork'];
    }

    /**
     * Sets afterCallWork
     * @param \PureCloudSDK\AfterCallWork $afterCallWork After-call work for the communication.
     * @return $this
     */
    public function setAfterCallWork($afterCallWork)
    {
        $this->container['afterCallWork'] = $afterCallWork;

        return $this;
    }

    /**
     * Gets afterCallWorkRequired
     * @return bool
     */
    public function getAfterCallWorkRequired()
    {
        return $this->container['afterCallWorkRequired'];
    }

    /**
     * Sets afterCallWorkRequired
     * @param bool $afterCallWorkRequired Indicates if after-call work is required for a communication. Only used when the ACW Setting is Agent Requested.
     * @return $this
     */
    public function setAfterCallWorkRequired($afterCallWorkRequired)
    {
        $this->container['afterCallWorkRequired'] = $afterCallWorkRequired;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
