<?php

/**
 * ContentActions
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * ContentActions Class Doc Comment
 *
 * @category    Class */
 // @description User actions available on the content. All actions are optional and all actions are executed simultaneously.
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ContentActions implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ContentActions';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'url' => 'string',
        'urlTarget' => 'string',
        'textback' => 'string',
        'commandName' => 'string',
        'context' => 'map[string,object]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'url' => 'url',
        'urlTarget' => 'urlTarget',
        'textback' => 'textback',
        'commandName' => 'commandName',
        'context' => 'context'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'url' => 'setUrl',
        'urlTarget' => 'setUrlTarget',
        'textback' => 'setTextback',
        'commandName' => 'setCommandName',
        'context' => 'setContext'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'url' => 'getUrl',
        'urlTarget' => 'getUrlTarget',
        'textback' => 'getTextback',
        'commandName' => 'getCommandName',
        'context' => 'getContext'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['url'] = isset($data['url']) ? $data['url'] : null;
        $this->container['urlTarget'] = isset($data['urlTarget']) ? $data['urlTarget'] : null;
        $this->container['textback'] = isset($data['textback']) ? $data['textback'] : null;
        $this->container['commandName'] = isset($data['commandName']) ? $data['commandName'] : null;
        $this->container['context'] = isset($data['context']) ? $data['context'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets url
     * @return string
     */
    public function getUrl()
    {
        return $this->container['url'];
    }

    /**
     * Sets url
     * @param string $url A URL for a web page to redirect the user to
     * @return $this
     */
    public function setUrl($url)
    {
        $this->container['url'] = $url;

        return $this;
    }

    /**
     * Gets urlTarget
     * @return string
     */
    public function getUrlTarget()
    {
        return $this->container['urlTarget'];
    }

    /**
     * Sets urlTarget
     * @param string $urlTarget The target window or tab within the URL's web page. If empty will open a blank page or tab.
     * @return $this
     */
    public function setUrlTarget($urlTarget)
    {
        $this->container['urlTarget'] = $urlTarget;

        return $this;
    }

    /**
     * Gets textback
     * @return string
     */
    public function getTextback()
    {
        return $this->container['textback'];
    }

    /**
     * Sets textback
     * @param string $textback Text to be sent back in reply when a list item is selected
     * @return $this
     */
    public function setTextback($textback)
    {
        $this->container['textback'] = $textback;

        return $this;
    }

    /**
     * Gets commandName
     * @return string
     */
    public function getCommandName()
    {
        return $this->container['commandName'];
    }

    /**
     * Sets commandName
     * @param string $commandName Execute an organization's specific command
     * @return $this
     */
    public function setCommandName($commandName)
    {
        $this->container['commandName'] = $commandName;

        return $this;
    }

    /**
     * Gets context
     * @return map[string,object]
     */
    public function getContext()
    {
        return $this->container['context'];
    }

    /**
     * Sets context
     * @param map[string,object] $context Additional context for the command
     * @return $this
     */
    public function setContext($context)
    {
        $this->container['context'] = $context;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
