<?php

/**
 * CreateManagementUnitSettings
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * CreateManagementUnitSettings Class Doc Comment
 *
 * @category    Class */
 // @description Management Unit Settings
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CreateManagementUnitSettings implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CreateManagementUnitSettings';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'adherence' => '\PureCloudSDK\AdherenceSettings',
        'shortTermForecasting' => '\PureCloudSDK\ShortTermForecastingSettings',
        'timeOff' => '\PureCloudSDK\TimeOffRequestSettings',
        'scheduling' => '\PureCloudSDK\SchedulingSettings',
        'shiftTrading' => '\PureCloudSDK\ShiftTradeSettings'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'adherence' => 'adherence',
        'shortTermForecasting' => 'shortTermForecasting',
        'timeOff' => 'timeOff',
        'scheduling' => 'scheduling',
        'shiftTrading' => 'shiftTrading'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'adherence' => 'setAdherence',
        'shortTermForecasting' => 'setShortTermForecasting',
        'timeOff' => 'setTimeOff',
        'scheduling' => 'setScheduling',
        'shiftTrading' => 'setShiftTrading'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'adherence' => 'getAdherence',
        'shortTermForecasting' => 'getShortTermForecasting',
        'timeOff' => 'getTimeOff',
        'scheduling' => 'getScheduling',
        'shiftTrading' => 'getShiftTrading'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['adherence'] = isset($data['adherence']) ? $data['adherence'] : null;
        $this->container['shortTermForecasting'] = isset($data['shortTermForecasting']) ? $data['shortTermForecasting'] : null;
        $this->container['timeOff'] = isset($data['timeOff']) ? $data['timeOff'] : null;
        $this->container['scheduling'] = isset($data['scheduling']) ? $data['scheduling'] : null;
        $this->container['shiftTrading'] = isset($data['shiftTrading']) ? $data['shiftTrading'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets adherence
     * @return \PureCloudSDK\AdherenceSettings
     */
    public function getAdherence()
    {
        return $this->container['adherence'];
    }

    /**
     * Sets adherence
     * @param \PureCloudSDK\AdherenceSettings $adherence Adherence settings for this management unit
     * @return $this
     */
    public function setAdherence($adherence)
    {
        $this->container['adherence'] = $adherence;

        return $this;
    }

    /**
     * Gets shortTermForecasting
     * @return \PureCloudSDK\ShortTermForecastingSettings
     */
    public function getShortTermForecasting()
    {
        return $this->container['shortTermForecasting'];
    }

    /**
     * Sets shortTermForecasting
     * @param \PureCloudSDK\ShortTermForecastingSettings $shortTermForecasting Short term forecasting settings for this management unit
     * @return $this
     */
    public function setShortTermForecasting($shortTermForecasting)
    {
        $this->container['shortTermForecasting'] = $shortTermForecasting;

        return $this;
    }

    /**
     * Gets timeOff
     * @return \PureCloudSDK\TimeOffRequestSettings
     */
    public function getTimeOff()
    {
        return $this->container['timeOff'];
    }

    /**
     * Sets timeOff
     * @param \PureCloudSDK\TimeOffRequestSettings $timeOff Time off request settings for this management unit
     * @return $this
     */
    public function setTimeOff($timeOff)
    {
        $this->container['timeOff'] = $timeOff;

        return $this;
    }

    /**
     * Gets scheduling
     * @return \PureCloudSDK\SchedulingSettings
     */
    public function getScheduling()
    {
        return $this->container['scheduling'];
    }

    /**
     * Sets scheduling
     * @param \PureCloudSDK\SchedulingSettings $scheduling Scheduling settings for this management unit
     * @return $this
     */
    public function setScheduling($scheduling)
    {
        $this->container['scheduling'] = $scheduling;

        return $this;
    }

    /**
     * Gets shiftTrading
     * @return \PureCloudSDK\ShiftTradeSettings
     */
    public function getShiftTrading()
    {
        return $this->container['shiftTrading'];
    }

    /**
     * Sets shiftTrading
     * @param \PureCloudSDK\ShiftTradeSettings $shiftTrading Shift trade settings for this management unit
     * @return $this
     */
    public function setShiftTrading($shiftTrading)
    {
        $this->container['shiftTrading'] = $shiftTrading;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
