<?php

/**
 * ExternalOrganizationTrustorLink
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * ExternalOrganizationTrustorLink Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ExternalOrganizationTrustorLink implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ExternalOrganizationTrustorLink';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'externalOrganizationId' => 'string',
        'trustorOrgId' => 'string',
        'dateCreated' => '\DateTime',
        'externalOrganizationUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'externalOrganizationId' => 'externalOrganizationId',
        'trustorOrgId' => 'trustorOrgId',
        'dateCreated' => 'dateCreated',
        'externalOrganizationUri' => 'externalOrganizationUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'externalOrganizationId' => 'setExternalOrganizationId',
        'trustorOrgId' => 'setTrustorOrgId',
        'dateCreated' => 'setDateCreated',
        'externalOrganizationUri' => 'setExternalOrganizationUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'externalOrganizationId' => 'getExternalOrganizationId',
        'trustorOrgId' => 'getTrustorOrgId',
        'dateCreated' => 'getDateCreated',
        'externalOrganizationUri' => 'getExternalOrganizationUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['externalOrganizationId'] = isset($data['externalOrganizationId']) ? $data['externalOrganizationId'] : null;
        $this->container['trustorOrgId'] = isset($data['trustorOrgId']) ? $data['trustorOrgId'] : null;
        $this->container['dateCreated'] = isset($data['dateCreated']) ? $data['dateCreated'] : null;
        $this->container['externalOrganizationUri'] = isset($data['externalOrganizationUri']) ? $data['externalOrganizationUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets externalOrganizationId
     * @return string
     */
    public function getExternalOrganizationId()
    {
        return $this->container['externalOrganizationId'];
    }

    /**
     * Sets externalOrganizationId
     * @param string $externalOrganizationId The id of a PureCloud External Organization entity in the External Contacts system that will be used to represent the trustor org
     * @return $this
     */
    public function setExternalOrganizationId($externalOrganizationId)
    {
        $this->container['externalOrganizationId'] = $externalOrganizationId;

        return $this;
    }

    /**
     * Gets trustorOrgId
     * @return string
     */
    public function getTrustorOrgId()
    {
        return $this->container['trustorOrgId'];
    }

    /**
     * Sets trustorOrgId
     * @param string $trustorOrgId The id of a PureCloud organization that has granted trust to this PureCloud organization
     * @return $this
     */
    public function setTrustorOrgId($trustorOrgId)
    {
        $this->container['trustorOrgId'] = $trustorOrgId;

        return $this;
    }

    /**
     * Gets dateCreated
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['dateCreated'];
    }

    /**
     * Sets dateCreated
     * @param \DateTime $dateCreated Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($dateCreated)
    {
        $this->container['dateCreated'] = $dateCreated;

        return $this;
    }

    /**
     * Gets externalOrganizationUri
     * @return string
     */
    public function getExternalOrganizationUri()
    {
        return $this->container['externalOrganizationUri'];
    }

    /**
     * Sets externalOrganizationUri
     * @param string $externalOrganizationUri The URI for the External Organization that is linked to the trustor org
     * @return $this
     */
    public function setExternalOrganizationUri($externalOrganizationUri)
    {
        $this->container['externalOrganizationUri'] = $externalOrganizationUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
