<?php

/**
 * GDPRRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * GDPRRequest Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class GDPRRequest implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'GDPRRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'createdBy' => '\PureCloudSDK\DomainEntityRef',
        'replacementTerms' => '\PureCloudSDK\ReplacementTerm[]',
        'requestType' => 'string',
        'createdDate' => '\DateTime',
        'status' => 'string',
        'subject' => '\PureCloudSDK\GDPRSubject',
        'resultsUrl' => 'string',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'createdBy' => 'createdBy',
        'replacementTerms' => 'replacementTerms',
        'requestType' => 'requestType',
        'createdDate' => 'createdDate',
        'status' => 'status',
        'subject' => 'subject',
        'resultsUrl' => 'resultsUrl',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'createdBy' => 'setCreatedBy',
        'replacementTerms' => 'setReplacementTerms',
        'requestType' => 'setRequestType',
        'createdDate' => 'setCreatedDate',
        'status' => 'setStatus',
        'subject' => 'setSubject',
        'resultsUrl' => 'setResultsUrl',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'createdBy' => 'getCreatedBy',
        'replacementTerms' => 'getReplacementTerms',
        'requestType' => 'getRequestType',
        'createdDate' => 'getCreatedDate',
        'status' => 'getStatus',
        'subject' => 'getSubject',
        'resultsUrl' => 'getResultsUrl',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const REQUEST_TYPE_EXPORT = 'GDPR_EXPORT';
    public const REQUEST_TYPE_UPDATE = 'GDPR_UPDATE';
    public const REQUEST_TYPE_DELETE = 'GDPR_DELETE';
    public const STATUS_INITIATED = 'INITIATED';
    public const STATUS_SEARCHING = 'SEARCHING';
    public const STATUS_UPDATING = 'UPDATING';
    public const STATUS_DELETING = 'DELETING';
    public const STATUS_COMPLETED = 'COMPLETED';
    public const STATUS_ERROR = 'ERROR';
    public const STATUS_FINALIZING = 'FINALIZING';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getRequestTypeAllowableValues()
    {
        return [
            self::REQUEST_TYPE_EXPORT,
            self::REQUEST_TYPE_UPDATE,
            self::REQUEST_TYPE_DELETE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_INITIATED,
            self::STATUS_SEARCHING,
            self::STATUS_UPDATING,
            self::STATUS_DELETING,
            self::STATUS_COMPLETED,
            self::STATUS_ERROR,
            self::STATUS_FINALIZING,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['createdBy'] = isset($data['createdBy']) ? $data['createdBy'] : null;
        $this->container['replacementTerms'] = isset($data['replacementTerms']) ? $data['replacementTerms'] : null;
        $this->container['requestType'] = isset($data['requestType']) ? $data['requestType'] : null;
        $this->container['createdDate'] = isset($data['createdDate']) ? $data['createdDate'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['subject'] = isset($data['subject']) ? $data['subject'] : null;
        $this->container['resultsUrl'] = isset($data['resultsUrl']) ? $data['resultsUrl'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['createdBy'] === null) {
            $invalid_properties[] = "'createdBy' can't be null";
        }
        if ($this->container['requestType'] === null) {
            $invalid_properties[] = "'requestType' can't be null";
        }
        $allowed_values = array("GDPR_EXPORT", "GDPR_UPDATE", "GDPR_DELETE");
        if (!in_array($this->container['requestType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'requestType', must be one of #{allowed_values}.";
        }

        if ($this->container['createdDate'] === null) {
            $invalid_properties[] = "'createdDate' can't be null";
        }
        if ($this->container['status'] === null) {
            $invalid_properties[] = "'status' can't be null";
        }
        $allowed_values = array("INITIATED", "SEARCHING", "UPDATING", "DELETING", "COMPLETED", "ERROR", "FINALIZING");
        if (!in_array($this->container['status'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'status', must be one of #{allowed_values}.";
        }

        if ($this->container['subject'] === null) {
            $invalid_properties[] = "'subject' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['createdBy'] === null) {
            return false;
        }
        if ($this->container['requestType'] === null) {
            return false;
        }
        $allowed_values = array("GDPR_EXPORT", "GDPR_UPDATE", "GDPR_DELETE");
        if (!in_array($this->container['requestType'], $allowed_values)) {
            return false;
        }
        if ($this->container['createdDate'] === null) {
            return false;
        }
        if ($this->container['status'] === null) {
            return false;
        }
        $allowed_values = array("INITIATED", "SEARCHING", "UPDATING", "DELETING", "COMPLETED", "ERROR", "FINALIZING");
        if (!in_array($this->container['status'], $allowed_values)) {
            return false;
        }
        if ($this->container['subject'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets createdBy
     * @return \PureCloudSDK\DomainEntityRef
     */
    public function getCreatedBy()
    {
        return $this->container['createdBy'];
    }

    /**
     * Sets createdBy
     * @param \PureCloudSDK\DomainEntityRef $createdBy The user that created this request
     * @return $this
     */
    public function setCreatedBy($createdBy)
    {
        $this->container['createdBy'] = $createdBy;

        return $this;
    }

    /**
     * Gets replacementTerms
     * @return \PureCloudSDK\ReplacementTerm[]
     */
    public function getReplacementTerms()
    {
        return $this->container['replacementTerms'];
    }

    /**
     * Sets replacementTerms
     * @param \PureCloudSDK\ReplacementTerm[] $replacementTerms The replacement terms for the provided search terms, in the case of a GDPR_UPDATE request
     * @return $this
     */
    public function setReplacementTerms($replacementTerms)
    {
        $this->container['replacementTerms'] = $replacementTerms;

        return $this;
    }

    /**
     * Gets requestType
     * @return string
     */
    public function getRequestType()
    {
        return $this->container['requestType'];
    }

    /**
     * Sets requestType
     * @param string $requestType The type of GDPR request
     * @return $this
     */
    public function setRequestType($requestType)
    {
        $allowed_values = array('GDPR_EXPORT', 'GDPR_UPDATE', 'GDPR_DELETE');
        if (!in_array($requestType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'requestType', must be one of 'GDPR_EXPORT', 'GDPR_UPDATE', 'GDPR_DELETE'");
        }
        $this->container['requestType'] = $requestType;

        return $this;
    }

    /**
     * Gets createdDate
     * @return \DateTime
     */
    public function getCreatedDate()
    {
        return $this->container['createdDate'];
    }

    /**
     * Sets createdDate
     * @param \DateTime $createdDate When the request was submitted. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setCreatedDate($createdDate)
    {
        $this->container['createdDate'] = $createdDate;

        return $this;
    }

    /**
     * Gets status
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     * @param string $status The status of the request
     * @return $this
     */
    public function setStatus($status)
    {
        $allowed_values = array('INITIATED', 'SEARCHING', 'UPDATING', 'DELETING', 'COMPLETED', 'ERROR', 'FINALIZING');
        if (!in_array($status, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'status', must be one of 'INITIATED', 'SEARCHING', 'UPDATING', 'DELETING', 'COMPLETED', 'ERROR', 'FINALIZING'");
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets subject
     * @return \PureCloudSDK\GDPRSubject
     */
    public function getSubject()
    {
        return $this->container['subject'];
    }

    /**
     * Sets subject
     * @param \PureCloudSDK\GDPRSubject $subject The subject of the GDPR request
     * @return $this
     */
    public function setSubject($subject)
    {
        $this->container['subject'] = $subject;

        return $this;
    }

    /**
     * Gets resultsUrl
     * @return string
     */
    public function getResultsUrl()
    {
        return $this->container['resultsUrl'];
    }

    /**
     * Sets resultsUrl
     * @param string $resultsUrl The location where the results of the request can be retrieved
     * @return $this
     */
    public function setResultsUrl($resultsUrl)
    {
        $this->container['resultsUrl'] = $resultsUrl;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
