<?php

/**
 * HomerRecord
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * HomerRecord Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class HomerRecord implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'HomerRecord';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'date' => '\DateTime',
        'milliTs' => 'string',
        'microTs' => 'string',
        'method' => 'string',
        'replyReason' => 'string',
        'ruri' => 'string',
        'ruriUser' => 'string',
        'ruriDomain' => 'string',
        'fromUser' => 'string',
        'fromDomain' => 'string',
        'fromTag' => 'string',
        'toUser' => 'string',
        'toDomain' => 'string',
        'toTag' => 'string',
        'pidUser' => 'string',
        'contactUser' => 'string',
        'authUser' => 'string',
        'callid' => 'string',
        'callidAleg' => 'string',
        'via1' => 'string',
        'via1Branch' => 'string',
        'cseq' => 'string',
        'diversion' => 'string',
        'reason' => 'string',
        'contentType' => 'string',
        'auth' => 'string',
        'userAgent' => 'string',
        'sourceIp' => 'string',
        'sourcePort' => 'string',
        'destinationIp' => 'string',
        'destinationPort' => 'string',
        'contactIp' => 'string',
        'contactPort' => 'string',
        'originatorIp' => 'string',
        'originatorPort' => 'string',
        'correlationId' => 'string',
        'proto' => 'string',
        'family' => 'string',
        'rtpStat' => 'string',
        'type' => 'string',
        'node' => 'string',
        'trans' => 'string',
        'dbnode' => 'string',
        'msg' => 'string',
        'sourceAlias' => 'string',
        'destinationAlias' => 'string',
        'conversationId' => 'string',
        'participantId' => 'string',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'date' => 'date',
        'milliTs' => 'milliTs',
        'microTs' => 'microTs',
        'method' => 'method',
        'replyReason' => 'replyReason',
        'ruri' => 'ruri',
        'ruriUser' => 'ruriUser',
        'ruriDomain' => 'ruriDomain',
        'fromUser' => 'fromUser',
        'fromDomain' => 'fromDomain',
        'fromTag' => 'fromTag',
        'toUser' => 'toUser',
        'toDomain' => 'toDomain',
        'toTag' => 'toTag',
        'pidUser' => 'pidUser',
        'contactUser' => 'contactUser',
        'authUser' => 'authUser',
        'callid' => 'callid',
        'callidAleg' => 'callidAleg',
        'via1' => 'via1',
        'via1Branch' => 'via1Branch',
        'cseq' => 'cseq',
        'diversion' => 'diversion',
        'reason' => 'reason',
        'contentType' => 'contentType',
        'auth' => 'auth',
        'userAgent' => 'userAgent',
        'sourceIp' => 'sourceIp',
        'sourcePort' => 'sourcePort',
        'destinationIp' => 'destinationIp',
        'destinationPort' => 'destinationPort',
        'contactIp' => 'contactIp',
        'contactPort' => 'contactPort',
        'originatorIp' => 'originatorIp',
        'originatorPort' => 'originatorPort',
        'correlationId' => 'correlationId',
        'proto' => 'proto',
        'family' => 'family',
        'rtpStat' => 'rtpStat',
        'type' => 'type',
        'node' => 'node',
        'trans' => 'trans',
        'dbnode' => 'dbnode',
        'msg' => 'msg',
        'sourceAlias' => 'sourceAlias',
        'destinationAlias' => 'destinationAlias',
        'conversationId' => 'conversationId',
        'participantId' => 'participantId',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'date' => 'setDate',
        'milliTs' => 'setMilliTs',
        'microTs' => 'setMicroTs',
        'method' => 'setMethod',
        'replyReason' => 'setReplyReason',
        'ruri' => 'setRuri',
        'ruriUser' => 'setRuriUser',
        'ruriDomain' => 'setRuriDomain',
        'fromUser' => 'setFromUser',
        'fromDomain' => 'setFromDomain',
        'fromTag' => 'setFromTag',
        'toUser' => 'setToUser',
        'toDomain' => 'setToDomain',
        'toTag' => 'setToTag',
        'pidUser' => 'setPidUser',
        'contactUser' => 'setContactUser',
        'authUser' => 'setAuthUser',
        'callid' => 'setCallid',
        'callidAleg' => 'setCallidAleg',
        'via1' => 'setVia1',
        'via1Branch' => 'setVia1Branch',
        'cseq' => 'setCseq',
        'diversion' => 'setDiversion',
        'reason' => 'setReason',
        'contentType' => 'setContentType',
        'auth' => 'setAuth',
        'userAgent' => 'setUserAgent',
        'sourceIp' => 'setSourceIp',
        'sourcePort' => 'setSourcePort',
        'destinationIp' => 'setDestinationIp',
        'destinationPort' => 'setDestinationPort',
        'contactIp' => 'setContactIp',
        'contactPort' => 'setContactPort',
        'originatorIp' => 'setOriginatorIp',
        'originatorPort' => 'setOriginatorPort',
        'correlationId' => 'setCorrelationId',
        'proto' => 'setProto',
        'family' => 'setFamily',
        'rtpStat' => 'setRtpStat',
        'type' => 'setType',
        'node' => 'setNode',
        'trans' => 'setTrans',
        'dbnode' => 'setDbnode',
        'msg' => 'setMsg',
        'sourceAlias' => 'setSourceAlias',
        'destinationAlias' => 'setDestinationAlias',
        'conversationId' => 'setConversationId',
        'participantId' => 'setParticipantId',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'date' => 'getDate',
        'milliTs' => 'getMilliTs',
        'microTs' => 'getMicroTs',
        'method' => 'getMethod',
        'replyReason' => 'getReplyReason',
        'ruri' => 'getRuri',
        'ruriUser' => 'getRuriUser',
        'ruriDomain' => 'getRuriDomain',
        'fromUser' => 'getFromUser',
        'fromDomain' => 'getFromDomain',
        'fromTag' => 'getFromTag',
        'toUser' => 'getToUser',
        'toDomain' => 'getToDomain',
        'toTag' => 'getToTag',
        'pidUser' => 'getPidUser',
        'contactUser' => 'getContactUser',
        'authUser' => 'getAuthUser',
        'callid' => 'getCallid',
        'callidAleg' => 'getCallidAleg',
        'via1' => 'getVia1',
        'via1Branch' => 'getVia1Branch',
        'cseq' => 'getCseq',
        'diversion' => 'getDiversion',
        'reason' => 'getReason',
        'contentType' => 'getContentType',
        'auth' => 'getAuth',
        'userAgent' => 'getUserAgent',
        'sourceIp' => 'getSourceIp',
        'sourcePort' => 'getSourcePort',
        'destinationIp' => 'getDestinationIp',
        'destinationPort' => 'getDestinationPort',
        'contactIp' => 'getContactIp',
        'contactPort' => 'getContactPort',
        'originatorIp' => 'getOriginatorIp',
        'originatorPort' => 'getOriginatorPort',
        'correlationId' => 'getCorrelationId',
        'proto' => 'getProto',
        'family' => 'getFamily',
        'rtpStat' => 'getRtpStat',
        'type' => 'getType',
        'node' => 'getNode',
        'trans' => 'getTrans',
        'dbnode' => 'getDbnode',
        'msg' => 'getMsg',
        'sourceAlias' => 'getSourceAlias',
        'destinationAlias' => 'getDestinationAlias',
        'conversationId' => 'getConversationId',
        'participantId' => 'getParticipantId',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['date'] = isset($data['date']) ? $data['date'] : null;
        $this->container['milliTs'] = isset($data['milliTs']) ? $data['milliTs'] : null;
        $this->container['microTs'] = isset($data['microTs']) ? $data['microTs'] : null;
        $this->container['method'] = isset($data['method']) ? $data['method'] : null;
        $this->container['replyReason'] = isset($data['replyReason']) ? $data['replyReason'] : null;
        $this->container['ruri'] = isset($data['ruri']) ? $data['ruri'] : null;
        $this->container['ruriUser'] = isset($data['ruriUser']) ? $data['ruriUser'] : null;
        $this->container['ruriDomain'] = isset($data['ruriDomain']) ? $data['ruriDomain'] : null;
        $this->container['fromUser'] = isset($data['fromUser']) ? $data['fromUser'] : null;
        $this->container['fromDomain'] = isset($data['fromDomain']) ? $data['fromDomain'] : null;
        $this->container['fromTag'] = isset($data['fromTag']) ? $data['fromTag'] : null;
        $this->container['toUser'] = isset($data['toUser']) ? $data['toUser'] : null;
        $this->container['toDomain'] = isset($data['toDomain']) ? $data['toDomain'] : null;
        $this->container['toTag'] = isset($data['toTag']) ? $data['toTag'] : null;
        $this->container['pidUser'] = isset($data['pidUser']) ? $data['pidUser'] : null;
        $this->container['contactUser'] = isset($data['contactUser']) ? $data['contactUser'] : null;
        $this->container['authUser'] = isset($data['authUser']) ? $data['authUser'] : null;
        $this->container['callid'] = isset($data['callid']) ? $data['callid'] : null;
        $this->container['callidAleg'] = isset($data['callidAleg']) ? $data['callidAleg'] : null;
        $this->container['via1'] = isset($data['via1']) ? $data['via1'] : null;
        $this->container['via1Branch'] = isset($data['via1Branch']) ? $data['via1Branch'] : null;
        $this->container['cseq'] = isset($data['cseq']) ? $data['cseq'] : null;
        $this->container['diversion'] = isset($data['diversion']) ? $data['diversion'] : null;
        $this->container['reason'] = isset($data['reason']) ? $data['reason'] : null;
        $this->container['contentType'] = isset($data['contentType']) ? $data['contentType'] : null;
        $this->container['auth'] = isset($data['auth']) ? $data['auth'] : null;
        $this->container['userAgent'] = isset($data['userAgent']) ? $data['userAgent'] : null;
        $this->container['sourceIp'] = isset($data['sourceIp']) ? $data['sourceIp'] : null;
        $this->container['sourcePort'] = isset($data['sourcePort']) ? $data['sourcePort'] : null;
        $this->container['destinationIp'] = isset($data['destinationIp']) ? $data['destinationIp'] : null;
        $this->container['destinationPort'] = isset($data['destinationPort']) ? $data['destinationPort'] : null;
        $this->container['contactIp'] = isset($data['contactIp']) ? $data['contactIp'] : null;
        $this->container['contactPort'] = isset($data['contactPort']) ? $data['contactPort'] : null;
        $this->container['originatorIp'] = isset($data['originatorIp']) ? $data['originatorIp'] : null;
        $this->container['originatorPort'] = isset($data['originatorPort']) ? $data['originatorPort'] : null;
        $this->container['correlationId'] = isset($data['correlationId']) ? $data['correlationId'] : null;
        $this->container['proto'] = isset($data['proto']) ? $data['proto'] : null;
        $this->container['family'] = isset($data['family']) ? $data['family'] : null;
        $this->container['rtpStat'] = isset($data['rtpStat']) ? $data['rtpStat'] : null;
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['node'] = isset($data['node']) ? $data['node'] : null;
        $this->container['trans'] = isset($data['trans']) ? $data['trans'] : null;
        $this->container['dbnode'] = isset($data['dbnode']) ? $data['dbnode'] : null;
        $this->container['msg'] = isset($data['msg']) ? $data['msg'] : null;
        $this->container['sourceAlias'] = isset($data['sourceAlias']) ? $data['sourceAlias'] : null;
        $this->container['destinationAlias'] = isset($data['destinationAlias']) ? $data['destinationAlias'] : null;
        $this->container['conversationId'] = isset($data['conversationId']) ? $data['conversationId'] : null;
        $this->container['participantId'] = isset($data['participantId']) ? $data['participantId'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets date
     * @return \DateTime
     */
    public function getDate()
    {
        return $this->container['date'];
    }

    /**
     * Sets date
     * @param \DateTime $date metadata associated to the SIP calls. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDate($date)
    {
        $this->container['date'] = $date;

        return $this;
    }

    /**
     * Gets milliTs
     * @return string
     */
    public function getMilliTs()
    {
        return $this->container['milliTs'];
    }

    /**
     * Sets milliTs
     * @param string $milliTs metadata associated to the SIP calls
     * @return $this
     */
    public function setMilliTs($milliTs)
    {
        $this->container['milliTs'] = $milliTs;

        return $this;
    }

    /**
     * Gets microTs
     * @return string
     */
    public function getMicroTs()
    {
        return $this->container['microTs'];
    }

    /**
     * Sets microTs
     * @param string $microTs metadata associated to the SIP calls
     * @return $this
     */
    public function setMicroTs($microTs)
    {
        $this->container['microTs'] = $microTs;

        return $this;
    }

    /**
     * Gets method
     * @return string
     */
    public function getMethod()
    {
        return $this->container['method'];
    }

    /**
     * Sets method
     * @param string $method metadata associated to the SIP calls
     * @return $this
     */
    public function setMethod($method)
    {
        $this->container['method'] = $method;

        return $this;
    }

    /**
     * Gets replyReason
     * @return string
     */
    public function getReplyReason()
    {
        return $this->container['replyReason'];
    }

    /**
     * Sets replyReason
     * @param string $replyReason metadata associated to the SIP calls
     * @return $this
     */
    public function setReplyReason($replyReason)
    {
        $this->container['replyReason'] = $replyReason;

        return $this;
    }

    /**
     * Gets ruri
     * @return string
     */
    public function getRuri()
    {
        return $this->container['ruri'];
    }

    /**
     * Sets ruri
     * @param string $ruri metadata associated to the SIP calls
     * @return $this
     */
    public function setRuri($ruri)
    {
        $this->container['ruri'] = $ruri;

        return $this;
    }

    /**
     * Gets ruriUser
     * @return string
     */
    public function getRuriUser()
    {
        return $this->container['ruriUser'];
    }

    /**
     * Sets ruriUser
     * @param string $ruriUser metadata associated to the SIP calls
     * @return $this
     */
    public function setRuriUser($ruriUser)
    {
        $this->container['ruriUser'] = $ruriUser;

        return $this;
    }

    /**
     * Gets ruriDomain
     * @return string
     */
    public function getRuriDomain()
    {
        return $this->container['ruriDomain'];
    }

    /**
     * Sets ruriDomain
     * @param string $ruriDomain metadata associated to the SIP calls
     * @return $this
     */
    public function setRuriDomain($ruriDomain)
    {
        $this->container['ruriDomain'] = $ruriDomain;

        return $this;
    }

    /**
     * Gets fromUser
     * @return string
     */
    public function getFromUser()
    {
        return $this->container['fromUser'];
    }

    /**
     * Sets fromUser
     * @param string $fromUser metadata associated to the SIP calls
     * @return $this
     */
    public function setFromUser($fromUser)
    {
        $this->container['fromUser'] = $fromUser;

        return $this;
    }

    /**
     * Gets fromDomain
     * @return string
     */
    public function getFromDomain()
    {
        return $this->container['fromDomain'];
    }

    /**
     * Sets fromDomain
     * @param string $fromDomain metadata associated to the SIP calls
     * @return $this
     */
    public function setFromDomain($fromDomain)
    {
        $this->container['fromDomain'] = $fromDomain;

        return $this;
    }

    /**
     * Gets fromTag
     * @return string
     */
    public function getFromTag()
    {
        return $this->container['fromTag'];
    }

    /**
     * Sets fromTag
     * @param string $fromTag metadata associated to the SIP calls
     * @return $this
     */
    public function setFromTag($fromTag)
    {
        $this->container['fromTag'] = $fromTag;

        return $this;
    }

    /**
     * Gets toUser
     * @return string
     */
    public function getToUser()
    {
        return $this->container['toUser'];
    }

    /**
     * Sets toUser
     * @param string $toUser metadata associated to the SIP calls
     * @return $this
     */
    public function setToUser($toUser)
    {
        $this->container['toUser'] = $toUser;

        return $this;
    }

    /**
     * Gets toDomain
     * @return string
     */
    public function getToDomain()
    {
        return $this->container['toDomain'];
    }

    /**
     * Sets toDomain
     * @param string $toDomain metadata associated to the SIP calls
     * @return $this
     */
    public function setToDomain($toDomain)
    {
        $this->container['toDomain'] = $toDomain;

        return $this;
    }

    /**
     * Gets toTag
     * @return string
     */
    public function getToTag()
    {
        return $this->container['toTag'];
    }

    /**
     * Sets toTag
     * @param string $toTag metadata associated to the SIP calls
     * @return $this
     */
    public function setToTag($toTag)
    {
        $this->container['toTag'] = $toTag;

        return $this;
    }

    /**
     * Gets pidUser
     * @return string
     */
    public function getPidUser()
    {
        return $this->container['pidUser'];
    }

    /**
     * Sets pidUser
     * @param string $pidUser metadata associated to the SIP calls
     * @return $this
     */
    public function setPidUser($pidUser)
    {
        $this->container['pidUser'] = $pidUser;

        return $this;
    }

    /**
     * Gets contactUser
     * @return string
     */
    public function getContactUser()
    {
        return $this->container['contactUser'];
    }

    /**
     * Sets contactUser
     * @param string $contactUser metadata associated to the SIP calls
     * @return $this
     */
    public function setContactUser($contactUser)
    {
        $this->container['contactUser'] = $contactUser;

        return $this;
    }

    /**
     * Gets authUser
     * @return string
     */
    public function getAuthUser()
    {
        return $this->container['authUser'];
    }

    /**
     * Sets authUser
     * @param string $authUser metadata associated to the SIP calls
     * @return $this
     */
    public function setAuthUser($authUser)
    {
        $this->container['authUser'] = $authUser;

        return $this;
    }

    /**
     * Gets callid
     * @return string
     */
    public function getCallid()
    {
        return $this->container['callid'];
    }

    /**
     * Sets callid
     * @param string $callid metadata associated to the SIP calls
     * @return $this
     */
    public function setCallid($callid)
    {
        $this->container['callid'] = $callid;

        return $this;
    }

    /**
     * Gets callidAleg
     * @return string
     */
    public function getCallidAleg()
    {
        return $this->container['callidAleg'];
    }

    /**
     * Sets callidAleg
     * @param string $callidAleg metadata associated to the SIP calls
     * @return $this
     */
    public function setCallidAleg($callidAleg)
    {
        $this->container['callidAleg'] = $callidAleg;

        return $this;
    }

    /**
     * Gets via1
     * @return string
     */
    public function getVia1()
    {
        return $this->container['via1'];
    }

    /**
     * Sets via1
     * @param string $via1 metadata associated to the SIP calls
     * @return $this
     */
    public function setVia1($via1)
    {
        $this->container['via1'] = $via1;

        return $this;
    }

    /**
     * Gets via1Branch
     * @return string
     */
    public function getVia1Branch()
    {
        return $this->container['via1Branch'];
    }

    /**
     * Sets via1Branch
     * @param string $via1Branch metadata associated to the SIP calls
     * @return $this
     */
    public function setVia1Branch($via1Branch)
    {
        $this->container['via1Branch'] = $via1Branch;

        return $this;
    }

    /**
     * Gets cseq
     * @return string
     */
    public function getCseq()
    {
        return $this->container['cseq'];
    }

    /**
     * Sets cseq
     * @param string $cseq metadata associated to the SIP calls
     * @return $this
     */
    public function setCseq($cseq)
    {
        $this->container['cseq'] = $cseq;

        return $this;
    }

    /**
     * Gets diversion
     * @return string
     */
    public function getDiversion()
    {
        return $this->container['diversion'];
    }

    /**
     * Sets diversion
     * @param string $diversion metadata associated to the SIP calls
     * @return $this
     */
    public function setDiversion($diversion)
    {
        $this->container['diversion'] = $diversion;

        return $this;
    }

    /**
     * Gets reason
     * @return string
     */
    public function getReason()
    {
        return $this->container['reason'];
    }

    /**
     * Sets reason
     * @param string $reason metadata associated to the SIP calls
     * @return $this
     */
    public function setReason($reason)
    {
        $this->container['reason'] = $reason;

        return $this;
    }

    /**
     * Gets contentType
     * @return string
     */
    public function getContentType()
    {
        return $this->container['contentType'];
    }

    /**
     * Sets contentType
     * @param string $contentType metadata associated to the SIP calls
     * @return $this
     */
    public function setContentType($contentType)
    {
        $this->container['contentType'] = $contentType;

        return $this;
    }

    /**
     * Gets auth
     * @return string
     */
    public function getAuth()
    {
        return $this->container['auth'];
    }

    /**
     * Sets auth
     * @param string $auth metadata associated to the SIP calls
     * @return $this
     */
    public function setAuth($auth)
    {
        $this->container['auth'] = $auth;

        return $this;
    }

    /**
     * Gets userAgent
     * @return string
     */
    public function getUserAgent()
    {
        return $this->container['userAgent'];
    }

    /**
     * Sets userAgent
     * @param string $userAgent metadata associated to the SIP calls
     * @return $this
     */
    public function setUserAgent($userAgent)
    {
        $this->container['userAgent'] = $userAgent;

        return $this;
    }

    /**
     * Gets sourceIp
     * @return string
     */
    public function getSourceIp()
    {
        return $this->container['sourceIp'];
    }

    /**
     * Sets sourceIp
     * @param string $sourceIp metadata associated to the SIP calls
     * @return $this
     */
    public function setSourceIp($sourceIp)
    {
        $this->container['sourceIp'] = $sourceIp;

        return $this;
    }

    /**
     * Gets sourcePort
     * @return string
     */
    public function getSourcePort()
    {
        return $this->container['sourcePort'];
    }

    /**
     * Sets sourcePort
     * @param string $sourcePort metadata associated to the SIP calls
     * @return $this
     */
    public function setSourcePort($sourcePort)
    {
        $this->container['sourcePort'] = $sourcePort;

        return $this;
    }

    /**
     * Gets destinationIp
     * @return string
     */
    public function getDestinationIp()
    {
        return $this->container['destinationIp'];
    }

    /**
     * Sets destinationIp
     * @param string $destinationIp metadata associated to the SIP calls
     * @return $this
     */
    public function setDestinationIp($destinationIp)
    {
        $this->container['destinationIp'] = $destinationIp;

        return $this;
    }

    /**
     * Gets destinationPort
     * @return string
     */
    public function getDestinationPort()
    {
        return $this->container['destinationPort'];
    }

    /**
     * Sets destinationPort
     * @param string $destinationPort metadata associated to the SIP calls
     * @return $this
     */
    public function setDestinationPort($destinationPort)
    {
        $this->container['destinationPort'] = $destinationPort;

        return $this;
    }

    /**
     * Gets contactIp
     * @return string
     */
    public function getContactIp()
    {
        return $this->container['contactIp'];
    }

    /**
     * Sets contactIp
     * @param string $contactIp metadata associated to the SIP calls
     * @return $this
     */
    public function setContactIp($contactIp)
    {
        $this->container['contactIp'] = $contactIp;

        return $this;
    }

    /**
     * Gets contactPort
     * @return string
     */
    public function getContactPort()
    {
        return $this->container['contactPort'];
    }

    /**
     * Sets contactPort
     * @param string $contactPort metadata associated to the SIP calls
     * @return $this
     */
    public function setContactPort($contactPort)
    {
        $this->container['contactPort'] = $contactPort;

        return $this;
    }

    /**
     * Gets originatorIp
     * @return string
     */
    public function getOriginatorIp()
    {
        return $this->container['originatorIp'];
    }

    /**
     * Sets originatorIp
     * @param string $originatorIp metadata associated to the SIP calls
     * @return $this
     */
    public function setOriginatorIp($originatorIp)
    {
        $this->container['originatorIp'] = $originatorIp;

        return $this;
    }

    /**
     * Gets originatorPort
     * @return string
     */
    public function getOriginatorPort()
    {
        return $this->container['originatorPort'];
    }

    /**
     * Sets originatorPort
     * @param string $originatorPort metadata associated to the SIP calls
     * @return $this
     */
    public function setOriginatorPort($originatorPort)
    {
        $this->container['originatorPort'] = $originatorPort;

        return $this;
    }

    /**
     * Gets correlationId
     * @return string
     */
    public function getCorrelationId()
    {
        return $this->container['correlationId'];
    }

    /**
     * Sets correlationId
     * @param string $correlationId metadata associated to the SIP calls
     * @return $this
     */
    public function setCorrelationId($correlationId)
    {
        $this->container['correlationId'] = $correlationId;

        return $this;
    }

    /**
     * Gets proto
     * @return string
     */
    public function getProto()
    {
        return $this->container['proto'];
    }

    /**
     * Sets proto
     * @param string $proto metadata associated to the SIP calls
     * @return $this
     */
    public function setProto($proto)
    {
        $this->container['proto'] = $proto;

        return $this;
    }

    /**
     * Gets family
     * @return string
     */
    public function getFamily()
    {
        return $this->container['family'];
    }

    /**
     * Sets family
     * @param string $family metadata associated to the SIP calls
     * @return $this
     */
    public function setFamily($family)
    {
        $this->container['family'] = $family;

        return $this;
    }

    /**
     * Gets rtpStat
     * @return string
     */
    public function getRtpStat()
    {
        return $this->container['rtpStat'];
    }

    /**
     * Sets rtpStat
     * @param string $rtpStat metadata associated to the SIP calls
     * @return $this
     */
    public function setRtpStat($rtpStat)
    {
        $this->container['rtpStat'] = $rtpStat;

        return $this;
    }

    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type metadata associated to the SIP calls
     * @return $this
     */
    public function setType($type)
    {
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets node
     * @return string
     */
    public function getNode()
    {
        return $this->container['node'];
    }

    /**
     * Sets node
     * @param string $node metadata associated to the SIP calls
     * @return $this
     */
    public function setNode($node)
    {
        $this->container['node'] = $node;

        return $this;
    }

    /**
     * Gets trans
     * @return string
     */
    public function getTrans()
    {
        return $this->container['trans'];
    }

    /**
     * Sets trans
     * @param string $trans metadata associated to the SIP calls
     * @return $this
     */
    public function setTrans($trans)
    {
        $this->container['trans'] = $trans;

        return $this;
    }

    /**
     * Gets dbnode
     * @return string
     */
    public function getDbnode()
    {
        return $this->container['dbnode'];
    }

    /**
     * Sets dbnode
     * @param string $dbnode metadata associated to the SIP calls
     * @return $this
     */
    public function setDbnode($dbnode)
    {
        $this->container['dbnode'] = $dbnode;

        return $this;
    }

    /**
     * Gets msg
     * @return string
     */
    public function getMsg()
    {
        return $this->container['msg'];
    }

    /**
     * Sets msg
     * @param string $msg metadata associated to the SIP calls
     * @return $this
     */
    public function setMsg($msg)
    {
        $this->container['msg'] = $msg;

        return $this;
    }

    /**
     * Gets sourceAlias
     * @return string
     */
    public function getSourceAlias()
    {
        return $this->container['sourceAlias'];
    }

    /**
     * Sets sourceAlias
     * @param string $sourceAlias metadata associated to the SIP calls
     * @return $this
     */
    public function setSourceAlias($sourceAlias)
    {
        $this->container['sourceAlias'] = $sourceAlias;

        return $this;
    }

    /**
     * Gets destinationAlias
     * @return string
     */
    public function getDestinationAlias()
    {
        return $this->container['destinationAlias'];
    }

    /**
     * Sets destinationAlias
     * @param string $destinationAlias metadata associated to the SIP calls
     * @return $this
     */
    public function setDestinationAlias($destinationAlias)
    {
        $this->container['destinationAlias'] = $destinationAlias;

        return $this;
    }

    /**
     * Gets conversationId
     * @return string
     */
    public function getConversationId()
    {
        return $this->container['conversationId'];
    }

    /**
     * Sets conversationId
     * @param string $conversationId metadata associated to the SIP calls
     * @return $this
     */
    public function setConversationId($conversationId)
    {
        $this->container['conversationId'] = $conversationId;

        return $this;
    }

    /**
     * Gets participantId
     * @return string
     */
    public function getParticipantId()
    {
        return $this->container['participantId'];
    }

    /**
     * Sets participantId
     * @param string $participantId metadata associated to the SIP calls
     * @return $this
     */
    public function setParticipantId($participantId)
    {
        $this->container['participantId'] = $participantId;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
