<?php

/**
 * MessageContent
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * MessageContent Class Doc Comment
 *
 * @category    Class */
 // @description Message content element
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class MessageContent implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'MessageContent';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'contentType' => 'string',
        'location' => '\PureCloudSDK\ContentLocation',
        'attachment' => '\PureCloudSDK\ContentAttachment',
        'quickReply' => '\PureCloudSDK\ContentQuickReply',
        'generic' => '\PureCloudSDK\ContentGeneric',
        'list' => '\PureCloudSDK\ContentList',
        'template' => '\PureCloudSDK\ContentNotificationTemplate'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'contentType' => 'contentType',
        'location' => 'location',
        'attachment' => 'attachment',
        'quickReply' => 'quickReply',
        'generic' => 'generic',
        'list' => 'list',
        'template' => 'template'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'contentType' => 'setContentType',
        'location' => 'setLocation',
        'attachment' => 'setAttachment',
        'quickReply' => 'setQuickReply',
        'generic' => 'setGeneric',
        'list' => 'setList',
        'template' => 'setTemplate'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'contentType' => 'getContentType',
        'location' => 'getLocation',
        'attachment' => 'getAttachment',
        'quickReply' => 'getQuickReply',
        'generic' => 'getGeneric',
        'list' => 'getList',
        'template' => 'getTemplate'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const CONTENT_TYPE_ATTACHMENT = 'Attachment';
    public const CONTENT_TYPE_LOCATION = 'Location';
    public const CONTENT_TYPE_QUICK_REPLY = 'QuickReply';
    public const CONTENT_TYPE_NOTIFICATION = 'Notification';
    public const CONTENT_TYPE_GENERIC_TEMPLATE = 'GenericTemplate';
    public const CONTENT_TYPE_LIST_TEMPLATE = 'ListTemplate';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getContentTypeAllowableValues()
    {
        return [
            self::CONTENT_TYPE_ATTACHMENT,
            self::CONTENT_TYPE_LOCATION,
            self::CONTENT_TYPE_QUICK_REPLY,
            self::CONTENT_TYPE_NOTIFICATION,
            self::CONTENT_TYPE_GENERIC_TEMPLATE,
            self::CONTENT_TYPE_LIST_TEMPLATE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['contentType'] = isset($data['contentType']) ? $data['contentType'] : null;
        $this->container['location'] = isset($data['location']) ? $data['location'] : null;
        $this->container['attachment'] = isset($data['attachment']) ? $data['attachment'] : null;
        $this->container['quickReply'] = isset($data['quickReply']) ? $data['quickReply'] : null;
        $this->container['generic'] = isset($data['generic']) ? $data['generic'] : null;
        $this->container['list'] = isset($data['list']) ? $data['list'] : null;
        $this->container['template'] = isset($data['template']) ? $data['template'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['contentType'] === null) {
            $invalid_properties[] = "'contentType' can't be null";
        }
        $allowed_values = array("Attachment", "Location", "QuickReply", "Notification", "GenericTemplate", "ListTemplate");
        if (!in_array($this->container['contentType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'contentType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['contentType'] === null) {
            return false;
        }
        $allowed_values = array("Attachment", "Location", "QuickReply", "Notification", "GenericTemplate", "ListTemplate");
        if (!in_array($this->container['contentType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets contentType
     * @return string
     */
    public function getContentType()
    {
        return $this->container['contentType'];
    }

    /**
     * Sets contentType
     * @param string $contentType Type of this content element. If contentType = \"Attachment\" only one item is allowed.
     * @return $this
     */
    public function setContentType($contentType)
    {
        $allowed_values = array('Attachment', 'Location', 'QuickReply', 'Notification', 'GenericTemplate', 'ListTemplate');
        if (!in_array($contentType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'contentType', must be one of 'Attachment', 'Location', 'QuickReply', 'Notification', 'GenericTemplate', 'ListTemplate'");
        }
        $this->container['contentType'] = $contentType;

        return $this;
    }

    /**
     * Gets location
     * @return \PureCloudSDK\ContentLocation
     */
    public function getLocation()
    {
        return $this->container['location'];
    }

    /**
     * Sets location
     * @param \PureCloudSDK\ContentLocation $location Location object
     * @return $this
     */
    public function setLocation($location)
    {
        $this->container['location'] = $location;

        return $this;
    }

    /**
     * Gets attachment
     * @return \PureCloudSDK\ContentAttachment
     */
    public function getAttachment()
    {
        return $this->container['attachment'];
    }

    /**
     * Sets attachment
     * @param \PureCloudSDK\ContentAttachment $attachment Attachment object
     * @return $this
     */
    public function setAttachment($attachment)
    {
        $this->container['attachment'] = $attachment;

        return $this;
    }

    /**
     * Gets quickReply
     * @return \PureCloudSDK\ContentQuickReply
     */
    public function getQuickReply()
    {
        return $this->container['quickReply'];
    }

    /**
     * Sets quickReply
     * @param \PureCloudSDK\ContentQuickReply $quickReply Quick reply object
     * @return $this
     */
    public function setQuickReply($quickReply)
    {
        $this->container['quickReply'] = $quickReply;

        return $this;
    }

    /**
     * Gets generic
     * @return \PureCloudSDK\ContentGeneric
     */
    public function getGeneric()
    {
        return $this->container['generic'];
    }

    /**
     * Sets generic
     * @param \PureCloudSDK\ContentGeneric $generic Generic content object
     * @return $this
     */
    public function setGeneric($generic)
    {
        $this->container['generic'] = $generic;

        return $this;
    }

    /**
     * Gets list
     * @return \PureCloudSDK\ContentList
     */
    public function getList()
    {
        return $this->container['list'];
    }

    /**
     * Sets list
     * @param \PureCloudSDK\ContentList $list List content object
     * @return $this
     */
    public function setList($list)
    {
        $this->container['list'] = $list;

        return $this;
    }

    /**
     * Gets template
     * @return \PureCloudSDK\ContentNotificationTemplate
     */
    public function getTemplate()
    {
        return $this->container['template'];
    }

    /**
     * Sets template
     * @param \PureCloudSDK\ContentNotificationTemplate $template Template notification object
     * @return $this
     */
    public function setTemplate($template)
    {
        $this->container['template'] = $template;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
