<?php

/**
 * ScheduleGenerationMessage
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * ScheduleGenerationMessage Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ScheduleGenerationMessage implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ScheduleGenerationMessage';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'type' => 'string',
        'arguments' => '\PureCloudSDK\SchedulerMessageArgument[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'type' => 'type',
        'arguments' => 'arguments'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'type' => 'setType',
        'arguments' => 'setArguments'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'type' => 'getType',
        'arguments' => 'getArguments'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const TYPE_AGENT_NOT_FOUND = 'AgentNotFound';
    public const TYPE_AGENT_NOT_IN_SELECTED_MANAGEMENT_UNIT = 'AgentNotInSelectedManagementUnit';
    public const TYPE_AGENT_NOT_LICENSED = 'AgentNotLicensed';
    public const TYPE_AGENT_WITHOUT_WORK_PLAN = 'AgentWithoutWorkPlan';
    public const TYPE_WORK_PLAN_NOT_ENABLED = 'WorkPlanNotEnabled';
    public const TYPE_WORK_PLAN_NOT_FOUND = 'WorkPlanNotFound';
    public const TYPE_AGENT_WITHOUT_CAPABILITY = 'AgentWithoutCapability';
    public const TYPE_NO_NEED_DAYS = 'NoNeedDays';
    public const TYPE_UNABLE_TO_PRODUCE_AGENT_SCHEDULE = 'UnableToProduceAgentSchedule';
    public const TYPE_UNABLE_TO_SCHEDULE_MAX_CONSECUTIVE_WORKING_DAYS = 'UnableToScheduleMaxConsecutiveWorkingDays';
    public const TYPE_UNABLE_TO_SCHEDULE_MAX_CONSECUTIVE_WORKING_WEEKENDS = 'UnableToScheduleMaxConsecutiveWorkingWeekends';
    public const TYPE_UNABLE_TO_SCHEDULE_MAX_WEEKLY_PAID_TIME = 'UnableToScheduleMaxWeeklyPaidTime';
    public const TYPE_UNABLE_TO_SCHEDULE_MAX_WEEKLY_WORK_DAYS = 'UnableToScheduleMaxWeeklyWorkDays';
    public const TYPE_UNABLE_TO_SCHEDULE_MAX_WORK_DAY_PAID_TIME = 'UnableToScheduleMaxWorkDayPaidTime';
    public const TYPE_UNABLE_TO_SCHEDULE_MIN_CONSECUTIVE_NON_WORKING_TIME_PER_WEEK = 'UnableToScheduleMinConsecutiveNonWorkingTimePerWeek';
    public const TYPE_UNABLE_TO_SCHEDULE_MIN_INTERSHIFT_TIME = 'UnableToScheduleMinIntershiftTime';
    public const TYPE_UNABLE_TO_SCHEDULE_MIN_SHIFT_START_DISTANCE = 'UnableToScheduleMinShiftStartDistance';
    public const TYPE_UNABLE_TO_SCHEDULE_MIN_WEEKLY_PAID_TIME = 'UnableToScheduleMinWeeklyPaidTime';
    public const TYPE_UNABLE_TO_SCHEDULE_MIN_WEEKLY_WORK_DAYS = 'UnableToScheduleMinWeeklyWorkDays';
    public const TYPE_UNABLE_TO_SCHEDULE_MIN_WORK_DAY_PAID_TIME = 'UnableToScheduleMinWorkDayPaidTime';
    public const TYPE_UNABLE_TO_SCHEDULE_PLANNING_PERIOD_MAX_DAYS_OFF = 'UnableToSchedulePlanningPeriodMaxDaysOff';
    public const TYPE_UNABLE_TO_SCHEDULE_PLANNING_PERIOD_MAX_PAID_TIME = 'UnableToSchedulePlanningPeriodMaxPaidTime';
    public const TYPE_UNABLE_TO_SCHEDULE_PLANNING_PERIOD_MIN_DAYS_OFF = 'UnableToSchedulePlanningPeriodMinDaysOff';
    public const TYPE_UNABLE_TO_SCHEDULE_PLANNING_PERIOD_MIN_PAID_TIME = 'UnableToSchedulePlanningPeriodMinPaidTime';
    public const TYPE_UNABLE_TO_SCHEDULE_SHIFT_VARIANCE = 'UnableToScheduleShiftVariance';
    public const TYPE_UNABLE_TO_SCHEDULE_WORK_DAY = 'UnableToScheduleWorkDay';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_AGENT_NOT_FOUND,
            self::TYPE_AGENT_NOT_IN_SELECTED_MANAGEMENT_UNIT,
            self::TYPE_AGENT_NOT_LICENSED,
            self::TYPE_AGENT_WITHOUT_WORK_PLAN,
            self::TYPE_WORK_PLAN_NOT_ENABLED,
            self::TYPE_WORK_PLAN_NOT_FOUND,
            self::TYPE_AGENT_WITHOUT_CAPABILITY,
            self::TYPE_NO_NEED_DAYS,
            self::TYPE_UNABLE_TO_PRODUCE_AGENT_SCHEDULE,
            self::TYPE_UNABLE_TO_SCHEDULE_MAX_CONSECUTIVE_WORKING_DAYS,
            self::TYPE_UNABLE_TO_SCHEDULE_MAX_CONSECUTIVE_WORKING_WEEKENDS,
            self::TYPE_UNABLE_TO_SCHEDULE_MAX_WEEKLY_PAID_TIME,
            self::TYPE_UNABLE_TO_SCHEDULE_MAX_WEEKLY_WORK_DAYS,
            self::TYPE_UNABLE_TO_SCHEDULE_MAX_WORK_DAY_PAID_TIME,
            self::TYPE_UNABLE_TO_SCHEDULE_MIN_CONSECUTIVE_NON_WORKING_TIME_PER_WEEK,
            self::TYPE_UNABLE_TO_SCHEDULE_MIN_INTERSHIFT_TIME,
            self::TYPE_UNABLE_TO_SCHEDULE_MIN_SHIFT_START_DISTANCE,
            self::TYPE_UNABLE_TO_SCHEDULE_MIN_WEEKLY_PAID_TIME,
            self::TYPE_UNABLE_TO_SCHEDULE_MIN_WEEKLY_WORK_DAYS,
            self::TYPE_UNABLE_TO_SCHEDULE_MIN_WORK_DAY_PAID_TIME,
            self::TYPE_UNABLE_TO_SCHEDULE_PLANNING_PERIOD_MAX_DAYS_OFF,
            self::TYPE_UNABLE_TO_SCHEDULE_PLANNING_PERIOD_MAX_PAID_TIME,
            self::TYPE_UNABLE_TO_SCHEDULE_PLANNING_PERIOD_MIN_DAYS_OFF,
            self::TYPE_UNABLE_TO_SCHEDULE_PLANNING_PERIOD_MIN_PAID_TIME,
            self::TYPE_UNABLE_TO_SCHEDULE_SHIFT_VARIANCE,
            self::TYPE_UNABLE_TO_SCHEDULE_WORK_DAY,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['arguments'] = isset($data['arguments']) ? $data['arguments'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("AgentNotFound", "AgentNotInSelectedManagementUnit", "AgentNotLicensed", "AgentWithoutWorkPlan", "WorkPlanNotEnabled", "WorkPlanNotFound", "AgentWithoutCapability", "NoNeedDays", "UnableToProduceAgentSchedule", "UnableToScheduleMaxConsecutiveWorkingDays", "UnableToScheduleMaxConsecutiveWorkingWeekends", "UnableToScheduleMaxWeeklyPaidTime", "UnableToScheduleMaxWeeklyWorkDays", "UnableToScheduleMaxWorkDayPaidTime", "UnableToScheduleMinConsecutiveNonWorkingTimePerWeek", "UnableToScheduleMinIntershiftTime", "UnableToScheduleMinShiftStartDistance", "UnableToScheduleMinWeeklyPaidTime", "UnableToScheduleMinWeeklyWorkDays", "UnableToScheduleMinWorkDayPaidTime", "UnableToSchedulePlanningPeriodMaxDaysOff", "UnableToSchedulePlanningPeriodMaxPaidTime", "UnableToSchedulePlanningPeriodMinDaysOff", "UnableToSchedulePlanningPeriodMinPaidTime", "UnableToScheduleShiftVariance", "UnableToScheduleWorkDay");
        if (!in_array($this->container['type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'type', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("AgentNotFound", "AgentNotInSelectedManagementUnit", "AgentNotLicensed", "AgentWithoutWorkPlan", "WorkPlanNotEnabled", "WorkPlanNotFound", "AgentWithoutCapability", "NoNeedDays", "UnableToProduceAgentSchedule", "UnableToScheduleMaxConsecutiveWorkingDays", "UnableToScheduleMaxConsecutiveWorkingWeekends", "UnableToScheduleMaxWeeklyPaidTime", "UnableToScheduleMaxWeeklyWorkDays", "UnableToScheduleMaxWorkDayPaidTime", "UnableToScheduleMinConsecutiveNonWorkingTimePerWeek", "UnableToScheduleMinIntershiftTime", "UnableToScheduleMinShiftStartDistance", "UnableToScheduleMinWeeklyPaidTime", "UnableToScheduleMinWeeklyWorkDays", "UnableToScheduleMinWorkDayPaidTime", "UnableToSchedulePlanningPeriodMaxDaysOff", "UnableToSchedulePlanningPeriodMaxPaidTime", "UnableToSchedulePlanningPeriodMinDaysOff", "UnableToSchedulePlanningPeriodMinPaidTime", "UnableToScheduleShiftVariance", "UnableToScheduleWorkDay");
        if (!in_array($this->container['type'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type The type of the message
     * @return $this
     */
    public function setType($type)
    {
        $allowed_values = array('AgentNotFound', 'AgentNotInSelectedManagementUnit', 'AgentNotLicensed', 'AgentWithoutWorkPlan', 'WorkPlanNotEnabled', 'WorkPlanNotFound', 'AgentWithoutCapability', 'NoNeedDays', 'UnableToProduceAgentSchedule', 'UnableToScheduleMaxConsecutiveWorkingDays', 'UnableToScheduleMaxConsecutiveWorkingWeekends', 'UnableToScheduleMaxWeeklyPaidTime', 'UnableToScheduleMaxWeeklyWorkDays', 'UnableToScheduleMaxWorkDayPaidTime', 'UnableToScheduleMinConsecutiveNonWorkingTimePerWeek', 'UnableToScheduleMinIntershiftTime', 'UnableToScheduleMinShiftStartDistance', 'UnableToScheduleMinWeeklyPaidTime', 'UnableToScheduleMinWeeklyWorkDays', 'UnableToScheduleMinWorkDayPaidTime', 'UnableToSchedulePlanningPeriodMaxDaysOff', 'UnableToSchedulePlanningPeriodMaxPaidTime', 'UnableToSchedulePlanningPeriodMinDaysOff', 'UnableToSchedulePlanningPeriodMinPaidTime', 'UnableToScheduleShiftVariance', 'UnableToScheduleWorkDay');
        if (!in_array($type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'type', must be one of 'AgentNotFound', 'AgentNotInSelectedManagementUnit', 'AgentNotLicensed', 'AgentWithoutWorkPlan', 'WorkPlanNotEnabled', 'WorkPlanNotFound', 'AgentWithoutCapability', 'NoNeedDays', 'UnableToProduceAgentSchedule', 'UnableToScheduleMaxConsecutiveWorkingDays', 'UnableToScheduleMaxConsecutiveWorkingWeekends', 'UnableToScheduleMaxWeeklyPaidTime', 'UnableToScheduleMaxWeeklyWorkDays', 'UnableToScheduleMaxWorkDayPaidTime', 'UnableToScheduleMinConsecutiveNonWorkingTimePerWeek', 'UnableToScheduleMinIntershiftTime', 'UnableToScheduleMinShiftStartDistance', 'UnableToScheduleMinWeeklyPaidTime', 'UnableToScheduleMinWeeklyWorkDays', 'UnableToScheduleMinWorkDayPaidTime', 'UnableToSchedulePlanningPeriodMaxDaysOff', 'UnableToSchedulePlanningPeriodMaxPaidTime', 'UnableToSchedulePlanningPeriodMinDaysOff', 'UnableToSchedulePlanningPeriodMinPaidTime', 'UnableToScheduleShiftVariance', 'UnableToScheduleWorkDay'");
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets arguments
     * @return \PureCloudSDK\SchedulerMessageArgument[]
     */
    public function getArguments()
    {
        return $this->container['arguments'];
    }

    /**
     * Sets arguments
     * @param \PureCloudSDK\SchedulerMessageArgument[] $arguments The arguments describing the message
     * @return $this
     */
    public function setArguments($arguments)
    {
        $this->container['arguments'] = $arguments;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
