<?php

/**
 * ScimServiceProviderConfig
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * ScimServiceProviderConfig Class Doc Comment
 *
 * @category    Class */
 // @description Defines a SCIM service provider&#39;s configuration.
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ScimServiceProviderConfig implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ScimServiceProviderConfig';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'schemas' => 'string[]',
        'documentationUri' => 'string',
        'patch' => '\PureCloudSDK\ScimServiceProviderConfigSimpleFeature',
        'filter' => '\PureCloudSDK\ScimServiceProviderConfigFilterFeature',
        'etag' => '\PureCloudSDK\ScimServiceProviderConfigSimpleFeature',
        'sort' => '\PureCloudSDK\ScimServiceProviderConfigSimpleFeature',
        'bulk' => '\PureCloudSDK\ScimServiceProviderConfigBulkFeature',
        'changePassword' => '\PureCloudSDK\ScimServiceProviderConfigSimpleFeature',
        'authenticationSchemes' => '\PureCloudSDK\ScimServiceProviderConfigAuthenticationScheme[]',
        'meta' => '\PureCloudSDK\ScimMetadata'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'schemas' => 'schemas',
        'documentationUri' => 'documentationUri',
        'patch' => 'patch',
        'filter' => 'filter',
        'etag' => 'etag',
        'sort' => 'sort',
        'bulk' => 'bulk',
        'changePassword' => 'changePassword',
        'authenticationSchemes' => 'authenticationSchemes',
        'meta' => 'meta'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'schemas' => 'setSchemas',
        'documentationUri' => 'setDocumentationUri',
        'patch' => 'setPatch',
        'filter' => 'setFilter',
        'etag' => 'setEtag',
        'sort' => 'setSort',
        'bulk' => 'setBulk',
        'changePassword' => 'setChangePassword',
        'authenticationSchemes' => 'setAuthenticationSchemes',
        'meta' => 'setMeta'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'schemas' => 'getSchemas',
        'documentationUri' => 'getDocumentationUri',
        'patch' => 'getPatch',
        'filter' => 'getFilter',
        'etag' => 'getEtag',
        'sort' => 'getSort',
        'bulk' => 'getBulk',
        'changePassword' => 'getChangePassword',
        'authenticationSchemes' => 'getAuthenticationSchemes',
        'meta' => 'getMeta'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['schemas'] = isset($data['schemas']) ? $data['schemas'] : null;
        $this->container['documentationUri'] = isset($data['documentationUri']) ? $data['documentationUri'] : null;
        $this->container['patch'] = isset($data['patch']) ? $data['patch'] : null;
        $this->container['filter'] = isset($data['filter']) ? $data['filter'] : null;
        $this->container['etag'] = isset($data['etag']) ? $data['etag'] : null;
        $this->container['sort'] = isset($data['sort']) ? $data['sort'] : null;
        $this->container['bulk'] = isset($data['bulk']) ? $data['bulk'] : null;
        $this->container['changePassword'] = isset($data['changePassword']) ? $data['changePassword'] : null;
        $this->container['authenticationSchemes'] = isset($data['authenticationSchemes']) ? $data['authenticationSchemes'] : null;
        $this->container['meta'] = isset($data['meta']) ? $data['meta'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets schemas
     * @return string[]
     */
    public function getSchemas()
    {
        return $this->container['schemas'];
    }

    /**
     * Sets schemas
     * @param string[] $schemas The list of supported schemas.
     * @return $this
     */
    public function setSchemas($schemas)
    {
        $this->container['schemas'] = $schemas;

        return $this;
    }

    /**
     * Gets documentationUri
     * @return string
     */
    public function getDocumentationUri()
    {
        return $this->container['documentationUri'];
    }

    /**
     * Sets documentationUri
     * @param string $documentationUri The HTTP-addressable URL that points to the service provider's documentation.
     * @return $this
     */
    public function setDocumentationUri($documentationUri)
    {
        $this->container['documentationUri'] = $documentationUri;

        return $this;
    }

    /**
     * Gets patch
     * @return \PureCloudSDK\ScimServiceProviderConfigSimpleFeature
     */
    public function getPatch()
    {
        return $this->container['patch'];
    }

    /**
     * Sets patch
     * @param \PureCloudSDK\ScimServiceProviderConfigSimpleFeature $patch The \"patch\" configuration options.
     * @return $this
     */
    public function setPatch($patch)
    {
        $this->container['patch'] = $patch;

        return $this;
    }

    /**
     * Gets filter
     * @return \PureCloudSDK\ScimServiceProviderConfigFilterFeature
     */
    public function getFilter()
    {
        return $this->container['filter'];
    }

    /**
     * Sets filter
     * @param \PureCloudSDK\ScimServiceProviderConfigFilterFeature $filter The \"filter\" configuration options.
     * @return $this
     */
    public function setFilter($filter)
    {
        $this->container['filter'] = $filter;

        return $this;
    }

    /**
     * Gets etag
     * @return \PureCloudSDK\ScimServiceProviderConfigSimpleFeature
     */
    public function getEtag()
    {
        return $this->container['etag'];
    }

    /**
     * Sets etag
     * @param \PureCloudSDK\ScimServiceProviderConfigSimpleFeature $etag The \"etag\" configuration options.
     * @return $this
     */
    public function setEtag($etag)
    {
        $this->container['etag'] = $etag;

        return $this;
    }

    /**
     * Gets sort
     * @return \PureCloudSDK\ScimServiceProviderConfigSimpleFeature
     */
    public function getSort()
    {
        return $this->container['sort'];
    }

    /**
     * Sets sort
     * @param \PureCloudSDK\ScimServiceProviderConfigSimpleFeature $sort The \"sort\" configuration options.
     * @return $this
     */
    public function setSort($sort)
    {
        $this->container['sort'] = $sort;

        return $this;
    }

    /**
     * Gets bulk
     * @return \PureCloudSDK\ScimServiceProviderConfigBulkFeature
     */
    public function getBulk()
    {
        return $this->container['bulk'];
    }

    /**
     * Sets bulk
     * @param \PureCloudSDK\ScimServiceProviderConfigBulkFeature $bulk The \"bulk\" configuration options.
     * @return $this
     */
    public function setBulk($bulk)
    {
        $this->container['bulk'] = $bulk;

        return $this;
    }

    /**
     * Gets changePassword
     * @return \PureCloudSDK\ScimServiceProviderConfigSimpleFeature
     */
    public function getChangePassword()
    {
        return $this->container['changePassword'];
    }

    /**
     * Sets changePassword
     * @param \PureCloudSDK\ScimServiceProviderConfigSimpleFeature $changePassword The \"changePassword\" configuration options.
     * @return $this
     */
    public function setChangePassword($changePassword)
    {
        $this->container['changePassword'] = $changePassword;

        return $this;
    }

    /**
     * Gets authenticationSchemes
     * @return \PureCloudSDK\ScimServiceProviderConfigAuthenticationScheme[]
     */
    public function getAuthenticationSchemes()
    {
        return $this->container['authenticationSchemes'];
    }

    /**
     * Sets authenticationSchemes
     * @param \PureCloudSDK\ScimServiceProviderConfigAuthenticationScheme[] $authenticationSchemes The list of supported authentication schemes.
     * @return $this
     */
    public function setAuthenticationSchemes($authenticationSchemes)
    {
        $this->container['authenticationSchemes'] = $authenticationSchemes;

        return $this;
    }

    /**
     * Gets meta
     * @return \PureCloudSDK\ScimMetadata
     */
    public function getMeta()
    {
        return $this->container['meta'];
    }

    /**
     * Sets meta
     * @param \PureCloudSDK\ScimMetadata $meta The metadata of the SCIM resource.
     * @return $this
     */
    public function setMeta($meta)
    {
        $this->container['meta'] = $meta;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
