<?php

/**
 * ScimUserExtensions
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * ScimUserExtensions Class Doc Comment
 *
 * @category    Class */
 // @description Genesys Cloud user extensions to SCIM RFC.
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ScimUserExtensions implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ScimUserExtensions';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'routingSkills' => '\PureCloudSDK\ScimUserRoutingSkill[]',
        'routingLanguages' => '\PureCloudSDK\ScimUserRoutingLanguage[]',
        'externalIds' => '\PureCloudSDK\ScimGenesysUserExternalId[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'routingSkills' => 'routingSkills',
        'routingLanguages' => 'routingLanguages',
        'externalIds' => 'externalIds'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'routingSkills' => 'setRoutingSkills',
        'routingLanguages' => 'setRoutingLanguages',
        'externalIds' => 'setExternalIds'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'routingSkills' => 'getRoutingSkills',
        'routingLanguages' => 'getRoutingLanguages',
        'externalIds' => 'getExternalIds'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['routingSkills'] = isset($data['routingSkills']) ? $data['routingSkills'] : null;
        $this->container['routingLanguages'] = isset($data['routingLanguages']) ? $data['routingLanguages'] : null;
        $this->container['externalIds'] = isset($data['externalIds']) ? $data['externalIds'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets routingSkills
     * @return \PureCloudSDK\ScimUserRoutingSkill[]
     */
    public function getRoutingSkills()
    {
        return $this->container['routingSkills'];
    }

    /**
     * Sets routingSkills
     * @param \PureCloudSDK\ScimUserRoutingSkill[] $routingSkills The list of routing skills assigned to a user. Maximum 50 skills.
     * @return $this
     */
    public function setRoutingSkills($routingSkills)
    {
        $this->container['routingSkills'] = $routingSkills;

        return $this;
    }

    /**
     * Gets routingLanguages
     * @return \PureCloudSDK\ScimUserRoutingLanguage[]
     */
    public function getRoutingLanguages()
    {
        return $this->container['routingLanguages'];
    }

    /**
     * Sets routingLanguages
     * @param \PureCloudSDK\ScimUserRoutingLanguage[] $routingLanguages The list of routing languages assigned to a user. Maximum 50 languages.
     * @return $this
     */
    public function setRoutingLanguages($routingLanguages)
    {
        $this->container['routingLanguages'] = $routingLanguages;

        return $this;
    }

    /**
     * Gets externalIds
     * @return \PureCloudSDK\ScimGenesysUserExternalId[]
     */
    public function getExternalIds()
    {
        return $this->container['externalIds'];
    }

    /**
     * Sets externalIds
     * @param \PureCloudSDK\ScimGenesysUserExternalId[] $externalIds External Identifiers assigned to user. SCIM External ID will be visible here with authority prefix 'x-pc:scimv2:v1' but will be immutable.
     * @return $this
     */
    public function setExternalIds($externalIds)
    {
        $this->container['externalIds'] = $externalIds;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
