<?php

/**
 * SmsConfig
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * SmsConfig Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class SmsConfig implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'SmsConfig';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'messageColumn' => 'string',
        'phoneColumn' => 'string',
        'senderSmsPhoneNumber' => '\PureCloudSDK\SmsPhoneNumberRef'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'messageColumn' => 'messageColumn',
        'phoneColumn' => 'phoneColumn',
        'senderSmsPhoneNumber' => 'senderSmsPhoneNumber'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'messageColumn' => 'setMessageColumn',
        'phoneColumn' => 'setPhoneColumn',
        'senderSmsPhoneNumber' => 'setSenderSmsPhoneNumber'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'messageColumn' => 'getMessageColumn',
        'phoneColumn' => 'getPhoneColumn',
        'senderSmsPhoneNumber' => 'getSenderSmsPhoneNumber'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['messageColumn'] = isset($data['messageColumn']) ? $data['messageColumn'] : null;
        $this->container['phoneColumn'] = isset($data['phoneColumn']) ? $data['phoneColumn'] : null;
        $this->container['senderSmsPhoneNumber'] = isset($data['senderSmsPhoneNumber']) ? $data['senderSmsPhoneNumber'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['messageColumn'] === null) {
            $invalid_properties[] = "'messageColumn' can't be null";
        }
        if ($this->container['phoneColumn'] === null) {
            $invalid_properties[] = "'phoneColumn' can't be null";
        }
        if ($this->container['senderSmsPhoneNumber'] === null) {
            $invalid_properties[] = "'senderSmsPhoneNumber' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['messageColumn'] === null) {
            return false;
        }
        if ($this->container['phoneColumn'] === null) {
            return false;
        }
        if ($this->container['senderSmsPhoneNumber'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets messageColumn
     * @return string
     */
    public function getMessageColumn()
    {
        return $this->container['messageColumn'];
    }

    /**
     * Sets messageColumn
     * @param string $messageColumn The Contact List column specifying the message to send to the contact.
     * @return $this
     */
    public function setMessageColumn($messageColumn)
    {
        $this->container['messageColumn'] = $messageColumn;

        return $this;
    }

    /**
     * Gets phoneColumn
     * @return string
     */
    public function getPhoneColumn()
    {
        return $this->container['phoneColumn'];
    }

    /**
     * Sets phoneColumn
     * @param string $phoneColumn The Contact List column specifying the phone number to send a message to.
     * @return $this
     */
    public function setPhoneColumn($phoneColumn)
    {
        $this->container['phoneColumn'] = $phoneColumn;

        return $this;
    }

    /**
     * Gets senderSmsPhoneNumber
     * @return \PureCloudSDK\SmsPhoneNumberRef
     */
    public function getSenderSmsPhoneNumber()
    {
        return $this->container['senderSmsPhoneNumber'];
    }

    /**
     * Sets senderSmsPhoneNumber
     * @param \PureCloudSDK\SmsPhoneNumberRef $senderSmsPhoneNumber A reference to the SMS Phone Number that will be used as the sender of a message.
     * @return $this
     */
    public function setSenderSmsPhoneNumber($senderSmsPhoneNumber)
    {
        $this->container['senderSmsPhoneNumber'] = $senderSmsPhoneNumber;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
