<?php

/**
 * UploadUrlRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * UploadUrlRequest Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class UploadUrlRequest implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'UploadUrlRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'fileName' => 'string',
        'contentMd5' => 'string',
        'signedUrlTimeoutSeconds' => 'int',
        'serverSideEncryption' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'fileName' => 'fileName',
        'contentMd5' => 'contentMd5',
        'signedUrlTimeoutSeconds' => 'signedUrlTimeoutSeconds',
        'serverSideEncryption' => 'serverSideEncryption'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'fileName' => 'setFileName',
        'contentMd5' => 'setContentMd5',
        'signedUrlTimeoutSeconds' => 'setSignedUrlTimeoutSeconds',
        'serverSideEncryption' => 'setServerSideEncryption'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'fileName' => 'getFileName',
        'contentMd5' => 'getContentMd5',
        'signedUrlTimeoutSeconds' => 'getSignedUrlTimeoutSeconds',
        'serverSideEncryption' => 'getServerSideEncryption'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const SERVER_SIDE_ENCRYPTION_AES256 = 'AES256';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getServerSideEncryptionAllowableValues()
    {
        return [
            self::SERVER_SIDE_ENCRYPTION_AES256,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['fileName'] = isset($data['fileName']) ? $data['fileName'] : null;
        $this->container['contentMd5'] = isset($data['contentMd5']) ? $data['contentMd5'] : null;
        $this->container['signedUrlTimeoutSeconds'] = isset($data['signedUrlTimeoutSeconds']) ? $data['signedUrlTimeoutSeconds'] : null;
        $this->container['serverSideEncryption'] = isset($data['serverSideEncryption']) ? $data['serverSideEncryption'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("AES256");
        if (!in_array($this->container['serverSideEncryption'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'serverSideEncryption', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("AES256");
        if (!in_array($this->container['serverSideEncryption'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets fileName
     * @return string
     */
    public function getFileName()
    {
        return $this->container['fileName'];
    }

    /**
     * Sets fileName
     * @param string $fileName Name of the file to upload. It must not start with a dot and not end with a forward slash. Whitespace and the following characters are not allowed: \\{^}%`]\">[~<#|
     * @return $this
     */
    public function setFileName($fileName)
    {
        $this->container['fileName'] = $fileName;

        return $this;
    }

    /**
     * Gets contentMd5
     * @return string
     */
    public function getContentMd5()
    {
        return $this->container['contentMd5'];
    }

    /**
     * Sets contentMd5
     * @param string $contentMd5 Content MD-5 of the file to upload
     * @return $this
     */
    public function setContentMd5($contentMd5)
    {
        $this->container['contentMd5'] = $contentMd5;

        return $this;
    }

    /**
     * Gets signedUrlTimeoutSeconds
     * @return int
     */
    public function getSignedUrlTimeoutSeconds()
    {
        return $this->container['signedUrlTimeoutSeconds'];
    }

    /**
     * Sets signedUrlTimeoutSeconds
     * @param int $signedUrlTimeoutSeconds The number of seconds the presigned URL is valid for (from 1 to 604800 seconds). If none provided, defaults to 600 seconds
     * @return $this
     */
    public function setSignedUrlTimeoutSeconds($signedUrlTimeoutSeconds)
    {
        $this->container['signedUrlTimeoutSeconds'] = $signedUrlTimeoutSeconds;

        return $this;
    }

    /**
     * Gets serverSideEncryption
     * @return string
     */
    public function getServerSideEncryption()
    {
        return $this->container['serverSideEncryption'];
    }

    /**
     * Sets serverSideEncryption
     * @param string $serverSideEncryption
     * @return $this
     */
    public function setServerSideEncryption($serverSideEncryption)
    {
        $allowed_values = array('AES256');
        if (!in_array($serverSideEncryption, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'serverSideEncryption', must be one of 'AES256'");
        }
        $this->container['serverSideEncryption'] = $serverSideEncryption;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
