<?php

/**
 * VoicemailGroupPolicy
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * VoicemailGroupPolicy Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class VoicemailGroupPolicy implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'VoicemailGroupPolicy';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'name' => 'string',
        'group' => '\PureCloudSDK\Group',
        'enabled' => 'bool',
        'sendEmailNotifications' => 'bool',
        'rotateCallsSecs' => 'int',
        'stopRingingAfterRotations' => 'int',
        'overflowGroupId' => 'string',
        'groupAlertType' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'name' => 'name',
        'group' => 'group',
        'enabled' => 'enabled',
        'sendEmailNotifications' => 'sendEmailNotifications',
        'rotateCallsSecs' => 'rotateCallsSecs',
        'stopRingingAfterRotations' => 'stopRingingAfterRotations',
        'overflowGroupId' => 'overflowGroupId',
        'groupAlertType' => 'groupAlertType'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'name' => 'setName',
        'group' => 'setGroup',
        'enabled' => 'setEnabled',
        'sendEmailNotifications' => 'setSendEmailNotifications',
        'rotateCallsSecs' => 'setRotateCallsSecs',
        'stopRingingAfterRotations' => 'setStopRingingAfterRotations',
        'overflowGroupId' => 'setOverflowGroupId',
        'groupAlertType' => 'setGroupAlertType'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'name' => 'getName',
        'group' => 'getGroup',
        'enabled' => 'getEnabled',
        'sendEmailNotifications' => 'getSendEmailNotifications',
        'rotateCallsSecs' => 'getRotateCallsSecs',
        'stopRingingAfterRotations' => 'getStopRingingAfterRotations',
        'overflowGroupId' => 'getOverflowGroupId',
        'groupAlertType' => 'getGroupAlertType'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const GROUP_ALERT_TYPE_RANDOM = 'RANDOM';
    public const GROUP_ALERT_TYPE_ROUND_ROBIN = 'ROUND_ROBIN';
    public const GROUP_ALERT_TYPE_SEQUENTIAL = 'SEQUENTIAL';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getGroupAlertTypeAllowableValues()
    {
        return [
            self::GROUP_ALERT_TYPE_RANDOM,
            self::GROUP_ALERT_TYPE_ROUND_ROBIN,
            self::GROUP_ALERT_TYPE_SEQUENTIAL,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['group'] = isset($data['group']) ? $data['group'] : null;
        $this->container['enabled'] = isset($data['enabled']) ? $data['enabled'] : null;
        $this->container['sendEmailNotifications'] = isset($data['sendEmailNotifications']) ? $data['sendEmailNotifications'] : null;
        $this->container['rotateCallsSecs'] = isset($data['rotateCallsSecs']) ? $data['rotateCallsSecs'] : null;
        $this->container['stopRingingAfterRotations'] = isset($data['stopRingingAfterRotations']) ? $data['stopRingingAfterRotations'] : null;
        $this->container['overflowGroupId'] = isset($data['overflowGroupId']) ? $data['overflowGroupId'] : null;
        $this->container['groupAlertType'] = isset($data['groupAlertType']) ? $data['groupAlertType'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("RANDOM", "ROUND_ROBIN", "SEQUENTIAL");
        if (!in_array($this->container['groupAlertType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'groupAlertType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("RANDOM", "ROUND_ROBIN", "SEQUENTIAL");
        if (!in_array($this->container['groupAlertType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets group
     * @return \PureCloudSDK\Group
     */
    public function getGroup()
    {
        return $this->container['group'];
    }

    /**
     * Sets group
     * @param \PureCloudSDK\Group $group The group associated with the policy
     * @return $this
     */
    public function setGroup($group)
    {
        $this->container['group'] = $group;

        return $this;
    }

    /**
     * Gets enabled
     * @return bool
     */
    public function getEnabled()
    {
        return $this->container['enabled'];
    }

    /**
     * Sets enabled
     * @param bool $enabled Whether voicemail is enabled for the group
     * @return $this
     */
    public function setEnabled($enabled)
    {
        $this->container['enabled'] = $enabled;

        return $this;
    }

    /**
     * Gets sendEmailNotifications
     * @return bool
     */
    public function getSendEmailNotifications()
    {
        return $this->container['sendEmailNotifications'];
    }

    /**
     * Sets sendEmailNotifications
     * @param bool $sendEmailNotifications Whether email notifications are sent to group members when a new voicemail is received
     * @return $this
     */
    public function setSendEmailNotifications($sendEmailNotifications)
    {
        $this->container['sendEmailNotifications'] = $sendEmailNotifications;

        return $this;
    }

    /**
     * Gets rotateCallsSecs
     * @return int
     */
    public function getRotateCallsSecs()
    {
        return $this->container['rotateCallsSecs'];
    }

    /**
     * Sets rotateCallsSecs
     * @param int $rotateCallsSecs How many seconds to ring before rotating to the next member in the group
     * @return $this
     */
    public function setRotateCallsSecs($rotateCallsSecs)
    {
        $this->container['rotateCallsSecs'] = $rotateCallsSecs;

        return $this;
    }

    /**
     * Gets stopRingingAfterRotations
     * @return int
     */
    public function getStopRingingAfterRotations()
    {
        return $this->container['stopRingingAfterRotations'];
    }

    /**
     * Sets stopRingingAfterRotations
     * @param int $stopRingingAfterRotations How many rotations to go through
     * @return $this
     */
    public function setStopRingingAfterRotations($stopRingingAfterRotations)
    {
        $this->container['stopRingingAfterRotations'] = $stopRingingAfterRotations;

        return $this;
    }

    /**
     * Gets overflowGroupId
     * @return string
     */
    public function getOverflowGroupId()
    {
        return $this->container['overflowGroupId'];
    }

    /**
     * Sets overflowGroupId
     * @param string $overflowGroupId A fallback group to contact when all of the members in this group did not answer the call.
     * @return $this
     */
    public function setOverflowGroupId($overflowGroupId)
    {
        $this->container['overflowGroupId'] = $overflowGroupId;

        return $this;
    }

    /**
     * Gets groupAlertType
     * @return string
     */
    public function getGroupAlertType()
    {
        return $this->container['groupAlertType'];
    }

    /**
     * Sets groupAlertType
     * @param string $groupAlertType Specifies if the members in this group should be contacted randomly, in a specific order, or by round-robin.
     * @return $this
     */
    public function setGroupAlertType($groupAlertType)
    {
        $allowed_values = array('RANDOM', 'ROUND_ROBIN', 'SEQUENTIAL');
        if (!in_array($groupAlertType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'groupAlertType', must be one of 'RANDOM', 'ROUND_ROBIN', 'SEQUENTIAL'");
        }
        $this->container['groupAlertType'] = $groupAlertType;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
