<?php

/**
 * WfmUserNotification
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * WfmUserNotification Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class WfmUserNotification implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'WfmUserNotification';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'mutableGroupId' => 'string',
        'timestamp' => '\DateTime',
        'type' => 'string',
        'shiftTrade' => '\PureCloudSDK\ShiftTradeNotification',
        'timeOffRequest' => '\PureCloudSDK\TimeOffRequestNotification',
        'markedAsRead' => 'bool',
        'agentNotification' => 'bool',
        'otherNotificationIdsInGroup' => 'string[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'mutableGroupId' => 'mutableGroupId',
        'timestamp' => 'timestamp',
        'type' => 'type',
        'shiftTrade' => 'shiftTrade',
        'timeOffRequest' => 'timeOffRequest',
        'markedAsRead' => 'markedAsRead',
        'agentNotification' => 'agentNotification',
        'otherNotificationIdsInGroup' => 'otherNotificationIdsInGroup'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'mutableGroupId' => 'setMutableGroupId',
        'timestamp' => 'setTimestamp',
        'type' => 'setType',
        'shiftTrade' => 'setShiftTrade',
        'timeOffRequest' => 'setTimeOffRequest',
        'markedAsRead' => 'setMarkedAsRead',
        'agentNotification' => 'setAgentNotification',
        'otherNotificationIdsInGroup' => 'setOtherNotificationIdsInGroup'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'mutableGroupId' => 'getMutableGroupId',
        'timestamp' => 'getTimestamp',
        'type' => 'getType',
        'shiftTrade' => 'getShiftTrade',
        'timeOffRequest' => 'getTimeOffRequest',
        'markedAsRead' => 'getMarkedAsRead',
        'agentNotification' => 'getAgentNotification',
        'otherNotificationIdsInGroup' => 'getOtherNotificationIdsInGroup'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const TYPE_SHIFT_TRADE = 'ShiftTrade';
    public const TYPE_TIME_OFF_REQUEST = 'TimeOffRequest';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_SHIFT_TRADE,
            self::TYPE_TIME_OFF_REQUEST,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['mutableGroupId'] = isset($data['mutableGroupId']) ? $data['mutableGroupId'] : null;
        $this->container['timestamp'] = isset($data['timestamp']) ? $data['timestamp'] : null;
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['shiftTrade'] = isset($data['shiftTrade']) ? $data['shiftTrade'] : null;
        $this->container['timeOffRequest'] = isset($data['timeOffRequest']) ? $data['timeOffRequest'] : null;
        $this->container['markedAsRead'] = isset($data['markedAsRead']) ? $data['markedAsRead'] : null;
        $this->container['agentNotification'] = isset($data['agentNotification']) ? $data['agentNotification'] : null;
        $this->container['otherNotificationIdsInGroup'] = isset($data['otherNotificationIdsInGroup']) ? $data['otherNotificationIdsInGroup'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['id'] === null) {
            $invalid_properties[] = "'id' can't be null";
        }
        if ($this->container['mutableGroupId'] === null) {
            $invalid_properties[] = "'mutableGroupId' can't be null";
        }
        $allowed_values = array("ShiftTrade", "TimeOffRequest");
        if (!in_array($this->container['type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'type', must be one of #{allowed_values}.";
        }

        if ($this->container['markedAsRead'] === null) {
            $invalid_properties[] = "'markedAsRead' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['id'] === null) {
            return false;
        }
        if ($this->container['mutableGroupId'] === null) {
            return false;
        }
        $allowed_values = array("ShiftTrade", "TimeOffRequest");
        if (!in_array($this->container['type'], $allowed_values)) {
            return false;
        }
        if ($this->container['markedAsRead'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The immutable globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets mutableGroupId
     * @return string
     */
    public function getMutableGroupId()
    {
        return $this->container['mutableGroupId'];
    }

    /**
     * Sets mutableGroupId
     * @param string $mutableGroupId The group ID of the notification (mutable, may change  on update)
     * @return $this
     */
    public function setMutableGroupId($mutableGroupId)
    {
        $this->container['mutableGroupId'] = $mutableGroupId;

        return $this;
    }

    /**
     * Gets timestamp
     * @return \DateTime
     */
    public function getTimestamp()
    {
        return $this->container['timestamp'];
    }

    /**
     * Sets timestamp
     * @param \DateTime $timestamp The timestamp for this notification. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setTimestamp($timestamp)
    {
        $this->container['timestamp'] = $timestamp;

        return $this;
    }

    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type The type of this notification
     * @return $this
     */
    public function setType($type)
    {
        $allowed_values = array('ShiftTrade', 'TimeOffRequest');
        if (!in_array($type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'type', must be one of 'ShiftTrade', 'TimeOffRequest'");
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets shiftTrade
     * @return \PureCloudSDK\ShiftTradeNotification
     */
    public function getShiftTrade()
    {
        return $this->container['shiftTrade'];
    }

    /**
     * Sets shiftTrade
     * @param \PureCloudSDK\ShiftTradeNotification $shiftTrade A shift trade notification.  Only set if type == ShiftTrade
     * @return $this
     */
    public function setShiftTrade($shiftTrade)
    {
        $this->container['shiftTrade'] = $shiftTrade;

        return $this;
    }

    /**
     * Gets timeOffRequest
     * @return \PureCloudSDK\TimeOffRequestNotification
     */
    public function getTimeOffRequest()
    {
        return $this->container['timeOffRequest'];
    }

    /**
     * Sets timeOffRequest
     * @param \PureCloudSDK\TimeOffRequestNotification $timeOffRequest A time off request notification.  Only set if type == TimeOffRequest
     * @return $this
     */
    public function setTimeOffRequest($timeOffRequest)
    {
        $this->container['timeOffRequest'] = $timeOffRequest;

        return $this;
    }

    /**
     * Gets markedAsRead
     * @return bool
     */
    public function getMarkedAsRead()
    {
        return $this->container['markedAsRead'];
    }

    /**
     * Sets markedAsRead
     * @param bool $markedAsRead Whether this notification has been marked \"read\"
     * @return $this
     */
    public function setMarkedAsRead($markedAsRead)
    {
        $this->container['markedAsRead'] = $markedAsRead;

        return $this;
    }

    /**
     * Gets agentNotification
     * @return bool
     */
    public function getAgentNotification()
    {
        return $this->container['agentNotification'];
    }

    /**
     * Sets agentNotification
     * @param bool $agentNotification Whether this notification is for an agent
     * @return $this
     */
    public function setAgentNotification($agentNotification)
    {
        $this->container['agentNotification'] = $agentNotification;

        return $this;
    }

    /**
     * Gets otherNotificationIdsInGroup
     * @return string[]
     */
    public function getOtherNotificationIdsInGroup()
    {
        return $this->container['otherNotificationIdsInGroup'];
    }

    /**
     * Sets otherNotificationIdsInGroup
     * @param string[] $otherNotificationIdsInGroup Other notification IDs in group.  This field is only populated in real-time notifications
     * @return $this
     */
    public function setOtherNotificationIdsInGroup($otherNotificationIdsInGroup)
    {
        $this->container['otherNotificationIdsInGroup'] = $otherNotificationIdsInGroup;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
