<?php
/**
 * AnalyticsConversationSegment
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * AnalyticsConversationSegment Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class AnalyticsConversationSegment implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'AnalyticsConversationSegment';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'segmentStart' => '\DateTime',
        'segmentEnd' => '\DateTime',
        'queueId' => 'string',
        'wrapUpCode' => 'string',
        'wrapUpNote' => 'string',
        'wrapUpTags' => 'string[]',
        'errorCode' => 'string',
        'disconnectType' => 'string',
        'segmentType' => 'string',
        'requestedRoutingUserIds' => 'string[]',
        'requestedRoutingSkillIds' => 'string[]',
        'requestedLanguageId' => 'string',
        'properties' => '\PureCloudSDK\AnalyticsProperty[]',
        'sourceConversationId' => 'string',
        'destinationConversationId' => 'string',
        'sourceSessionId' => 'string',
        'destinationSessionId' => 'string',
        'sipResponseCodes' => 'int[]',
        'q850ResponseCodes' => 'int[]',
        'conference' => 'bool',
        'groupId' => 'string',
        'subject' => 'string',
        'audioMuted' => 'bool',
        'videoMuted' => 'bool'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'segmentStart' => 'segmentStart',
        'segmentEnd' => 'segmentEnd',
        'queueId' => 'queueId',
        'wrapUpCode' => 'wrapUpCode',
        'wrapUpNote' => 'wrapUpNote',
        'wrapUpTags' => 'wrapUpTags',
        'errorCode' => 'errorCode',
        'disconnectType' => 'disconnectType',
        'segmentType' => 'segmentType',
        'requestedRoutingUserIds' => 'requestedRoutingUserIds',
        'requestedRoutingSkillIds' => 'requestedRoutingSkillIds',
        'requestedLanguageId' => 'requestedLanguageId',
        'properties' => 'properties',
        'sourceConversationId' => 'sourceConversationId',
        'destinationConversationId' => 'destinationConversationId',
        'sourceSessionId' => 'sourceSessionId',
        'destinationSessionId' => 'destinationSessionId',
        'sipResponseCodes' => 'sipResponseCodes',
        'q850ResponseCodes' => 'q850ResponseCodes',
        'conference' => 'conference',
        'groupId' => 'groupId',
        'subject' => 'subject',
        'audioMuted' => 'audioMuted',
        'videoMuted' => 'videoMuted'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'segmentStart' => 'setSegmentStart',
        'segmentEnd' => 'setSegmentEnd',
        'queueId' => 'setQueueId',
        'wrapUpCode' => 'setWrapUpCode',
        'wrapUpNote' => 'setWrapUpNote',
        'wrapUpTags' => 'setWrapUpTags',
        'errorCode' => 'setErrorCode',
        'disconnectType' => 'setDisconnectType',
        'segmentType' => 'setSegmentType',
        'requestedRoutingUserIds' => 'setRequestedRoutingUserIds',
        'requestedRoutingSkillIds' => 'setRequestedRoutingSkillIds',
        'requestedLanguageId' => 'setRequestedLanguageId',
        'properties' => 'setProperties',
        'sourceConversationId' => 'setSourceConversationId',
        'destinationConversationId' => 'setDestinationConversationId',
        'sourceSessionId' => 'setSourceSessionId',
        'destinationSessionId' => 'setDestinationSessionId',
        'sipResponseCodes' => 'setSipResponseCodes',
        'q850ResponseCodes' => 'setQ850ResponseCodes',
        'conference' => 'setConference',
        'groupId' => 'setGroupId',
        'subject' => 'setSubject',
        'audioMuted' => 'setAudioMuted',
        'videoMuted' => 'setVideoMuted'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'segmentStart' => 'getSegmentStart',
        'segmentEnd' => 'getSegmentEnd',
        'queueId' => 'getQueueId',
        'wrapUpCode' => 'getWrapUpCode',
        'wrapUpNote' => 'getWrapUpNote',
        'wrapUpTags' => 'getWrapUpTags',
        'errorCode' => 'getErrorCode',
        'disconnectType' => 'getDisconnectType',
        'segmentType' => 'getSegmentType',
        'requestedRoutingUserIds' => 'getRequestedRoutingUserIds',
        'requestedRoutingSkillIds' => 'getRequestedRoutingSkillIds',
        'requestedLanguageId' => 'getRequestedLanguageId',
        'properties' => 'getProperties',
        'sourceConversationId' => 'getSourceConversationId',
        'destinationConversationId' => 'getDestinationConversationId',
        'sourceSessionId' => 'getSourceSessionId',
        'destinationSessionId' => 'getDestinationSessionId',
        'sipResponseCodes' => 'getSipResponseCodes',
        'q850ResponseCodes' => 'getQ850ResponseCodes',
        'conference' => 'getConference',
        'groupId' => 'getGroupId',
        'subject' => 'getSubject',
        'audioMuted' => 'getAudioMuted',
        'videoMuted' => 'getVideoMuted'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const DISCONNECT_TYPE_ENDPOINT = 'endpoint';
    const DISCONNECT_TYPE_CLIENT = 'client';
    const DISCONNECT_TYPE_SYSTEM = 'system';
    const DISCONNECT_TYPE_TRANSFER = 'transfer';
    const DISCONNECT_TYPE_ERROR = 'error';
    const DISCONNECT_TYPE_PEER = 'peer';
    const DISCONNECT_TYPE_OTHER = 'other';
    const DISCONNECT_TYPE_SPAM = 'spam';
    const DISCONNECT_TYPE_TRANSPORT_FAILURE = 'transportFailure';
    const DISCONNECT_TYPE_CONFERENCE_TRANSFER = 'conferenceTransfer';
    const DISCONNECT_TYPE_CONSULT_TRANSFER = 'consultTransfer';
    const DISCONNECT_TYPE_FORWARD_TRANSFER = 'forwardTransfer';
    const SEGMENT_TYPE_UNKNOWN = 'unknown';
    const SEGMENT_TYPE_ALERT = 'alert';
    const SEGMENT_TYPE_SYSTEM = 'system';
    const SEGMENT_TYPE_DELAY = 'delay';
    const SEGMENT_TYPE_HOLD = 'hold';
    const SEGMENT_TYPE_INTERACT = 'interact';
    const SEGMENT_TYPE_IVR = 'ivr';
    const SEGMENT_TYPE_DIALING = 'dialing';
    const SEGMENT_TYPE_WRAPUP = 'wrapup';
    const SEGMENT_TYPE_VOICEMAIL = 'voicemail';
    const SEGMENT_TYPE_SCHEDULED = 'scheduled';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDisconnectTypeAllowableValues()
    {
        return [
            self::DISCONNECT_TYPE_ENDPOINT,
            self::DISCONNECT_TYPE_CLIENT,
            self::DISCONNECT_TYPE_SYSTEM,
            self::DISCONNECT_TYPE_TRANSFER,
            self::DISCONNECT_TYPE_ERROR,
            self::DISCONNECT_TYPE_PEER,
            self::DISCONNECT_TYPE_OTHER,
            self::DISCONNECT_TYPE_SPAM,
            self::DISCONNECT_TYPE_TRANSPORT_FAILURE,
            self::DISCONNECT_TYPE_CONFERENCE_TRANSFER,
            self::DISCONNECT_TYPE_CONSULT_TRANSFER,
            self::DISCONNECT_TYPE_FORWARD_TRANSFER,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getSegmentTypeAllowableValues()
    {
        return [
            self::SEGMENT_TYPE_UNKNOWN,
            self::SEGMENT_TYPE_ALERT,
            self::SEGMENT_TYPE_SYSTEM,
            self::SEGMENT_TYPE_DELAY,
            self::SEGMENT_TYPE_HOLD,
            self::SEGMENT_TYPE_INTERACT,
            self::SEGMENT_TYPE_IVR,
            self::SEGMENT_TYPE_DIALING,
            self::SEGMENT_TYPE_WRAPUP,
            self::SEGMENT_TYPE_VOICEMAIL,
            self::SEGMENT_TYPE_SCHEDULED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['segmentStart'] = isset($data['segmentStart']) ? $data['segmentStart'] : null;
        $this->container['segmentEnd'] = isset($data['segmentEnd']) ? $data['segmentEnd'] : null;
        $this->container['queueId'] = isset($data['queueId']) ? $data['queueId'] : null;
        $this->container['wrapUpCode'] = isset($data['wrapUpCode']) ? $data['wrapUpCode'] : null;
        $this->container['wrapUpNote'] = isset($data['wrapUpNote']) ? $data['wrapUpNote'] : null;
        $this->container['wrapUpTags'] = isset($data['wrapUpTags']) ? $data['wrapUpTags'] : null;
        $this->container['errorCode'] = isset($data['errorCode']) ? $data['errorCode'] : null;
        $this->container['disconnectType'] = isset($data['disconnectType']) ? $data['disconnectType'] : null;
        $this->container['segmentType'] = isset($data['segmentType']) ? $data['segmentType'] : null;
        $this->container['requestedRoutingUserIds'] = isset($data['requestedRoutingUserIds']) ? $data['requestedRoutingUserIds'] : null;
        $this->container['requestedRoutingSkillIds'] = isset($data['requestedRoutingSkillIds']) ? $data['requestedRoutingSkillIds'] : null;
        $this->container['requestedLanguageId'] = isset($data['requestedLanguageId']) ? $data['requestedLanguageId'] : null;
        $this->container['properties'] = isset($data['properties']) ? $data['properties'] : null;
        $this->container['sourceConversationId'] = isset($data['sourceConversationId']) ? $data['sourceConversationId'] : null;
        $this->container['destinationConversationId'] = isset($data['destinationConversationId']) ? $data['destinationConversationId'] : null;
        $this->container['sourceSessionId'] = isset($data['sourceSessionId']) ? $data['sourceSessionId'] : null;
        $this->container['destinationSessionId'] = isset($data['destinationSessionId']) ? $data['destinationSessionId'] : null;
        $this->container['sipResponseCodes'] = isset($data['sipResponseCodes']) ? $data['sipResponseCodes'] : null;
        $this->container['q850ResponseCodes'] = isset($data['q850ResponseCodes']) ? $data['q850ResponseCodes'] : null;
        $this->container['conference'] = isset($data['conference']) ? $data['conference'] : false;
        $this->container['groupId'] = isset($data['groupId']) ? $data['groupId'] : null;
        $this->container['subject'] = isset($data['subject']) ? $data['subject'] : null;
        $this->container['audioMuted'] = isset($data['audioMuted']) ? $data['audioMuted'] : false;
        $this->container['videoMuted'] = isset($data['videoMuted']) ? $data['videoMuted'] : false;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("endpoint", "client", "system", "transfer", "error", "peer", "other", "spam", "transportFailure", "conferenceTransfer", "consultTransfer", "forwardTransfer");
        if (!in_array($this->container['disconnectType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'disconnectType', must be one of #{allowed_values}.";
        }

        $allowed_values = array("unknown", "alert", "system", "delay", "hold", "interact", "ivr", "dialing", "wrapup", "voicemail", "scheduled");
        if (!in_array($this->container['segmentType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'segmentType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("endpoint", "client", "system", "transfer", "error", "peer", "other", "spam", "transportFailure", "conferenceTransfer", "consultTransfer", "forwardTransfer");
        if (!in_array($this->container['disconnectType'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("unknown", "alert", "system", "delay", "hold", "interact", "ivr", "dialing", "wrapup", "voicemail", "scheduled");
        if (!in_array($this->container['segmentType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets segmentStart
     * @return \DateTime
     */
    public function getSegmentStart()
    {
        return $this->container['segmentStart'];
    }

    /**
     * Sets segmentStart
     * @param \DateTime $segmentStart Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setSegmentStart($segmentStart)
    {
        $this->container['segmentStart'] = $segmentStart;

        return $this;
    }

    /**
     * Gets segmentEnd
     * @return \DateTime
     */
    public function getSegmentEnd()
    {
        return $this->container['segmentEnd'];
    }

    /**
     * Sets segmentEnd
     * @param \DateTime $segmentEnd Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setSegmentEnd($segmentEnd)
    {
        $this->container['segmentEnd'] = $segmentEnd;

        return $this;
    }

    /**
     * Gets queueId
     * @return string
     */
    public function getQueueId()
    {
        return $this->container['queueId'];
    }

    /**
     * Sets queueId
     * @param string $queueId
     * @return $this
     */
    public function setQueueId($queueId)
    {
        $this->container['queueId'] = $queueId;

        return $this;
    }

    /**
     * Gets wrapUpCode
     * @return string
     */
    public function getWrapUpCode()
    {
        return $this->container['wrapUpCode'];
    }

    /**
     * Sets wrapUpCode
     * @param string $wrapUpCode
     * @return $this
     */
    public function setWrapUpCode($wrapUpCode)
    {
        $this->container['wrapUpCode'] = $wrapUpCode;

        return $this;
    }

    /**
     * Gets wrapUpNote
     * @return string
     */
    public function getWrapUpNote()
    {
        return $this->container['wrapUpNote'];
    }

    /**
     * Sets wrapUpNote
     * @param string $wrapUpNote
     * @return $this
     */
    public function setWrapUpNote($wrapUpNote)
    {
        $this->container['wrapUpNote'] = $wrapUpNote;

        return $this;
    }

    /**
     * Gets wrapUpTags
     * @return string[]
     */
    public function getWrapUpTags()
    {
        return $this->container['wrapUpTags'];
    }

    /**
     * Sets wrapUpTags
     * @param string[] $wrapUpTags
     * @return $this
     */
    public function setWrapUpTags($wrapUpTags)
    {
        $this->container['wrapUpTags'] = $wrapUpTags;

        return $this;
    }

    /**
     * Gets errorCode
     * @return string
     */
    public function getErrorCode()
    {
        return $this->container['errorCode'];
    }

    /**
     * Sets errorCode
     * @param string $errorCode
     * @return $this
     */
    public function setErrorCode($errorCode)
    {
        $this->container['errorCode'] = $errorCode;

        return $this;
    }

    /**
     * Gets disconnectType
     * @return string
     */
    public function getDisconnectType()
    {
        return $this->container['disconnectType'];
    }

    /**
     * Sets disconnectType
     * @param string $disconnectType
     * @return $this
     */
    public function setDisconnectType($disconnectType)
    {
        $allowed_values = array('endpoint', 'client', 'system', 'transfer', 'error', 'peer', 'other', 'spam', 'transportFailure', 'conferenceTransfer', 'consultTransfer', 'forwardTransfer');
        if (!in_array($disconnectType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'disconnectType', must be one of 'endpoint', 'client', 'system', 'transfer', 'error', 'peer', 'other', 'spam', 'transportFailure', 'conferenceTransfer', 'consultTransfer', 'forwardTransfer'");
        }
        $this->container['disconnectType'] = $disconnectType;

        return $this;
    }

    /**
     * Gets segmentType
     * @return string
     */
    public function getSegmentType()
    {
        return $this->container['segmentType'];
    }

    /**
     * Sets segmentType
     * @param string $segmentType
     * @return $this
     */
    public function setSegmentType($segmentType)
    {
        $allowed_values = array('unknown', 'alert', 'system', 'delay', 'hold', 'interact', 'ivr', 'dialing', 'wrapup', 'voicemail', 'scheduled');
        if (!in_array($segmentType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'segmentType', must be one of 'unknown', 'alert', 'system', 'delay', 'hold', 'interact', 'ivr', 'dialing', 'wrapup', 'voicemail', 'scheduled'");
        }
        $this->container['segmentType'] = $segmentType;

        return $this;
    }

    /**
     * Gets requestedRoutingUserIds
     * @return string[]
     */
    public function getRequestedRoutingUserIds()
    {
        return $this->container['requestedRoutingUserIds'];
    }

    /**
     * Sets requestedRoutingUserIds
     * @param string[] $requestedRoutingUserIds
     * @return $this
     */
    public function setRequestedRoutingUserIds($requestedRoutingUserIds)
    {
        $this->container['requestedRoutingUserIds'] = $requestedRoutingUserIds;

        return $this;
    }

    /**
     * Gets requestedRoutingSkillIds
     * @return string[]
     */
    public function getRequestedRoutingSkillIds()
    {
        return $this->container['requestedRoutingSkillIds'];
    }

    /**
     * Sets requestedRoutingSkillIds
     * @param string[] $requestedRoutingSkillIds
     * @return $this
     */
    public function setRequestedRoutingSkillIds($requestedRoutingSkillIds)
    {
        $this->container['requestedRoutingSkillIds'] = $requestedRoutingSkillIds;

        return $this;
    }

    /**
     * Gets requestedLanguageId
     * @return string
     */
    public function getRequestedLanguageId()
    {
        return $this->container['requestedLanguageId'];
    }

    /**
     * Sets requestedLanguageId
     * @param string $requestedLanguageId
     * @return $this
     */
    public function setRequestedLanguageId($requestedLanguageId)
    {
        $this->container['requestedLanguageId'] = $requestedLanguageId;

        return $this;
    }

    /**
     * Gets properties
     * @return \PureCloudSDK\AnalyticsProperty[]
     */
    public function getProperties()
    {
        return $this->container['properties'];
    }

    /**
     * Sets properties
     * @param \PureCloudSDK\AnalyticsProperty[] $properties
     * @return $this
     */
    public function setProperties($properties)
    {
        $this->container['properties'] = $properties;

        return $this;
    }

    /**
     * Gets sourceConversationId
     * @return string
     */
    public function getSourceConversationId()
    {
        return $this->container['sourceConversationId'];
    }

    /**
     * Sets sourceConversationId
     * @param string $sourceConversationId
     * @return $this
     */
    public function setSourceConversationId($sourceConversationId)
    {
        $this->container['sourceConversationId'] = $sourceConversationId;

        return $this;
    }

    /**
     * Gets destinationConversationId
     * @return string
     */
    public function getDestinationConversationId()
    {
        return $this->container['destinationConversationId'];
    }

    /**
     * Sets destinationConversationId
     * @param string $destinationConversationId
     * @return $this
     */
    public function setDestinationConversationId($destinationConversationId)
    {
        $this->container['destinationConversationId'] = $destinationConversationId;

        return $this;
    }

    /**
     * Gets sourceSessionId
     * @return string
     */
    public function getSourceSessionId()
    {
        return $this->container['sourceSessionId'];
    }

    /**
     * Sets sourceSessionId
     * @param string $sourceSessionId
     * @return $this
     */
    public function setSourceSessionId($sourceSessionId)
    {
        $this->container['sourceSessionId'] = $sourceSessionId;

        return $this;
    }

    /**
     * Gets destinationSessionId
     * @return string
     */
    public function getDestinationSessionId()
    {
        return $this->container['destinationSessionId'];
    }

    /**
     * Sets destinationSessionId
     * @param string $destinationSessionId
     * @return $this
     */
    public function setDestinationSessionId($destinationSessionId)
    {
        $this->container['destinationSessionId'] = $destinationSessionId;

        return $this;
    }

    /**
     * Gets sipResponseCodes
     * @return int[]
     */
    public function getSipResponseCodes()
    {
        return $this->container['sipResponseCodes'];
    }

    /**
     * Sets sipResponseCodes
     * @param int[] $sipResponseCodes
     * @return $this
     */
    public function setSipResponseCodes($sipResponseCodes)
    {
        $this->container['sipResponseCodes'] = $sipResponseCodes;

        return $this;
    }

    /**
     * Gets q850ResponseCodes
     * @return int[]
     */
    public function getQ850ResponseCodes()
    {
        return $this->container['q850ResponseCodes'];
    }

    /**
     * Sets q850ResponseCodes
     * @param int[] $q850ResponseCodes
     * @return $this
     */
    public function setQ850ResponseCodes($q850ResponseCodes)
    {
        $this->container['q850ResponseCodes'] = $q850ResponseCodes;

        return $this;
    }

    /**
     * Gets conference
     * @return bool
     */
    public function getConference()
    {
        return $this->container['conference'];
    }

    /**
     * Sets conference
     * @param bool $conference
     * @return $this
     */
    public function setConference($conference)
    {
        $this->container['conference'] = $conference;

        return $this;
    }

    /**
     * Gets groupId
     * @return string
     */
    public function getGroupId()
    {
        return $this->container['groupId'];
    }

    /**
     * Sets groupId
     * @param string $groupId
     * @return $this
     */
    public function setGroupId($groupId)
    {
        $this->container['groupId'] = $groupId;

        return $this;
    }

    /**
     * Gets subject
     * @return string
     */
    public function getSubject()
    {
        return $this->container['subject'];
    }

    /**
     * Sets subject
     * @param string $subject
     * @return $this
     */
    public function setSubject($subject)
    {
        $this->container['subject'] = $subject;

        return $this;
    }

    /**
     * Gets audioMuted
     * @return bool
     */
    public function getAudioMuted()
    {
        return $this->container['audioMuted'];
    }

    /**
     * Sets audioMuted
     * @param bool $audioMuted
     * @return $this
     */
    public function setAudioMuted($audioMuted)
    {
        $this->container['audioMuted'] = $audioMuted;

        return $this;
    }

    /**
     * Gets videoMuted
     * @return bool
     */
    public function getVideoMuted()
    {
        return $this->container['videoMuted'];
    }

    /**
     * Sets videoMuted
     * @param bool $videoMuted
     * @return $this
     */
    public function setVideoMuted($videoMuted)
    {
        $this->container['videoMuted'] = $videoMuted;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


