<?php
/**
 * CampaignInteraction
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * CampaignInteraction Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CampaignInteraction implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CampaignInteraction';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'campaign' => '\PureCloudSDK\UriReference',
        'agent' => '\PureCloudSDK\UriReference',
        'contact' => '\PureCloudSDK\UriReference',
        'destinationAddress' => 'string',
        'activePreviewCall' => 'bool',
        'lastActivePreviewWrapupTime' => '\DateTime',
        'creationTime' => '\DateTime',
        'callPlacedTime' => '\DateTime',
        'callRoutedTime' => '\DateTime',
        'previewConnectedTime' => '\DateTime',
        'queue' => '\PureCloudSDK\UriReference',
        'script' => '\PureCloudSDK\UriReference',
        'disposition' => 'string',
        'callerName' => 'string',
        'callerAddress' => 'string',
        'previewPopDeliveredTime' => '\DateTime',
        'conversation' => '\PureCloudSDK\Conversation',
        'dialerSystemParticipantId' => 'string',
        'dialingMode' => 'string',
        'skills' => '\PureCloudSDK\UriReference[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'campaign' => 'campaign',
        'agent' => 'agent',
        'contact' => 'contact',
        'destinationAddress' => 'destinationAddress',
        'activePreviewCall' => 'activePreviewCall',
        'lastActivePreviewWrapupTime' => 'lastActivePreviewWrapupTime',
        'creationTime' => 'creationTime',
        'callPlacedTime' => 'callPlacedTime',
        'callRoutedTime' => 'callRoutedTime',
        'previewConnectedTime' => 'previewConnectedTime',
        'queue' => 'queue',
        'script' => 'script',
        'disposition' => 'disposition',
        'callerName' => 'callerName',
        'callerAddress' => 'callerAddress',
        'previewPopDeliveredTime' => 'previewPopDeliveredTime',
        'conversation' => 'conversation',
        'dialerSystemParticipantId' => 'dialerSystemParticipantId',
        'dialingMode' => 'dialingMode',
        'skills' => 'skills'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'campaign' => 'setCampaign',
        'agent' => 'setAgent',
        'contact' => 'setContact',
        'destinationAddress' => 'setDestinationAddress',
        'activePreviewCall' => 'setActivePreviewCall',
        'lastActivePreviewWrapupTime' => 'setLastActivePreviewWrapupTime',
        'creationTime' => 'setCreationTime',
        'callPlacedTime' => 'setCallPlacedTime',
        'callRoutedTime' => 'setCallRoutedTime',
        'previewConnectedTime' => 'setPreviewConnectedTime',
        'queue' => 'setQueue',
        'script' => 'setScript',
        'disposition' => 'setDisposition',
        'callerName' => 'setCallerName',
        'callerAddress' => 'setCallerAddress',
        'previewPopDeliveredTime' => 'setPreviewPopDeliveredTime',
        'conversation' => 'setConversation',
        'dialerSystemParticipantId' => 'setDialerSystemParticipantId',
        'dialingMode' => 'setDialingMode',
        'skills' => 'setSkills'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'campaign' => 'getCampaign',
        'agent' => 'getAgent',
        'contact' => 'getContact',
        'destinationAddress' => 'getDestinationAddress',
        'activePreviewCall' => 'getActivePreviewCall',
        'lastActivePreviewWrapupTime' => 'getLastActivePreviewWrapupTime',
        'creationTime' => 'getCreationTime',
        'callPlacedTime' => 'getCallPlacedTime',
        'callRoutedTime' => 'getCallRoutedTime',
        'previewConnectedTime' => 'getPreviewConnectedTime',
        'queue' => 'getQueue',
        'script' => 'getScript',
        'disposition' => 'getDisposition',
        'callerName' => 'getCallerName',
        'callerAddress' => 'getCallerAddress',
        'previewPopDeliveredTime' => 'getPreviewPopDeliveredTime',
        'conversation' => 'getConversation',
        'dialerSystemParticipantId' => 'getDialerSystemParticipantId',
        'dialingMode' => 'getDialingMode',
        'skills' => 'getSkills'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const DISPOSITION_DISCONNECT = 'DISCONNECT';
    const DISPOSITION_LIVE_VOICE = 'LIVE_VOICE';
    const DISPOSITION_BUSY = 'BUSY';
    const DISPOSITION_MACHINE = 'MACHINE';
    const DISPOSITION_NO_ANSWER = 'NO_ANSWER';
    const DISPOSITION_SIT_CALLABLE = 'SIT_CALLABLE';
    const DISPOSITION_SIT_UNCALLABLE = 'SIT_UNCALLABLE';
    const DISPOSITION_FAX = 'FAX';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDispositionAllowableValues()
    {
        return [
            self::DISPOSITION_DISCONNECT,
            self::DISPOSITION_LIVE_VOICE,
            self::DISPOSITION_BUSY,
            self::DISPOSITION_MACHINE,
            self::DISPOSITION_NO_ANSWER,
            self::DISPOSITION_SIT_CALLABLE,
            self::DISPOSITION_SIT_UNCALLABLE,
            self::DISPOSITION_FAX,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['campaign'] = isset($data['campaign']) ? $data['campaign'] : null;
        $this->container['agent'] = isset($data['agent']) ? $data['agent'] : null;
        $this->container['contact'] = isset($data['contact']) ? $data['contact'] : null;
        $this->container['destinationAddress'] = isset($data['destinationAddress']) ? $data['destinationAddress'] : null;
        $this->container['activePreviewCall'] = isset($data['activePreviewCall']) ? $data['activePreviewCall'] : false;
        $this->container['lastActivePreviewWrapupTime'] = isset($data['lastActivePreviewWrapupTime']) ? $data['lastActivePreviewWrapupTime'] : null;
        $this->container['creationTime'] = isset($data['creationTime']) ? $data['creationTime'] : null;
        $this->container['callPlacedTime'] = isset($data['callPlacedTime']) ? $data['callPlacedTime'] : null;
        $this->container['callRoutedTime'] = isset($data['callRoutedTime']) ? $data['callRoutedTime'] : null;
        $this->container['previewConnectedTime'] = isset($data['previewConnectedTime']) ? $data['previewConnectedTime'] : null;
        $this->container['queue'] = isset($data['queue']) ? $data['queue'] : null;
        $this->container['script'] = isset($data['script']) ? $data['script'] : null;
        $this->container['disposition'] = isset($data['disposition']) ? $data['disposition'] : null;
        $this->container['callerName'] = isset($data['callerName']) ? $data['callerName'] : null;
        $this->container['callerAddress'] = isset($data['callerAddress']) ? $data['callerAddress'] : null;
        $this->container['previewPopDeliveredTime'] = isset($data['previewPopDeliveredTime']) ? $data['previewPopDeliveredTime'] : null;
        $this->container['conversation'] = isset($data['conversation']) ? $data['conversation'] : null;
        $this->container['dialerSystemParticipantId'] = isset($data['dialerSystemParticipantId']) ? $data['dialerSystemParticipantId'] : null;
        $this->container['dialingMode'] = isset($data['dialingMode']) ? $data['dialingMode'] : null;
        $this->container['skills'] = isset($data['skills']) ? $data['skills'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("DISCONNECT", "LIVE_VOICE", "BUSY", "MACHINE", "NO_ANSWER", "SIT_CALLABLE", "SIT_UNCALLABLE", "FAX");
        if (!in_array($this->container['disposition'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'disposition', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("DISCONNECT", "LIVE_VOICE", "BUSY", "MACHINE", "NO_ANSWER", "SIT_CALLABLE", "SIT_UNCALLABLE", "FAX");
        if (!in_array($this->container['disposition'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets campaign
     * @return \PureCloudSDK\UriReference
     */
    public function getCampaign()
    {
        return $this->container['campaign'];
    }

    /**
     * Sets campaign
     * @param \PureCloudSDK\UriReference $campaign
     * @return $this
     */
    public function setCampaign($campaign)
    {
        $this->container['campaign'] = $campaign;

        return $this;
    }

    /**
     * Gets agent
     * @return \PureCloudSDK\UriReference
     */
    public function getAgent()
    {
        return $this->container['agent'];
    }

    /**
     * Sets agent
     * @param \PureCloudSDK\UriReference $agent
     * @return $this
     */
    public function setAgent($agent)
    {
        $this->container['agent'] = $agent;

        return $this;
    }

    /**
     * Gets contact
     * @return \PureCloudSDK\UriReference
     */
    public function getContact()
    {
        return $this->container['contact'];
    }

    /**
     * Sets contact
     * @param \PureCloudSDK\UriReference $contact
     * @return $this
     */
    public function setContact($contact)
    {
        $this->container['contact'] = $contact;

        return $this;
    }

    /**
     * Gets destinationAddress
     * @return string
     */
    public function getDestinationAddress()
    {
        return $this->container['destinationAddress'];
    }

    /**
     * Sets destinationAddress
     * @param string $destinationAddress
     * @return $this
     */
    public function setDestinationAddress($destinationAddress)
    {
        $this->container['destinationAddress'] = $destinationAddress;

        return $this;
    }

    /**
     * Gets activePreviewCall
     * @return bool
     */
    public function getActivePreviewCall()
    {
        return $this->container['activePreviewCall'];
    }

    /**
     * Sets activePreviewCall
     * @param bool $activePreviewCall Boolean value if there is an active preview call on the interaction
     * @return $this
     */
    public function setActivePreviewCall($activePreviewCall)
    {
        $this->container['activePreviewCall'] = $activePreviewCall;

        return $this;
    }

    /**
     * Gets lastActivePreviewWrapupTime
     * @return \DateTime
     */
    public function getLastActivePreviewWrapupTime()
    {
        return $this->container['lastActivePreviewWrapupTime'];
    }

    /**
     * Sets lastActivePreviewWrapupTime
     * @param \DateTime $lastActivePreviewWrapupTime The time when the last preview of the interaction was wrapped up. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setLastActivePreviewWrapupTime($lastActivePreviewWrapupTime)
    {
        $this->container['lastActivePreviewWrapupTime'] = $lastActivePreviewWrapupTime;

        return $this;
    }

    /**
     * Gets creationTime
     * @return \DateTime
     */
    public function getCreationTime()
    {
        return $this->container['creationTime'];
    }

    /**
     * Sets creationTime
     * @param \DateTime $creationTime The time when dialer created the interaction. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setCreationTime($creationTime)
    {
        $this->container['creationTime'] = $creationTime;

        return $this;
    }

    /**
     * Gets callPlacedTime
     * @return \DateTime
     */
    public function getCallPlacedTime()
    {
        return $this->container['callPlacedTime'];
    }

    /**
     * Sets callPlacedTime
     * @param \DateTime $callPlacedTime The time when the agent or system places the call. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setCallPlacedTime($callPlacedTime)
    {
        $this->container['callPlacedTime'] = $callPlacedTime;

        return $this;
    }

    /**
     * Gets callRoutedTime
     * @return \DateTime
     */
    public function getCallRoutedTime()
    {
        return $this->container['callRoutedTime'];
    }

    /**
     * Sets callRoutedTime
     * @param \DateTime $callRoutedTime The time when the agent was connected to the call. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setCallRoutedTime($callRoutedTime)
    {
        $this->container['callRoutedTime'] = $callRoutedTime;

        return $this;
    }

    /**
     * Gets previewConnectedTime
     * @return \DateTime
     */
    public function getPreviewConnectedTime()
    {
        return $this->container['previewConnectedTime'];
    }

    /**
     * Sets previewConnectedTime
     * @param \DateTime $previewConnectedTime The time when the customer and routing participant are connected. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setPreviewConnectedTime($previewConnectedTime)
    {
        $this->container['previewConnectedTime'] = $previewConnectedTime;

        return $this;
    }

    /**
     * Gets queue
     * @return \PureCloudSDK\UriReference
     */
    public function getQueue()
    {
        return $this->container['queue'];
    }

    /**
     * Sets queue
     * @param \PureCloudSDK\UriReference $queue
     * @return $this
     */
    public function setQueue($queue)
    {
        $this->container['queue'] = $queue;

        return $this;
    }

    /**
     * Gets script
     * @return \PureCloudSDK\UriReference
     */
    public function getScript()
    {
        return $this->container['script'];
    }

    /**
     * Sets script
     * @param \PureCloudSDK\UriReference $script
     * @return $this
     */
    public function setScript($script)
    {
        $this->container['script'] = $script;

        return $this;
    }

    /**
     * Gets disposition
     * @return string
     */
    public function getDisposition()
    {
        return $this->container['disposition'];
    }

    /**
     * Sets disposition
     * @param string $disposition Describes what happened with call analysis for instance: disposition.classification.callable.person, disposition.classification.callable.noanswer
     * @return $this
     */
    public function setDisposition($disposition)
    {
        $allowed_values = array('DISCONNECT', 'LIVE_VOICE', 'BUSY', 'MACHINE', 'NO_ANSWER', 'SIT_CALLABLE', 'SIT_UNCALLABLE', 'FAX');
        if (!in_array($disposition, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'disposition', must be one of 'DISCONNECT', 'LIVE_VOICE', 'BUSY', 'MACHINE', 'NO_ANSWER', 'SIT_CALLABLE', 'SIT_UNCALLABLE', 'FAX'");
        }
        $this->container['disposition'] = $disposition;

        return $this;
    }

    /**
     * Gets callerName
     * @return string
     */
    public function getCallerName()
    {
        return $this->container['callerName'];
    }

    /**
     * Sets callerName
     * @param string $callerName
     * @return $this
     */
    public function setCallerName($callerName)
    {
        $this->container['callerName'] = $callerName;

        return $this;
    }

    /**
     * Gets callerAddress
     * @return string
     */
    public function getCallerAddress()
    {
        return $this->container['callerAddress'];
    }

    /**
     * Sets callerAddress
     * @param string $callerAddress
     * @return $this
     */
    public function setCallerAddress($callerAddress)
    {
        $this->container['callerAddress'] = $callerAddress;

        return $this;
    }

    /**
     * Gets previewPopDeliveredTime
     * @return \DateTime
     */
    public function getPreviewPopDeliveredTime()
    {
        return $this->container['previewPopDeliveredTime'];
    }

    /**
     * Sets previewPopDeliveredTime
     * @param \DateTime $previewPopDeliveredTime Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setPreviewPopDeliveredTime($previewPopDeliveredTime)
    {
        $this->container['previewPopDeliveredTime'] = $previewPopDeliveredTime;

        return $this;
    }

    /**
     * Gets conversation
     * @return \PureCloudSDK\Conversation
     */
    public function getConversation()
    {
        return $this->container['conversation'];
    }

    /**
     * Sets conversation
     * @param \PureCloudSDK\Conversation $conversation
     * @return $this
     */
    public function setConversation($conversation)
    {
        $this->container['conversation'] = $conversation;

        return $this;
    }

    /**
     * Gets dialerSystemParticipantId
     * @return string
     */
    public function getDialerSystemParticipantId()
    {
        return $this->container['dialerSystemParticipantId'];
    }

    /**
     * Sets dialerSystemParticipantId
     * @param string $dialerSystemParticipantId conversation participant id that is the dialer system participant to monitor the call from dialer perspective
     * @return $this
     */
    public function setDialerSystemParticipantId($dialerSystemParticipantId)
    {
        $this->container['dialerSystemParticipantId'] = $dialerSystemParticipantId;

        return $this;
    }

    /**
     * Gets dialingMode
     * @return string
     */
    public function getDialingMode()
    {
        return $this->container['dialingMode'];
    }

    /**
     * Sets dialingMode
     * @param string $dialingMode
     * @return $this
     */
    public function setDialingMode($dialingMode)
    {
        $this->container['dialingMode'] = $dialingMode;

        return $this;
    }

    /**
     * Gets skills
     * @return \PureCloudSDK\UriReference[]
     */
    public function getSkills()
    {
        return $this->container['skills'];
    }

    /**
     * Sets skills
     * @param \PureCloudSDK\UriReference[] $skills Any skills that are attached to the call for routing
     * @return $this
     */
    public function setSkills($skills)
    {
        $this->container['skills'] = $skills;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


