<?php
/**
 * CustomerAccount
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * CustomerAccount Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CustomerAccount implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CustomerAccount';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'isFrozen' => 'bool',
        'orgLegalName' => 'string',
        'orgPhone' => 'string',
        'isTaxExempt' => 'bool',
        'billingAddress' => '\PureCloudSDK\BillingAddress',
        'currency' => 'string',
        'primaryPaymentMethodId' => 'string',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'isFrozen' => 'isFrozen',
        'orgLegalName' => 'orgLegalName',
        'orgPhone' => 'orgPhone',
        'isTaxExempt' => 'isTaxExempt',
        'billingAddress' => 'billingAddress',
        'currency' => 'currency',
        'primaryPaymentMethodId' => 'primaryPaymentMethodId',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'isFrozen' => 'setIsFrozen',
        'orgLegalName' => 'setOrgLegalName',
        'orgPhone' => 'setOrgPhone',
        'isTaxExempt' => 'setIsTaxExempt',
        'billingAddress' => 'setBillingAddress',
        'currency' => 'setCurrency',
        'primaryPaymentMethodId' => 'setPrimaryPaymentMethodId',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'isFrozen' => 'getIsFrozen',
        'orgLegalName' => 'getOrgLegalName',
        'orgPhone' => 'getOrgPhone',
        'isTaxExempt' => 'getIsTaxExempt',
        'billingAddress' => 'getBillingAddress',
        'currency' => 'getCurrency',
        'primaryPaymentMethodId' => 'getPrimaryPaymentMethodId',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['isFrozen'] = isset($data['isFrozen']) ? $data['isFrozen'] : false;
        $this->container['orgLegalName'] = isset($data['orgLegalName']) ? $data['orgLegalName'] : null;
        $this->container['orgPhone'] = isset($data['orgPhone']) ? $data['orgPhone'] : null;
        $this->container['isTaxExempt'] = isset($data['isTaxExempt']) ? $data['isTaxExempt'] : false;
        $this->container['billingAddress'] = isset($data['billingAddress']) ? $data['billingAddress'] : null;
        $this->container['currency'] = isset($data['currency']) ? $data['currency'] : null;
        $this->container['primaryPaymentMethodId'] = isset($data['primaryPaymentMethodId']) ? $data['primaryPaymentMethodId'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['isFrozen'] === null) {
            $invalid_properties[] = "'isFrozen' can't be null";
        }
        if ($this->container['orgLegalName'] === null) {
            $invalid_properties[] = "'orgLegalName' can't be null";
        }
        if ($this->container['orgPhone'] === null) {
            $invalid_properties[] = "'orgPhone' can't be null";
        }
        if ($this->container['isTaxExempt'] === null) {
            $invalid_properties[] = "'isTaxExempt' can't be null";
        }
        if ($this->container['billingAddress'] === null) {
            $invalid_properties[] = "'billingAddress' can't be null";
        }
        if ($this->container['currency'] === null) {
            $invalid_properties[] = "'currency' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['isFrozen'] === null) {
            return false;
        }
        if ($this->container['orgLegalName'] === null) {
            return false;
        }
        if ($this->container['orgPhone'] === null) {
            return false;
        }
        if ($this->container['isTaxExempt'] === null) {
            return false;
        }
        if ($this->container['billingAddress'] === null) {
            return false;
        }
        if ($this->container['currency'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets isFrozen
     * @return bool
     */
    public function getIsFrozen()
    {
        return $this->container['isFrozen'];
    }

    /**
     * Sets isFrozen
     * @param bool $isFrozen Indicates whether the account is currently frozen for review.
     * @return $this
     */
    public function setIsFrozen($isFrozen)
    {
        $this->container['isFrozen'] = $isFrozen;

        return $this;
    }

    /**
     * Gets orgLegalName
     * @return string
     */
    public function getOrgLegalName()
    {
        return $this->container['orgLegalName'];
    }

    /**
     * Sets orgLegalName
     * @param string $orgLegalName The organization legal name.
     * @return $this
     */
    public function setOrgLegalName($orgLegalName)
    {
        $this->container['orgLegalName'] = $orgLegalName;

        return $this;
    }

    /**
     * Gets orgPhone
     * @return string
     */
    public function getOrgPhone()
    {
        return $this->container['orgPhone'];
    }

    /**
     * Sets orgPhone
     * @param string $orgPhone The organization phone number.
     * @return $this
     */
    public function setOrgPhone($orgPhone)
    {
        $this->container['orgPhone'] = $orgPhone;

        return $this;
    }

    /**
     * Gets isTaxExempt
     * @return bool
     */
    public function getIsTaxExempt()
    {
        return $this->container['isTaxExempt'];
    }

    /**
     * Sets isTaxExempt
     * @param bool $isTaxExempt Indicates whether the account is tax exempt.
     * @return $this
     */
    public function setIsTaxExempt($isTaxExempt)
    {
        $this->container['isTaxExempt'] = $isTaxExempt;

        return $this;
    }

    /**
     * Gets billingAddress
     * @return \PureCloudSDK\BillingAddress
     */
    public function getBillingAddress()
    {
        return $this->container['billingAddress'];
    }

    /**
     * Sets billingAddress
     * @param \PureCloudSDK\BillingAddress $billingAddress The account billing address.
     * @return $this
     */
    public function setBillingAddress($billingAddress)
    {
        $this->container['billingAddress'] = $billingAddress;

        return $this;
    }

    /**
     * Gets currency
     * @return string
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     * @param string $currency The account currency.
     * @return $this
     */
    public function setCurrency($currency)
    {
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets primaryPaymentMethodId
     * @return string
     */
    public function getPrimaryPaymentMethodId()
    {
        return $this->container['primaryPaymentMethodId'];
    }

    /**
     * Sets primaryPaymentMethodId
     * @param string $primaryPaymentMethodId Primary Payment Method ID.
     * @return $this
     */
    public function setPrimaryPaymentMethodId($primaryPaymentMethodId)
    {
        $this->container['primaryPaymentMethodId'] = $primaryPaymentMethodId;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


