<?php
/**
 * FlowHistoryDataItem
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * FlowHistoryDataItem Class Doc Comment
 *
 * @category    Class */
 // @description Data elements associated with a history event
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class FlowHistoryDataItem implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'FlowHistoryDataItem';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'parameterName' => 'string',
        'parameterType' => 'string',
        'parameterValues' => '\PureCloudSDK\Value'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'parameterName' => 'parameterName',
        'parameterType' => 'parameterType',
        'parameterValues' => 'parameterValues'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'parameterName' => 'setParameterName',
        'parameterType' => 'setParameterType',
        'parameterValues' => 'setParameterValues'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'parameterName' => 'getParameterName',
        'parameterType' => 'getParameterType',
        'parameterValues' => 'getParameterValues'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['parameterName'] = isset($data['parameterName']) ? $data['parameterName'] : null;
        $this->container['parameterType'] = isset($data['parameterType']) ? $data['parameterType'] : null;
        $this->container['parameterValues'] = isset($data['parameterValues']) ? $data['parameterValues'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['parameterName'] === null) {
            $invalid_properties[] = "'parameterName' can't be null";
        }
        if ($this->container['parameterType'] === null) {
            $invalid_properties[] = "'parameterType' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['parameterName'] === null) {
            return false;
        }
        if ($this->container['parameterType'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets parameterName
     * @return string
     */
    public function getParameterName()
    {
        return $this->container['parameterName'];
    }

    /**
     * Sets parameterName
     * @param string $parameterName The name of the data element associated with a history event.
     * @return $this
     */
    public function setParameterName($parameterName)
    {
        $this->container['parameterName'] = $parameterName;

        return $this;
    }

    /**
     * Gets parameterType
     * @return string
     */
    public function getParameterType()
    {
        return $this->container['parameterType'];
    }

    /**
     * Sets parameterType
     * @param string $parameterType The type of the data element associated with a history event.
     * @return $this
     */
    public function setParameterType($parameterType)
    {
        $this->container['parameterType'] = $parameterType;

        return $this;
    }

    /**
     * Gets parameterValues
     * @return \PureCloudSDK\Value
     */
    public function getParameterValues()
    {
        return $this->container['parameterValues'];
    }

    /**
     * Sets parameterValues
     * @param \PureCloudSDK\Value $parameterValues The values of the data element associated with a history event.
     * @return $this
     */
    public function setParameterValues($parameterValues)
    {
        $this->container['parameterValues'] = $parameterValues;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


