<?php
/**
 * ForecastEntry
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * ForecastEntry Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ForecastEntry implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ForecastEntry';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'metric' => 'string',
        'dimensions' => '\PureCloudSDK\ForecastDimensions',
        'values' => 'double[]',
        'historicalTimeSeriesData' => '\PureCloudSDK\HistoricalTimeSeriesData',
        'lowerIntervals' => 'double[]',
        'upperIntervals' => 'double[]',
        'model' => '\PureCloudSDK\ForecastModel'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'metric' => 'metric',
        'dimensions' => 'dimensions',
        'values' => 'values',
        'historicalTimeSeriesData' => 'historicalTimeSeriesData',
        'lowerIntervals' => 'lowerIntervals',
        'upperIntervals' => 'upperIntervals',
        'model' => 'model'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'metric' => 'setMetric',
        'dimensions' => 'setDimensions',
        'values' => 'setValues',
        'historicalTimeSeriesData' => 'setHistoricalTimeSeriesData',
        'lowerIntervals' => 'setLowerIntervals',
        'upperIntervals' => 'setUpperIntervals',
        'model' => 'setModel'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'metric' => 'getMetric',
        'dimensions' => 'getDimensions',
        'values' => 'getValues',
        'historicalTimeSeriesData' => 'getHistoricalTimeSeriesData',
        'lowerIntervals' => 'getLowerIntervals',
        'upperIntervals' => 'getUpperIntervals',
        'model' => 'getModel'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const METRIC_VOLUME = 'VOLUME';
    const METRIC_ATT = 'ATT';
    const METRIC_ACW = 'ACW';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMetricAllowableValues()
    {
        return [
            self::METRIC_VOLUME,
            self::METRIC_ATT,
            self::METRIC_ACW,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['metric'] = isset($data['metric']) ? $data['metric'] : null;
        $this->container['dimensions'] = isset($data['dimensions']) ? $data['dimensions'] : null;
        $this->container['values'] = isset($data['values']) ? $data['values'] : null;
        $this->container['historicalTimeSeriesData'] = isset($data['historicalTimeSeriesData']) ? $data['historicalTimeSeriesData'] : null;
        $this->container['lowerIntervals'] = isset($data['lowerIntervals']) ? $data['lowerIntervals'] : null;
        $this->container['upperIntervals'] = isset($data['upperIntervals']) ? $data['upperIntervals'] : null;
        $this->container['model'] = isset($data['model']) ? $data['model'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("VOLUME", "ATT", "ACW");
        if (!in_array($this->container['metric'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'metric', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("VOLUME", "ATT", "ACW");
        if (!in_array($this->container['metric'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets metric
     * @return string
     */
    public function getMetric()
    {
        return $this->container['metric'];
    }

    /**
     * Sets metric
     * @param string $metric The metric of the entry
     * @return $this
     */
    public function setMetric($metric)
    {
        $allowed_values = array('VOLUME', 'ATT', 'ACW');
        if (!in_array($metric, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'metric', must be one of 'VOLUME', 'ATT', 'ACW'");
        }
        $this->container['metric'] = $metric;

        return $this;
    }

    /**
     * Gets dimensions
     * @return \PureCloudSDK\ForecastDimensions
     */
    public function getDimensions()
    {
        return $this->container['dimensions'];
    }

    /**
     * Sets dimensions
     * @param \PureCloudSDK\ForecastDimensions $dimensions The dimensions of the entry
     * @return $this
     */
    public function setDimensions($dimensions)
    {
        $this->container['dimensions'] = $dimensions;

        return $this;
    }

    /**
     * Gets values
     * @return double[]
     */
    public function getValues()
    {
        return $this->container['values'];
    }

    /**
     * Sets values
     * @param double[] $values The forecasted values
     * @return $this
     */
    public function setValues($values)
    {
        $this->container['values'] = $values;

        return $this;
    }

    /**
     * Gets historicalTimeSeriesData
     * @return \PureCloudSDK\HistoricalTimeSeriesData
     */
    public function getHistoricalTimeSeriesData()
    {
        return $this->container['historicalTimeSeriesData'];
    }

    /**
     * Sets historicalTimeSeriesData
     * @param \PureCloudSDK\HistoricalTimeSeriesData $historicalTimeSeriesData The historical time series data
     * @return $this
     */
    public function setHistoricalTimeSeriesData($historicalTimeSeriesData)
    {
        $this->container['historicalTimeSeriesData'] = $historicalTimeSeriesData;

        return $this;
    }

    /**
     * Gets lowerIntervals
     * @return double[]
     */
    public function getLowerIntervals()
    {
        return $this->container['lowerIntervals'];
    }

    /**
     * Sets lowerIntervals
     * @param double[] $lowerIntervals The lower intervals of the forecasted values
     * @return $this
     */
    public function setLowerIntervals($lowerIntervals)
    {
        $this->container['lowerIntervals'] = $lowerIntervals;

        return $this;
    }

    /**
     * Gets upperIntervals
     * @return double[]
     */
    public function getUpperIntervals()
    {
        return $this->container['upperIntervals'];
    }

    /**
     * Sets upperIntervals
     * @param double[] $upperIntervals The upper intervals of the forecasted values
     * @return $this
     */
    public function setUpperIntervals($upperIntervals)
    {
        $this->container['upperIntervals'] = $upperIntervals;

        return $this;
    }

    /**
     * Gets model
     * @return \PureCloudSDK\ForecastModel
     */
    public function getModel()
    {
        return $this->container['model'];
    }

    /**
     * Sets model
     * @param \PureCloudSDK\ForecastModel $model The forecasting model used for creating forecasted values
     * @return $this
     */
    public function setModel($model)
    {
        $this->container['model'] = $model;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


