<?php
/**
 * Parameter
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * Parameter Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Parameter implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Parameter';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'name' => 'string',
        'parameterType' => 'string',
        'domain' => 'string',
        'required' => 'bool'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'name' => 'name',
        'parameterType' => 'parameterType',
        'domain' => 'domain',
        'required' => 'required'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'name' => 'setName',
        'parameterType' => 'setParameterType',
        'domain' => 'setDomain',
        'required' => 'setRequired'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'name' => 'getName',
        'parameterType' => 'getParameterType',
        'domain' => 'getDomain',
        'required' => 'getRequired'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const PARAMETER_TYPE_UUID = 'UUID';
    const PARAMETER_TYPE_STRING = 'STRING';
    const PARAMETER_TYPE_UUIDLIST = 'UUIDLIST';
    const PARAMETER_TYPE_STRINGLIST = 'STRINGLIST';
    const DOMAIN_USERID = 'USERID';
    const DOMAIN_QUEUEID = 'QUEUEID';
    const DOMAIN_MEDIATYPE = 'MEDIATYPE';
    const DOMAIN_DIALERCAMPAIGNID = 'DIALERCAMPAIGNID';
    const DOMAIN_QMEVALFORMID = 'QMEVALFORMID';
    const DOMAIN_UNKNOWN = 'UNKNOWN';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getParameterTypeAllowableValues()
    {
        return [
            self::PARAMETER_TYPE_UUID,
            self::PARAMETER_TYPE_STRING,
            self::PARAMETER_TYPE_UUIDLIST,
            self::PARAMETER_TYPE_STRINGLIST,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDomainAllowableValues()
    {
        return [
            self::DOMAIN_USERID,
            self::DOMAIN_QUEUEID,
            self::DOMAIN_MEDIATYPE,
            self::DOMAIN_DIALERCAMPAIGNID,
            self::DOMAIN_QMEVALFORMID,
            self::DOMAIN_UNKNOWN,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['parameterType'] = isset($data['parameterType']) ? $data['parameterType'] : null;
        $this->container['domain'] = isset($data['domain']) ? $data['domain'] : null;
        $this->container['required'] = isset($data['required']) ? $data['required'] : false;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("UUID", "STRING", "UUIDLIST", "STRINGLIST");
        if (!in_array($this->container['parameterType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'parameterType', must be one of #{allowed_values}.";
        }

        $allowed_values = array("USERID", "QUEUEID", "MEDIATYPE", "DIALERCAMPAIGNID", "QMEVALFORMID", "UNKNOWN");
        if (!in_array($this->container['domain'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'domain', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("UUID", "STRING", "UUIDLIST", "STRINGLIST");
        if (!in_array($this->container['parameterType'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("USERID", "QUEUEID", "MEDIATYPE", "DIALERCAMPAIGNID", "QMEVALFORMID", "UNKNOWN");
        if (!in_array($this->container['domain'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets parameterType
     * @return string
     */
    public function getParameterType()
    {
        return $this->container['parameterType'];
    }

    /**
     * Sets parameterType
     * @param string $parameterType
     * @return $this
     */
    public function setParameterType($parameterType)
    {
        $allowed_values = array('UUID', 'STRING', 'UUIDLIST', 'STRINGLIST');
        if (!in_array($parameterType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'parameterType', must be one of 'UUID', 'STRING', 'UUIDLIST', 'STRINGLIST'");
        }
        $this->container['parameterType'] = $parameterType;

        return $this;
    }

    /**
     * Gets domain
     * @return string
     */
    public function getDomain()
    {
        return $this->container['domain'];
    }

    /**
     * Sets domain
     * @param string $domain
     * @return $this
     */
    public function setDomain($domain)
    {
        $allowed_values = array('USERID', 'QUEUEID', 'MEDIATYPE', 'DIALERCAMPAIGNID', 'QMEVALFORMID', 'UNKNOWN');
        if (!in_array($domain, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'domain', must be one of 'USERID', 'QUEUEID', 'MEDIATYPE', 'DIALERCAMPAIGNID', 'QMEVALFORMID', 'UNKNOWN'");
        }
        $this->container['domain'] = $domain;

        return $this;
    }

    /**
     * Gets required
     * @return bool
     */
    public function getRequired()
    {
        return $this->container['required'];
    }

    /**
     * Sets required
     * @param bool $required
     * @return $this
     */
    public function setRequired($required)
    {
        $this->container['required'] = $required;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


