<?php
/**
 * PaymentMethod
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * PaymentMethod Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class PaymentMethod implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'PaymentMethod';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'type' => 'string',
        'providerName' => 'string',
        'token' => 'string',
        'cardExpirationDate' => 'string',
        'cardLastFourDigits' => 'string',
        'cardType' => 'string',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'type' => 'type',
        'providerName' => 'providerName',
        'token' => 'token',
        'cardExpirationDate' => 'cardExpirationDate',
        'cardLastFourDigits' => 'cardLastFourDigits',
        'cardType' => 'cardType',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'type' => 'setType',
        'providerName' => 'setProviderName',
        'token' => 'setToken',
        'cardExpirationDate' => 'setCardExpirationDate',
        'cardLastFourDigits' => 'setCardLastFourDigits',
        'cardType' => 'setCardType',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'type' => 'getType',
        'providerName' => 'getProviderName',
        'token' => 'getToken',
        'cardExpirationDate' => 'getCardExpirationDate',
        'cardLastFourDigits' => 'getCardLastFourDigits',
        'cardType' => 'getCardType',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const TYPE_TOKEN = 'CARD_TOKEN';
    const CARD_TYPE_VISA = 'Visa';
    const CARD_TYPE_MASTER_CARD = 'MasterCard';
    const CARD_TYPE_DISCOVER = 'Discover';
    const CARD_TYPE_AMERICAN_EXPRESS = 'American Express';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_TOKEN,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getCardTypeAllowableValues()
    {
        return [
            self::CARD_TYPE_VISA,
            self::CARD_TYPE_MASTER_CARD,
            self::CARD_TYPE_DISCOVER,
            self::CARD_TYPE_AMERICAN_EXPRESS,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['providerName'] = isset($data['providerName']) ? $data['providerName'] : null;
        $this->container['token'] = isset($data['token']) ? $data['token'] : null;
        $this->container['cardExpirationDate'] = isset($data['cardExpirationDate']) ? $data['cardExpirationDate'] : null;
        $this->container['cardLastFourDigits'] = isset($data['cardLastFourDigits']) ? $data['cardLastFourDigits'] : null;
        $this->container['cardType'] = isset($data['cardType']) ? $data['cardType'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['type'] === null) {
            $invalid_properties[] = "'type' can't be null";
        }
        $allowed_values = array("CARD_TOKEN");
        if (!in_array($this->container['type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'type', must be one of #{allowed_values}.";
        }

        if ($this->container['providerName'] === null) {
            $invalid_properties[] = "'providerName' can't be null";
        }
        if ($this->container['token'] === null) {
            $invalid_properties[] = "'token' can't be null";
        }
        $allowed_values = array("Visa", "MasterCard", "Discover", "American Express");
        if (!in_array($this->container['cardType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'cardType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['type'] === null) {
            return false;
        }
        $allowed_values = array("CARD_TOKEN");
        if (!in_array($this->container['type'], $allowed_values)) {
            return false;
        }
        if ($this->container['providerName'] === null) {
            return false;
        }
        if ($this->container['token'] === null) {
            return false;
        }
        $allowed_values = array("Visa", "MasterCard", "Discover", "American Express");
        if (!in_array($this->container['cardType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type Method type
     * @return $this
     */
    public function setType($type)
    {
        $allowed_values = array('CARD_TOKEN');
        if (!in_array($type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'type', must be one of 'CARD_TOKEN'");
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets providerName
     * @return string
     */
    public function getProviderName()
    {
        return $this->container['providerName'];
    }

    /**
     * Sets providerName
     * @param string $providerName Provider name
     * @return $this
     */
    public function setProviderName($providerName)
    {
        $this->container['providerName'] = $providerName;

        return $this;
    }

    /**
     * Gets token
     * @return string
     */
    public function getToken()
    {
        return $this->container['token'];
    }

    /**
     * Sets token
     * @param string $token Payment token
     * @return $this
     */
    public function setToken($token)
    {
        $this->container['token'] = $token;

        return $this;
    }

    /**
     * Gets cardExpirationDate
     * @return string
     */
    public function getCardExpirationDate()
    {
        return $this->container['cardExpirationDate'];
    }

    /**
     * Sets cardExpirationDate
     * @param string $cardExpirationDate for payment methods of type CARD_TOKEN, the card's expiration date in the format YYYY-MM.
     * @return $this
     */
    public function setCardExpirationDate($cardExpirationDate)
    {
        $this->container['cardExpirationDate'] = $cardExpirationDate;

        return $this;
    }

    /**
     * Gets cardLastFourDigits
     * @return string
     */
    public function getCardLastFourDigits()
    {
        return $this->container['cardLastFourDigits'];
    }

    /**
     * Sets cardLastFourDigits
     * @param string $cardLastFourDigits
     * @return $this
     */
    public function setCardLastFourDigits($cardLastFourDigits)
    {
        $this->container['cardLastFourDigits'] = $cardLastFourDigits;

        return $this;
    }

    /**
     * Gets cardType
     * @return string
     */
    public function getCardType()
    {
        return $this->container['cardType'];
    }

    /**
     * Sets cardType
     * @param string $cardType for payment methods of type CARD_TOKEN, the type of credit or debit card
     * @return $this
     */
    public function setCardType($cardType)
    {
        $allowed_values = array('Visa', 'MasterCard', 'Discover', 'American Express');
        if (!in_array($cardType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'cardType', must be one of 'Visa', 'MasterCard', 'Discover', 'American Express'");
        }
        $this->container['cardType'] = $cardType;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


