<?php
/**
 * RankingPair
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * RankingPair Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class RankingPair implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'RankingPair';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'dateCreated' => '\DateTime',
        'dateModified' => '\DateTime',
        'channel' => 'string',
        'featureTag' => 'string',
        'profileId' => 'string',
        'profileType' => 'string',
        'rankingChoice' => 'string',
        'rankingPairIdA' => 'string',
        'rankingPairIdB' => 'string',
        'rankVersion' => 'string',
        'sourceId' => 'string',
        'sourceType' => 'string',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'dateCreated' => 'dateCreated',
        'dateModified' => 'dateModified',
        'channel' => 'channel',
        'featureTag' => 'featureTag',
        'profileId' => 'profileId',
        'profileType' => 'profileType',
        'rankingChoice' => 'rankingChoice',
        'rankingPairIdA' => 'rankingPairIdA',
        'rankingPairIdB' => 'rankingPairIdB',
        'rankVersion' => 'rankVersion',
        'sourceId' => 'sourceId',
        'sourceType' => 'sourceType',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'dateCreated' => 'setDateCreated',
        'dateModified' => 'setDateModified',
        'channel' => 'setChannel',
        'featureTag' => 'setFeatureTag',
        'profileId' => 'setProfileId',
        'profileType' => 'setProfileType',
        'rankingChoice' => 'setRankingChoice',
        'rankingPairIdA' => 'setRankingPairIdA',
        'rankingPairIdB' => 'setRankingPairIdB',
        'rankVersion' => 'setRankVersion',
        'sourceId' => 'setSourceId',
        'sourceType' => 'setSourceType',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'dateCreated' => 'getDateCreated',
        'dateModified' => 'getDateModified',
        'channel' => 'getChannel',
        'featureTag' => 'getFeatureTag',
        'profileId' => 'getProfileId',
        'profileType' => 'getProfileType',
        'rankingChoice' => 'getRankingChoice',
        'rankingPairIdA' => 'getRankingPairIdA',
        'rankingPairIdB' => 'getRankingPairIdB',
        'rankVersion' => 'getRankVersion',
        'sourceId' => 'getSourceId',
        'sourceType' => 'getSourceType',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const CHANNEL_TWITTER = 'TWITTER';
    const CHANNEL_FACEBOOK = 'FACEBOOK';
    const PROFILE_TYPE_GISTENER = 'GISTENER';
    const PROFILE_TYPE_EXPLORATION = 'EXPLORATION';
    const PROFILE_TYPE_FIXED_DATASET = 'FIXED_DATASET';
    const SOURCE_TYPE_ADMIN = 'ADMIN';
    const SOURCE_TYPE_AGENT = 'AGENT';
    const SOURCE_TYPE_SYSTEM = 'SYSTEM';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getChannelAllowableValues()
    {
        return [
            self::CHANNEL_TWITTER,
            self::CHANNEL_FACEBOOK,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getProfileTypeAllowableValues()
    {
        return [
            self::PROFILE_TYPE_GISTENER,
            self::PROFILE_TYPE_EXPLORATION,
            self::PROFILE_TYPE_FIXED_DATASET,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getSourceTypeAllowableValues()
    {
        return [
            self::SOURCE_TYPE_ADMIN,
            self::SOURCE_TYPE_AGENT,
            self::SOURCE_TYPE_SYSTEM,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['dateCreated'] = isset($data['dateCreated']) ? $data['dateCreated'] : null;
        $this->container['dateModified'] = isset($data['dateModified']) ? $data['dateModified'] : null;
        $this->container['channel'] = isset($data['channel']) ? $data['channel'] : null;
        $this->container['featureTag'] = isset($data['featureTag']) ? $data['featureTag'] : null;
        $this->container['profileId'] = isset($data['profileId']) ? $data['profileId'] : null;
        $this->container['profileType'] = isset($data['profileType']) ? $data['profileType'] : null;
        $this->container['rankingChoice'] = isset($data['rankingChoice']) ? $data['rankingChoice'] : null;
        $this->container['rankingPairIdA'] = isset($data['rankingPairIdA']) ? $data['rankingPairIdA'] : null;
        $this->container['rankingPairIdB'] = isset($data['rankingPairIdB']) ? $data['rankingPairIdB'] : null;
        $this->container['rankVersion'] = isset($data['rankVersion']) ? $data['rankVersion'] : null;
        $this->container['sourceId'] = isset($data['sourceId']) ? $data['sourceId'] : null;
        $this->container['sourceType'] = isset($data['sourceType']) ? $data['sourceType'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['channel'] === null) {
            $invalid_properties[] = "'channel' can't be null";
        }
        $allowed_values = array("TWITTER", "FACEBOOK");
        if (!in_array($this->container['channel'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'channel', must be one of #{allowed_values}.";
        }

        if ($this->container['profileId'] === null) {
            $invalid_properties[] = "'profileId' can't be null";
        }
        if ($this->container['profileType'] === null) {
            $invalid_properties[] = "'profileType' can't be null";
        }
        $allowed_values = array("GISTENER", "EXPLORATION", "FIXED_DATASET");
        if (!in_array($this->container['profileType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'profileType', must be one of #{allowed_values}.";
        }

        if ($this->container['rankingChoice'] === null) {
            $invalid_properties[] = "'rankingChoice' can't be null";
        }
        if ($this->container['rankingPairIdA'] === null) {
            $invalid_properties[] = "'rankingPairIdA' can't be null";
        }
        if ($this->container['rankingPairIdB'] === null) {
            $invalid_properties[] = "'rankingPairIdB' can't be null";
        }
        $allowed_values = array("ADMIN", "AGENT", "SYSTEM");
        if (!in_array($this->container['sourceType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'sourceType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['channel'] === null) {
            return false;
        }
        $allowed_values = array("TWITTER", "FACEBOOK");
        if (!in_array($this->container['channel'], $allowed_values)) {
            return false;
        }
        if ($this->container['profileId'] === null) {
            return false;
        }
        if ($this->container['profileType'] === null) {
            return false;
        }
        $allowed_values = array("GISTENER", "EXPLORATION", "FIXED_DATASET");
        if (!in_array($this->container['profileType'], $allowed_values)) {
            return false;
        }
        if ($this->container['rankingChoice'] === null) {
            return false;
        }
        if ($this->container['rankingPairIdA'] === null) {
            return false;
        }
        if ($this->container['rankingPairIdB'] === null) {
            return false;
        }
        $allowed_values = array("ADMIN", "AGENT", "SYSTEM");
        if (!in_array($this->container['sourceType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets dateCreated
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['dateCreated'];
    }

    /**
     * Sets dateCreated
     * @param \DateTime $dateCreated Creation date for the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($dateCreated)
    {
        $this->container['dateCreated'] = $dateCreated;

        return $this;
    }

    /**
     * Gets dateModified
     * @return \DateTime
     */
    public function getDateModified()
    {
        return $this->container['dateModified'];
    }

    /**
     * Sets dateModified
     * @param \DateTime $dateModified Date the entity was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateModified($dateModified)
    {
        $this->container['dateModified'] = $dateModified;

        return $this;
    }

    /**
     * Gets channel
     * @return string
     */
    public function getChannel()
    {
        return $this->container['channel'];
    }

    /**
     * Sets channel
     * @param string $channel Identifying channel-source of content ranking
     * @return $this
     */
    public function setChannel($channel)
    {
        $allowed_values = array('TWITTER', 'FACEBOOK');
        if (!in_array($channel, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'channel', must be one of 'TWITTER', 'FACEBOOK'");
        }
        $this->container['channel'] = $channel;

        return $this;
    }

    /**
     * Gets featureTag
     * @return string
     */
    public function getFeatureTag()
    {
        return $this->container['featureTag'];
    }

    /**
     * Sets featureTag
     * @param string $featureTag The feature considered most valued for the given ranking choice
     * @return $this
     */
    public function setFeatureTag($featureTag)
    {
        $this->container['featureTag'] = $featureTag;

        return $this;
    }

    /**
     * Gets profileId
     * @return string
     */
    public function getProfileId()
    {
        return $this->container['profileId'];
    }

    /**
     * Sets profileId
     * @param string $profileId Unique id of a given profile
     * @return $this
     */
    public function setProfileId($profileId)
    {
        $this->container['profileId'] = $profileId;

        return $this;
    }

    /**
     * Gets profileType
     * @return string
     */
    public function getProfileType()
    {
        return $this->container['profileType'];
    }

    /**
     * Sets profileType
     * @param string $profileType Types may include gistener, exploration, or dataset
     * @return $this
     */
    public function setProfileType($profileType)
    {
        $allowed_values = array('GISTENER', 'EXPLORATION', 'FIXED_DATASET');
        if (!in_array($profileType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'profileType', must be one of 'GISTENER', 'EXPLORATION', 'FIXED_DATASET'");
        }
        $this->container['profileType'] = $profileType;

        return $this;
    }

    /**
     * Gets rankingChoice
     * @return string
     */
    public function getRankingChoice()
    {
        return $this->container['rankingChoice'];
    }

    /**
     * Sets rankingChoice
     * @param string $rankingChoice Id of the ranking choice (copy of either rankingPairIdA or rankingPairIdB)
     * @return $this
     */
    public function setRankingChoice($rankingChoice)
    {
        $this->container['rankingChoice'] = $rankingChoice;

        return $this;
    }

    /**
     * Gets rankingPairIdA
     * @return string
     */
    public function getRankingPairIdA()
    {
        return $this->container['rankingPairIdA'];
    }

    /**
     * Sets rankingPairIdA
     * @param string $rankingPairIdA Id A of the ranking pair
     * @return $this
     */
    public function setRankingPairIdA($rankingPairIdA)
    {
        $this->container['rankingPairIdA'] = $rankingPairIdA;

        return $this;
    }

    /**
     * Gets rankingPairIdB
     * @return string
     */
    public function getRankingPairIdB()
    {
        return $this->container['rankingPairIdB'];
    }

    /**
     * Sets rankingPairIdB
     * @param string $rankingPairIdB Id B of the ranking pair
     * @return $this
     */
    public function setRankingPairIdB($rankingPairIdB)
    {
        $this->container['rankingPairIdB'] = $rankingPairIdB;

        return $this;
    }

    /**
     * Gets rankVersion
     * @return string
     */
    public function getRankVersion()
    {
        return $this->container['rankVersion'];
    }

    /**
     * Sets rankVersion
     * @param string $rankVersion Version of the ranking pair configuration
     * @return $this
     */
    public function setRankVersion($rankVersion)
    {
        $this->container['rankVersion'] = $rankVersion;

        return $this;
    }

    /**
     * Gets sourceId
     * @return string
     */
    public function getSourceId()
    {
        return $this->container['sourceId'];
    }

    /**
     * Sets sourceId
     * @param string $sourceId Unique id of a given source
     * @return $this
     */
    public function setSourceId($sourceId)
    {
        $this->container['sourceId'] = $sourceId;

        return $this;
    }

    /**
     * Gets sourceType
     * @return string
     */
    public function getSourceType()
    {
        return $this->container['sourceType'];
    }

    /**
     * Sets sourceType
     * @param string $sourceType Types may include admin, agent, system, or some other testing source
     * @return $this
     */
    public function setSourceType($sourceType)
    {
        $allowed_values = array('ADMIN', 'AGENT', 'SYSTEM');
        if (!in_array($sourceType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'sourceType', must be one of 'ADMIN', 'AGENT', 'SYSTEM'");
        }
        $this->container['sourceType'] = $sourceType;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


