<?php
/**
 * Scene
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * Scene Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Scene implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Scene';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'description' => 'string',
        'sceneGroups' => '\PureCloudSDK\SceneGroup[]',
        'assets' => '\PureCloudSDK\Asset[]',
        'thumbnail' => '\PureCloudSDK\Thumbnail',
        'waypoints' => '\PureCloudSDK\Waypoint[]',
        'defaultOrientationY' => 'double',
        'defaultOrientationX' => 'double',
        'type' => 'string',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'description' => 'description',
        'sceneGroups' => 'sceneGroups',
        'assets' => 'assets',
        'thumbnail' => 'thumbnail',
        'waypoints' => 'waypoints',
        'defaultOrientationY' => 'defaultOrientationY',
        'defaultOrientationX' => 'defaultOrientationX',
        'type' => 'type',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'description' => 'setDescription',
        'sceneGroups' => 'setSceneGroups',
        'assets' => 'setAssets',
        'thumbnail' => 'setThumbnail',
        'waypoints' => 'setWaypoints',
        'defaultOrientationY' => 'setDefaultOrientationY',
        'defaultOrientationX' => 'setDefaultOrientationX',
        'type' => 'setType',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'description' => 'getDescription',
        'sceneGroups' => 'getSceneGroups',
        'assets' => 'getAssets',
        'thumbnail' => 'getThumbnail',
        'waypoints' => 'getWaypoints',
        'defaultOrientationY' => 'getDefaultOrientationY',
        'defaultOrientationX' => 'getDefaultOrientationX',
        'type' => 'getType',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const TYPE_PRIMARY = 'PRIMARY';
    const TYPE_SECONDARY = 'SECONDARY';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_PRIMARY,
            self::TYPE_SECONDARY,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['sceneGroups'] = isset($data['sceneGroups']) ? $data['sceneGroups'] : null;
        $this->container['assets'] = isset($data['assets']) ? $data['assets'] : null;
        $this->container['thumbnail'] = isset($data['thumbnail']) ? $data['thumbnail'] : null;
        $this->container['waypoints'] = isset($data['waypoints']) ? $data['waypoints'] : null;
        $this->container['defaultOrientationY'] = isset($data['defaultOrientationY']) ? $data['defaultOrientationY'] : null;
        $this->container['defaultOrientationX'] = isset($data['defaultOrientationX']) ? $data['defaultOrientationX'] : null;
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("PRIMARY", "SECONDARY");
        if (!in_array($this->container['type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'type', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("PRIMARY", "SECONDARY");
        if (!in_array($this->container['type'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets sceneGroups
     * @return \PureCloudSDK\SceneGroup[]
     */
    public function getSceneGroups()
    {
        return $this->container['sceneGroups'];
    }

    /**
     * Sets sceneGroups
     * @param \PureCloudSDK\SceneGroup[] $sceneGroups
     * @return $this
     */
    public function setSceneGroups($sceneGroups)
    {
        $this->container['sceneGroups'] = $sceneGroups;

        return $this;
    }

    /**
     * Gets assets
     * @return \PureCloudSDK\Asset[]
     */
    public function getAssets()
    {
        return $this->container['assets'];
    }

    /**
     * Sets assets
     * @param \PureCloudSDK\Asset[] $assets
     * @return $this
     */
    public function setAssets($assets)
    {
        $this->container['assets'] = $assets;

        return $this;
    }

    /**
     * Gets thumbnail
     * @return \PureCloudSDK\Thumbnail
     */
    public function getThumbnail()
    {
        return $this->container['thumbnail'];
    }

    /**
     * Sets thumbnail
     * @param \PureCloudSDK\Thumbnail $thumbnail
     * @return $this
     */
    public function setThumbnail($thumbnail)
    {
        $this->container['thumbnail'] = $thumbnail;

        return $this;
    }

    /**
     * Gets waypoints
     * @return \PureCloudSDK\Waypoint[]
     */
    public function getWaypoints()
    {
        return $this->container['waypoints'];
    }

    /**
     * Sets waypoints
     * @param \PureCloudSDK\Waypoint[] $waypoints
     * @return $this
     */
    public function setWaypoints($waypoints)
    {
        $this->container['waypoints'] = $waypoints;

        return $this;
    }

    /**
     * Gets defaultOrientationY
     * @return double
     */
    public function getDefaultOrientationY()
    {
        return $this->container['defaultOrientationY'];
    }

    /**
     * Sets defaultOrientationY
     * @param double $defaultOrientationY
     * @return $this
     */
    public function setDefaultOrientationY($defaultOrientationY)
    {
        $this->container['defaultOrientationY'] = $defaultOrientationY;

        return $this;
    }

    /**
     * Gets defaultOrientationX
     * @return double
     */
    public function getDefaultOrientationX()
    {
        return $this->container['defaultOrientationX'];
    }

    /**
     * Sets defaultOrientationX
     * @param double $defaultOrientationX
     * @return $this
     */
    public function setDefaultOrientationX($defaultOrientationX)
    {
        $this->container['defaultOrientationX'] = $defaultOrientationX;

        return $this;
    }

    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type
     * @return $this
     */
    public function setType($type)
    {
        $allowed_values = array('PRIMARY', 'SECONDARY');
        if (!in_array($type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'type', must be one of 'PRIMARY', 'SECONDARY'");
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


