<?php
/**
 * SocialAccount
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * SocialAccount Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class SocialAccount implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'SocialAccount';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'dateCreated' => '\DateTime',
        'dateModified' => '\DateTime',
        'archived' => 'bool',
        'enabled' => 'bool',
        'authorized' => 'bool',
        'socialHub' => 'string',
        'accessToken' => 'string',
        'accessTokenSecret' => 'string',
        'twitterId' => 'string',
        'streamingEnabled' => 'bool',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'dateCreated' => 'dateCreated',
        'dateModified' => 'dateModified',
        'archived' => 'archived',
        'enabled' => 'enabled',
        'authorized' => 'authorized',
        'socialHub' => 'socialHub',
        'accessToken' => 'access_token',
        'accessTokenSecret' => 'access_token_secret',
        'twitterId' => 'twitterId',
        'streamingEnabled' => 'streamingEnabled',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'dateCreated' => 'setDateCreated',
        'dateModified' => 'setDateModified',
        'archived' => 'setArchived',
        'enabled' => 'setEnabled',
        'authorized' => 'setAuthorized',
        'socialHub' => 'setSocialHub',
        'accessToken' => 'setAccessToken',
        'accessTokenSecret' => 'setAccessTokenSecret',
        'twitterId' => 'setTwitterId',
        'streamingEnabled' => 'setStreamingEnabled',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'dateCreated' => 'getDateCreated',
        'dateModified' => 'getDateModified',
        'archived' => 'getArchived',
        'enabled' => 'getEnabled',
        'authorized' => 'getAuthorized',
        'socialHub' => 'getSocialHub',
        'accessToken' => 'getAccessToken',
        'accessTokenSecret' => 'getAccessTokenSecret',
        'twitterId' => 'getTwitterId',
        'streamingEnabled' => 'getStreamingEnabled',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['dateCreated'] = isset($data['dateCreated']) ? $data['dateCreated'] : null;
        $this->container['dateModified'] = isset($data['dateModified']) ? $data['dateModified'] : null;
        $this->container['archived'] = isset($data['archived']) ? $data['archived'] : false;
        $this->container['enabled'] = isset($data['enabled']) ? $data['enabled'] : false;
        $this->container['authorized'] = isset($data['authorized']) ? $data['authorized'] : false;
        $this->container['socialHub'] = isset($data['socialHub']) ? $data['socialHub'] : null;
        $this->container['accessToken'] = isset($data['accessToken']) ? $data['accessToken'] : null;
        $this->container['accessTokenSecret'] = isset($data['accessTokenSecret']) ? $data['accessTokenSecret'] : null;
        $this->container['twitterId'] = isset($data['twitterId']) ? $data['twitterId'] : null;
        $this->container['streamingEnabled'] = isset($data['streamingEnabled']) ? $data['streamingEnabled'] : false;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['accessToken'] === null) {
            $invalid_properties[] = "'accessToken' can't be null";
        }
        if ($this->container['accessTokenSecret'] === null) {
            $invalid_properties[] = "'accessTokenSecret' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['accessToken'] === null) {
            return false;
        }
        if ($this->container['accessTokenSecret'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets dateCreated
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['dateCreated'];
    }

    /**
     * Sets dateCreated
     * @param \DateTime $dateCreated Creation date for the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($dateCreated)
    {
        $this->container['dateCreated'] = $dateCreated;

        return $this;
    }

    /**
     * Gets dateModified
     * @return \DateTime
     */
    public function getDateModified()
    {
        return $this->container['dateModified'];
    }

    /**
     * Sets dateModified
     * @param \DateTime $dateModified Date the entity was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateModified($dateModified)
    {
        $this->container['dateModified'] = $dateModified;

        return $this;
    }

    /**
     * Gets archived
     * @return bool
     */
    public function getArchived()
    {
        return $this->container['archived'];
    }

    /**
     * Sets archived
     * @param bool $archived Indicates if this Social Account has been archived
     * @return $this
     */
    public function setArchived($archived)
    {
        $this->container['archived'] = $archived;

        return $this;
    }

    /**
     * Gets enabled
     * @return bool
     */
    public function getEnabled()
    {
        return $this->container['enabled'];
    }

    /**
     * Sets enabled
     * @param bool $enabled Indicates if this Social Account is available for selection by other entities
     * @return $this
     */
    public function setEnabled($enabled)
    {
        $this->container['enabled'] = $enabled;

        return $this;
    }

    /**
     * Gets authorized
     * @return bool
     */
    public function getAuthorized()
    {
        return $this->container['authorized'];
    }

    /**
     * Sets authorized
     * @param bool $authorized True when successfully completing the third-party authorization process
     * @return $this
     */
    public function setAuthorized($authorized)
    {
        $this->container['authorized'] = $authorized;

        return $this;
    }

    /**
     * Gets socialHub
     * @return string
     */
    public function getSocialHub()
    {
        return $this->container['socialHub'];
    }

    /**
     * Sets socialHub
     * @param string $socialHub Which third party Social Media Hub this account will be communicating through
     * @return $this
     */
    public function setSocialHub($socialHub)
    {
        $this->container['socialHub'] = $socialHub;

        return $this;
    }

    /**
     * Gets accessToken
     * @return string
     */
    public function getAccessToken()
    {
        return $this->container['accessToken'];
    }

    /**
     * Sets accessToken
     * @param string $accessToken Credential provided through the Social Hub's authorization process
     * @return $this
     */
    public function setAccessToken($accessToken)
    {
        $this->container['accessToken'] = $accessToken;

        return $this;
    }

    /**
     * Gets accessTokenSecret
     * @return string
     */
    public function getAccessTokenSecret()
    {
        return $this->container['accessTokenSecret'];
    }

    /**
     * Sets accessTokenSecret
     * @param string $accessTokenSecret Credential provided through the Social Hub's authorization process
     * @return $this
     */
    public function setAccessTokenSecret($accessTokenSecret)
    {
        $this->container['accessTokenSecret'] = $accessTokenSecret;

        return $this;
    }

    /**
     * Gets twitterId
     * @return string
     */
    public function getTwitterId()
    {
        return $this->container['twitterId'];
    }

    /**
     * Sets twitterId
     * @param string $twitterId The account ID as provided by Twitter during the authorization process
     * @return $this
     */
    public function setTwitterId($twitterId)
    {
        $this->container['twitterId'] = $twitterId;

        return $this;
    }

    /**
     * Gets streamingEnabled
     * @return bool
     */
    public function getStreamingEnabled()
    {
        return $this->container['streamingEnabled'];
    }

    /**
     * Sets streamingEnabled
     * @param bool $streamingEnabled Indicates if a stream should be opened on behalf of the indicated Social Hub account
     * @return $this
     */
    public function setStreamingEnabled($streamingEnabled)
    {
        $this->container['streamingEnabled'] = $streamingEnabled;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


