<?php
/**
 * SocializeEntityFilter
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * SocializeEntityFilter Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class SocializeEntityFilter implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'SocializeEntityFilter';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'fieldName' => 'string',
        'operator' => 'string',
        'fieldValue' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'fieldName' => 'fieldName',
        'operator' => 'operator',
        'fieldValue' => 'fieldValue'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'fieldName' => 'setFieldName',
        'operator' => 'setOperator',
        'fieldValue' => 'setFieldValue'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'fieldName' => 'getFieldName',
        'operator' => 'getOperator',
        'fieldValue' => 'getFieldValue'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const OPERATOR_EQ = 'EQ';
    const OPERATOR_NEG_EQ = 'NEG_EQ';
    const OPERATOR_CONTAINS = 'CONTAINS';
    const OPERATOR_NEG_CONTAINS = 'NEG_CONTAINS';
    const OPERATOR_STARTS_WITH = 'STARTS_WITH';
    const OPERATOR_NEG_STARTS_WITH = 'NEG_STARTS_WITH';
    const OPERATOR_ENDS_WITH = 'ENDS_WITH';
    const OPERATOR_NEG_ENDS_WITH = 'NEG_ENDS_WITH';
    const OPERATOR_BT = 'BT';
    const OPERATOR_GT = 'GT';
    const OPERATOR_LT = 'LT';
    const OPERATOR_GE = 'GE';
    const OPERATOR_LE = 'LE';
    const OPERATOR_IN = 'IN';
    const OPERATOR_NULL = 'NULL';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getOperatorAllowableValues()
    {
        return [
            self::OPERATOR_EQ,
            self::OPERATOR_NEG_EQ,
            self::OPERATOR_CONTAINS,
            self::OPERATOR_NEG_CONTAINS,
            self::OPERATOR_STARTS_WITH,
            self::OPERATOR_NEG_STARTS_WITH,
            self::OPERATOR_ENDS_WITH,
            self::OPERATOR_NEG_ENDS_WITH,
            self::OPERATOR_BT,
            self::OPERATOR_GT,
            self::OPERATOR_LT,
            self::OPERATOR_GE,
            self::OPERATOR_LE,
            self::OPERATOR_IN,
            self::OPERATOR_NULL,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['fieldName'] = isset($data['fieldName']) ? $data['fieldName'] : null;
        $this->container['operator'] = isset($data['operator']) ? $data['operator'] : null;
        $this->container['fieldValue'] = isset($data['fieldValue']) ? $data['fieldValue'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("EQ", "NEG_EQ", "CONTAINS", "NEG_CONTAINS", "STARTS_WITH", "NEG_STARTS_WITH", "ENDS_WITH", "NEG_ENDS_WITH", "BT", "GT", "LT", "GE", "LE", "IN", "NULL");
        if (!in_array($this->container['operator'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'operator', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("EQ", "NEG_EQ", "CONTAINS", "NEG_CONTAINS", "STARTS_WITH", "NEG_STARTS_WITH", "ENDS_WITH", "NEG_ENDS_WITH", "BT", "GT", "LT", "GE", "LE", "IN", "NULL");
        if (!in_array($this->container['operator'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets fieldName
     * @return string
     */
    public function getFieldName()
    {
        return $this->container['fieldName'];
    }

    /**
     * Sets fieldName
     * @param string $fieldName The fieldName the filter will be applied to.
     * @return $this
     */
    public function setFieldName($fieldName)
    {
        $this->container['fieldName'] = $fieldName;

        return $this;
    }

    /**
     * Gets operator
     * @return string
     */
    public function getOperator()
    {
        return $this->container['operator'];
    }

    /**
     * Sets operator
     * @param string $operator The operator to apply when filtering.
     * @return $this
     */
    public function setOperator($operator)
    {
        $allowed_values = array('EQ', 'NEG_EQ', 'CONTAINS', 'NEG_CONTAINS', 'STARTS_WITH', 'NEG_STARTS_WITH', 'ENDS_WITH', 'NEG_ENDS_WITH', 'BT', 'GT', 'LT', 'GE', 'LE', 'IN', 'NULL');
        if (!in_array($operator, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'operator', must be one of 'EQ', 'NEG_EQ', 'CONTAINS', 'NEG_CONTAINS', 'STARTS_WITH', 'NEG_STARTS_WITH', 'ENDS_WITH', 'NEG_ENDS_WITH', 'BT', 'GT', 'LT', 'GE', 'LE', 'IN', 'NULL'");
        }
        $this->container['operator'] = $operator;

        return $this;
    }

    /**
     * Gets fieldValue
     * @return string
     */
    public function getFieldValue()
    {
        return $this->container['fieldValue'];
    }

    /**
     * Sets fieldValue
     * @param string $fieldValue The value to filter on.
     * @return $this
     */
    public function setFieldValue($fieldValue)
    {
        $this->container['fieldValue'] = $fieldValue;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


