<?php
/**
 * TwitterExpression
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * TwitterExpression Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class TwitterExpression implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'TwitterExpression';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'dateCreated' => '\DateTime',
        'dateModified' => '\DateTime',
        'isDispositioned' => 'bool',
        'isNoise' => 'bool',
        'gistener' => '\PureCloudSDK\Gistener',
        'tweetId' => 'string',
        'text' => 'string',
        'tweetCreated' => '\DateTime',
        'isReply' => 'bool',
        'isRetweet' => 'bool',
        'retweetParentId' => 'string',
        'retweetCount' => 'int',
        'isQuotedTweet' => 'bool',
        'quotedParentId' => 'string',
        'userId' => 'string',
        'userName' => 'string',
        'userScreenName' => 'string',
        'userTweetCount' => 'int',
        'userFollowersCount' => 'int',
        'groupTags' => '\PureCloudSDK\GroupTag[]',
        'routed' => 'bool',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'dateCreated' => 'dateCreated',
        'dateModified' => 'dateModified',
        'isDispositioned' => 'isDispositioned',
        'isNoise' => 'isNoise',
        'gistener' => 'gistener',
        'tweetId' => 'tweetId',
        'text' => 'text',
        'tweetCreated' => 'tweetCreated',
        'isReply' => 'isReply',
        'isRetweet' => 'isRetweet',
        'retweetParentId' => 'retweetParentId',
        'retweetCount' => 'retweetCount',
        'isQuotedTweet' => 'isQuotedTweet',
        'quotedParentId' => 'quotedParentId',
        'userId' => 'userId',
        'userName' => 'userName',
        'userScreenName' => 'userScreenName',
        'userTweetCount' => 'userTweetCount',
        'userFollowersCount' => 'userFollowersCount',
        'groupTags' => 'groupTags',
        'routed' => 'routed',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'dateCreated' => 'setDateCreated',
        'dateModified' => 'setDateModified',
        'isDispositioned' => 'setIsDispositioned',
        'isNoise' => 'setIsNoise',
        'gistener' => 'setGistener',
        'tweetId' => 'setTweetId',
        'text' => 'setText',
        'tweetCreated' => 'setTweetCreated',
        'isReply' => 'setIsReply',
        'isRetweet' => 'setIsRetweet',
        'retweetParentId' => 'setRetweetParentId',
        'retweetCount' => 'setRetweetCount',
        'isQuotedTweet' => 'setIsQuotedTweet',
        'quotedParentId' => 'setQuotedParentId',
        'userId' => 'setUserId',
        'userName' => 'setUserName',
        'userScreenName' => 'setUserScreenName',
        'userTweetCount' => 'setUserTweetCount',
        'userFollowersCount' => 'setUserFollowersCount',
        'groupTags' => 'setGroupTags',
        'routed' => 'setRouted',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'dateCreated' => 'getDateCreated',
        'dateModified' => 'getDateModified',
        'isDispositioned' => 'getIsDispositioned',
        'isNoise' => 'getIsNoise',
        'gistener' => 'getGistener',
        'tweetId' => 'getTweetId',
        'text' => 'getText',
        'tweetCreated' => 'getTweetCreated',
        'isReply' => 'getIsReply',
        'isRetweet' => 'getIsRetweet',
        'retweetParentId' => 'getRetweetParentId',
        'retweetCount' => 'getRetweetCount',
        'isQuotedTweet' => 'getIsQuotedTweet',
        'quotedParentId' => 'getQuotedParentId',
        'userId' => 'getUserId',
        'userName' => 'getUserName',
        'userScreenName' => 'getUserScreenName',
        'userTweetCount' => 'getUserTweetCount',
        'userFollowersCount' => 'getUserFollowersCount',
        'groupTags' => 'getGroupTags',
        'routed' => 'getRouted',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['dateCreated'] = isset($data['dateCreated']) ? $data['dateCreated'] : null;
        $this->container['dateModified'] = isset($data['dateModified']) ? $data['dateModified'] : null;
        $this->container['isDispositioned'] = isset($data['isDispositioned']) ? $data['isDispositioned'] : false;
        $this->container['isNoise'] = isset($data['isNoise']) ? $data['isNoise'] : false;
        $this->container['gistener'] = isset($data['gistener']) ? $data['gistener'] : null;
        $this->container['tweetId'] = isset($data['tweetId']) ? $data['tweetId'] : null;
        $this->container['text'] = isset($data['text']) ? $data['text'] : null;
        $this->container['tweetCreated'] = isset($data['tweetCreated']) ? $data['tweetCreated'] : null;
        $this->container['isReply'] = isset($data['isReply']) ? $data['isReply'] : false;
        $this->container['isRetweet'] = isset($data['isRetweet']) ? $data['isRetweet'] : false;
        $this->container['retweetParentId'] = isset($data['retweetParentId']) ? $data['retweetParentId'] : null;
        $this->container['retweetCount'] = isset($data['retweetCount']) ? $data['retweetCount'] : null;
        $this->container['isQuotedTweet'] = isset($data['isQuotedTweet']) ? $data['isQuotedTweet'] : false;
        $this->container['quotedParentId'] = isset($data['quotedParentId']) ? $data['quotedParentId'] : null;
        $this->container['userId'] = isset($data['userId']) ? $data['userId'] : null;
        $this->container['userName'] = isset($data['userName']) ? $data['userName'] : null;
        $this->container['userScreenName'] = isset($data['userScreenName']) ? $data['userScreenName'] : null;
        $this->container['userTweetCount'] = isset($data['userTweetCount']) ? $data['userTweetCount'] : null;
        $this->container['userFollowersCount'] = isset($data['userFollowersCount']) ? $data['userFollowersCount'] : null;
        $this->container['groupTags'] = isset($data['groupTags']) ? $data['groupTags'] : null;
        $this->container['routed'] = isset($data['routed']) ? $data['routed'] : false;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['gistener'] === null) {
            $invalid_properties[] = "'gistener' can't be null";
        }
        if ($this->container['tweetId'] === null) {
            $invalid_properties[] = "'tweetId' can't be null";
        }
        if ($this->container['text'] === null) {
            $invalid_properties[] = "'text' can't be null";
        }
        if ($this->container['userName'] === null) {
            $invalid_properties[] = "'userName' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['gistener'] === null) {
            return false;
        }
        if ($this->container['tweetId'] === null) {
            return false;
        }
        if ($this->container['text'] === null) {
            return false;
        }
        if ($this->container['userName'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets dateCreated
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['dateCreated'];
    }

    /**
     * Sets dateCreated
     * @param \DateTime $dateCreated Creation date for the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($dateCreated)
    {
        $this->container['dateCreated'] = $dateCreated;

        return $this;
    }

    /**
     * Gets dateModified
     * @return \DateTime
     */
    public function getDateModified()
    {
        return $this->container['dateModified'];
    }

    /**
     * Sets dateModified
     * @param \DateTime $dateModified Date the entity was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateModified($dateModified)
    {
        $this->container['dateModified'] = $dateModified;

        return $this;
    }

    /**
     * Gets isDispositioned
     * @return bool
     */
    public function getIsDispositioned()
    {
        return $this->container['isDispositioned'];
    }

    /**
     * Sets isDispositioned
     * @param bool $isDispositioned True once the expression has been dispositioned by an agent through the ACD process
     * @return $this
     */
    public function setIsDispositioned($isDispositioned)
    {
        $this->container['isDispositioned'] = $isDispositioned;

        return $this;
    }

    /**
     * Gets isNoise
     * @return bool
     */
    public function getIsNoise()
    {
        return $this->container['isNoise'];
    }

    /**
     * Sets isNoise
     * @param bool $isNoise Indicates if a user/agent found this expression to be undesirable
     * @return $this
     */
    public function setIsNoise($isNoise)
    {
        $this->container['isNoise'] = $isNoise;

        return $this;
    }

    /**
     * Gets gistener
     * @return \PureCloudSDK\Gistener
     */
    public function getGistener()
    {
        return $this->container['gistener'];
    }

    /**
     * Sets gistener
     * @param \PureCloudSDK\Gistener $gistener The Gistener that generated this expression
     * @return $this
     */
    public function setGistener($gistener)
    {
        $this->container['gistener'] = $gistener;

        return $this;
    }

    /**
     * Gets tweetId
     * @return string
     */
    public function getTweetId()
    {
        return $this->container['tweetId'];
    }

    /**
     * Sets tweetId
     * @param string $tweetId Twitter: the tweet's unique id
     * @return $this
     */
    public function setTweetId($tweetId)
    {
        $this->container['tweetId'] = $tweetId;

        return $this;
    }

    /**
     * Gets text
     * @return string
     */
    public function getText()
    {
        return $this->container['text'];
    }

    /**
     * Sets text
     * @param string $text Twitter: the tweets full text
     * @return $this
     */
    public function setText($text)
    {
        $this->container['text'] = $text;

        return $this;
    }

    /**
     * Gets tweetCreated
     * @return \DateTime
     */
    public function getTweetCreated()
    {
        return $this->container['tweetCreated'];
    }

    /**
     * Sets tweetCreated
     * @param \DateTime $tweetCreated Twitter: the date the tweet was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setTweetCreated($tweetCreated)
    {
        $this->container['tweetCreated'] = $tweetCreated;

        return $this;
    }

    /**
     * Gets isReply
     * @return bool
     */
    public function getIsReply()
    {
        return $this->container['isReply'];
    }

    /**
     * Sets isReply
     * @param bool $isReply Twitter: indicates this tweet as a reply to another tweet
     * @return $this
     */
    public function setIsReply($isReply)
    {
        $this->container['isReply'] = $isReply;

        return $this;
    }

    /**
     * Gets isRetweet
     * @return bool
     */
    public function getIsRetweet()
    {
        return $this->container['isRetweet'];
    }

    /**
     * Sets isRetweet
     * @param bool $isRetweet Twitter: indicates this tweet as a 'retweet' of another tweet
     * @return $this
     */
    public function setIsRetweet($isRetweet)
    {
        $this->container['isRetweet'] = $isRetweet;

        return $this;
    }

    /**
     * Gets retweetParentId
     * @return string
     */
    public function getRetweetParentId()
    {
        return $this->container['retweetParentId'];
    }

    /**
     * Sets retweetParentId
     * @param string $retweetParentId Twitter: when the expression is a retweet, this is Twitter's id of the original tweet
     * @return $this
     */
    public function setRetweetParentId($retweetParentId)
    {
        $this->container['retweetParentId'] = $retweetParentId;

        return $this;
    }

    /**
     * Gets retweetCount
     * @return int
     */
    public function getRetweetCount()
    {
        return $this->container['retweetCount'];
    }

    /**
     * Sets retweetCount
     * @param int $retweetCount Twitter: the number of times the parent tweet was retweeted - at the time this expression was created
     * @return $this
     */
    public function setRetweetCount($retweetCount)
    {
        $this->container['retweetCount'] = $retweetCount;

        return $this;
    }

    /**
     * Gets isQuotedTweet
     * @return bool
     */
    public function getIsQuotedTweet()
    {
        return $this->container['isQuotedTweet'];
    }

    /**
     * Sets isQuotedTweet
     * @param bool $isQuotedTweet Twitter: indicates this expression as a quoted tweet (a tweet with an addendum as the primary text)
     * @return $this
     */
    public function setIsQuotedTweet($isQuotedTweet)
    {
        $this->container['isQuotedTweet'] = $isQuotedTweet;

        return $this;
    }

    /**
     * Gets quotedParentId
     * @return string
     */
    public function getQuotedParentId()
    {
        return $this->container['quotedParentId'];
    }

    /**
     * Sets quotedParentId
     * @param string $quotedParentId Twitter: when the expression is a quoted tweet, this is Twitter's id of the original tweet (may not be immediately functional)
     * @return $this
     */
    public function setQuotedParentId($quotedParentId)
    {
        $this->container['quotedParentId'] = $quotedParentId;

        return $this;
    }

    /**
     * Gets userId
     * @return string
     */
    public function getUserId()
    {
        return $this->container['userId'];
    }

    /**
     * Sets userId
     * @param string $userId Twitter: the expressing user's Twitter id
     * @return $this
     */
    public function setUserId($userId)
    {
        $this->container['userId'] = $userId;

        return $this;
    }

    /**
     * Gets userName
     * @return string
     */
    public function getUserName()
    {
        return $this->container['userName'];
    }

    /**
     * Sets userName
     * @param string $userName Twitter: the user's account name for the core service
     * @return $this
     */
    public function setUserName($userName)
    {
        $this->container['userName'] = $userName;

        return $this;
    }

    /**
     * Gets userScreenName
     * @return string
     */
    public function getUserScreenName()
    {
        return $this->container['userScreenName'];
    }

    /**
     * Sets userScreenName
     * @param string $userScreenName Twitter: the user's custom 'branding' name (allowed to change over time)
     * @return $this
     */
    public function setUserScreenName($userScreenName)
    {
        $this->container['userScreenName'] = $userScreenName;

        return $this;
    }

    /**
     * Gets userTweetCount
     * @return int
     */
    public function getUserTweetCount()
    {
        return $this->container['userTweetCount'];
    }

    /**
     * Sets userTweetCount
     * @param int $userTweetCount Twitter: the number of times this user has tweeted (includes all forms of expression replies/quotes/retweets)
     * @return $this
     */
    public function setUserTweetCount($userTweetCount)
    {
        $this->container['userTweetCount'] = $userTweetCount;

        return $this;
    }

    /**
     * Gets userFollowersCount
     * @return int
     */
    public function getUserFollowersCount()
    {
        return $this->container['userFollowersCount'];
    }

    /**
     * Sets userFollowersCount
     * @param int $userFollowersCount Twitter: the number of followers this user has at the time of this expression
     * @return $this
     */
    public function setUserFollowersCount($userFollowersCount)
    {
        $this->container['userFollowersCount'] = $userFollowersCount;

        return $this;
    }

    /**
     * Gets groupTags
     * @return \PureCloudSDK\GroupTag[]
     */
    public function getGroupTags()
    {
        return $this->container['groupTags'];
    }

    /**
     * Sets groupTags
     * @param \PureCloudSDK\GroupTag[] $groupTags The Group Tags applied by the generating Gistener
     * @return $this
     */
    public function setGroupTags($groupTags)
    {
        $this->container['groupTags'] = $groupTags;

        return $this;
    }

    /**
     * Gets routed
     * @return bool
     */
    public function getRouted()
    {
        return $this->container['routed'];
    }

    /**
     * Sets routed
     * @param bool $routed
     * @return $this
     */
    public function setRouted($routed)
    {
        $this->container['routed'] = $routed;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


