<?php
/**
 * UsageRateRegion
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * UsageRateRegion Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class UsageRateRegion implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'UsageRateRegion';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'compositeKey' => 'string',
        'effectiveDate' => '\DateTime',
        'dialerType' => 'string',
        'domain' => 'string',
        'usageCountry' => 'string',
        'currency' => 'string',
        'minDurationSeconds' => 'int',
        'minIncrementSeconds' => 'int',
        'shortDurationSeconds' => 'int',
        'cnamLookupPrice' => 'float',
        'shortDurationPrice' => 'float',
        'rates' => '\PureCloudSDK\UsageRate[]',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'compositeKey' => 'compositeKey',
        'effectiveDate' => 'effectiveDate',
        'dialerType' => 'dialerType',
        'domain' => 'domain',
        'usageCountry' => 'usageCountry',
        'currency' => 'currency',
        'minDurationSeconds' => 'minDurationSeconds',
        'minIncrementSeconds' => 'minIncrementSeconds',
        'shortDurationSeconds' => 'shortDurationSeconds',
        'cnamLookupPrice' => 'cnamLookupPrice',
        'shortDurationPrice' => 'shortDurationPrice',
        'rates' => 'rates',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'compositeKey' => 'setCompositeKey',
        'effectiveDate' => 'setEffectiveDate',
        'dialerType' => 'setDialerType',
        'domain' => 'setDomain',
        'usageCountry' => 'setUsageCountry',
        'currency' => 'setCurrency',
        'minDurationSeconds' => 'setMinDurationSeconds',
        'minIncrementSeconds' => 'setMinIncrementSeconds',
        'shortDurationSeconds' => 'setShortDurationSeconds',
        'cnamLookupPrice' => 'setCnamLookupPrice',
        'shortDurationPrice' => 'setShortDurationPrice',
        'rates' => 'setRates',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'compositeKey' => 'getCompositeKey',
        'effectiveDate' => 'getEffectiveDate',
        'dialerType' => 'getDialerType',
        'domain' => 'getDomain',
        'usageCountry' => 'getUsageCountry',
        'currency' => 'getCurrency',
        'minDurationSeconds' => 'getMinDurationSeconds',
        'minIncrementSeconds' => 'getMinIncrementSeconds',
        'shortDurationSeconds' => 'getShortDurationSeconds',
        'cnamLookupPrice' => 'getCnamLookupPrice',
        'shortDurationPrice' => 'getShortDurationPrice',
        'rates' => 'getRates',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const DIALER_TYPE_DIALER = 'NO_DIALER';
    const DOMAIN_CA = 'CA';
    const DOMAIN_FR = 'FR';
    const DOMAIN_GB = 'GB';
    const DOMAIN_IE = 'IE';
    const DOMAIN_US = 'US';
    const DOMAIN_NA_TF = 'NA_TF';
    const USAGE_COUNTRY_AD = 'AD';
    const USAGE_COUNTRY_AE = 'AE';
    const USAGE_COUNTRY_AF = 'AF';
    const USAGE_COUNTRY_AG = 'AG';
    const USAGE_COUNTRY_AI = 'AI';
    const USAGE_COUNTRY_AL = 'AL';
    const USAGE_COUNTRY_AM = 'AM';
    const USAGE_COUNTRY_AO = 'AO';
    const USAGE_COUNTRY_AQ = 'AQ';
    const USAGE_COUNTRY_AR = 'AR';
    const USAGE_COUNTRY_AS = 'AS';
    const USAGE_COUNTRY_AT = 'AT';
    const USAGE_COUNTRY_AU = 'AU';
    const USAGE_COUNTRY_AW = 'AW';
    const USAGE_COUNTRY_AZ = 'AZ';
    const USAGE_COUNTRY_BA = 'BA';
    const USAGE_COUNTRY_BB = 'BB';
    const USAGE_COUNTRY_BD = 'BD';
    const USAGE_COUNTRY_BE = 'BE';
    const USAGE_COUNTRY_BF = 'BF';
    const USAGE_COUNTRY_BG = 'BG';
    const USAGE_COUNTRY_BH = 'BH';
    const USAGE_COUNTRY_BI = 'BI';
    const USAGE_COUNTRY_BJ = 'BJ';
    const USAGE_COUNTRY_BM = 'BM';
    const USAGE_COUNTRY_BN = 'BN';
    const USAGE_COUNTRY_BO = 'BO';
    const USAGE_COUNTRY_BR = 'BR';
    const USAGE_COUNTRY_BS = 'BS';
    const USAGE_COUNTRY_BT = 'BT';
    const USAGE_COUNTRY_BW = 'BW';
    const USAGE_COUNTRY_BY = 'BY';
    const USAGE_COUNTRY_BZ = 'BZ';
    const USAGE_COUNTRY_CA = 'CA';
    const USAGE_COUNTRY_CD = 'CD';
    const USAGE_COUNTRY_CF = 'CF';
    const USAGE_COUNTRY_CG = 'CG';
    const USAGE_COUNTRY_CH = 'CH';
    const USAGE_COUNTRY_CI = 'CI';
    const USAGE_COUNTRY_CK = 'CK';
    const USAGE_COUNTRY_CL = 'CL';
    const USAGE_COUNTRY_CM = 'CM';
    const USAGE_COUNTRY_CN = 'CN';
    const USAGE_COUNTRY_CO = 'CO';
    const USAGE_COUNTRY_CR = 'CR';
    const USAGE_COUNTRY_CU = 'CU';
    const USAGE_COUNTRY_CV = 'CV';
    const USAGE_COUNTRY_CY = 'CY';
    const USAGE_COUNTRY_CZ = 'CZ';
    const USAGE_COUNTRY_DE = 'DE';
    const USAGE_COUNTRY_DJ = 'DJ';
    const USAGE_COUNTRY_DK = 'DK';
    const USAGE_COUNTRY_DM = 'DM';
    const USAGE_COUNTRY_DO = 'DO';
    const USAGE_COUNTRY_DZ = 'DZ';
    const USAGE_COUNTRY_EC = 'EC';
    const USAGE_COUNTRY_EE = 'EE';
    const USAGE_COUNTRY_EG = 'EG';
    const USAGE_COUNTRY_ER = 'ER';
    const USAGE_COUNTRY_ES = 'ES';
    const USAGE_COUNTRY_ET = 'ET';
    const USAGE_COUNTRY_FI = 'FI';
    const USAGE_COUNTRY_FJ = 'FJ';
    const USAGE_COUNTRY_FK = 'FK';
    const USAGE_COUNTRY_FM = 'FM';
    const USAGE_COUNTRY_FO = 'FO';
    const USAGE_COUNTRY_FR = 'FR';
    const USAGE_COUNTRY_GA = 'GA';
    const USAGE_COUNTRY_GB = 'GB';
    const USAGE_COUNTRY_GD = 'GD';
    const USAGE_COUNTRY_GE = 'GE';
    const USAGE_COUNTRY_GF = 'GF';
    const USAGE_COUNTRY_GH = 'GH';
    const USAGE_COUNTRY_GI = 'GI';
    const USAGE_COUNTRY_GL = 'GL';
    const USAGE_COUNTRY_GM = 'GM';
    const USAGE_COUNTRY_GN = 'GN';
    const USAGE_COUNTRY_GP = 'GP';
    const USAGE_COUNTRY_GQ = 'GQ';
    const USAGE_COUNTRY_GR = 'GR';
    const USAGE_COUNTRY_GT = 'GT';
    const USAGE_COUNTRY_GU = 'GU';
    const USAGE_COUNTRY_GW = 'GW';
    const USAGE_COUNTRY_GY = 'GY';
    const USAGE_COUNTRY_HK = 'HK';
    const USAGE_COUNTRY_HN = 'HN';
    const USAGE_COUNTRY_HR = 'HR';
    const USAGE_COUNTRY_HT = 'HT';
    const USAGE_COUNTRY_HU = 'HU';
    const USAGE_COUNTRY_ID = 'ID';
    const USAGE_COUNTRY_IE = 'IE';
    const USAGE_COUNTRY_IL = 'IL';
    const USAGE_COUNTRY_IN = 'IN';
    const USAGE_COUNTRY_IO = 'IO';
    const USAGE_COUNTRY_IQ = 'IQ';
    const USAGE_COUNTRY_IR = 'IR';
    const USAGE_COUNTRY_IS = 'IS';
    const USAGE_COUNTRY_IT = 'IT';
    const USAGE_COUNTRY_JM = 'JM';
    const USAGE_COUNTRY_JO = 'JO';
    const USAGE_COUNTRY_JP = 'JP';
    const USAGE_COUNTRY_KE = 'KE';
    const USAGE_COUNTRY_KG = 'KG';
    const USAGE_COUNTRY_KH = 'KH';
    const USAGE_COUNTRY_KI = 'KI';
    const USAGE_COUNTRY_KM = 'KM';
    const USAGE_COUNTRY_KN = 'KN';
    const USAGE_COUNTRY_KP = 'KP';
    const USAGE_COUNTRY_KR = 'KR';
    const USAGE_COUNTRY_KW = 'KW';
    const USAGE_COUNTRY_KY = 'KY';
    const USAGE_COUNTRY_KZ = 'KZ';
    const USAGE_COUNTRY_LA = 'LA';
    const USAGE_COUNTRY_LB = 'LB';
    const USAGE_COUNTRY_LC = 'LC';
    const USAGE_COUNTRY_LI = 'LI';
    const USAGE_COUNTRY_LK = 'LK';
    const USAGE_COUNTRY_LR = 'LR';
    const USAGE_COUNTRY_LS = 'LS';
    const USAGE_COUNTRY_LT = 'LT';
    const USAGE_COUNTRY_LU = 'LU';
    const USAGE_COUNTRY_LV = 'LV';
    const USAGE_COUNTRY_LY = 'LY';
    const USAGE_COUNTRY_MA = 'MA';
    const USAGE_COUNTRY_MC = 'MC';
    const USAGE_COUNTRY_MD = 'MD';
    const USAGE_COUNTRY_ME = 'ME';
    const USAGE_COUNTRY_MG = 'MG';
    const USAGE_COUNTRY_MH = 'MH';
    const USAGE_COUNTRY_MK = 'MK';
    const USAGE_COUNTRY_ML = 'ML';
    const USAGE_COUNTRY_MM = 'MM';
    const USAGE_COUNTRY_MN = 'MN';
    const USAGE_COUNTRY_MO = 'MO';
    const USAGE_COUNTRY_MP = 'MP';
    const USAGE_COUNTRY_MQ = 'MQ';
    const USAGE_COUNTRY_MR = 'MR';
    const USAGE_COUNTRY_MS = 'MS';
    const USAGE_COUNTRY_MT = 'MT';
    const USAGE_COUNTRY_MU = 'MU';
    const USAGE_COUNTRY_MV = 'MV';
    const USAGE_COUNTRY_MW = 'MW';
    const USAGE_COUNTRY_MX = 'MX';
    const USAGE_COUNTRY_MY = 'MY';
    const USAGE_COUNTRY_MZ = 'MZ';
    const USAGE_COUNTRY_NA = 'NA';
    const USAGE_COUNTRY_NC = 'NC';
    const USAGE_COUNTRY_NE = 'NE';
    const USAGE_COUNTRY_NF = 'NF';
    const USAGE_COUNTRY_NG = 'NG';
    const USAGE_COUNTRY_NI = 'NI';
    const USAGE_COUNTRY_NL = 'NL';
    const USAGE_COUNTRY_NO = 'NO';
    const USAGE_COUNTRY_NP = 'NP';
    const USAGE_COUNTRY_NR = 'NR';
    const USAGE_COUNTRY_NU = 'NU';
    const USAGE_COUNTRY_NZ = 'NZ';
    const USAGE_COUNTRY_OM = 'OM';
    const USAGE_COUNTRY_PA = 'PA';
    const USAGE_COUNTRY_PE = 'PE';
    const USAGE_COUNTRY_PF = 'PF';
    const USAGE_COUNTRY_PG = 'PG';
    const USAGE_COUNTRY_PH = 'PH';
    const USAGE_COUNTRY_PK = 'PK';
    const USAGE_COUNTRY_PL = 'PL';
    const USAGE_COUNTRY_PM = 'PM';
    const USAGE_COUNTRY_PR = 'PR';
    const USAGE_COUNTRY_PS = 'PS';
    const USAGE_COUNTRY_PT = 'PT';
    const USAGE_COUNTRY_PW = 'PW';
    const USAGE_COUNTRY_PY = 'PY';
    const USAGE_COUNTRY_QA = 'QA';
    const USAGE_COUNTRY_RE = 'RE';
    const USAGE_COUNTRY_RO = 'RO';
    const USAGE_COUNTRY_RS = 'RS';
    const USAGE_COUNTRY_RU = 'RU';
    const USAGE_COUNTRY_RW = 'RW';
    const USAGE_COUNTRY_SA = 'SA';
    const USAGE_COUNTRY_SB = 'SB';
    const USAGE_COUNTRY_SC = 'SC';
    const USAGE_COUNTRY_SD = 'SD';
    const USAGE_COUNTRY_SE = 'SE';
    const USAGE_COUNTRY_SG = 'SG';
    const USAGE_COUNTRY_SH = 'SH';
    const USAGE_COUNTRY_SI = 'SI';
    const USAGE_COUNTRY_SK = 'SK';
    const USAGE_COUNTRY_SL = 'SL';
    const USAGE_COUNTRY_SM = 'SM';
    const USAGE_COUNTRY_SN = 'SN';
    const USAGE_COUNTRY_SO = 'SO';
    const USAGE_COUNTRY_SR = 'SR';
    const USAGE_COUNTRY_SS = 'SS';
    const USAGE_COUNTRY_ST = 'ST';
    const USAGE_COUNTRY_SV = 'SV';
    const USAGE_COUNTRY_SX = 'SX';
    const USAGE_COUNTRY_SY = 'SY';
    const USAGE_COUNTRY_SZ = 'SZ';
    const USAGE_COUNTRY_TC = 'TC';
    const USAGE_COUNTRY_TD = 'TD';
    const USAGE_COUNTRY_TG = 'TG';
    const USAGE_COUNTRY_TH = 'TH';
    const USAGE_COUNTRY_TJ = 'TJ';
    const USAGE_COUNTRY_TK = 'TK';
    const USAGE_COUNTRY_TL = 'TL';
    const USAGE_COUNTRY_TM = 'TM';
    const USAGE_COUNTRY_TN = 'TN';
    const USAGE_COUNTRY_TO = 'TO';
    const USAGE_COUNTRY_TR = 'TR';
    const USAGE_COUNTRY_TT = 'TT';
    const USAGE_COUNTRY_TV = 'TV';
    const USAGE_COUNTRY_TW = 'TW';
    const USAGE_COUNTRY_TZ = 'TZ';
    const USAGE_COUNTRY_UA = 'UA';
    const USAGE_COUNTRY_UG = 'UG';
    const USAGE_COUNTRY_US = 'US';
    const USAGE_COUNTRY_UY = 'UY';
    const USAGE_COUNTRY_VA = 'VA';
    const USAGE_COUNTRY_VC = 'VC';
    const USAGE_COUNTRY_VE = 'VE';
    const USAGE_COUNTRY_VG = 'VG';
    const USAGE_COUNTRY_VI = 'VI';
    const USAGE_COUNTRY_VN = 'VN';
    const USAGE_COUNTRY_VU = 'VU';
    const USAGE_COUNTRY_WF = 'WF';
    const USAGE_COUNTRY_WS = 'WS';
    const USAGE_COUNTRY_XG = 'XG';
    const USAGE_COUNTRY_XI = 'XI';
    const USAGE_COUNTRY_XN = 'XN';
    const USAGE_COUNTRY_XV = 'XV';
    const USAGE_COUNTRY_YE = 'YE';
    const USAGE_COUNTRY_ZA = 'ZA';
    const USAGE_COUNTRY_ZM = 'ZM';
    const USAGE_COUNTRY_ZW = 'ZW';
    const CURRENCY_USD = 'USD';
    const CURRENCY_CAD = 'CAD';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDialerTypeAllowableValues()
    {
        return [
            self::DIALER_TYPE_DIALER,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDomainAllowableValues()
    {
        return [
            self::DOMAIN_CA,
            self::DOMAIN_FR,
            self::DOMAIN_GB,
            self::DOMAIN_IE,
            self::DOMAIN_US,
            self::DOMAIN_NA_TF,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getUsageCountryAllowableValues()
    {
        return [
            self::USAGE_COUNTRY_AD,
            self::USAGE_COUNTRY_AE,
            self::USAGE_COUNTRY_AF,
            self::USAGE_COUNTRY_AG,
            self::USAGE_COUNTRY_AI,
            self::USAGE_COUNTRY_AL,
            self::USAGE_COUNTRY_AM,
            self::USAGE_COUNTRY_AO,
            self::USAGE_COUNTRY_AQ,
            self::USAGE_COUNTRY_AR,
            self::USAGE_COUNTRY_AS,
            self::USAGE_COUNTRY_AT,
            self::USAGE_COUNTRY_AU,
            self::USAGE_COUNTRY_AW,
            self::USAGE_COUNTRY_AZ,
            self::USAGE_COUNTRY_BA,
            self::USAGE_COUNTRY_BB,
            self::USAGE_COUNTRY_BD,
            self::USAGE_COUNTRY_BE,
            self::USAGE_COUNTRY_BF,
            self::USAGE_COUNTRY_BG,
            self::USAGE_COUNTRY_BH,
            self::USAGE_COUNTRY_BI,
            self::USAGE_COUNTRY_BJ,
            self::USAGE_COUNTRY_BM,
            self::USAGE_COUNTRY_BN,
            self::USAGE_COUNTRY_BO,
            self::USAGE_COUNTRY_BR,
            self::USAGE_COUNTRY_BS,
            self::USAGE_COUNTRY_BT,
            self::USAGE_COUNTRY_BW,
            self::USAGE_COUNTRY_BY,
            self::USAGE_COUNTRY_BZ,
            self::USAGE_COUNTRY_CA,
            self::USAGE_COUNTRY_CD,
            self::USAGE_COUNTRY_CF,
            self::USAGE_COUNTRY_CG,
            self::USAGE_COUNTRY_CH,
            self::USAGE_COUNTRY_CI,
            self::USAGE_COUNTRY_CK,
            self::USAGE_COUNTRY_CL,
            self::USAGE_COUNTRY_CM,
            self::USAGE_COUNTRY_CN,
            self::USAGE_COUNTRY_CO,
            self::USAGE_COUNTRY_CR,
            self::USAGE_COUNTRY_CU,
            self::USAGE_COUNTRY_CV,
            self::USAGE_COUNTRY_CY,
            self::USAGE_COUNTRY_CZ,
            self::USAGE_COUNTRY_DE,
            self::USAGE_COUNTRY_DJ,
            self::USAGE_COUNTRY_DK,
            self::USAGE_COUNTRY_DM,
            self::USAGE_COUNTRY_DO,
            self::USAGE_COUNTRY_DZ,
            self::USAGE_COUNTRY_EC,
            self::USAGE_COUNTRY_EE,
            self::USAGE_COUNTRY_EG,
            self::USAGE_COUNTRY_ER,
            self::USAGE_COUNTRY_ES,
            self::USAGE_COUNTRY_ET,
            self::USAGE_COUNTRY_FI,
            self::USAGE_COUNTRY_FJ,
            self::USAGE_COUNTRY_FK,
            self::USAGE_COUNTRY_FM,
            self::USAGE_COUNTRY_FO,
            self::USAGE_COUNTRY_FR,
            self::USAGE_COUNTRY_GA,
            self::USAGE_COUNTRY_GB,
            self::USAGE_COUNTRY_GD,
            self::USAGE_COUNTRY_GE,
            self::USAGE_COUNTRY_GF,
            self::USAGE_COUNTRY_GH,
            self::USAGE_COUNTRY_GI,
            self::USAGE_COUNTRY_GL,
            self::USAGE_COUNTRY_GM,
            self::USAGE_COUNTRY_GN,
            self::USAGE_COUNTRY_GP,
            self::USAGE_COUNTRY_GQ,
            self::USAGE_COUNTRY_GR,
            self::USAGE_COUNTRY_GT,
            self::USAGE_COUNTRY_GU,
            self::USAGE_COUNTRY_GW,
            self::USAGE_COUNTRY_GY,
            self::USAGE_COUNTRY_HK,
            self::USAGE_COUNTRY_HN,
            self::USAGE_COUNTRY_HR,
            self::USAGE_COUNTRY_HT,
            self::USAGE_COUNTRY_HU,
            self::USAGE_COUNTRY_ID,
            self::USAGE_COUNTRY_IE,
            self::USAGE_COUNTRY_IL,
            self::USAGE_COUNTRY_IN,
            self::USAGE_COUNTRY_IO,
            self::USAGE_COUNTRY_IQ,
            self::USAGE_COUNTRY_IR,
            self::USAGE_COUNTRY_IS,
            self::USAGE_COUNTRY_IT,
            self::USAGE_COUNTRY_JM,
            self::USAGE_COUNTRY_JO,
            self::USAGE_COUNTRY_JP,
            self::USAGE_COUNTRY_KE,
            self::USAGE_COUNTRY_KG,
            self::USAGE_COUNTRY_KH,
            self::USAGE_COUNTRY_KI,
            self::USAGE_COUNTRY_KM,
            self::USAGE_COUNTRY_KN,
            self::USAGE_COUNTRY_KP,
            self::USAGE_COUNTRY_KR,
            self::USAGE_COUNTRY_KW,
            self::USAGE_COUNTRY_KY,
            self::USAGE_COUNTRY_KZ,
            self::USAGE_COUNTRY_LA,
            self::USAGE_COUNTRY_LB,
            self::USAGE_COUNTRY_LC,
            self::USAGE_COUNTRY_LI,
            self::USAGE_COUNTRY_LK,
            self::USAGE_COUNTRY_LR,
            self::USAGE_COUNTRY_LS,
            self::USAGE_COUNTRY_LT,
            self::USAGE_COUNTRY_LU,
            self::USAGE_COUNTRY_LV,
            self::USAGE_COUNTRY_LY,
            self::USAGE_COUNTRY_MA,
            self::USAGE_COUNTRY_MC,
            self::USAGE_COUNTRY_MD,
            self::USAGE_COUNTRY_ME,
            self::USAGE_COUNTRY_MG,
            self::USAGE_COUNTRY_MH,
            self::USAGE_COUNTRY_MK,
            self::USAGE_COUNTRY_ML,
            self::USAGE_COUNTRY_MM,
            self::USAGE_COUNTRY_MN,
            self::USAGE_COUNTRY_MO,
            self::USAGE_COUNTRY_MP,
            self::USAGE_COUNTRY_MQ,
            self::USAGE_COUNTRY_MR,
            self::USAGE_COUNTRY_MS,
            self::USAGE_COUNTRY_MT,
            self::USAGE_COUNTRY_MU,
            self::USAGE_COUNTRY_MV,
            self::USAGE_COUNTRY_MW,
            self::USAGE_COUNTRY_MX,
            self::USAGE_COUNTRY_MY,
            self::USAGE_COUNTRY_MZ,
            self::USAGE_COUNTRY_NA,
            self::USAGE_COUNTRY_NC,
            self::USAGE_COUNTRY_NE,
            self::USAGE_COUNTRY_NF,
            self::USAGE_COUNTRY_NG,
            self::USAGE_COUNTRY_NI,
            self::USAGE_COUNTRY_NL,
            self::USAGE_COUNTRY_NO,
            self::USAGE_COUNTRY_NP,
            self::USAGE_COUNTRY_NR,
            self::USAGE_COUNTRY_NU,
            self::USAGE_COUNTRY_NZ,
            self::USAGE_COUNTRY_OM,
            self::USAGE_COUNTRY_PA,
            self::USAGE_COUNTRY_PE,
            self::USAGE_COUNTRY_PF,
            self::USAGE_COUNTRY_PG,
            self::USAGE_COUNTRY_PH,
            self::USAGE_COUNTRY_PK,
            self::USAGE_COUNTRY_PL,
            self::USAGE_COUNTRY_PM,
            self::USAGE_COUNTRY_PR,
            self::USAGE_COUNTRY_PS,
            self::USAGE_COUNTRY_PT,
            self::USAGE_COUNTRY_PW,
            self::USAGE_COUNTRY_PY,
            self::USAGE_COUNTRY_QA,
            self::USAGE_COUNTRY_RE,
            self::USAGE_COUNTRY_RO,
            self::USAGE_COUNTRY_RS,
            self::USAGE_COUNTRY_RU,
            self::USAGE_COUNTRY_RW,
            self::USAGE_COUNTRY_SA,
            self::USAGE_COUNTRY_SB,
            self::USAGE_COUNTRY_SC,
            self::USAGE_COUNTRY_SD,
            self::USAGE_COUNTRY_SE,
            self::USAGE_COUNTRY_SG,
            self::USAGE_COUNTRY_SH,
            self::USAGE_COUNTRY_SI,
            self::USAGE_COUNTRY_SK,
            self::USAGE_COUNTRY_SL,
            self::USAGE_COUNTRY_SM,
            self::USAGE_COUNTRY_SN,
            self::USAGE_COUNTRY_SO,
            self::USAGE_COUNTRY_SR,
            self::USAGE_COUNTRY_SS,
            self::USAGE_COUNTRY_ST,
            self::USAGE_COUNTRY_SV,
            self::USAGE_COUNTRY_SX,
            self::USAGE_COUNTRY_SY,
            self::USAGE_COUNTRY_SZ,
            self::USAGE_COUNTRY_TC,
            self::USAGE_COUNTRY_TD,
            self::USAGE_COUNTRY_TG,
            self::USAGE_COUNTRY_TH,
            self::USAGE_COUNTRY_TJ,
            self::USAGE_COUNTRY_TK,
            self::USAGE_COUNTRY_TL,
            self::USAGE_COUNTRY_TM,
            self::USAGE_COUNTRY_TN,
            self::USAGE_COUNTRY_TO,
            self::USAGE_COUNTRY_TR,
            self::USAGE_COUNTRY_TT,
            self::USAGE_COUNTRY_TV,
            self::USAGE_COUNTRY_TW,
            self::USAGE_COUNTRY_TZ,
            self::USAGE_COUNTRY_UA,
            self::USAGE_COUNTRY_UG,
            self::USAGE_COUNTRY_US,
            self::USAGE_COUNTRY_UY,
            self::USAGE_COUNTRY_VA,
            self::USAGE_COUNTRY_VC,
            self::USAGE_COUNTRY_VE,
            self::USAGE_COUNTRY_VG,
            self::USAGE_COUNTRY_VI,
            self::USAGE_COUNTRY_VN,
            self::USAGE_COUNTRY_VU,
            self::USAGE_COUNTRY_WF,
            self::USAGE_COUNTRY_WS,
            self::USAGE_COUNTRY_XG,
            self::USAGE_COUNTRY_XI,
            self::USAGE_COUNTRY_XN,
            self::USAGE_COUNTRY_XV,
            self::USAGE_COUNTRY_YE,
            self::USAGE_COUNTRY_ZA,
            self::USAGE_COUNTRY_ZM,
            self::USAGE_COUNTRY_ZW,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getCurrencyAllowableValues()
    {
        return [
            self::CURRENCY_USD,
            self::CURRENCY_CAD,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['compositeKey'] = isset($data['compositeKey']) ? $data['compositeKey'] : null;
        $this->container['effectiveDate'] = isset($data['effectiveDate']) ? $data['effectiveDate'] : null;
        $this->container['dialerType'] = isset($data['dialerType']) ? $data['dialerType'] : null;
        $this->container['domain'] = isset($data['domain']) ? $data['domain'] : null;
        $this->container['usageCountry'] = isset($data['usageCountry']) ? $data['usageCountry'] : null;
        $this->container['currency'] = isset($data['currency']) ? $data['currency'] : null;
        $this->container['minDurationSeconds'] = isset($data['minDurationSeconds']) ? $data['minDurationSeconds'] : null;
        $this->container['minIncrementSeconds'] = isset($data['minIncrementSeconds']) ? $data['minIncrementSeconds'] : null;
        $this->container['shortDurationSeconds'] = isset($data['shortDurationSeconds']) ? $data['shortDurationSeconds'] : null;
        $this->container['cnamLookupPrice'] = isset($data['cnamLookupPrice']) ? $data['cnamLookupPrice'] : null;
        $this->container['shortDurationPrice'] = isset($data['shortDurationPrice']) ? $data['shortDurationPrice'] : null;
        $this->container['rates'] = isset($data['rates']) ? $data['rates'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("NO_DIALER");
        if (!in_array($this->container['dialerType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'dialerType', must be one of #{allowed_values}.";
        }

        $allowed_values = array("CA", "FR", "GB", "IE", "US", "NA_TF");
        if (!in_array($this->container['domain'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'domain', must be one of #{allowed_values}.";
        }

        $allowed_values = array("AD", "AE", "AF", "AG", "AI", "AL", "AM", "AO", "AQ", "AR", "AS", "AT", "AU", "AW", "AZ", "BA", "BB", "BD", "BE", "BF", "BG", "BH", "BI", "BJ", "BM", "BN", "BO", "BR", "BS", "BT", "BW", "BY", "BZ", "CA", "CD", "CF", "CG", "CH", "CI", "CK", "CL", "CM", "CN", "CO", "CR", "CU", "CV", "CY", "CZ", "DE", "DJ", "DK", "DM", "DO", "DZ", "EC", "EE", "EG", "ER", "ES", "ET", "FI", "FJ", "FK", "FM", "FO", "FR", "GA", "GB", "GD", "GE", "GF", "GH", "GI", "GL", "GM", "GN", "GP", "GQ", "GR", "GT", "GU", "GW", "GY", "HK", "HN", "HR", "HT", "HU", "ID", "IE", "IL", "IN", "IO", "IQ", "IR", "IS", "IT", "JM", "JO", "JP", "KE", "KG", "KH", "KI", "KM", "KN", "KP", "KR", "KW", "KY", "KZ", "LA", "LB", "LC", "LI", "LK", "LR", "LS", "LT", "LU", "LV", "LY", "MA", "MC", "MD", "ME", "MG", "MH", "MK", "ML", "MM", "MN", "MO", "MP", "MQ", "MR", "MS", "MT", "MU", "MV", "MW", "MX", "MY", "MZ", "NA", "NC", "NE", "NF", "NG", "NI", "NL", "NO", "NP", "NR", "NU", "NZ", "OM", "PA", "PE", "PF", "PG", "PH", "PK", "PL", "PM", "PR", "PS", "PT", "PW", "PY", "QA", "RE", "RO", "RS", "RU", "RW", "SA", "SB", "SC", "SD", "SE", "SG", "SH", "SI", "SK", "SL", "SM", "SN", "SO", "SR", "SS", "ST", "SV", "SX", "SY", "SZ", "TC", "TD", "TG", "TH", "TJ", "TK", "TL", "TM", "TN", "TO", "TR", "TT", "TV", "TW", "TZ", "UA", "UG", "US", "UY", "VA", "VC", "VE", "VG", "VI", "VN", "VU", "WF", "WS", "XG", "XI", "XN", "XV", "YE", "ZA", "ZM", "ZW");
        if (!in_array($this->container['usageCountry'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'usageCountry', must be one of #{allowed_values}.";
        }

        $allowed_values = array("USD", "CAD");
        if (!in_array($this->container['currency'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'currency', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("NO_DIALER");
        if (!in_array($this->container['dialerType'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("CA", "FR", "GB", "IE", "US", "NA_TF");
        if (!in_array($this->container['domain'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("AD", "AE", "AF", "AG", "AI", "AL", "AM", "AO", "AQ", "AR", "AS", "AT", "AU", "AW", "AZ", "BA", "BB", "BD", "BE", "BF", "BG", "BH", "BI", "BJ", "BM", "BN", "BO", "BR", "BS", "BT", "BW", "BY", "BZ", "CA", "CD", "CF", "CG", "CH", "CI", "CK", "CL", "CM", "CN", "CO", "CR", "CU", "CV", "CY", "CZ", "DE", "DJ", "DK", "DM", "DO", "DZ", "EC", "EE", "EG", "ER", "ES", "ET", "FI", "FJ", "FK", "FM", "FO", "FR", "GA", "GB", "GD", "GE", "GF", "GH", "GI", "GL", "GM", "GN", "GP", "GQ", "GR", "GT", "GU", "GW", "GY", "HK", "HN", "HR", "HT", "HU", "ID", "IE", "IL", "IN", "IO", "IQ", "IR", "IS", "IT", "JM", "JO", "JP", "KE", "KG", "KH", "KI", "KM", "KN", "KP", "KR", "KW", "KY", "KZ", "LA", "LB", "LC", "LI", "LK", "LR", "LS", "LT", "LU", "LV", "LY", "MA", "MC", "MD", "ME", "MG", "MH", "MK", "ML", "MM", "MN", "MO", "MP", "MQ", "MR", "MS", "MT", "MU", "MV", "MW", "MX", "MY", "MZ", "NA", "NC", "NE", "NF", "NG", "NI", "NL", "NO", "NP", "NR", "NU", "NZ", "OM", "PA", "PE", "PF", "PG", "PH", "PK", "PL", "PM", "PR", "PS", "PT", "PW", "PY", "QA", "RE", "RO", "RS", "RU", "RW", "SA", "SB", "SC", "SD", "SE", "SG", "SH", "SI", "SK", "SL", "SM", "SN", "SO", "SR", "SS", "ST", "SV", "SX", "SY", "SZ", "TC", "TD", "TG", "TH", "TJ", "TK", "TL", "TM", "TN", "TO", "TR", "TT", "TV", "TW", "TZ", "UA", "UG", "US", "UY", "VA", "VC", "VE", "VG", "VI", "VN", "VU", "WF", "WS", "XG", "XI", "XN", "XV", "YE", "ZA", "ZM", "ZW");
        if (!in_array($this->container['usageCountry'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("USD", "CAD");
        if (!in_array($this->container['currency'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets compositeKey
     * @return string
     */
    public function getCompositeKey()
    {
        return $this->container['compositeKey'];
    }

    /**
     * Sets compositeKey
     * @param string $compositeKey
     * @return $this
     */
    public function setCompositeKey($compositeKey)
    {
        $this->container['compositeKey'] = $compositeKey;

        return $this;
    }

    /**
     * Gets effectiveDate
     * @return \DateTime
     */
    public function getEffectiveDate()
    {
        return $this->container['effectiveDate'];
    }

    /**
     * Sets effectiveDate
     * @param \DateTime $effectiveDate Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd
     * @return $this
     */
    public function setEffectiveDate($effectiveDate)
    {
        $this->container['effectiveDate'] = $effectiveDate;

        return $this;
    }

    /**
     * Gets dialerType
     * @return string
     */
    public function getDialerType()
    {
        return $this->container['dialerType'];
    }

    /**
     * Sets dialerType
     * @param string $dialerType
     * @return $this
     */
    public function setDialerType($dialerType)
    {
        $allowed_values = array('NO_DIALER');
        if (!in_array($dialerType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'dialerType', must be one of 'NO_DIALER'");
        }
        $this->container['dialerType'] = $dialerType;

        return $this;
    }

    /**
     * Gets domain
     * @return string
     */
    public function getDomain()
    {
        return $this->container['domain'];
    }

    /**
     * Sets domain
     * @param string $domain
     * @return $this
     */
    public function setDomain($domain)
    {
        $allowed_values = array('CA', 'FR', 'GB', 'IE', 'US', 'NA_TF');
        if (!in_array($domain, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'domain', must be one of 'CA', 'FR', 'GB', 'IE', 'US', 'NA_TF'");
        }
        $this->container['domain'] = $domain;

        return $this;
    }

    /**
     * Gets usageCountry
     * @return string
     */
    public function getUsageCountry()
    {
        return $this->container['usageCountry'];
    }

    /**
     * Sets usageCountry
     * @param string $usageCountry
     * @return $this
     */
    public function setUsageCountry($usageCountry)
    {
        $allowed_values = array('AD', 'AE', 'AF', 'AG', 'AI', 'AL', 'AM', 'AO', 'AQ', 'AR', 'AS', 'AT', 'AU', 'AW', 'AZ', 'BA', 'BB', 'BD', 'BE', 'BF', 'BG', 'BH', 'BI', 'BJ', 'BM', 'BN', 'BO', 'BR', 'BS', 'BT', 'BW', 'BY', 'BZ', 'CA', 'CD', 'CF', 'CG', 'CH', 'CI', 'CK', 'CL', 'CM', 'CN', 'CO', 'CR', 'CU', 'CV', 'CY', 'CZ', 'DE', 'DJ', 'DK', 'DM', 'DO', 'DZ', 'EC', 'EE', 'EG', 'ER', 'ES', 'ET', 'FI', 'FJ', 'FK', 'FM', 'FO', 'FR', 'GA', 'GB', 'GD', 'GE', 'GF', 'GH', 'GI', 'GL', 'GM', 'GN', 'GP', 'GQ', 'GR', 'GT', 'GU', 'GW', 'GY', 'HK', 'HN', 'HR', 'HT', 'HU', 'ID', 'IE', 'IL', 'IN', 'IO', 'IQ', 'IR', 'IS', 'IT', 'JM', 'JO', 'JP', 'KE', 'KG', 'KH', 'KI', 'KM', 'KN', 'KP', 'KR', 'KW', 'KY', 'KZ', 'LA', 'LB', 'LC', 'LI', 'LK', 'LR', 'LS', 'LT', 'LU', 'LV', 'LY', 'MA', 'MC', 'MD', 'ME', 'MG', 'MH', 'MK', 'ML', 'MM', 'MN', 'MO', 'MP', 'MQ', 'MR', 'MS', 'MT', 'MU', 'MV', 'MW', 'MX', 'MY', 'MZ', 'NA', 'NC', 'NE', 'NF', 'NG', 'NI', 'NL', 'NO', 'NP', 'NR', 'NU', 'NZ', 'OM', 'PA', 'PE', 'PF', 'PG', 'PH', 'PK', 'PL', 'PM', 'PR', 'PS', 'PT', 'PW', 'PY', 'QA', 'RE', 'RO', 'RS', 'RU', 'RW', 'SA', 'SB', 'SC', 'SD', 'SE', 'SG', 'SH', 'SI', 'SK', 'SL', 'SM', 'SN', 'SO', 'SR', 'SS', 'ST', 'SV', 'SX', 'SY', 'SZ', 'TC', 'TD', 'TG', 'TH', 'TJ', 'TK', 'TL', 'TM', 'TN', 'TO', 'TR', 'TT', 'TV', 'TW', 'TZ', 'UA', 'UG', 'US', 'UY', 'VA', 'VC', 'VE', 'VG', 'VI', 'VN', 'VU', 'WF', 'WS', 'XG', 'XI', 'XN', 'XV', 'YE', 'ZA', 'ZM', 'ZW');
        if (!in_array($usageCountry, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'usageCountry', must be one of 'AD', 'AE', 'AF', 'AG', 'AI', 'AL', 'AM', 'AO', 'AQ', 'AR', 'AS', 'AT', 'AU', 'AW', 'AZ', 'BA', 'BB', 'BD', 'BE', 'BF', 'BG', 'BH', 'BI', 'BJ', 'BM', 'BN', 'BO', 'BR', 'BS', 'BT', 'BW', 'BY', 'BZ', 'CA', 'CD', 'CF', 'CG', 'CH', 'CI', 'CK', 'CL', 'CM', 'CN', 'CO', 'CR', 'CU', 'CV', 'CY', 'CZ', 'DE', 'DJ', 'DK', 'DM', 'DO', 'DZ', 'EC', 'EE', 'EG', 'ER', 'ES', 'ET', 'FI', 'FJ', 'FK', 'FM', 'FO', 'FR', 'GA', 'GB', 'GD', 'GE', 'GF', 'GH', 'GI', 'GL', 'GM', 'GN', 'GP', 'GQ', 'GR', 'GT', 'GU', 'GW', 'GY', 'HK', 'HN', 'HR', 'HT', 'HU', 'ID', 'IE', 'IL', 'IN', 'IO', 'IQ', 'IR', 'IS', 'IT', 'JM', 'JO', 'JP', 'KE', 'KG', 'KH', 'KI', 'KM', 'KN', 'KP', 'KR', 'KW', 'KY', 'KZ', 'LA', 'LB', 'LC', 'LI', 'LK', 'LR', 'LS', 'LT', 'LU', 'LV', 'LY', 'MA', 'MC', 'MD', 'ME', 'MG', 'MH', 'MK', 'ML', 'MM', 'MN', 'MO', 'MP', 'MQ', 'MR', 'MS', 'MT', 'MU', 'MV', 'MW', 'MX', 'MY', 'MZ', 'NA', 'NC', 'NE', 'NF', 'NG', 'NI', 'NL', 'NO', 'NP', 'NR', 'NU', 'NZ', 'OM', 'PA', 'PE', 'PF', 'PG', 'PH', 'PK', 'PL', 'PM', 'PR', 'PS', 'PT', 'PW', 'PY', 'QA', 'RE', 'RO', 'RS', 'RU', 'RW', 'SA', 'SB', 'SC', 'SD', 'SE', 'SG', 'SH', 'SI', 'SK', 'SL', 'SM', 'SN', 'SO', 'SR', 'SS', 'ST', 'SV', 'SX', 'SY', 'SZ', 'TC', 'TD', 'TG', 'TH', 'TJ', 'TK', 'TL', 'TM', 'TN', 'TO', 'TR', 'TT', 'TV', 'TW', 'TZ', 'UA', 'UG', 'US', 'UY', 'VA', 'VC', 'VE', 'VG', 'VI', 'VN', 'VU', 'WF', 'WS', 'XG', 'XI', 'XN', 'XV', 'YE', 'ZA', 'ZM', 'ZW'");
        }
        $this->container['usageCountry'] = $usageCountry;

        return $this;
    }

    /**
     * Gets currency
     * @return string
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     * @param string $currency
     * @return $this
     */
    public function setCurrency($currency)
    {
        $allowed_values = array('USD', 'CAD');
        if (!in_array($currency, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'currency', must be one of 'USD', 'CAD'");
        }
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets minDurationSeconds
     * @return int
     */
    public function getMinDurationSeconds()
    {
        return $this->container['minDurationSeconds'];
    }

    /**
     * Sets minDurationSeconds
     * @param int $minDurationSeconds
     * @return $this
     */
    public function setMinDurationSeconds($minDurationSeconds)
    {
        $this->container['minDurationSeconds'] = $minDurationSeconds;

        return $this;
    }

    /**
     * Gets minIncrementSeconds
     * @return int
     */
    public function getMinIncrementSeconds()
    {
        return $this->container['minIncrementSeconds'];
    }

    /**
     * Sets minIncrementSeconds
     * @param int $minIncrementSeconds
     * @return $this
     */
    public function setMinIncrementSeconds($minIncrementSeconds)
    {
        $this->container['minIncrementSeconds'] = $minIncrementSeconds;

        return $this;
    }

    /**
     * Gets shortDurationSeconds
     * @return int
     */
    public function getShortDurationSeconds()
    {
        return $this->container['shortDurationSeconds'];
    }

    /**
     * Sets shortDurationSeconds
     * @param int $shortDurationSeconds
     * @return $this
     */
    public function setShortDurationSeconds($shortDurationSeconds)
    {
        $this->container['shortDurationSeconds'] = $shortDurationSeconds;

        return $this;
    }

    /**
     * Gets cnamLookupPrice
     * @return float
     */
    public function getCnamLookupPrice()
    {
        return $this->container['cnamLookupPrice'];
    }

    /**
     * Sets cnamLookupPrice
     * @param float $cnamLookupPrice
     * @return $this
     */
    public function setCnamLookupPrice($cnamLookupPrice)
    {
        $this->container['cnamLookupPrice'] = $cnamLookupPrice;

        return $this;
    }

    /**
     * Gets shortDurationPrice
     * @return float
     */
    public function getShortDurationPrice()
    {
        return $this->container['shortDurationPrice'];
    }

    /**
     * Sets shortDurationPrice
     * @param float $shortDurationPrice
     * @return $this
     */
    public function setShortDurationPrice($shortDurationPrice)
    {
        $this->container['shortDurationPrice'] = $shortDurationPrice;

        return $this;
    }

    /**
     * Gets rates
     * @return \PureCloudSDK\UsageRate[]
     */
    public function getRates()
    {
        return $this->container['rates'];
    }

    /**
     * Sets rates
     * @param \PureCloudSDK\UsageRate[] $rates
     * @return $this
     */
    public function setRates($rates)
    {
        $this->container['rates'] = $rates;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


