<?php
/**
 * VoiceRateInternational
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * VoiceRateInternational Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class VoiceRateInternational implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'VoiceRateInternational';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'currency' => 'string',
        'amendmentId' => 'string',
        'type' => 'string',
        'effectiveDate' => '\DateTime',
        'rate' => 'float',
        'durationMinimumSeconds' => 'int',
        'durationIncrementSeconds' => 'int',
        'origin' => 'string',
        'destination' => 'string',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'currency' => 'currency',
        'amendmentId' => 'amendmentId',
        'type' => 'type',
        'effectiveDate' => 'effectiveDate',
        'rate' => 'rate',
        'durationMinimumSeconds' => 'durationMinimumSeconds',
        'durationIncrementSeconds' => 'durationIncrementSeconds',
        'origin' => 'origin',
        'destination' => 'destination',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'currency' => 'setCurrency',
        'amendmentId' => 'setAmendmentId',
        'type' => 'setType',
        'effectiveDate' => 'setEffectiveDate',
        'rate' => 'setRate',
        'durationMinimumSeconds' => 'setDurationMinimumSeconds',
        'durationIncrementSeconds' => 'setDurationIncrementSeconds',
        'origin' => 'setOrigin',
        'destination' => 'setDestination',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'currency' => 'getCurrency',
        'amendmentId' => 'getAmendmentId',
        'type' => 'getType',
        'effectiveDate' => 'getEffectiveDate',
        'rate' => 'getRate',
        'durationMinimumSeconds' => 'getDurationMinimumSeconds',
        'durationIncrementSeconds' => 'getDurationIncrementSeconds',
        'origin' => 'getOrigin',
        'destination' => 'getDestination',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const TYPE_RATE_TOLL_FREE = 'RATE_TOLL_FREE';
    const TYPE_RATE_TOLLED = 'RATE_TOLLED';
    const TYPE_OUTBOUND_INTERSTATE = 'OUTBOUND_INTERSTATE';
    const TYPE_OUTBOUND_INTRASTATE = 'OUTBOUND_INTRASTATE';
    const TYPE_OUTBOUND_LOCAL = 'OUTBOUND_LOCAL';
    const TYPE_EXTENDED = 'EXTENDED';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_RATE_TOLL_FREE,
            self::TYPE_RATE_TOLLED,
            self::TYPE_OUTBOUND_INTERSTATE,
            self::TYPE_OUTBOUND_INTRASTATE,
            self::TYPE_OUTBOUND_LOCAL,
            self::TYPE_EXTENDED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['currency'] = isset($data['currency']) ? $data['currency'] : null;
        $this->container['amendmentId'] = isset($data['amendmentId']) ? $data['amendmentId'] : null;
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['effectiveDate'] = isset($data['effectiveDate']) ? $data['effectiveDate'] : null;
        $this->container['rate'] = isset($data['rate']) ? $data['rate'] : null;
        $this->container['durationMinimumSeconds'] = isset($data['durationMinimumSeconds']) ? $data['durationMinimumSeconds'] : null;
        $this->container['durationIncrementSeconds'] = isset($data['durationIncrementSeconds']) ? $data['durationIncrementSeconds'] : null;
        $this->container['origin'] = isset($data['origin']) ? $data['origin'] : null;
        $this->container['destination'] = isset($data['destination']) ? $data['destination'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['currency'] === null) {
            $invalid_properties[] = "'currency' can't be null";
        }
        if ($this->container['amendmentId'] === null) {
            $invalid_properties[] = "'amendmentId' can't be null";
        }
        if ($this->container['type'] === null) {
            $invalid_properties[] = "'type' can't be null";
        }
        $allowed_values = array("RATE_TOLL_FREE", "RATE_TOLLED", "OUTBOUND_INTERSTATE", "OUTBOUND_INTRASTATE", "OUTBOUND_LOCAL", "EXTENDED");
        if (!in_array($this->container['type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'type', must be one of #{allowed_values}.";
        }

        if ($this->container['effectiveDate'] === null) {
            $invalid_properties[] = "'effectiveDate' can't be null";
        }
        if ($this->container['rate'] === null) {
            $invalid_properties[] = "'rate' can't be null";
        }
        if ($this->container['durationMinimumSeconds'] === null) {
            $invalid_properties[] = "'durationMinimumSeconds' can't be null";
        }
        if ($this->container['durationIncrementSeconds'] === null) {
            $invalid_properties[] = "'durationIncrementSeconds' can't be null";
        }
        if ($this->container['origin'] === null) {
            $invalid_properties[] = "'origin' can't be null";
        }
        if ($this->container['destination'] === null) {
            $invalid_properties[] = "'destination' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['currency'] === null) {
            return false;
        }
        if ($this->container['amendmentId'] === null) {
            return false;
        }
        if ($this->container['type'] === null) {
            return false;
        }
        $allowed_values = array("RATE_TOLL_FREE", "RATE_TOLLED", "OUTBOUND_INTERSTATE", "OUTBOUND_INTRASTATE", "OUTBOUND_LOCAL", "EXTENDED");
        if (!in_array($this->container['type'], $allowed_values)) {
            return false;
        }
        if ($this->container['effectiveDate'] === null) {
            return false;
        }
        if ($this->container['rate'] === null) {
            return false;
        }
        if ($this->container['durationMinimumSeconds'] === null) {
            return false;
        }
        if ($this->container['durationIncrementSeconds'] === null) {
            return false;
        }
        if ($this->container['origin'] === null) {
            return false;
        }
        if ($this->container['destination'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets currency
     * @return string
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     * @param string $currency The ISO 4217 currency code of the voice rate.
     * @return $this
     */
    public function setCurrency($currency)
    {
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets amendmentId
     * @return string
     */
    public function getAmendmentId()
    {
        return $this->container['amendmentId'];
    }

    /**
     * Sets amendmentId
     * @param string $amendmentId The amendment Id of the voice rate.
     * @return $this
     */
    public function setAmendmentId($amendmentId)
    {
        $this->container['amendmentId'] = $amendmentId;

        return $this;
    }

    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type The voice rate type.
     * @return $this
     */
    public function setType($type)
    {
        $allowed_values = array('RATE_TOLL_FREE', 'RATE_TOLLED', 'OUTBOUND_INTERSTATE', 'OUTBOUND_INTRASTATE', 'OUTBOUND_LOCAL', 'EXTENDED');
        if (!in_array($type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'type', must be one of 'RATE_TOLL_FREE', 'RATE_TOLLED', 'OUTBOUND_INTERSTATE', 'OUTBOUND_INTRASTATE', 'OUTBOUND_LOCAL', 'EXTENDED'");
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets effectiveDate
     * @return \DateTime
     */
    public function getEffectiveDate()
    {
        return $this->container['effectiveDate'];
    }

    /**
     * Sets effectiveDate
     * @param \DateTime $effectiveDate The effective date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setEffectiveDate($effectiveDate)
    {
        $this->container['effectiveDate'] = $effectiveDate;

        return $this;
    }

    /**
     * Gets rate
     * @return float
     */
    public function getRate()
    {
        return $this->container['rate'];
    }

    /**
     * Sets rate
     * @param float $rate The rate.
     * @return $this
     */
    public function setRate($rate)
    {
        $this->container['rate'] = $rate;

        return $this;
    }

    /**
     * Gets durationMinimumSeconds
     * @return int
     */
    public function getDurationMinimumSeconds()
    {
        return $this->container['durationMinimumSeconds'];
    }

    /**
     * Sets durationMinimumSeconds
     * @param int $durationMinimumSeconds The minimum duration charged in seconds.
     * @return $this
     */
    public function setDurationMinimumSeconds($durationMinimumSeconds)
    {
        $this->container['durationMinimumSeconds'] = $durationMinimumSeconds;

        return $this;
    }

    /**
     * Gets durationIncrementSeconds
     * @return int
     */
    public function getDurationIncrementSeconds()
    {
        return $this->container['durationIncrementSeconds'];
    }

    /**
     * Sets durationIncrementSeconds
     * @param int $durationIncrementSeconds The billing duration increment in seconds.
     * @return $this
     */
    public function setDurationIncrementSeconds($durationIncrementSeconds)
    {
        $this->container['durationIncrementSeconds'] = $durationIncrementSeconds;

        return $this;
    }

    /**
     * Gets origin
     * @return string
     */
    public function getOrigin()
    {
        return $this->container['origin'];
    }

    /**
     * Sets origin
     * @param string $origin The origin.
     * @return $this
     */
    public function setOrigin($origin)
    {
        $this->container['origin'] = $origin;

        return $this;
    }

    /**
     * Gets destination
     * @return string
     */
    public function getDestination()
    {
        return $this->container['destination'];
    }

    /**
     * Sets destination
     * @param string $destination The destination.
     * @return $this
     */
    public function setDestination($destination)
    {
        $this->container['destination'] = $destination;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


