# PureCloudSDK\AlertingApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteAlertingHeartbeatAlertsAlertId**](AlertingApi.md#deleteAlertingHeartbeatAlertsAlertId) | **DELETE** /api/v2/alerting/heartbeat/alerts/{alertId} | Delete a heart beat alert
[**deleteAlertingHeartbeatRulesRuleId**](AlertingApi.md#deleteAlertingHeartbeatRulesRuleId) | **DELETE** /api/v2/alerting/heartbeat/rules/{ruleId} | Delete a heart beat rule.
[**deleteAlertingInteractionstatsAlertsAlertId**](AlertingApi.md#deleteAlertingInteractionstatsAlertsAlertId) | **DELETE** /api/v2/alerting/interactionstats/alerts/{alertId} | Delete an interaction stats alert
[**deleteAlertingInteractionstatsRulesRuleId**](AlertingApi.md#deleteAlertingInteractionstatsRulesRuleId) | **DELETE** /api/v2/alerting/interactionstats/rules/{ruleId} | Delete an interaction stats rule.
[**getAlertingHeartbeatAlerts**](AlertingApi.md#getAlertingHeartbeatAlerts) | **GET** /api/v2/alerting/heartbeat/alerts | Get heart beat alert list.
[**getAlertingHeartbeatAlertsAlertId**](AlertingApi.md#getAlertingHeartbeatAlertsAlertId) | **GET** /api/v2/alerting/heartbeat/alerts/{alertId} | Get a heart beat alert
[**getAlertingHeartbeatRules**](AlertingApi.md#getAlertingHeartbeatRules) | **GET** /api/v2/alerting/heartbeat/rules | Get a heart beat rule list.
[**getAlertingHeartbeatRulesRuleId**](AlertingApi.md#getAlertingHeartbeatRulesRuleId) | **GET** /api/v2/alerting/heartbeat/rules/{ruleId} | Get a heart beat rule.
[**getAlertingInteractionstatsAlerts**](AlertingApi.md#getAlertingInteractionstatsAlerts) | **GET** /api/v2/alerting/interactionstats/alerts | Get interaction stats alert list.
[**getAlertingInteractionstatsAlertsAlertId**](AlertingApi.md#getAlertingInteractionstatsAlertsAlertId) | **GET** /api/v2/alerting/interactionstats/alerts/{alertId} | Get an interaction stats alert
[**getAlertingInteractionstatsAlertsUnread**](AlertingApi.md#getAlertingInteractionstatsAlertsUnread) | **GET** /api/v2/alerting/interactionstats/alerts/unread | Gets user unread count of interaction stats alerts.
[**getAlertingInteractionstatsRules**](AlertingApi.md#getAlertingInteractionstatsRules) | **GET** /api/v2/alerting/interactionstats/rules | Get an interaction stats rule list.
[**getAlertingInteractionstatsRulesRuleId**](AlertingApi.md#getAlertingInteractionstatsRulesRuleId) | **GET** /api/v2/alerting/interactionstats/rules/{ruleId} | Get an interaction stats rule.
[**postAlertingHeartbeatRules**](AlertingApi.md#postAlertingHeartbeatRules) | **POST** /api/v2/alerting/heartbeat/rules | Create a heart beat rule.
[**postAlertingInteractionstatsRules**](AlertingApi.md#postAlertingInteractionstatsRules) | **POST** /api/v2/alerting/interactionstats/rules | Create an interaction stats rule.
[**putAlertingHeartbeatRulesRuleId**](AlertingApi.md#putAlertingHeartbeatRulesRuleId) | **PUT** /api/v2/alerting/heartbeat/rules/{ruleId} | Update a heart beat rule
[**putAlertingInteractionstatsAlertsAlertId**](AlertingApi.md#putAlertingInteractionstatsAlertsAlertId) | **PUT** /api/v2/alerting/interactionstats/alerts/{alertId} | Update an interaction stats alert read status
[**putAlertingInteractionstatsRulesRuleId**](AlertingApi.md#putAlertingInteractionstatsRulesRuleId) | **PUT** /api/v2/alerting/interactionstats/rules/{ruleId} | Update an interaction stats rule


# **deleteAlertingHeartbeatAlertsAlertId**
> deleteAlertingHeartbeatAlertsAlertId($alertId)

Delete a heart beat alert



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$alertId = "alertId_example"; // string | Alert ID

try {
    $api_instance->deleteAlertingHeartbeatAlertsAlertId($alertId);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->deleteAlertingHeartbeatAlertsAlertId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **alertId** | **string**| Alert ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteAlertingHeartbeatRulesRuleId**
> deleteAlertingHeartbeatRulesRuleId($ruleId)

Delete a heart beat rule.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$ruleId = "ruleId_example"; // string | Rule ID

try {
    $api_instance->deleteAlertingHeartbeatRulesRuleId($ruleId);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->deleteAlertingHeartbeatRulesRuleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ruleId** | **string**| Rule ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteAlertingInteractionstatsAlertsAlertId**
> deleteAlertingInteractionstatsAlertsAlertId($alertId)

Delete an interaction stats alert



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$alertId = "alertId_example"; // string | Alert ID

try {
    $api_instance->deleteAlertingInteractionstatsAlertsAlertId($alertId);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->deleteAlertingInteractionstatsAlertsAlertId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **alertId** | **string**| Alert ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteAlertingInteractionstatsRulesRuleId**
> deleteAlertingInteractionstatsRulesRuleId($ruleId)

Delete an interaction stats rule.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$ruleId = "ruleId_example"; // string | Rule ID

try {
    $api_instance->deleteAlertingInteractionstatsRulesRuleId($ruleId);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->deleteAlertingInteractionstatsRulesRuleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ruleId** | **string**| Rule ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAlertingHeartbeatAlerts**
> \PureCloudSDK\HeartBeatAlertContainer getAlertingHeartbeatAlerts()

Get heart beat alert list.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();

try {
    $result = $api_instance->getAlertingHeartbeatAlerts();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->getAlertingHeartbeatAlerts: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\HeartBeatAlertContainer**](../Model/HeartBeatAlertContainer.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAlertingHeartbeatAlertsAlertId**
> \PureCloudSDK\HeartBeatAlert getAlertingHeartbeatAlertsAlertId($alertId)

Get a heart beat alert



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$alertId = "alertId_example"; // string | Alert ID

try {
    $result = $api_instance->getAlertingHeartbeatAlertsAlertId($alertId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->getAlertingHeartbeatAlertsAlertId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **alertId** | **string**| Alert ID |

### Return type

[**\PureCloudSDK\HeartBeatAlert**](../Model/HeartBeatAlert.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAlertingHeartbeatRules**
> \PureCloudSDK\HeartBeatRuleContainer getAlertingHeartbeatRules()

Get a heart beat rule list.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();

try {
    $result = $api_instance->getAlertingHeartbeatRules();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->getAlertingHeartbeatRules: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\HeartBeatRuleContainer**](../Model/HeartBeatRuleContainer.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAlertingHeartbeatRulesRuleId**
> \PureCloudSDK\HeartBeatRule getAlertingHeartbeatRulesRuleId($ruleId)

Get a heart beat rule.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$ruleId = "ruleId_example"; // string | Rule ID

try {
    $result = $api_instance->getAlertingHeartbeatRulesRuleId($ruleId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->getAlertingHeartbeatRulesRuleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ruleId** | **string**| Rule ID |

### Return type

[**\PureCloudSDK\HeartBeatRule**](../Model/HeartBeatRule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAlertingInteractionstatsAlerts**
> \PureCloudSDK\InteractionStatsAlertContainer getAlertingInteractionstatsAlerts()

Get interaction stats alert list.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();

try {
    $result = $api_instance->getAlertingInteractionstatsAlerts();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->getAlertingInteractionstatsAlerts: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\InteractionStatsAlertContainer**](../Model/InteractionStatsAlertContainer.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAlertingInteractionstatsAlertsAlertId**
> \PureCloudSDK\InteractionStatsAlert getAlertingInteractionstatsAlertsAlertId($alertId)

Get an interaction stats alert



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$alertId = "alertId_example"; // string | Alert ID

try {
    $result = $api_instance->getAlertingInteractionstatsAlertsAlertId($alertId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->getAlertingInteractionstatsAlertsAlertId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **alertId** | **string**| Alert ID |

### Return type

[**\PureCloudSDK\InteractionStatsAlert**](../Model/InteractionStatsAlert.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAlertingInteractionstatsAlertsUnread**
> \PureCloudSDK\UnreadMetric getAlertingInteractionstatsAlertsUnread()

Gets user unread count of interaction stats alerts.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();

try {
    $result = $api_instance->getAlertingInteractionstatsAlertsUnread();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->getAlertingInteractionstatsAlertsUnread: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\UnreadMetric**](../Model/UnreadMetric.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAlertingInteractionstatsRules**
> \PureCloudSDK\InteractionStatsRuleContainer getAlertingInteractionstatsRules()

Get an interaction stats rule list.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();

try {
    $result = $api_instance->getAlertingInteractionstatsRules();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->getAlertingInteractionstatsRules: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\InteractionStatsRuleContainer**](../Model/InteractionStatsRuleContainer.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAlertingInteractionstatsRulesRuleId**
> \PureCloudSDK\InteractionStatsRule getAlertingInteractionstatsRulesRuleId($ruleId)

Get an interaction stats rule.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$ruleId = "ruleId_example"; // string | Rule ID

try {
    $result = $api_instance->getAlertingInteractionstatsRulesRuleId($ruleId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->getAlertingInteractionstatsRulesRuleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ruleId** | **string**| Rule ID |

### Return type

[**\PureCloudSDK\InteractionStatsRule**](../Model/InteractionStatsRule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAlertingHeartbeatRules**
> \PureCloudSDK\HeartBeatRule postAlertingHeartbeatRules($body)

Create a heart beat rule.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$body = new \PureCloudSDK\HeartBeatRule(); // \PureCloudSDK\HeartBeatRule | HeartBeatRule

try {
    $result = $api_instance->postAlertingHeartbeatRules($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->postAlertingHeartbeatRules: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\HeartBeatRule**](../Model/\PureCloudSDK\HeartBeatRule.md)| HeartBeatRule |

### Return type

[**\PureCloudSDK\HeartBeatRule**](../Model/HeartBeatRule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAlertingInteractionstatsRules**
> \PureCloudSDK\InteractionStatsRule postAlertingInteractionstatsRules($body)

Create an interaction stats rule.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$body = new \PureCloudSDK\InteractionStatsRule(); // \PureCloudSDK\InteractionStatsRule | AlertingRule

try {
    $result = $api_instance->postAlertingInteractionstatsRules($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->postAlertingInteractionstatsRules: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\InteractionStatsRule**](../Model/\PureCloudSDK\InteractionStatsRule.md)| AlertingRule |

### Return type

[**\PureCloudSDK\InteractionStatsRule**](../Model/InteractionStatsRule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putAlertingHeartbeatRulesRuleId**
> \PureCloudSDK\HeartBeatRule putAlertingHeartbeatRulesRuleId($ruleId, $body)

Update a heart beat rule



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$ruleId = "ruleId_example"; // string | Rule ID
$body = new \PureCloudSDK\HeartBeatRule(); // \PureCloudSDK\HeartBeatRule | HeartBeatRule

try {
    $result = $api_instance->putAlertingHeartbeatRulesRuleId($ruleId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->putAlertingHeartbeatRulesRuleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ruleId** | **string**| Rule ID |
 **body** | [**\PureCloudSDK\HeartBeatRule**](../Model/\PureCloudSDK\HeartBeatRule.md)| HeartBeatRule |

### Return type

[**\PureCloudSDK\HeartBeatRule**](../Model/HeartBeatRule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putAlertingInteractionstatsAlertsAlertId**
> \PureCloudSDK\UnreadStatus putAlertingInteractionstatsAlertsAlertId($alertId, $body)

Update an interaction stats alert read status



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$alertId = "alertId_example"; // string | Alert ID
$body = new \PureCloudSDK\UnreadStatus(); // \PureCloudSDK\UnreadStatus | InteractionStatsAlert

try {
    $result = $api_instance->putAlertingInteractionstatsAlertsAlertId($alertId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->putAlertingInteractionstatsAlertsAlertId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **alertId** | **string**| Alert ID |
 **body** | [**\PureCloudSDK\UnreadStatus**](../Model/\PureCloudSDK\UnreadStatus.md)| InteractionStatsAlert |

### Return type

[**\PureCloudSDK\UnreadStatus**](../Model/UnreadStatus.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putAlertingInteractionstatsRulesRuleId**
> \PureCloudSDK\InteractionStatsRule putAlertingInteractionstatsRulesRuleId($ruleId, $body)

Update an interaction stats rule



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$ruleId = "ruleId_example"; // string | Rule ID
$body = new \PureCloudSDK\InteractionStatsRule(); // \PureCloudSDK\InteractionStatsRule | AlertingRule

try {
    $result = $api_instance->putAlertingInteractionstatsRulesRuleId($ruleId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->putAlertingInteractionstatsRulesRuleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ruleId** | **string**| Rule ID |
 **body** | [**\PureCloudSDK\InteractionStatsRule**](../Model/\PureCloudSDK\InteractionStatsRule.md)| AlertingRule |

### Return type

[**\PureCloudSDK\InteractionStatsRule**](../Model/InteractionStatsRule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

