# PureCloudSDK\AnalyticsApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteAnalyticsReportingSchedulesScheduleId**](AnalyticsApi.md#deleteAnalyticsReportingSchedulesScheduleId) | **DELETE** /api/v2/analytics/reporting/schedules/{scheduleId} | Delete a scheduled report job.
[**getAnalyticsConversationsConversationIdDetails**](AnalyticsApi.md#getAnalyticsConversationsConversationIdDetails) | **GET** /api/v2/analytics/conversations/{conversationId}/details | Get a conversation by id
[**getAnalyticsReportingMetadata**](AnalyticsApi.md#getAnalyticsReportingMetadata) | **GET** /api/v2/analytics/reporting/metadata | Get list of reporting metadata.
[**getAnalyticsReportingReportIdMetadata**](AnalyticsApi.md#getAnalyticsReportingReportIdMetadata) | **GET** /api/v2/analytics/reporting/{reportId}/metadata | Get a reporting metadata.
[**getAnalyticsReportingReportformats**](AnalyticsApi.md#getAnalyticsReportingReportformats) | **GET** /api/v2/analytics/reporting/reportformats | Get a list of report formats
[**getAnalyticsReportingSchedules**](AnalyticsApi.md#getAnalyticsReportingSchedules) | **GET** /api/v2/analytics/reporting/schedules | Get a list of scheduled report jobs
[**getAnalyticsReportingSchedulesScheduleId**](AnalyticsApi.md#getAnalyticsReportingSchedulesScheduleId) | **GET** /api/v2/analytics/reporting/schedules/{scheduleId} | Get a scheduled report job.
[**getAnalyticsReportingSchedulesScheduleIdHistory**](AnalyticsApi.md#getAnalyticsReportingSchedulesScheduleIdHistory) | **GET** /api/v2/analytics/reporting/schedules/{scheduleId}/history | Get list of completed scheduled report jobs.
[**getAnalyticsReportingSchedulesScheduleIdHistoryLatest**](AnalyticsApi.md#getAnalyticsReportingSchedulesScheduleIdHistoryLatest) | **GET** /api/v2/analytics/reporting/schedules/{scheduleId}/history/latest | Get most recently completed scheduled report job.
[**getAnalyticsReportingSchedulesScheduleIdHistoryRunId**](AnalyticsApi.md#getAnalyticsReportingSchedulesScheduleIdHistoryRunId) | **GET** /api/v2/analytics/reporting/schedules/{scheduleId}/history/{runId} | A completed scheduled report job
[**getAnalyticsReportingTimeperiods**](AnalyticsApi.md#getAnalyticsReportingTimeperiods) | **GET** /api/v2/analytics/reporting/timeperiods | Get a list of report time periods.
[**postAnalyticsConversationsAggregatesQuery**](AnalyticsApi.md#postAnalyticsConversationsAggregatesQuery) | **POST** /api/v2/analytics/conversations/aggregates/query | Query for conversation aggregates
[**postAnalyticsConversationsConversationIdDetailsProperties**](AnalyticsApi.md#postAnalyticsConversationsConversationIdDetailsProperties) | **POST** /api/v2/analytics/conversations/{conversationId}/details/properties | Index conversation properties
[**postAnalyticsConversationsDetailsQuery**](AnalyticsApi.md#postAnalyticsConversationsDetailsQuery) | **POST** /api/v2/analytics/conversations/details/query | Query for conversation details
[**postAnalyticsEvaluationsAggregatesQuery**](AnalyticsApi.md#postAnalyticsEvaluationsAggregatesQuery) | **POST** /api/v2/analytics/evaluations/aggregates/query | Query for evaluation aggregates
[**postAnalyticsQueuesObservationsQuery**](AnalyticsApi.md#postAnalyticsQueuesObservationsQuery) | **POST** /api/v2/analytics/queues/observations/query | Query for queue observations
[**postAnalyticsReportingSchedules**](AnalyticsApi.md#postAnalyticsReportingSchedules) | **POST** /api/v2/analytics/reporting/schedules | Create a scheduled report job
[**postAnalyticsReportingSchedulesScheduleIdRunreport**](AnalyticsApi.md#postAnalyticsReportingSchedulesScheduleIdRunreport) | **POST** /api/v2/analytics/reporting/schedules/{scheduleId}/runreport | Place a scheduled report immediately into the reporting queue
[**postAnalyticsUsersAggregatesQuery**](AnalyticsApi.md#postAnalyticsUsersAggregatesQuery) | **POST** /api/v2/analytics/users/aggregates/query | Query for user aggregates
[**postAnalyticsUsersDetailsQuery**](AnalyticsApi.md#postAnalyticsUsersDetailsQuery) | **POST** /api/v2/analytics/users/details/query | Query for user details
[**postAnalyticsUsersObservationsQuery**](AnalyticsApi.md#postAnalyticsUsersObservationsQuery) | **POST** /api/v2/analytics/users/observations/query | Query for user observations
[**putAnalyticsReportingSchedulesScheduleId**](AnalyticsApi.md#putAnalyticsReportingSchedulesScheduleId) | **PUT** /api/v2/analytics/reporting/schedules/{scheduleId} | Update a scheduled report job.


# **deleteAnalyticsReportingSchedulesScheduleId**
> string deleteAnalyticsReportingSchedulesScheduleId($scheduleId)

Delete a scheduled report job.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$scheduleId = "scheduleId_example"; // string | Schedule ID

try {
    $result = $api_instance->deleteAnalyticsReportingSchedulesScheduleId($scheduleId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->deleteAnalyticsReportingSchedulesScheduleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **scheduleId** | **string**| Schedule ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAnalyticsConversationsConversationIdDetails**
> \PureCloudSDK\AnalyticsConversation getAnalyticsConversationsConversationIdDetails($conversationId)

Get a conversation by id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$conversationId = "conversationId_example"; // string | conversationId

try {
    $result = $api_instance->getAnalyticsConversationsConversationIdDetails($conversationId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->getAnalyticsConversationsConversationIdDetails: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |

### Return type

[**\PureCloudSDK\AnalyticsConversation**](../Model/AnalyticsConversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAnalyticsReportingMetadata**
> \PureCloudSDK\ReportMetaDataEntityListing getAnalyticsReportingMetadata($pageNumber, $pageSize, $locale)

Get list of reporting metadata.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$pageNumber = 1; // int | Page number
$pageSize = 25; // int | Page size
$locale = "locale_example"; // string | Locale

try {
    $result = $api_instance->getAnalyticsReportingMetadata($pageNumber, $pageSize, $locale);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->getAnalyticsReportingMetadata: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **locale** | **string**| Locale | [optional]

### Return type

[**\PureCloudSDK\ReportMetaDataEntityListing**](../Model/ReportMetaDataEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAnalyticsReportingReportIdMetadata**
> \PureCloudSDK\ReportMetaData getAnalyticsReportingReportIdMetadata($reportId, $locale)

Get a reporting metadata.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$reportId = "reportId_example"; // string | Report ID
$locale = "locale_example"; // string | Locale

try {
    $result = $api_instance->getAnalyticsReportingReportIdMetadata($reportId, $locale);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->getAnalyticsReportingReportIdMetadata: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **reportId** | **string**| Report ID |
 **locale** | **string**| Locale | [optional]

### Return type

[**\PureCloudSDK\ReportMetaData**](../Model/ReportMetaData.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAnalyticsReportingReportformats**
> string[] getAnalyticsReportingReportformats()

Get a list of report formats

Get a list of report formats.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();

try {
    $result = $api_instance->getAnalyticsReportingReportformats();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->getAnalyticsReportingReportformats: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

**string[]**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAnalyticsReportingSchedules**
> \PureCloudSDK\ReportScheduleEntityListing getAnalyticsReportingSchedules($pageNumber, $pageSize)

Get a list of scheduled report jobs

Get a list of scheduled report jobs.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$pageNumber = 1; // int | Page number
$pageSize = 25; // int | Page size

try {
    $result = $api_instance->getAnalyticsReportingSchedules($pageNumber, $pageSize);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->getAnalyticsReportingSchedules: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **pageSize** | **int**| Page size | [optional] [default to 25]

### Return type

[**\PureCloudSDK\ReportScheduleEntityListing**](../Model/ReportScheduleEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAnalyticsReportingSchedulesScheduleId**
> \PureCloudSDK\ReportSchedule getAnalyticsReportingSchedulesScheduleId($scheduleId)

Get a scheduled report job.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$scheduleId = "scheduleId_example"; // string | Schedule ID

try {
    $result = $api_instance->getAnalyticsReportingSchedulesScheduleId($scheduleId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->getAnalyticsReportingSchedulesScheduleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **scheduleId** | **string**| Schedule ID |

### Return type

[**\PureCloudSDK\ReportSchedule**](../Model/ReportSchedule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAnalyticsReportingSchedulesScheduleIdHistory**
> \PureCloudSDK\ReportRunEntryEntityDomainListing getAnalyticsReportingSchedulesScheduleIdHistory($scheduleId, $pageNumber, $pageSize)

Get list of completed scheduled report jobs.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$scheduleId = "scheduleId_example"; // string | Schedule ID
$pageNumber = 1; // int | 
$pageSize = 25; // int | 

try {
    $result = $api_instance->getAnalyticsReportingSchedulesScheduleIdHistory($scheduleId, $pageNumber, $pageSize);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->getAnalyticsReportingSchedulesScheduleIdHistory: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **scheduleId** | **string**| Schedule ID |
 **pageNumber** | **int**|  | [optional] [default to 1]
 **pageSize** | **int**|  | [optional] [default to 25]

### Return type

[**\PureCloudSDK\ReportRunEntryEntityDomainListing**](../Model/ReportRunEntryEntityDomainListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAnalyticsReportingSchedulesScheduleIdHistoryLatest**
> \PureCloudSDK\ReportRunEntry getAnalyticsReportingSchedulesScheduleIdHistoryLatest($scheduleId)

Get most recently completed scheduled report job.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$scheduleId = "scheduleId_example"; // string | Schedule ID

try {
    $result = $api_instance->getAnalyticsReportingSchedulesScheduleIdHistoryLatest($scheduleId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->getAnalyticsReportingSchedulesScheduleIdHistoryLatest: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **scheduleId** | **string**| Schedule ID |

### Return type

[**\PureCloudSDK\ReportRunEntry**](../Model/ReportRunEntry.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAnalyticsReportingSchedulesScheduleIdHistoryRunId**
> \PureCloudSDK\ReportRunEntry getAnalyticsReportingSchedulesScheduleIdHistoryRunId($runId, $scheduleId)

A completed scheduled report job

A completed scheduled report job.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$runId = "runId_example"; // string | Run ID
$scheduleId = "scheduleId_example"; // string | Schedule ID

try {
    $result = $api_instance->getAnalyticsReportingSchedulesScheduleIdHistoryRunId($runId, $scheduleId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->getAnalyticsReportingSchedulesScheduleIdHistoryRunId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **runId** | **string**| Run ID |
 **scheduleId** | **string**| Schedule ID |

### Return type

[**\PureCloudSDK\ReportRunEntry**](../Model/ReportRunEntry.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAnalyticsReportingTimeperiods**
> string[] getAnalyticsReportingTimeperiods()

Get a list of report time periods.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();

try {
    $result = $api_instance->getAnalyticsReportingTimeperiods();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->getAnalyticsReportingTimeperiods: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

**string[]**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAnalyticsConversationsAggregatesQuery**
> \PureCloudSDK\AggregateQueryResponse postAnalyticsConversationsAggregatesQuery($body)

Query for conversation aggregates



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$body = new \PureCloudSDK\AggregationQuery(); // \PureCloudSDK\AggregationQuery | query

try {
    $result = $api_instance->postAnalyticsConversationsAggregatesQuery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->postAnalyticsConversationsAggregatesQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\AggregationQuery**](../Model/\PureCloudSDK\AggregationQuery.md)| query |

### Return type

[**\PureCloudSDK\AggregateQueryResponse**](../Model/AggregateQueryResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAnalyticsConversationsConversationIdDetailsProperties**
> \PureCloudSDK\PropertyIndexRequest postAnalyticsConversationsConversationIdDetailsProperties($conversationId, $body)

Index conversation properties



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$conversationId = "conversationId_example"; // string | conversationId
$body = new \PureCloudSDK\PropertyIndexRequest(); // \PureCloudSDK\PropertyIndexRequest | request

try {
    $result = $api_instance->postAnalyticsConversationsConversationIdDetailsProperties($conversationId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->postAnalyticsConversationsConversationIdDetailsProperties: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **body** | [**\PureCloudSDK\PropertyIndexRequest**](../Model/\PureCloudSDK\PropertyIndexRequest.md)| request |

### Return type

[**\PureCloudSDK\PropertyIndexRequest**](../Model/PropertyIndexRequest.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAnalyticsConversationsDetailsQuery**
> \PureCloudSDK\AnalyticsConversationQueryResponse postAnalyticsConversationsDetailsQuery($body)

Query for conversation details



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$body = new \PureCloudSDK\ConversationQuery(); // \PureCloudSDK\ConversationQuery | query

try {
    $result = $api_instance->postAnalyticsConversationsDetailsQuery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->postAnalyticsConversationsDetailsQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ConversationQuery**](../Model/\PureCloudSDK\ConversationQuery.md)| query |

### Return type

[**\PureCloudSDK\AnalyticsConversationQueryResponse**](../Model/AnalyticsConversationQueryResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAnalyticsEvaluationsAggregatesQuery**
> \PureCloudSDK\AggregateQueryResponse postAnalyticsEvaluationsAggregatesQuery($body)

Query for evaluation aggregates



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$body = new \PureCloudSDK\AggregationQuery(); // \PureCloudSDK\AggregationQuery | query

try {
    $result = $api_instance->postAnalyticsEvaluationsAggregatesQuery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->postAnalyticsEvaluationsAggregatesQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\AggregationQuery**](../Model/\PureCloudSDK\AggregationQuery.md)| query |

### Return type

[**\PureCloudSDK\AggregateQueryResponse**](../Model/AggregateQueryResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAnalyticsQueuesObservationsQuery**
> \PureCloudSDK\QualifierMappingObservationQueryResponse postAnalyticsQueuesObservationsQuery($body)

Query for queue observations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$body = new \PureCloudSDK\ObservationQuery(); // \PureCloudSDK\ObservationQuery | query

try {
    $result = $api_instance->postAnalyticsQueuesObservationsQuery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->postAnalyticsQueuesObservationsQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ObservationQuery**](../Model/\PureCloudSDK\ObservationQuery.md)| query |

### Return type

[**\PureCloudSDK\QualifierMappingObservationQueryResponse**](../Model/QualifierMappingObservationQueryResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAnalyticsReportingSchedules**
> \PureCloudSDK\ReportSchedule postAnalyticsReportingSchedules($body)

Create a scheduled report job

Create a scheduled report job.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$body = new \PureCloudSDK\ReportSchedule(); // \PureCloudSDK\ReportSchedule | ReportSchedule

try {
    $result = $api_instance->postAnalyticsReportingSchedules($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->postAnalyticsReportingSchedules: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ReportSchedule**](../Model/\PureCloudSDK\ReportSchedule.md)| ReportSchedule |

### Return type

[**\PureCloudSDK\ReportSchedule**](../Model/ReportSchedule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAnalyticsReportingSchedulesScheduleIdRunreport**
> \PureCloudSDK\RunNowResponse postAnalyticsReportingSchedulesScheduleIdRunreport($scheduleId)

Place a scheduled report immediately into the reporting queue



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$scheduleId = "scheduleId_example"; // string | Schedule ID

try {
    $result = $api_instance->postAnalyticsReportingSchedulesScheduleIdRunreport($scheduleId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->postAnalyticsReportingSchedulesScheduleIdRunreport: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **scheduleId** | **string**| Schedule ID |

### Return type

[**\PureCloudSDK\RunNowResponse**](../Model/RunNowResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAnalyticsUsersAggregatesQuery**
> \PureCloudSDK\PresenceQueryResponse postAnalyticsUsersAggregatesQuery($body)

Query for user aggregates



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$body = new \PureCloudSDK\AggregationQuery(); // \PureCloudSDK\AggregationQuery | query

try {
    $result = $api_instance->postAnalyticsUsersAggregatesQuery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->postAnalyticsUsersAggregatesQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\AggregationQuery**](../Model/\PureCloudSDK\AggregationQuery.md)| query |

### Return type

[**\PureCloudSDK\PresenceQueryResponse**](../Model/PresenceQueryResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAnalyticsUsersDetailsQuery**
> \PureCloudSDK\AnalyticsUserDetailsQueryResponse postAnalyticsUsersDetailsQuery($body)

Query for user details



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$body = new \PureCloudSDK\UserDetailsQuery(); // \PureCloudSDK\UserDetailsQuery | query

try {
    $result = $api_instance->postAnalyticsUsersDetailsQuery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->postAnalyticsUsersDetailsQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\UserDetailsQuery**](../Model/\PureCloudSDK\UserDetailsQuery.md)| query |

### Return type

[**\PureCloudSDK\AnalyticsUserDetailsQueryResponse**](../Model/AnalyticsUserDetailsQueryResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAnalyticsUsersObservationsQuery**
> \PureCloudSDK\ObservationQueryResponse postAnalyticsUsersObservationsQuery($body)

Query for user observations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$body = new \PureCloudSDK\ObservationQuery(); // \PureCloudSDK\ObservationQuery | query

try {
    $result = $api_instance->postAnalyticsUsersObservationsQuery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->postAnalyticsUsersObservationsQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ObservationQuery**](../Model/\PureCloudSDK\ObservationQuery.md)| query |

### Return type

[**\PureCloudSDK\ObservationQueryResponse**](../Model/ObservationQueryResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putAnalyticsReportingSchedulesScheduleId**
> \PureCloudSDK\ReportSchedule putAnalyticsReportingSchedulesScheduleId($scheduleId, $body)

Update a scheduled report job.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$scheduleId = "scheduleId_example"; // string | Schedule ID
$body = new \PureCloudSDK\ReportSchedule(); // \PureCloudSDK\ReportSchedule | ReportSchedule

try {
    $result = $api_instance->putAnalyticsReportingSchedulesScheduleId($scheduleId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->putAnalyticsReportingSchedulesScheduleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **scheduleId** | **string**| Schedule ID |
 **body** | [**\PureCloudSDK\ReportSchedule**](../Model/\PureCloudSDK\ReportSchedule.md)| ReportSchedule |

### Return type

[**\PureCloudSDK\ReportSchedule**](../Model/ReportSchedule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

