# PureCloudSDK\AuthorizationApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteAuthorizationRolesRoleId**](AuthorizationApi.md#deleteAuthorizationRolesRoleId) | **DELETE** /api/v2/authorization/roles/{roleId} | Delete an organization role.
[**deleteUsersUserIdRoles**](AuthorizationApi.md#deleteUsersUserIdRoles) | **DELETE** /api/v2/users/{userId}/roles | Removes all the roles from the user.
[**getAuthorizationPermissions**](AuthorizationApi.md#getAuthorizationPermissions) | **GET** /api/v2/authorization/permissions | Get all permissions.
[**getAuthorizationProducts**](AuthorizationApi.md#getAuthorizationProducts) | **GET** /api/v2/authorization/products | Get the list of enabled products
[**getAuthorizationRoles**](AuthorizationApi.md#getAuthorizationRoles) | **GET** /api/v2/authorization/roles | Retrieve a list of all roles defined for the organization
[**getAuthorizationRolesLeftroleIdComparedefaultRightroleId**](AuthorizationApi.md#getAuthorizationRolesLeftroleIdComparedefaultRightroleId) | **GET** /api/v2/authorization/roles/{leftRoleId}/comparedefault/{rightRoleId} | Get an org role to default role comparison comparison
[**getAuthorizationRolesRoleId**](AuthorizationApi.md#getAuthorizationRolesRoleId) | **GET** /api/v2/authorization/roles/{roleId} | Get a single organization role.
[**getUsersUserIdRoles**](AuthorizationApi.md#getUsersUserIdRoles) | **GET** /api/v2/users/{userId}/roles | Returns a listing of roles and permissions for a user.
[**patchAuthorizationRolesRoleId**](AuthorizationApi.md#patchAuthorizationRolesRoleId) | **PATCH** /api/v2/authorization/roles/{roleId} | Patch Organization Role for needsUpdate Field
[**postAuthorizationRoles**](AuthorizationApi.md#postAuthorizationRoles) | **POST** /api/v2/authorization/roles | Create an organization role.
[**postAuthorizationRolesDefault**](AuthorizationApi.md#postAuthorizationRolesDefault) | **POST** /api/v2/authorization/roles/default | Restores all default roles
[**postAuthorizationRolesLeftroleIdComparedefaultRightroleId**](AuthorizationApi.md#postAuthorizationRolesLeftroleIdComparedefaultRightroleId) | **POST** /api/v2/authorization/roles/{leftRoleId}/comparedefault/{rightRoleId} | Get an unsaved org role to default role comparison
[**putAuthorizationRolesDefault**](AuthorizationApi.md#putAuthorizationRolesDefault) | **PUT** /api/v2/authorization/roles/default | Restore specified default roles
[**putAuthorizationRolesRoleId**](AuthorizationApi.md#putAuthorizationRolesRoleId) | **PUT** /api/v2/authorization/roles/{roleId} | Update an organization role.
[**putAuthorizationRolesRoleIdUsersAdd**](AuthorizationApi.md#putAuthorizationRolesRoleIdUsersAdd) | **PUT** /api/v2/authorization/roles/{roleId}/users/add | Sets the users for the role
[**putAuthorizationRolesRoleIdUsersRemove**](AuthorizationApi.md#putAuthorizationRolesRoleIdUsersRemove) | **PUT** /api/v2/authorization/roles/{roleId}/users/remove | Removes the users from the role
[**putUsersUserIdRoles**](AuthorizationApi.md#putUsersUserIdRoles) | **PUT** /api/v2/users/{userId}/roles | Sets the user&#39;s roles


# **deleteAuthorizationRolesRoleId**
> deleteAuthorizationRolesRoleId($roleId)

Delete an organization role.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AuthorizationApi();
$roleId = "roleId_example"; // string | Role ID

try {
    $api_instance->deleteAuthorizationRolesRoleId($roleId);
} catch (Exception $e) {
    echo 'Exception when calling AuthorizationApi->deleteAuthorizationRolesRoleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **roleId** | **string**| Role ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteUsersUserIdRoles**
> deleteUsersUserIdRoles($userId)

Removes all the roles from the user.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AuthorizationApi();
$userId = "userId_example"; // string | User ID

try {
    $api_instance->deleteUsersUserIdRoles($userId);
} catch (Exception $e) {
    echo 'Exception when calling AuthorizationApi->deleteUsersUserIdRoles: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAuthorizationPermissions**
> \PureCloudSDK\PermissionCollectionEntityListing getAuthorizationPermissions($pageSize, $pageNumber)

Get all permissions.

Retrieve a list of all permission defined in the system.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AuthorizationApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number

try {
    $result = $api_instance->getAuthorizationPermissions($pageSize, $pageNumber);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthorizationApi->getAuthorizationPermissions: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\PermissionCollectionEntityListing**](../Model/PermissionCollectionEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAuthorizationProducts**
> \PureCloudSDK\OrganizationProductEntityListing getAuthorizationProducts()

Get the list of enabled products

Gets the list of enabled products. Some example product names are: collaborateFree, collaboratePro, communicate, and engage.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AuthorizationApi();

try {
    $result = $api_instance->getAuthorizationProducts();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthorizationApi->getAuthorizationProducts: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\OrganizationProductEntityListing**](../Model/OrganizationProductEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAuthorizationRoles**
> \PureCloudSDK\OrganizationRoleEntityListing getAuthorizationRoles($pageSize, $pageNumber, $sortBy, $expand, $nextPage, $previousPage, $permission, $userCount)

Retrieve a list of all roles defined for the organization



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AuthorizationApi();
$pageSize = 25; // int | The total page size requested
$pageNumber = 1; // int | The page number requested
$sortBy = "sortBy_example"; // string | variable name requested to sort by
$expand = NULL; // object[] | variable name requested by expand list
$nextPage = "nextPage_example"; // string | next page token
$previousPage = "previousPage_example"; // string | Previous page token
$permission = NULL; // object[] | 
$userCount = true; // bool | 

try {
    $result = $api_instance->getAuthorizationRoles($pageSize, $pageNumber, $sortBy, $expand, $nextPage, $previousPage, $permission, $userCount);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthorizationApi->getAuthorizationRoles: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| The total page size requested | [optional] [default to 25]
 **pageNumber** | **int**| The page number requested | [optional] [default to 1]
 **sortBy** | **string**| variable name requested to sort by | [optional]
 **expand** | [**object[]**](../Model/object.md)| variable name requested by expand list | [optional]
 **nextPage** | **string**| next page token | [optional]
 **previousPage** | **string**| Previous page token | [optional]
 **permission** | [**object[]**](../Model/object.md)|  | [optional]
 **userCount** | **bool**|  | [optional] [default to true]

### Return type

[**\PureCloudSDK\OrganizationRoleEntityListing**](../Model/OrganizationRoleEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAuthorizationRolesLeftroleIdComparedefaultRightroleId**
> \PureCloudSDK\DomainOrgRoleDifference getAuthorizationRolesLeftroleIdComparedefaultRightroleId($leftRoleId, $rightRoleId)

Get an org role to default role comparison comparison

Compares any organization role to a default role id and show differences

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AuthorizationApi();
$leftRoleId = "leftRoleId_example"; // string | Left Role ID
$rightRoleId = "rightRoleId_example"; // string | Right Role id

try {
    $result = $api_instance->getAuthorizationRolesLeftroleIdComparedefaultRightroleId($leftRoleId, $rightRoleId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthorizationApi->getAuthorizationRolesLeftroleIdComparedefaultRightroleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **leftRoleId** | **string**| Left Role ID |
 **rightRoleId** | **string**| Right Role id |

### Return type

[**\PureCloudSDK\DomainOrgRoleDifference**](../Model/DomainOrgRoleDifference.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAuthorizationRolesRoleId**
> \PureCloudSDK\DomainOrganizationRole getAuthorizationRolesRoleId($roleId)

Get a single organization role.

Get the organization role specified by its ID.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AuthorizationApi();
$roleId = "roleId_example"; // string | Role ID

try {
    $result = $api_instance->getAuthorizationRolesRoleId($roleId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthorizationApi->getAuthorizationRolesRoleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **roleId** | **string**| Role ID |

### Return type

[**\PureCloudSDK\DomainOrganizationRole**](../Model/DomainOrganizationRole.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUsersUserIdRoles**
> \PureCloudSDK\UserAuthorization getUsersUserIdRoles($userId)

Returns a listing of roles and permissions for a user.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AuthorizationApi();
$userId = "userId_example"; // string | User ID

try {
    $result = $api_instance->getUsersUserIdRoles($userId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthorizationApi->getUsersUserIdRoles: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |

### Return type

[**\PureCloudSDK\UserAuthorization**](../Model/UserAuthorization.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchAuthorizationRolesRoleId**
> \PureCloudSDK\DomainOrganizationRole patchAuthorizationRolesRoleId($roleId, $body)

Patch Organization Role for needsUpdate Field

Patch Organization Role for needsUpdate Field

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AuthorizationApi();
$roleId = "roleId_example"; // string | Role ID
$body = new \PureCloudSDK\DomainOrganizationRole(); // \PureCloudSDK\DomainOrganizationRole | Organization role

try {
    $result = $api_instance->patchAuthorizationRolesRoleId($roleId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthorizationApi->patchAuthorizationRolesRoleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **roleId** | **string**| Role ID |
 **body** | [**\PureCloudSDK\DomainOrganizationRole**](../Model/\PureCloudSDK\DomainOrganizationRole.md)| Organization role |

### Return type

[**\PureCloudSDK\DomainOrganizationRole**](../Model/DomainOrganizationRole.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAuthorizationRoles**
> \PureCloudSDK\DomainOrganizationRole postAuthorizationRoles($body)

Create an organization role.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AuthorizationApi();
$body = new \PureCloudSDK\DomainOrganizationRoleCreate(); // \PureCloudSDK\DomainOrganizationRoleCreate | Organization role

try {
    $result = $api_instance->postAuthorizationRoles($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthorizationApi->postAuthorizationRoles: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\DomainOrganizationRoleCreate**](../Model/\PureCloudSDK\DomainOrganizationRoleCreate.md)| Organization role |

### Return type

[**\PureCloudSDK\DomainOrganizationRole**](../Model/DomainOrganizationRole.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAuthorizationRolesDefault**
> \PureCloudSDK\OrganizationRoleEntityListing postAuthorizationRolesDefault($force)

Restores all default roles

This endpoint serves several purposes. 1. It provides the org with default roles. This is important for default roles that will be added after go-live (they can retroactively add the new default-role). Note: When not using a query param of force=true, it only adds the default roles not configured for the org; it does not overwrite roles. 2. Using the query param force=true, you can restore all default roles. Note: This does not have an effect on custom roles.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AuthorizationApi();
$force = false; // bool | Restore default roles

try {
    $result = $api_instance->postAuthorizationRolesDefault($force);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthorizationApi->postAuthorizationRolesDefault: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **force** | **bool**| Restore default roles | [optional] [default to false]

### Return type

[**\PureCloudSDK\OrganizationRoleEntityListing**](../Model/OrganizationRoleEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAuthorizationRolesLeftroleIdComparedefaultRightroleId**
> \PureCloudSDK\DomainOrgRoleDifference postAuthorizationRolesLeftroleIdComparedefaultRightroleId($leftRoleId, $rightRoleId, $body)

Get an unsaved org role to default role comparison

Allows users to compare their existing roles in an unsaved state to its default role

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AuthorizationApi();
$leftRoleId = "leftRoleId_example"; // string | Left Role ID
$rightRoleId = "rightRoleId_example"; // string | Right Role id
$body = new \PureCloudSDK\DomainOrganizationRole(); // \PureCloudSDK\DomainOrganizationRole | Organization role

try {
    $result = $api_instance->postAuthorizationRolesLeftroleIdComparedefaultRightroleId($leftRoleId, $rightRoleId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthorizationApi->postAuthorizationRolesLeftroleIdComparedefaultRightroleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **leftRoleId** | **string**| Left Role ID |
 **rightRoleId** | **string**| Right Role id |
 **body** | [**\PureCloudSDK\DomainOrganizationRole**](../Model/\PureCloudSDK\DomainOrganizationRole.md)| Organization role |

### Return type

[**\PureCloudSDK\DomainOrgRoleDifference**](../Model/DomainOrgRoleDifference.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putAuthorizationRolesDefault**
> \PureCloudSDK\OrganizationRoleEntityListing putAuthorizationRolesDefault($body)

Restore specified default roles



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AuthorizationApi();
$body = array(new DomainOrganizationRole()); // \PureCloudSDK\DomainOrganizationRole[] | Organization roles list

try {
    $result = $api_instance->putAuthorizationRolesDefault($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthorizationApi->putAuthorizationRolesDefault: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\DomainOrganizationRole[]**](../Model/DomainOrganizationRole.md)| Organization roles list |

### Return type

[**\PureCloudSDK\OrganizationRoleEntityListing**](../Model/OrganizationRoleEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putAuthorizationRolesRoleId**
> \PureCloudSDK\DomainOrganizationRole putAuthorizationRolesRoleId($roleId, $body)

Update an organization role.

Update

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AuthorizationApi();
$roleId = "roleId_example"; // string | Role ID
$body = new \PureCloudSDK\DomainOrganizationRoleUpdate(); // \PureCloudSDK\DomainOrganizationRoleUpdate | Organization role

try {
    $result = $api_instance->putAuthorizationRolesRoleId($roleId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthorizationApi->putAuthorizationRolesRoleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **roleId** | **string**| Role ID |
 **body** | [**\PureCloudSDK\DomainOrganizationRoleUpdate**](../Model/\PureCloudSDK\DomainOrganizationRoleUpdate.md)| Organization role |

### Return type

[**\PureCloudSDK\DomainOrganizationRole**](../Model/DomainOrganizationRole.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putAuthorizationRolesRoleIdUsersAdd**
> string[] putAuthorizationRolesRoleIdUsersAdd($roleId, $body)

Sets the users for the role



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AuthorizationApi();
$roleId = "roleId_example"; // string | Role ID
$body = array(new string[]()); // string[] | List of user IDs

try {
    $result = $api_instance->putAuthorizationRolesRoleIdUsersAdd($roleId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthorizationApi->putAuthorizationRolesRoleIdUsersAdd: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **roleId** | **string**| Role ID |
 **body** | **string[]**| List of user IDs |

### Return type

**string[]**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putAuthorizationRolesRoleIdUsersRemove**
> string[] putAuthorizationRolesRoleIdUsersRemove($roleId, $body)

Removes the users from the role



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AuthorizationApi();
$roleId = "roleId_example"; // string | Role ID
$body = array(new string[]()); // string[] | List of user IDs

try {
    $result = $api_instance->putAuthorizationRolesRoleIdUsersRemove($roleId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthorizationApi->putAuthorizationRolesRoleIdUsersRemove: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **roleId** | **string**| Role ID |
 **body** | **string[]**| List of user IDs |

### Return type

**string[]**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putUsersUserIdRoles**
> \PureCloudSDK\UserAuthorization putUsersUserIdRoles($userId, $body)

Sets the user's roles



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AuthorizationApi();
$userId = "userId_example"; // string | User ID
$body = array(new string[]()); // string[] | List of roles

try {
    $result = $api_instance->putUsersUserIdRoles($userId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthorizationApi->putUsersUserIdRoles: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |
 **body** | **string[]**| List of roles |

### Return type

[**\PureCloudSDK\UserAuthorization**](../Model/UserAuthorization.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

