# PureCloudSDK\ConversationsApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteConversationsCallsCallIdParticipantsParticipantIdConsult**](ConversationsApi.md#deleteConversationsCallsCallIdParticipantsParticipantIdConsult) | **DELETE** /api/v2/conversations/calls/{callId}/participants/{participantId}/consult | Cancel the transfer
[**deleteConversationsConversationIdParticipantsParticipantIdCodesAddcommunicationcode**](ConversationsApi.md#deleteConversationsConversationIdParticipantsParticipantIdCodesAddcommunicationcode) | **DELETE** /api/v2/conversations/{conversationId}/participants/{participantId}/codes/{addCommunicationCode} | Delete a code used to add a communication to this participant
[**deleteConversationsEmailsEmailIdMessagesDraftAttachmentsAttachmentId**](ConversationsApi.md#deleteConversationsEmailsEmailIdMessagesDraftAttachmentsAttachmentId) | **DELETE** /api/v2/conversations/emails/{emailId}/messages/draft/attachments/{attachmentId} | Delete attachment from draft
[**getAnalyticsConversationsConversationIdDetails**](ConversationsApi.md#getAnalyticsConversationsConversationIdDetails) | **GET** /api/v2/analytics/conversations/{conversationId}/details | Get a conversation by id
[**getConversations**](ConversationsApi.md#getConversations) | **GET** /api/v2/conversations | Get conversations
[**getConversationsCallbacks**](ConversationsApi.md#getConversationsCallbacks) | **GET** /api/v2/conversations/callbacks | Get callback conversations
[**getConversationsCallbacksCallbackId**](ConversationsApi.md#getConversationsCallbacksCallbackId) | **GET** /api/v2/conversations/callbacks/{callbackId} | Get callback conversation
[**getConversationsCallbacksCallbackIdParticipantsParticipantIdWrapup**](ConversationsApi.md#getConversationsCallbacksCallbackIdParticipantsParticipantIdWrapup) | **GET** /api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/wrapup | Get the wrap-up for this conversation participant.
[**getConversationsCallbacksCallbackIdParticipantsParticipantIdWrapupcodes**](ConversationsApi.md#getConversationsCallbacksCallbackIdParticipantsParticipantIdWrapupcodes) | **GET** /api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/wrapupcodes | Get list of wrapup codes for this conversation participant
[**getConversationsCalls**](ConversationsApi.md#getConversationsCalls) | **GET** /api/v2/conversations/calls | Get recent conversations
[**getConversationsCallsCallId**](ConversationsApi.md#getConversationsCallsCallId) | **GET** /api/v2/conversations/calls/{callId} | Get call conversation
[**getConversationsCallsCallIdParticipantsParticipantIdWrapup**](ConversationsApi.md#getConversationsCallsCallIdParticipantsParticipantIdWrapup) | **GET** /api/v2/conversations/calls/{callId}/participants/{participantId}/wrapup | Get the wrap-up for this conversation participant.
[**getConversationsCallsCallIdParticipantsParticipantIdWrapupcodes**](ConversationsApi.md#getConversationsCallsCallIdParticipantsParticipantIdWrapupcodes) | **GET** /api/v2/conversations/calls/{callId}/participants/{participantId}/wrapupcodes | Get list of wrapup codes for this conversation participant
[**getConversationsCallsHistory**](ConversationsApi.md#getConversationsCallsHistory) | **GET** /api/v2/conversations/calls/history | Get call history
[**getConversationsCallsMaximumconferenceparties**](ConversationsApi.md#getConversationsCallsMaximumconferenceparties) | **GET** /api/v2/conversations/calls/maximumconferenceparties | Get the maximum number of participants that this user can have on a conference
[**getConversationsChats**](ConversationsApi.md#getConversationsChats) | **GET** /api/v2/conversations/chats | Get recent chat conversations
[**getConversationsChatsChatId**](ConversationsApi.md#getConversationsChatsChatId) | **GET** /api/v2/conversations/chats/{chatId} | Get chat conversation
[**getConversationsChatsChatIdParticipantsParticipantIdWrapup**](ConversationsApi.md#getConversationsChatsChatIdParticipantsParticipantIdWrapup) | **GET** /api/v2/conversations/chats/{chatId}/participants/{participantId}/wrapup | Get the wrap-up for this conversation participant.
[**getConversationsChatsChatIdParticipantsParticipantIdWrapupcodes**](ConversationsApi.md#getConversationsChatsChatIdParticipantsParticipantIdWrapupcodes) | **GET** /api/v2/conversations/chats/{chatId}/participants/{participantId}/wrapupcodes | Get list of wrapup codes for this conversation participant
[**getConversationsCobrowsesessions**](ConversationsApi.md#getConversationsCobrowsesessions) | **GET** /api/v2/conversations/cobrowsesessions | Get recent cobrowse conversations
[**getConversationsCobrowsesessionsCobrowseId**](ConversationsApi.md#getConversationsCobrowsesessionsCobrowseId) | **GET** /api/v2/conversations/cobrowsesessions/{cobrowseId} | Get cobrowse conversation
[**getConversationsCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapup**](ConversationsApi.md#getConversationsCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapup) | **GET** /api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/wrapup | Get the wrap-up for this conversation participant.
[**getConversationsCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapupcodes**](ConversationsApi.md#getConversationsCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapupcodes) | **GET** /api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/wrapupcodes | Get list of wrapup codes for this conversation participant
[**getConversationsConversationId**](ConversationsApi.md#getConversationsConversationId) | **GET** /api/v2/conversations/{conversationId} | Get conversation
[**getConversationsConversationIdParticipantsParticipantIdWrapup**](ConversationsApi.md#getConversationsConversationIdParticipantsParticipantIdWrapup) | **GET** /api/v2/conversations/{conversationId}/participants/{participantId}/wrapup | Get the wrap-up for this conversation participant.
[**getConversationsConversationIdParticipantsParticipantIdWrapupcodes**](ConversationsApi.md#getConversationsConversationIdParticipantsParticipantIdWrapupcodes) | **GET** /api/v2/conversations/{conversationId}/participants/{participantId}/wrapupcodes | Get list of wrapup codes for this conversation participant
[**getConversationsEmails**](ConversationsApi.md#getConversationsEmails) | **GET** /api/v2/conversations/emails | Get recent email conversations
[**getConversationsEmailsEmailId**](ConversationsApi.md#getConversationsEmailsEmailId) | **GET** /api/v2/conversations/emails/{emailId} | Get email conversation
[**getConversationsEmailsEmailIdMessages**](ConversationsApi.md#getConversationsEmailsEmailIdMessages) | **GET** /api/v2/conversations/emails/{emailId}/messages | Get conversation messages
[**getConversationsEmailsEmailIdMessagesDraft**](ConversationsApi.md#getConversationsEmailsEmailIdMessagesDraft) | **GET** /api/v2/conversations/emails/{emailId}/messages/draft | Get conversation draft reply
[**getConversationsEmailsEmailIdMessagesMessageId**](ConversationsApi.md#getConversationsEmailsEmailIdMessagesMessageId) | **GET** /api/v2/conversations/emails/{emailId}/messages/{messageId} | Get conversation message
[**getConversationsEmailsEmailIdParticipantsParticipantIdWrapup**](ConversationsApi.md#getConversationsEmailsEmailIdParticipantsParticipantIdWrapup) | **GET** /api/v2/conversations/emails/{emailId}/participants/{participantId}/wrapup | Get the wrap-up for this conversation participant.
[**getConversationsEmailsEmailIdParticipantsParticipantIdWrapupcodes**](ConversationsApi.md#getConversationsEmailsEmailIdParticipantsParticipantIdWrapupcodes) | **GET** /api/v2/conversations/emails/{emailId}/participants/{participantId}/wrapupcodes | Get list of wrapup codes for this conversation participant
[**patchConversationsCallbacksCallbackId**](ConversationsApi.md#patchConversationsCallbacksCallbackId) | **PATCH** /api/v2/conversations/callbacks/{callbackId} | Update a conversation by disconnecting all of the participants
[**patchConversationsCallbacksCallbackIdParticipantsParticipantId**](ConversationsApi.md#patchConversationsCallbacksCallbackIdParticipantsParticipantId) | **PATCH** /api/v2/conversations/callbacks/{callbackId}/participants/{participantId} | Update conversation participant
[**patchConversationsCallbacksCallbackIdParticipantsParticipantIdAttributes**](ConversationsApi.md#patchConversationsCallbacksCallbackIdParticipantsParticipantIdAttributes) | **PATCH** /api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/attributes | Update the attributes on a conversation participant.
[**patchConversationsCallbacksCallbackIdParticipantsParticipantIdCommunicationsCommunicationId**](ConversationsApi.md#patchConversationsCallbacksCallbackIdParticipantsParticipantIdCommunicationsCommunicationId) | **PATCH** /api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/communications/{communicationId} | Update conversation participant&#39;s communication by disconnecting it.
[**patchConversationsCallsCallId**](ConversationsApi.md#patchConversationsCallsCallId) | **PATCH** /api/v2/conversations/calls/{callId} | Update a conversation by setting it&#39;s recording state, merging in other conversations to create a conference, or disconnecting all of the participants
[**patchConversationsCallsCallIdParticipantsParticipantId**](ConversationsApi.md#patchConversationsCallsCallIdParticipantsParticipantId) | **PATCH** /api/v2/conversations/calls/{callId}/participants/{participantId} | Update conversation participant
[**patchConversationsCallsCallIdParticipantsParticipantIdAttributes**](ConversationsApi.md#patchConversationsCallsCallIdParticipantsParticipantIdAttributes) | **PATCH** /api/v2/conversations/calls/{callId}/participants/{participantId}/attributes | Update the attributes on a conversation participant.
[**patchConversationsCallsCallIdParticipantsParticipantIdCommunicationsCommunicationId**](ConversationsApi.md#patchConversationsCallsCallIdParticipantsParticipantIdCommunicationsCommunicationId) | **PATCH** /api/v2/conversations/calls/{callId}/participants/{participantId}/communications/{communicationId} | Update conversation participant&#39;s communication by disconnecting it.
[**patchConversationsCallsCallIdParticipantsParticipantIdConsult**](ConversationsApi.md#patchConversationsCallsCallIdParticipantsParticipantIdConsult) | **PATCH** /api/v2/conversations/calls/{callId}/participants/{participantId}/consult | Change who can speak
[**patchConversationsChatsChatId**](ConversationsApi.md#patchConversationsChatsChatId) | **PATCH** /api/v2/conversations/chats/{chatId} | Update a conversation by disconnecting all of the participants
[**patchConversationsChatsChatIdParticipantsParticipantId**](ConversationsApi.md#patchConversationsChatsChatIdParticipantsParticipantId) | **PATCH** /api/v2/conversations/chats/{chatId}/participants/{participantId} | Update conversation participant
[**patchConversationsChatsChatIdParticipantsParticipantIdAttributes**](ConversationsApi.md#patchConversationsChatsChatIdParticipantsParticipantIdAttributes) | **PATCH** /api/v2/conversations/chats/{chatId}/participants/{participantId}/attributes | Update the attributes on a conversation participant.
[**patchConversationsChatsChatIdParticipantsParticipantIdCommunicationsCommunicationId**](ConversationsApi.md#patchConversationsChatsChatIdParticipantsParticipantIdCommunicationsCommunicationId) | **PATCH** /api/v2/conversations/chats/{chatId}/participants/{participantId}/communications/{communicationId} | Update conversation participant&#39;s communication by disconnecting it.
[**patchConversationsCobrowsesessionsCobrowseId**](ConversationsApi.md#patchConversationsCobrowsesessionsCobrowseId) | **PATCH** /api/v2/conversations/cobrowsesessions/{cobrowseId} | Update a conversation by disconnecting all of the participants
[**patchConversationsCobrowsesessionsCobrowseIdParticipantsParticipantId**](ConversationsApi.md#patchConversationsCobrowsesessionsCobrowseIdParticipantsParticipantId) | **PATCH** /api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId} | Update conversation participant
[**patchConversationsCobrowsesessionsCobrowseIdParticipantsParticipantIdAttributes**](ConversationsApi.md#patchConversationsCobrowsesessionsCobrowseIdParticipantsParticipantIdAttributes) | **PATCH** /api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/attributes | Update the attributes on a conversation participant.
[**patchConversationsCobrowsesessionsCobrowseIdParticipantsParticipantIdCommunicationsCommunicationId**](ConversationsApi.md#patchConversationsCobrowsesessionsCobrowseIdParticipantsParticipantIdCommunicationsCommunicationId) | **PATCH** /api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/communications/{communicationId} | Update conversation participant&#39;s communication by disconnecting it.
[**patchConversationsConversationIdParticipantsParticipantId**](ConversationsApi.md#patchConversationsConversationIdParticipantsParticipantId) | **PATCH** /api/v2/conversations/{conversationId}/participants/{participantId} | Update a participant.
[**patchConversationsConversationIdParticipantsParticipantIdAttributes**](ConversationsApi.md#patchConversationsConversationIdParticipantsParticipantIdAttributes) | **PATCH** /api/v2/conversations/{conversationId}/participants/{participantId}/attributes | Update the attributes on a conversation participant.
[**patchConversationsEmailsEmailId**](ConversationsApi.md#patchConversationsEmailsEmailId) | **PATCH** /api/v2/conversations/emails/{emailId} | Update a conversation by disconnecting all of the participants
[**patchConversationsEmailsEmailIdParticipantsParticipantId**](ConversationsApi.md#patchConversationsEmailsEmailIdParticipantsParticipantId) | **PATCH** /api/v2/conversations/emails/{emailId}/participants/{participantId} | Update conversation participant
[**patchConversationsEmailsEmailIdParticipantsParticipantIdAttributes**](ConversationsApi.md#patchConversationsEmailsEmailIdParticipantsParticipantIdAttributes) | **PATCH** /api/v2/conversations/emails/{emailId}/participants/{participantId}/attributes | Update the attributes on a conversation participant.
[**patchConversationsEmailsEmailIdParticipantsParticipantIdCommunicationsCommunicationId**](ConversationsApi.md#patchConversationsEmailsEmailIdParticipantsParticipantIdCommunicationsCommunicationId) | **PATCH** /api/v2/conversations/emails/{emailId}/participants/{participantId}/communications/{communicationId} | Update conversation participant&#39;s communication by disconnecting it.
[**postAnalyticsConversationsAggregatesQuery**](ConversationsApi.md#postAnalyticsConversationsAggregatesQuery) | **POST** /api/v2/analytics/conversations/aggregates/query | Query for conversation aggregates
[**postAnalyticsConversationsConversationIdDetailsProperties**](ConversationsApi.md#postAnalyticsConversationsConversationIdDetailsProperties) | **POST** /api/v2/analytics/conversations/{conversationId}/details/properties | Index conversation properties
[**postAnalyticsConversationsDetailsQuery**](ConversationsApi.md#postAnalyticsConversationsDetailsQuery) | **POST** /api/v2/analytics/conversations/details/query | Query for conversation details
[**postConversationsCallbacks**](ConversationsApi.md#postConversationsCallbacks) | **POST** /api/v2/conversations/callbacks | Create a Callback
[**postConversationsCallbacksCallbackIdParticipantsParticipantIdReplace**](ConversationsApi.md#postConversationsCallbacksCallbackIdParticipantsParticipantIdReplace) | **POST** /api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/replace | Replace this participant with the specified user and/or address
[**postConversationsCalls**](ConversationsApi.md#postConversationsCalls) | **POST** /api/v2/conversations/calls | Create a call conversation
[**postConversationsCallsCallId**](ConversationsApi.md#postConversationsCallsCallId) | **POST** /api/v2/conversations/calls/{callId} | Add a new call to a conversation
[**postConversationsCallsCallIdParticipants**](ConversationsApi.md#postConversationsCallsCallIdParticipants) | **POST** /api/v2/conversations/calls/{callId}/participants | Add participants to a conversation
[**postConversationsCallsCallIdParticipantsParticipantIdConsult**](ConversationsApi.md#postConversationsCallsCallIdParticipantsParticipantIdConsult) | **POST** /api/v2/conversations/calls/{callId}/participants/{participantId}/consult | Initiate and update consult transfer
[**postConversationsCallsCallIdParticipantsParticipantIdMonitor**](ConversationsApi.md#postConversationsCallsCallIdParticipantsParticipantIdMonitor) | **POST** /api/v2/conversations/calls/{callId}/participants/{participantId}/monitor | Listen in on the conversation from the point of view of a given participant.
[**postConversationsCallsCallIdParticipantsParticipantIdReplace**](ConversationsApi.md#postConversationsCallsCallIdParticipantsParticipantIdReplace) | **POST** /api/v2/conversations/calls/{callId}/participants/{participantId}/replace | Replace this participant with the specified user and/or address
[**postConversationsChatsChatIdParticipantsParticipantIdReplace**](ConversationsApi.md#postConversationsChatsChatIdParticipantsParticipantIdReplace) | **POST** /api/v2/conversations/chats/{chatId}/participants/{participantId}/replace | Replace this participant with the specified user and/or address
[**postConversationsCobrowsesessionsCobrowseIdParticipantsParticipantIdReplace**](ConversationsApi.md#postConversationsCobrowsesessionsCobrowseIdParticipantsParticipantIdReplace) | **POST** /api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/replace | Replace this participant with the specified user and/or address
[**postConversationsConversationIdParticipantsParticipantIdCallbacks**](ConversationsApi.md#postConversationsConversationIdParticipantsParticipantIdCallbacks) | **POST** /api/v2/conversations/{conversationId}/participants/{participantId}/callbacks | Create a new callback for the specified participant on the conversation.
[**postConversationsConversationIdParticipantsParticipantIdReplace**](ConversationsApi.md#postConversationsConversationIdParticipantsParticipantIdReplace) | **POST** /api/v2/conversations/{conversationId}/participants/{participantId}/replace | Replace this participant with the specified user and/or address
[**postConversationsEmailsEmailIdMessages**](ConversationsApi.md#postConversationsEmailsEmailIdMessages) | **POST** /api/v2/conversations/emails/{emailId}/messages | Send an email reply
[**postConversationsEmailsEmailIdParticipantsParticipantIdReplace**](ConversationsApi.md#postConversationsEmailsEmailIdParticipantsParticipantIdReplace) | **POST** /api/v2/conversations/emails/{emailId}/participants/{participantId}/replace | Replace this participant with the specified user and/or address
[**postConversationsFaxes**](ConversationsApi.md#postConversationsFaxes) | **POST** /api/v2/conversations/faxes | Create Fax Conversation
[**putConversationsEmailsEmailIdMessagesDraft**](ConversationsApi.md#putConversationsEmailsEmailIdMessagesDraft) | **PUT** /api/v2/conversations/emails/{emailId}/messages/draft | Update conversation draft reply


# **deleteConversationsCallsCallIdParticipantsParticipantIdConsult**
> string deleteConversationsCallsCallIdParticipantsParticipantIdConsult($callId, $participantId)

Cancel the transfer



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callId = "callId_example"; // string | callId
$participantId = "participantId_example"; // string | participantId

try {
    $result = $api_instance->deleteConversationsCallsCallIdParticipantsParticipantIdConsult($callId, $participantId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->deleteConversationsCallsCallIdParticipantsParticipantIdConsult: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callId** | **string**| callId |
 **participantId** | **string**| participantId |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteConversationsConversationIdParticipantsParticipantIdCodesAddcommunicationcode**
> deleteConversationsConversationIdParticipantsParticipantIdCodesAddcommunicationcode($conversationId, $participantId, $addCommunicationCode)

Delete a code used to add a communication to this participant



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversation ID
$participantId = "participantId_example"; // string | participant ID
$addCommunicationCode = "addCommunicationCode_example"; // string | addCommunicationCode

try {
    $api_instance->deleteConversationsConversationIdParticipantsParticipantIdCodesAddcommunicationcode($conversationId, $participantId, $addCommunicationCode);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->deleteConversationsConversationIdParticipantsParticipantIdCodesAddcommunicationcode: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversation ID |
 **participantId** | **string**| participant ID |
 **addCommunicationCode** | **string**| addCommunicationCode |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteConversationsEmailsEmailIdMessagesDraftAttachmentsAttachmentId**
> string deleteConversationsEmailsEmailIdMessagesDraftAttachmentsAttachmentId($emailId, $attachmentId)

Delete attachment from draft



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$emailId = "emailId_example"; // string | emailId
$attachmentId = "attachmentId_example"; // string | attachmentId

try {
    $result = $api_instance->deleteConversationsEmailsEmailIdMessagesDraftAttachmentsAttachmentId($emailId, $attachmentId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->deleteConversationsEmailsEmailIdMessagesDraftAttachmentsAttachmentId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **emailId** | **string**| emailId |
 **attachmentId** | **string**| attachmentId |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAnalyticsConversationsConversationIdDetails**
> \PureCloudSDK\AnalyticsConversation getAnalyticsConversationsConversationIdDetails($conversationId)

Get a conversation by id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId

try {
    $result = $api_instance->getAnalyticsConversationsConversationIdDetails($conversationId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getAnalyticsConversationsConversationIdDetails: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |

### Return type

[**\PureCloudSDK\AnalyticsConversation**](../Model/AnalyticsConversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversations**
> \PureCloudSDK\ConversationEntityListing getConversations($communicationType)

Get conversations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$communicationType = "communicationType_example"; // string | Call or Chat communication filtering

try {
    $result = $api_instance->getConversations($communicationType);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversations: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **communicationType** | **string**| Call or Chat communication filtering | [optional]

### Return type

[**\PureCloudSDK\ConversationEntityListing**](../Model/ConversationEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsCallbacks**
> \PureCloudSDK\CallbackConversationEntityListing getConversationsCallbacks()

Get callback conversations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();

try {
    $result = $api_instance->getConversationsCallbacks();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsCallbacks: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\CallbackConversationEntityListing**](../Model/CallbackConversationEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsCallbacksCallbackId**
> \PureCloudSDK\CallbackConversation getConversationsCallbacksCallbackId($callbackId)

Get callback conversation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callbackId = "callbackId_example"; // string | callbackId

try {
    $result = $api_instance->getConversationsCallbacksCallbackId($callbackId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsCallbacksCallbackId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callbackId** | **string**| callbackId |

### Return type

[**\PureCloudSDK\CallbackConversation**](../Model/CallbackConversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsCallbacksCallbackIdParticipantsParticipantIdWrapup**
> \PureCloudSDK\Wrapup getConversationsCallbacksCallbackIdParticipantsParticipantIdWrapup($callbackId, $participantId, $provisional)

Get the wrap-up for this conversation participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callbackId = "callbackId_example"; // string | callbackId
$participantId = "participantId_example"; // string | participantId
$provisional = false; // bool | Indicates if the wrap-up code is provisional.

try {
    $result = $api_instance->getConversationsCallbacksCallbackIdParticipantsParticipantIdWrapup($callbackId, $participantId, $provisional);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsCallbacksCallbackIdParticipantsParticipantIdWrapup: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callbackId** | **string**| callbackId |
 **participantId** | **string**| participantId |
 **provisional** | **bool**| Indicates if the wrap-up code is provisional. | [optional] [default to false]

### Return type

[**\PureCloudSDK\Wrapup**](../Model/Wrapup.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsCallbacksCallbackIdParticipantsParticipantIdWrapupcodes**
> \PureCloudSDK\WrapupCode[] getConversationsCallbacksCallbackIdParticipantsParticipantIdWrapupcodes($callbackId, $participantId)

Get list of wrapup codes for this conversation participant



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callbackId = "callbackId_example"; // string | callbackId
$participantId = "participantId_example"; // string | participantId

try {
    $result = $api_instance->getConversationsCallbacksCallbackIdParticipantsParticipantIdWrapupcodes($callbackId, $participantId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsCallbacksCallbackIdParticipantsParticipantIdWrapupcodes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callbackId** | **string**| callbackId |
 **participantId** | **string**| participantId |

### Return type

[**\PureCloudSDK\WrapupCode[]**](../Model/WrapupCode.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsCalls**
> \PureCloudSDK\CallConversationEntityListing getConversationsCalls()

Get recent conversations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();

try {
    $result = $api_instance->getConversationsCalls();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsCalls: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\CallConversationEntityListing**](../Model/CallConversationEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsCallsCallId**
> \PureCloudSDK\CallConversation getConversationsCallsCallId($callId)

Get call conversation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callId = "callId_example"; // string | callId

try {
    $result = $api_instance->getConversationsCallsCallId($callId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsCallsCallId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callId** | **string**| callId |

### Return type

[**\PureCloudSDK\CallConversation**](../Model/CallConversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsCallsCallIdParticipantsParticipantIdWrapup**
> \PureCloudSDK\Wrapup getConversationsCallsCallIdParticipantsParticipantIdWrapup($callId, $participantId, $provisional)

Get the wrap-up for this conversation participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callId = "callId_example"; // string | callId
$participantId = "participantId_example"; // string | participantId
$provisional = false; // bool | Indicates if the wrap-up code is provisional.

try {
    $result = $api_instance->getConversationsCallsCallIdParticipantsParticipantIdWrapup($callId, $participantId, $provisional);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsCallsCallIdParticipantsParticipantIdWrapup: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callId** | **string**| callId |
 **participantId** | **string**| participantId |
 **provisional** | **bool**| Indicates if the wrap-up code is provisional. | [optional] [default to false]

### Return type

[**\PureCloudSDK\Wrapup**](../Model/Wrapup.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsCallsCallIdParticipantsParticipantIdWrapupcodes**
> \PureCloudSDK\WrapupCode[] getConversationsCallsCallIdParticipantsParticipantIdWrapupcodes($callId, $participantId)

Get list of wrapup codes for this conversation participant



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callId = "callId_example"; // string | callId
$participantId = "participantId_example"; // string | participantId

try {
    $result = $api_instance->getConversationsCallsCallIdParticipantsParticipantIdWrapupcodes($callId, $participantId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsCallsCallIdParticipantsParticipantIdWrapupcodes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callId** | **string**| callId |
 **participantId** | **string**| participantId |

### Return type

[**\PureCloudSDK\WrapupCode[]**](../Model/WrapupCode.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsCallsHistory**
> \PureCloudSDK\CallConversationEntityListing getConversationsCallsHistory($pageSize, $pageNumber, $interval)

Get call history



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$interval = "interval_example"; // string | Interval string; format is ISO-8601. Separate start and end times with forward slash '/'

try {
    $result = $api_instance->getConversationsCallsHistory($pageSize, $pageNumber, $interval);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsCallsHistory: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **interval** | **string**| Interval string; format is ISO-8601. Separate start and end times with forward slash &#39;/&#39; | [optional]

### Return type

[**\PureCloudSDK\CallConversationEntityListing**](../Model/CallConversationEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsCallsMaximumconferenceparties**
> \PureCloudSDK\MaxParticipants getConversationsCallsMaximumconferenceparties()

Get the maximum number of participants that this user can have on a conference



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();

try {
    $result = $api_instance->getConversationsCallsMaximumconferenceparties();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsCallsMaximumconferenceparties: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\MaxParticipants**](../Model/MaxParticipants.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsChats**
> \PureCloudSDK\ChatConversationEntityListing getConversationsChats()

Get recent chat conversations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();

try {
    $result = $api_instance->getConversationsChats();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsChats: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\ChatConversationEntityListing**](../Model/ChatConversationEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsChatsChatId**
> \PureCloudSDK\ChatConversation getConversationsChatsChatId($chatId)

Get chat conversation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$chatId = "chatId_example"; // string | chatId

try {
    $result = $api_instance->getConversationsChatsChatId($chatId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsChatsChatId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **chatId** | **string**| chatId |

### Return type

[**\PureCloudSDK\ChatConversation**](../Model/ChatConversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsChatsChatIdParticipantsParticipantIdWrapup**
> \PureCloudSDK\Wrapup getConversationsChatsChatIdParticipantsParticipantIdWrapup($chatId, $participantId, $provisional)

Get the wrap-up for this conversation participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$chatId = "chatId_example"; // string | chatId
$participantId = "participantId_example"; // string | participantId
$provisional = false; // bool | Indicates if the wrap-up code is provisional.

try {
    $result = $api_instance->getConversationsChatsChatIdParticipantsParticipantIdWrapup($chatId, $participantId, $provisional);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsChatsChatIdParticipantsParticipantIdWrapup: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **chatId** | **string**| chatId |
 **participantId** | **string**| participantId |
 **provisional** | **bool**| Indicates if the wrap-up code is provisional. | [optional] [default to false]

### Return type

[**\PureCloudSDK\Wrapup**](../Model/Wrapup.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsChatsChatIdParticipantsParticipantIdWrapupcodes**
> \PureCloudSDK\WrapupCode[] getConversationsChatsChatIdParticipantsParticipantIdWrapupcodes($chatId, $participantId)

Get list of wrapup codes for this conversation participant



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$chatId = "chatId_example"; // string | chatId
$participantId = "participantId_example"; // string | participantId

try {
    $result = $api_instance->getConversationsChatsChatIdParticipantsParticipantIdWrapupcodes($chatId, $participantId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsChatsChatIdParticipantsParticipantIdWrapupcodes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **chatId** | **string**| chatId |
 **participantId** | **string**| participantId |

### Return type

[**\PureCloudSDK\WrapupCode[]**](../Model/WrapupCode.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsCobrowsesessions**
> \PureCloudSDK\CobrowseConversationEntityListing getConversationsCobrowsesessions()

Get recent cobrowse conversations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();

try {
    $result = $api_instance->getConversationsCobrowsesessions();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsCobrowsesessions: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\CobrowseConversationEntityListing**](../Model/CobrowseConversationEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsCobrowsesessionsCobrowseId**
> \PureCloudSDK\CobrowseConversation getConversationsCobrowsesessionsCobrowseId($cobrowseId)

Get cobrowse conversation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$cobrowseId = "cobrowseId_example"; // string | cobrowseId

try {
    $result = $api_instance->getConversationsCobrowsesessionsCobrowseId($cobrowseId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsCobrowsesessionsCobrowseId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **cobrowseId** | **string**| cobrowseId |

### Return type

[**\PureCloudSDK\CobrowseConversation**](../Model/CobrowseConversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapup**
> \PureCloudSDK\Wrapup getConversationsCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapup($cobrowseId, $participantId, $provisional)

Get the wrap-up for this conversation participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$cobrowseId = "cobrowseId_example"; // string | cobrowseId
$participantId = "participantId_example"; // string | participantId
$provisional = false; // bool | Indicates if the wrap-up code is provisional.

try {
    $result = $api_instance->getConversationsCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapup($cobrowseId, $participantId, $provisional);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapup: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **cobrowseId** | **string**| cobrowseId |
 **participantId** | **string**| participantId |
 **provisional** | **bool**| Indicates if the wrap-up code is provisional. | [optional] [default to false]

### Return type

[**\PureCloudSDK\Wrapup**](../Model/Wrapup.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapupcodes**
> \PureCloudSDK\WrapupCode[] getConversationsCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapupcodes($cobrowseId, $participantId)

Get list of wrapup codes for this conversation participant



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$cobrowseId = "cobrowseId_example"; // string | cobrowseId
$participantId = "participantId_example"; // string | participantId

try {
    $result = $api_instance->getConversationsCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapupcodes($cobrowseId, $participantId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapupcodes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **cobrowseId** | **string**| cobrowseId |
 **participantId** | **string**| participantId |

### Return type

[**\PureCloudSDK\WrapupCode[]**](../Model/WrapupCode.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsConversationId**
> \PureCloudSDK\Conversation getConversationsConversationId($conversationId)

Get conversation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversation ID

try {
    $result = $api_instance->getConversationsConversationId($conversationId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsConversationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversation ID |

### Return type

[**\PureCloudSDK\Conversation**](../Model/Conversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsConversationIdParticipantsParticipantIdWrapup**
> \PureCloudSDK\WrapupCode getConversationsConversationIdParticipantsParticipantIdWrapup($conversationId, $participantId, $provisional)

Get the wrap-up for this conversation participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversation ID
$participantId = "participantId_example"; // string | participant ID
$provisional = false; // bool | Indicates if the wrap-up code is provisional.

try {
    $result = $api_instance->getConversationsConversationIdParticipantsParticipantIdWrapup($conversationId, $participantId, $provisional);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsConversationIdParticipantsParticipantIdWrapup: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversation ID |
 **participantId** | **string**| participant ID |
 **provisional** | **bool**| Indicates if the wrap-up code is provisional. | [optional] [default to false]

### Return type

[**\PureCloudSDK\WrapupCode**](../Model/WrapupCode.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsConversationIdParticipantsParticipantIdWrapupcodes**
> \PureCloudSDK\WrapupCode[] getConversationsConversationIdParticipantsParticipantIdWrapupcodes($conversationId, $participantId)

Get list of wrapup codes for this conversation participant



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversation ID
$participantId = "participantId_example"; // string | participant ID

try {
    $result = $api_instance->getConversationsConversationIdParticipantsParticipantIdWrapupcodes($conversationId, $participantId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsConversationIdParticipantsParticipantIdWrapupcodes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversation ID |
 **participantId** | **string**| participant ID |

### Return type

[**\PureCloudSDK\WrapupCode[]**](../Model/WrapupCode.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsEmails**
> \PureCloudSDK\EmailConversationEntityListing getConversationsEmails()

Get recent email conversations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();

try {
    $result = $api_instance->getConversationsEmails();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsEmails: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\EmailConversationEntityListing**](../Model/EmailConversationEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsEmailsEmailId**
> \PureCloudSDK\EmailConversation getConversationsEmailsEmailId($emailId)

Get email conversation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$emailId = "emailId_example"; // string | emailId

try {
    $result = $api_instance->getConversationsEmailsEmailId($emailId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsEmailsEmailId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **emailId** | **string**| emailId |

### Return type

[**\PureCloudSDK\EmailConversation**](../Model/EmailConversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsEmailsEmailIdMessages**
> \PureCloudSDK\EmailMessageListing getConversationsEmailsEmailIdMessages($emailId)

Get conversation messages



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$emailId = "emailId_example"; // string | emailId

try {
    $result = $api_instance->getConversationsEmailsEmailIdMessages($emailId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsEmailsEmailIdMessages: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **emailId** | **string**| emailId |

### Return type

[**\PureCloudSDK\EmailMessageListing**](../Model/EmailMessageListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsEmailsEmailIdMessagesDraft**
> \PureCloudSDK\EmailMessage getConversationsEmailsEmailIdMessagesDraft($emailId)

Get conversation draft reply



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$emailId = "emailId_example"; // string | emailId

try {
    $result = $api_instance->getConversationsEmailsEmailIdMessagesDraft($emailId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsEmailsEmailIdMessagesDraft: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **emailId** | **string**| emailId |

### Return type

[**\PureCloudSDK\EmailMessage**](../Model/EmailMessage.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsEmailsEmailIdMessagesMessageId**
> \PureCloudSDK\EmailMessage getConversationsEmailsEmailIdMessagesMessageId($emailId, $messageId)

Get conversation message



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$emailId = "emailId_example"; // string | emailId
$messageId = "messageId_example"; // string | messageId

try {
    $result = $api_instance->getConversationsEmailsEmailIdMessagesMessageId($emailId, $messageId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsEmailsEmailIdMessagesMessageId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **emailId** | **string**| emailId |
 **messageId** | **string**| messageId |

### Return type

[**\PureCloudSDK\EmailMessage**](../Model/EmailMessage.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsEmailsEmailIdParticipantsParticipantIdWrapup**
> \PureCloudSDK\Wrapup getConversationsEmailsEmailIdParticipantsParticipantIdWrapup($emailId, $participantId, $provisional)

Get the wrap-up for this conversation participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$emailId = "emailId_example"; // string | emailId
$participantId = "participantId_example"; // string | participantId
$provisional = false; // bool | Indicates if the wrap-up code is provisional.

try {
    $result = $api_instance->getConversationsEmailsEmailIdParticipantsParticipantIdWrapup($emailId, $participantId, $provisional);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsEmailsEmailIdParticipantsParticipantIdWrapup: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **emailId** | **string**| emailId |
 **participantId** | **string**| participantId |
 **provisional** | **bool**| Indicates if the wrap-up code is provisional. | [optional] [default to false]

### Return type

[**\PureCloudSDK\Wrapup**](../Model/Wrapup.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsEmailsEmailIdParticipantsParticipantIdWrapupcodes**
> \PureCloudSDK\WrapupCode[] getConversationsEmailsEmailIdParticipantsParticipantIdWrapupcodes($emailId, $participantId)

Get list of wrapup codes for this conversation participant



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$emailId = "emailId_example"; // string | emailId
$participantId = "participantId_example"; // string | participantId

try {
    $result = $api_instance->getConversationsEmailsEmailIdParticipantsParticipantIdWrapupcodes($emailId, $participantId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsEmailsEmailIdParticipantsParticipantIdWrapupcodes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **emailId** | **string**| emailId |
 **participantId** | **string**| participantId |

### Return type

[**\PureCloudSDK\WrapupCode[]**](../Model/WrapupCode.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsCallbacksCallbackId**
> \PureCloudSDK\Conversation patchConversationsCallbacksCallbackId($callbackId, $body)

Update a conversation by disconnecting all of the participants



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callbackId = "callbackId_example"; // string | callbackId
$body = new \PureCloudSDK\Conversation(); // \PureCloudSDK\Conversation | Conversation

try {
    $result = $api_instance->patchConversationsCallbacksCallbackId($callbackId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsCallbacksCallbackId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callbackId** | **string**| callbackId |
 **body** | [**\PureCloudSDK\Conversation**](../Model/\PureCloudSDK\Conversation.md)| Conversation |

### Return type

[**\PureCloudSDK\Conversation**](../Model/Conversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsCallbacksCallbackIdParticipantsParticipantId**
> patchConversationsCallbacksCallbackIdParticipantsParticipantId($callbackId, $participantId, $body)

Update conversation participant



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callbackId = "callbackId_example"; // string | callbackId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\MediaParticipantRequest(); // \PureCloudSDK\MediaParticipantRequest | Participant

try {
    $api_instance->patchConversationsCallbacksCallbackIdParticipantsParticipantId($callbackId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsCallbacksCallbackIdParticipantsParticipantId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callbackId** | **string**| callbackId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\MediaParticipantRequest**](../Model/\PureCloudSDK\MediaParticipantRequest.md)| Participant |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsCallbacksCallbackIdParticipantsParticipantIdAttributes**
> patchConversationsCallbacksCallbackIdParticipantsParticipantIdAttributes($callbackId, $participantId, $body)

Update the attributes on a conversation participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callbackId = "callbackId_example"; // string | callbackId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\ParticipantAttributes(); // \PureCloudSDK\ParticipantAttributes | Attributes

try {
    $api_instance->patchConversationsCallbacksCallbackIdParticipantsParticipantIdAttributes($callbackId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsCallbacksCallbackIdParticipantsParticipantIdAttributes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callbackId** | **string**| callbackId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\ParticipantAttributes**](../Model/\PureCloudSDK\ParticipantAttributes.md)| Attributes |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsCallbacksCallbackIdParticipantsParticipantIdCommunicationsCommunicationId**
> patchConversationsCallbacksCallbackIdParticipantsParticipantIdCommunicationsCommunicationId($callbackId, $participantId, $communicationId, $body)

Update conversation participant's communication by disconnecting it.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callbackId = "callbackId_example"; // string | callbackId
$participantId = "participantId_example"; // string | participantId
$communicationId = "communicationId_example"; // string | communicationId
$body = new \PureCloudSDK\MediaParticipantRequest(); // \PureCloudSDK\MediaParticipantRequest | Participant

try {
    $api_instance->patchConversationsCallbacksCallbackIdParticipantsParticipantIdCommunicationsCommunicationId($callbackId, $participantId, $communicationId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsCallbacksCallbackIdParticipantsParticipantIdCommunicationsCommunicationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callbackId** | **string**| callbackId |
 **participantId** | **string**| participantId |
 **communicationId** | **string**| communicationId |
 **body** | [**\PureCloudSDK\MediaParticipantRequest**](../Model/\PureCloudSDK\MediaParticipantRequest.md)| Participant |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsCallsCallId**
> \PureCloudSDK\Conversation patchConversationsCallsCallId($callId, $body)

Update a conversation by setting it's recording state, merging in other conversations to create a conference, or disconnecting all of the participants



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callId = "callId_example"; // string | callId
$body = new \PureCloudSDK\Conversation(); // \PureCloudSDK\Conversation | Conversation

try {
    $result = $api_instance->patchConversationsCallsCallId($callId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsCallsCallId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callId** | **string**| callId |
 **body** | [**\PureCloudSDK\Conversation**](../Model/\PureCloudSDK\Conversation.md)| Conversation |

### Return type

[**\PureCloudSDK\Conversation**](../Model/Conversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsCallsCallIdParticipantsParticipantId**
> patchConversationsCallsCallIdParticipantsParticipantId($callId, $participantId, $body)

Update conversation participant



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callId = "callId_example"; // string | callId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\MediaParticipantRequest(); // \PureCloudSDK\MediaParticipantRequest | Participant request

try {
    $api_instance->patchConversationsCallsCallIdParticipantsParticipantId($callId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsCallsCallIdParticipantsParticipantId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callId** | **string**| callId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\MediaParticipantRequest**](../Model/\PureCloudSDK\MediaParticipantRequest.md)| Participant request |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsCallsCallIdParticipantsParticipantIdAttributes**
> patchConversationsCallsCallIdParticipantsParticipantIdAttributes($callId, $participantId, $body)

Update the attributes on a conversation participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callId = "callId_example"; // string | callId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\ParticipantAttributes(); // \PureCloudSDK\ParticipantAttributes | Participant attributes

try {
    $api_instance->patchConversationsCallsCallIdParticipantsParticipantIdAttributes($callId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsCallsCallIdParticipantsParticipantIdAttributes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callId** | **string**| callId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\ParticipantAttributes**](../Model/\PureCloudSDK\ParticipantAttributes.md)| Participant attributes |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsCallsCallIdParticipantsParticipantIdCommunicationsCommunicationId**
> patchConversationsCallsCallIdParticipantsParticipantIdCommunicationsCommunicationId($callId, $participantId, $communicationId, $body)

Update conversation participant's communication by disconnecting it.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callId = "callId_example"; // string | callId
$participantId = "participantId_example"; // string | participantId
$communicationId = "communicationId_example"; // string | communicationId
$body = new \PureCloudSDK\MediaParticipantRequest(); // \PureCloudSDK\MediaParticipantRequest | Participant

try {
    $api_instance->patchConversationsCallsCallIdParticipantsParticipantIdCommunicationsCommunicationId($callId, $participantId, $communicationId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsCallsCallIdParticipantsParticipantIdCommunicationsCommunicationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callId** | **string**| callId |
 **participantId** | **string**| participantId |
 **communicationId** | **string**| communicationId |
 **body** | [**\PureCloudSDK\MediaParticipantRequest**](../Model/\PureCloudSDK\MediaParticipantRequest.md)| Participant |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsCallsCallIdParticipantsParticipantIdConsult**
> \PureCloudSDK\ConsultTransferResponse patchConversationsCallsCallIdParticipantsParticipantIdConsult($callId, $participantId, $body)

Change who can speak



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callId = "callId_example"; // string | callId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\ConsultTransferUpdate(); // \PureCloudSDK\ConsultTransferUpdate | new speak to

try {
    $result = $api_instance->patchConversationsCallsCallIdParticipantsParticipantIdConsult($callId, $participantId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsCallsCallIdParticipantsParticipantIdConsult: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callId** | **string**| callId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\ConsultTransferUpdate**](../Model/\PureCloudSDK\ConsultTransferUpdate.md)| new speak to |

### Return type

[**\PureCloudSDK\ConsultTransferResponse**](../Model/ConsultTransferResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsChatsChatId**
> \PureCloudSDK\Conversation patchConversationsChatsChatId($chatId, $body)

Update a conversation by disconnecting all of the participants



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$chatId = "chatId_example"; // string | chatId
$body = new \PureCloudSDK\Conversation(); // \PureCloudSDK\Conversation | Conversation

try {
    $result = $api_instance->patchConversationsChatsChatId($chatId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsChatsChatId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **chatId** | **string**| chatId |
 **body** | [**\PureCloudSDK\Conversation**](../Model/\PureCloudSDK\Conversation.md)| Conversation |

### Return type

[**\PureCloudSDK\Conversation**](../Model/Conversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsChatsChatIdParticipantsParticipantId**
> patchConversationsChatsChatIdParticipantsParticipantId($chatId, $participantId, $body)

Update conversation participant



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$chatId = "chatId_example"; // string | chatId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\MediaParticipantRequest(); // \PureCloudSDK\MediaParticipantRequest | Update request

try {
    $api_instance->patchConversationsChatsChatIdParticipantsParticipantId($chatId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsChatsChatIdParticipantsParticipantId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **chatId** | **string**| chatId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\MediaParticipantRequest**](../Model/\PureCloudSDK\MediaParticipantRequest.md)| Update request |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsChatsChatIdParticipantsParticipantIdAttributes**
> patchConversationsChatsChatIdParticipantsParticipantIdAttributes($chatId, $participantId, $body)

Update the attributes on a conversation participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$chatId = "chatId_example"; // string | chatId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\ParticipantAttributes(); // \PureCloudSDK\ParticipantAttributes | Participant attributes

try {
    $api_instance->patchConversationsChatsChatIdParticipantsParticipantIdAttributes($chatId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsChatsChatIdParticipantsParticipantIdAttributes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **chatId** | **string**| chatId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\ParticipantAttributes**](../Model/\PureCloudSDK\ParticipantAttributes.md)| Participant attributes |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsChatsChatIdParticipantsParticipantIdCommunicationsCommunicationId**
> patchConversationsChatsChatIdParticipantsParticipantIdCommunicationsCommunicationId($chatId, $participantId, $communicationId, $body)

Update conversation participant's communication by disconnecting it.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$chatId = "chatId_example"; // string | chatId
$participantId = "participantId_example"; // string | participantId
$communicationId = "communicationId_example"; // string | communicationId
$body = new \PureCloudSDK\MediaParticipantRequest(); // \PureCloudSDK\MediaParticipantRequest | Participant

try {
    $api_instance->patchConversationsChatsChatIdParticipantsParticipantIdCommunicationsCommunicationId($chatId, $participantId, $communicationId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsChatsChatIdParticipantsParticipantIdCommunicationsCommunicationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **chatId** | **string**| chatId |
 **participantId** | **string**| participantId |
 **communicationId** | **string**| communicationId |
 **body** | [**\PureCloudSDK\MediaParticipantRequest**](../Model/\PureCloudSDK\MediaParticipantRequest.md)| Participant |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsCobrowsesessionsCobrowseId**
> \PureCloudSDK\Conversation patchConversationsCobrowsesessionsCobrowseId($cobrowseId, $body)

Update a conversation by disconnecting all of the participants



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$cobrowseId = "cobrowseId_example"; // string | cobrowseId
$body = new \PureCloudSDK\Conversation(); // \PureCloudSDK\Conversation | Conversation

try {
    $result = $api_instance->patchConversationsCobrowsesessionsCobrowseId($cobrowseId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsCobrowsesessionsCobrowseId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **cobrowseId** | **string**| cobrowseId |
 **body** | [**\PureCloudSDK\Conversation**](../Model/\PureCloudSDK\Conversation.md)| Conversation |

### Return type

[**\PureCloudSDK\Conversation**](../Model/Conversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsCobrowsesessionsCobrowseIdParticipantsParticipantId**
> patchConversationsCobrowsesessionsCobrowseIdParticipantsParticipantId($cobrowseId, $participantId, $body)

Update conversation participant



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$cobrowseId = "cobrowseId_example"; // string | cobrowseId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\MediaParticipantRequest(); // \PureCloudSDK\MediaParticipantRequest | 

try {
    $api_instance->patchConversationsCobrowsesessionsCobrowseIdParticipantsParticipantId($cobrowseId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsCobrowsesessionsCobrowseIdParticipantsParticipantId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **cobrowseId** | **string**| cobrowseId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\MediaParticipantRequest**](../Model/\PureCloudSDK\MediaParticipantRequest.md)|  | [optional]

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsCobrowsesessionsCobrowseIdParticipantsParticipantIdAttributes**
> patchConversationsCobrowsesessionsCobrowseIdParticipantsParticipantIdAttributes($cobrowseId, $participantId, $body)

Update the attributes on a conversation participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$cobrowseId = "cobrowseId_example"; // string | cobrowseId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\ParticipantAttributes(); // \PureCloudSDK\ParticipantAttributes | 

try {
    $api_instance->patchConversationsCobrowsesessionsCobrowseIdParticipantsParticipantIdAttributes($cobrowseId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsCobrowsesessionsCobrowseIdParticipantsParticipantIdAttributes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **cobrowseId** | **string**| cobrowseId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\ParticipantAttributes**](../Model/\PureCloudSDK\ParticipantAttributes.md)|  | [optional]

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsCobrowsesessionsCobrowseIdParticipantsParticipantIdCommunicationsCommunicationId**
> patchConversationsCobrowsesessionsCobrowseIdParticipantsParticipantIdCommunicationsCommunicationId($cobrowseId, $participantId, $communicationId, $body)

Update conversation participant's communication by disconnecting it.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$cobrowseId = "cobrowseId_example"; // string | cobrowseId
$participantId = "participantId_example"; // string | participantId
$communicationId = "communicationId_example"; // string | communicationId
$body = new \PureCloudSDK\MediaParticipantRequest(); // \PureCloudSDK\MediaParticipantRequest | Participant

try {
    $api_instance->patchConversationsCobrowsesessionsCobrowseIdParticipantsParticipantIdCommunicationsCommunicationId($cobrowseId, $participantId, $communicationId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsCobrowsesessionsCobrowseIdParticipantsParticipantIdCommunicationsCommunicationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **cobrowseId** | **string**| cobrowseId |
 **participantId** | **string**| participantId |
 **communicationId** | **string**| communicationId |
 **body** | [**\PureCloudSDK\MediaParticipantRequest**](../Model/\PureCloudSDK\MediaParticipantRequest.md)| Participant |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsConversationIdParticipantsParticipantId**
> patchConversationsConversationIdParticipantsParticipantId($conversationId, $participantId, $body)

Update a participant.

Update conversation participant.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversation ID
$participantId = "participantId_example"; // string | participant ID
$body = new \PureCloudSDK\MediaParticipantRequest(); // \PureCloudSDK\MediaParticipantRequest | Update request

try {
    $api_instance->patchConversationsConversationIdParticipantsParticipantId($conversationId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsConversationIdParticipantsParticipantId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversation ID |
 **participantId** | **string**| participant ID |
 **body** | [**\PureCloudSDK\MediaParticipantRequest**](../Model/\PureCloudSDK\MediaParticipantRequest.md)| Update request |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsConversationIdParticipantsParticipantIdAttributes**
> patchConversationsConversationIdParticipantsParticipantIdAttributes($conversationId, $participantId, $body)

Update the attributes on a conversation participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversation ID
$participantId = "participantId_example"; // string | participant ID
$body = new \PureCloudSDK\ParticipantAttributes(); // \PureCloudSDK\ParticipantAttributes | Participant attributes

try {
    $api_instance->patchConversationsConversationIdParticipantsParticipantIdAttributes($conversationId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsConversationIdParticipantsParticipantIdAttributes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversation ID |
 **participantId** | **string**| participant ID |
 **body** | [**\PureCloudSDK\ParticipantAttributes**](../Model/\PureCloudSDK\ParticipantAttributes.md)| Participant attributes |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsEmailsEmailId**
> \PureCloudSDK\Conversation patchConversationsEmailsEmailId($emailId, $body)

Update a conversation by disconnecting all of the participants



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$emailId = "emailId_example"; // string | emailId
$body = new \PureCloudSDK\Conversation(); // \PureCloudSDK\Conversation | Conversation

try {
    $result = $api_instance->patchConversationsEmailsEmailId($emailId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsEmailsEmailId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **emailId** | **string**| emailId |
 **body** | [**\PureCloudSDK\Conversation**](../Model/\PureCloudSDK\Conversation.md)| Conversation |

### Return type

[**\PureCloudSDK\Conversation**](../Model/Conversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsEmailsEmailIdParticipantsParticipantId**
> patchConversationsEmailsEmailIdParticipantsParticipantId($emailId, $participantId, $body)

Update conversation participant



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$emailId = "emailId_example"; // string | emailId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\MediaParticipantRequest(); // \PureCloudSDK\MediaParticipantRequest | Update request

try {
    $api_instance->patchConversationsEmailsEmailIdParticipantsParticipantId($emailId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsEmailsEmailIdParticipantsParticipantId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **emailId** | **string**| emailId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\MediaParticipantRequest**](../Model/\PureCloudSDK\MediaParticipantRequest.md)| Update request |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsEmailsEmailIdParticipantsParticipantIdAttributes**
> patchConversationsEmailsEmailIdParticipantsParticipantIdAttributes($emailId, $participantId, $body)

Update the attributes on a conversation participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$emailId = "emailId_example"; // string | emailId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\ParticipantAttributes(); // \PureCloudSDK\ParticipantAttributes | Participant attributes

try {
    $api_instance->patchConversationsEmailsEmailIdParticipantsParticipantIdAttributes($emailId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsEmailsEmailIdParticipantsParticipantIdAttributes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **emailId** | **string**| emailId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\ParticipantAttributes**](../Model/\PureCloudSDK\ParticipantAttributes.md)| Participant attributes |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsEmailsEmailIdParticipantsParticipantIdCommunicationsCommunicationId**
> patchConversationsEmailsEmailIdParticipantsParticipantIdCommunicationsCommunicationId($emailId, $participantId, $communicationId, $body)

Update conversation participant's communication by disconnecting it.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$emailId = "emailId_example"; // string | emailId
$participantId = "participantId_example"; // string | participantId
$communicationId = "communicationId_example"; // string | communicationId
$body = new \PureCloudSDK\MediaParticipantRequest(); // \PureCloudSDK\MediaParticipantRequest | Participant

try {
    $api_instance->patchConversationsEmailsEmailIdParticipantsParticipantIdCommunicationsCommunicationId($emailId, $participantId, $communicationId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsEmailsEmailIdParticipantsParticipantIdCommunicationsCommunicationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **emailId** | **string**| emailId |
 **participantId** | **string**| participantId |
 **communicationId** | **string**| communicationId |
 **body** | [**\PureCloudSDK\MediaParticipantRequest**](../Model/\PureCloudSDK\MediaParticipantRequest.md)| Participant |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAnalyticsConversationsAggregatesQuery**
> \PureCloudSDK\AggregateQueryResponse postAnalyticsConversationsAggregatesQuery($body)

Query for conversation aggregates



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$body = new \PureCloudSDK\AggregationQuery(); // \PureCloudSDK\AggregationQuery | query

try {
    $result = $api_instance->postAnalyticsConversationsAggregatesQuery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postAnalyticsConversationsAggregatesQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\AggregationQuery**](../Model/\PureCloudSDK\AggregationQuery.md)| query |

### Return type

[**\PureCloudSDK\AggregateQueryResponse**](../Model/AggregateQueryResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAnalyticsConversationsConversationIdDetailsProperties**
> \PureCloudSDK\PropertyIndexRequest postAnalyticsConversationsConversationIdDetailsProperties($conversationId, $body)

Index conversation properties



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$body = new \PureCloudSDK\PropertyIndexRequest(); // \PureCloudSDK\PropertyIndexRequest | request

try {
    $result = $api_instance->postAnalyticsConversationsConversationIdDetailsProperties($conversationId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postAnalyticsConversationsConversationIdDetailsProperties: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **body** | [**\PureCloudSDK\PropertyIndexRequest**](../Model/\PureCloudSDK\PropertyIndexRequest.md)| request |

### Return type

[**\PureCloudSDK\PropertyIndexRequest**](../Model/PropertyIndexRequest.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAnalyticsConversationsDetailsQuery**
> \PureCloudSDK\AnalyticsConversationQueryResponse postAnalyticsConversationsDetailsQuery($body)

Query for conversation details



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$body = new \PureCloudSDK\ConversationQuery(); // \PureCloudSDK\ConversationQuery | query

try {
    $result = $api_instance->postAnalyticsConversationsDetailsQuery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postAnalyticsConversationsDetailsQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ConversationQuery**](../Model/\PureCloudSDK\ConversationQuery.md)| query |

### Return type

[**\PureCloudSDK\AnalyticsConversationQueryResponse**](../Model/AnalyticsConversationQueryResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsCallbacks**
> \PureCloudSDK\CreateCallbackResponse postConversationsCallbacks($body)

Create a Callback



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$body = new \PureCloudSDK\CreateCallbackCommand(); // \PureCloudSDK\CreateCallbackCommand | Callback

try {
    $result = $api_instance->postConversationsCallbacks($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationsCallbacks: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\CreateCallbackCommand**](../Model/\PureCloudSDK\CreateCallbackCommand.md)| Callback |

### Return type

[**\PureCloudSDK\CreateCallbackResponse**](../Model/CreateCallbackResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsCallbacksCallbackIdParticipantsParticipantIdReplace**
> postConversationsCallbacksCallbackIdParticipantsParticipantIdReplace($callbackId, $participantId, $body)

Replace this participant with the specified user and/or address



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callbackId = "callbackId_example"; // string | callbackId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\TransferRequest(); // \PureCloudSDK\TransferRequest | Transfer request

try {
    $api_instance->postConversationsCallbacksCallbackIdParticipantsParticipantIdReplace($callbackId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationsCallbacksCallbackIdParticipantsParticipantIdReplace: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callbackId** | **string**| callbackId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\TransferRequest**](../Model/\PureCloudSDK\TransferRequest.md)| Transfer request |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsCalls**
> \PureCloudSDK\CreateCallResponse postConversationsCalls($body)

Create a call conversation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$body = new \PureCloudSDK\CreateCallRequest(); // \PureCloudSDK\CreateCallRequest | Call request

try {
    $result = $api_instance->postConversationsCalls($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationsCalls: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\CreateCallRequest**](../Model/\PureCloudSDK\CreateCallRequest.md)| Call request |

### Return type

[**\PureCloudSDK\CreateCallResponse**](../Model/CreateCallResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsCallsCallId**
> \PureCloudSDK\Conversation postConversationsCallsCallId($callId, $body)

Add a new call to a conversation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callId = "callId_example"; // string | callId
$body = new \PureCloudSDK\CallCommand(); // \PureCloudSDK\CallCommand | Conversation

try {
    $result = $api_instance->postConversationsCallsCallId($callId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationsCallsCallId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callId** | **string**| callId |
 **body** | [**\PureCloudSDK\CallCommand**](../Model/\PureCloudSDK\CallCommand.md)| Conversation |

### Return type

[**\PureCloudSDK\Conversation**](../Model/Conversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsCallsCallIdParticipants**
> \PureCloudSDK\Conversation postConversationsCallsCallIdParticipants($callId, $body)

Add participants to a conversation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callId = "callId_example"; // string | callId
$body = new \PureCloudSDK\Conversation(); // \PureCloudSDK\Conversation | Conversation

try {
    $result = $api_instance->postConversationsCallsCallIdParticipants($callId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationsCallsCallIdParticipants: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callId** | **string**| callId |
 **body** | [**\PureCloudSDK\Conversation**](../Model/\PureCloudSDK\Conversation.md)| Conversation |

### Return type

[**\PureCloudSDK\Conversation**](../Model/Conversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsCallsCallIdParticipantsParticipantIdConsult**
> \PureCloudSDK\ConsultTransferResponse postConversationsCallsCallIdParticipantsParticipantIdConsult($callId, $participantId, $body)

Initiate and update consult transfer



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callId = "callId_example"; // string | callId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\ConsultTransfer(); // \PureCloudSDK\ConsultTransfer | Destination address & initial speak to

try {
    $result = $api_instance->postConversationsCallsCallIdParticipantsParticipantIdConsult($callId, $participantId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationsCallsCallIdParticipantsParticipantIdConsult: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callId** | **string**| callId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\ConsultTransfer**](../Model/\PureCloudSDK\ConsultTransfer.md)| Destination address &amp; initial speak to |

### Return type

[**\PureCloudSDK\ConsultTransferResponse**](../Model/ConsultTransferResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsCallsCallIdParticipantsParticipantIdMonitor**
> postConversationsCallsCallIdParticipantsParticipantIdMonitor($callId, $participantId)

Listen in on the conversation from the point of view of a given participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callId = "callId_example"; // string | callId
$participantId = "participantId_example"; // string | participantId

try {
    $api_instance->postConversationsCallsCallIdParticipantsParticipantIdMonitor($callId, $participantId);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationsCallsCallIdParticipantsParticipantIdMonitor: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callId** | **string**| callId |
 **participantId** | **string**| participantId |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsCallsCallIdParticipantsParticipantIdReplace**
> postConversationsCallsCallIdParticipantsParticipantIdReplace($callId, $participantId, $body)

Replace this participant with the specified user and/or address



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callId = "callId_example"; // string | callId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\TransferRequest(); // \PureCloudSDK\TransferRequest | Transfer request

try {
    $api_instance->postConversationsCallsCallIdParticipantsParticipantIdReplace($callId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationsCallsCallIdParticipantsParticipantIdReplace: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callId** | **string**| callId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\TransferRequest**](../Model/\PureCloudSDK\TransferRequest.md)| Transfer request |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsChatsChatIdParticipantsParticipantIdReplace**
> postConversationsChatsChatIdParticipantsParticipantIdReplace($chatId, $participantId, $body)

Replace this participant with the specified user and/or address



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$chatId = "chatId_example"; // string | chatId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\TransferRequest(); // \PureCloudSDK\TransferRequest | Transfer request

try {
    $api_instance->postConversationsChatsChatIdParticipantsParticipantIdReplace($chatId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationsChatsChatIdParticipantsParticipantIdReplace: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **chatId** | **string**| chatId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\TransferRequest**](../Model/\PureCloudSDK\TransferRequest.md)| Transfer request |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsCobrowsesessionsCobrowseIdParticipantsParticipantIdReplace**
> postConversationsCobrowsesessionsCobrowseIdParticipantsParticipantIdReplace($cobrowseId, $participantId, $body)

Replace this participant with the specified user and/or address



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$cobrowseId = "cobrowseId_example"; // string | cobrowseId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\TransferRequest(); // \PureCloudSDK\TransferRequest | 

try {
    $api_instance->postConversationsCobrowsesessionsCobrowseIdParticipantsParticipantIdReplace($cobrowseId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationsCobrowsesessionsCobrowseIdParticipantsParticipantIdReplace: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **cobrowseId** | **string**| cobrowseId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\TransferRequest**](../Model/\PureCloudSDK\TransferRequest.md)|  | [optional]

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsConversationIdParticipantsParticipantIdCallbacks**
> postConversationsConversationIdParticipantsParticipantIdCallbacks($conversationId, $participantId, $body)

Create a new callback for the specified participant on the conversation.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversation ID
$participantId = "participantId_example"; // string | participant ID
$body = new \PureCloudSDK\CreateCallbackCommand(); // \PureCloudSDK\CreateCallbackCommand | 

try {
    $api_instance->postConversationsConversationIdParticipantsParticipantIdCallbacks($conversationId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationsConversationIdParticipantsParticipantIdCallbacks: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversation ID |
 **participantId** | **string**| participant ID |
 **body** | [**\PureCloudSDK\CreateCallbackCommand**](../Model/\PureCloudSDK\CreateCallbackCommand.md)|  | [optional]

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsConversationIdParticipantsParticipantIdReplace**
> postConversationsConversationIdParticipantsParticipantIdReplace($conversationId, $participantId, $body)

Replace this participant with the specified user and/or address



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversation ID
$participantId = "participantId_example"; // string | participant ID
$body = new \PureCloudSDK\TransferRequest(); // \PureCloudSDK\TransferRequest | Transfer request

try {
    $api_instance->postConversationsConversationIdParticipantsParticipantIdReplace($conversationId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationsConversationIdParticipantsParticipantIdReplace: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversation ID |
 **participantId** | **string**| participant ID |
 **body** | [**\PureCloudSDK\TransferRequest**](../Model/\PureCloudSDK\TransferRequest.md)| Transfer request |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsEmailsEmailIdMessages**
> \PureCloudSDK\EmailMessage postConversationsEmailsEmailIdMessages($emailId, $body)

Send an email reply



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$emailId = "emailId_example"; // string | emailId
$body = new \PureCloudSDK\EmailMessage(); // \PureCloudSDK\EmailMessage | Reply

try {
    $result = $api_instance->postConversationsEmailsEmailIdMessages($emailId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationsEmailsEmailIdMessages: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **emailId** | **string**| emailId |
 **body** | [**\PureCloudSDK\EmailMessage**](../Model/\PureCloudSDK\EmailMessage.md)| Reply |

### Return type

[**\PureCloudSDK\EmailMessage**](../Model/EmailMessage.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsEmailsEmailIdParticipantsParticipantIdReplace**
> postConversationsEmailsEmailIdParticipantsParticipantIdReplace($emailId, $participantId, $body)

Replace this participant with the specified user and/or address



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$emailId = "emailId_example"; // string | emailId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\TransferRequest(); // \PureCloudSDK\TransferRequest | Transfer request

try {
    $api_instance->postConversationsEmailsEmailIdParticipantsParticipantIdReplace($emailId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationsEmailsEmailIdParticipantsParticipantIdReplace: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **emailId** | **string**| emailId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\TransferRequest**](../Model/\PureCloudSDK\TransferRequest.md)| Transfer request |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsFaxes**
> \PureCloudSDK\FaxSendResponse postConversationsFaxes($body)

Create Fax Conversation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$body = new \PureCloudSDK\FaxSendRequest(); // \PureCloudSDK\FaxSendRequest | Fax

try {
    $result = $api_instance->postConversationsFaxes($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationsFaxes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\FaxSendRequest**](../Model/\PureCloudSDK\FaxSendRequest.md)| Fax |

### Return type

[**\PureCloudSDK\FaxSendResponse**](../Model/FaxSendResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putConversationsEmailsEmailIdMessagesDraft**
> \PureCloudSDK\EmailMessage putConversationsEmailsEmailIdMessagesDraft($emailId, $body)

Update conversation draft reply



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$emailId = "emailId_example"; // string | emailId
$body = new \PureCloudSDK\EmailMessage(); // \PureCloudSDK\EmailMessage | Draft

try {
    $result = $api_instance->putConversationsEmailsEmailIdMessagesDraft($emailId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->putConversationsEmailsEmailIdMessagesDraft: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **emailId** | **string**| emailId |
 **body** | [**\PureCloudSDK\EmailMessage**](../Model/\PureCloudSDK\EmailMessage.md)| Draft |

### Return type

[**\PureCloudSDK\EmailMessage**](../Model/EmailMessage.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

