# PureCloudSDK\ScriptsApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getScripts**](ScriptsApi.md#getScripts) | **GET** /api/v2/scripts | Get the list of scripts
[**getScriptsPublished**](ScriptsApi.md#getScriptsPublished) | **GET** /api/v2/scripts/published | Get the published scripts.
[**getScriptsPublishedScriptId**](ScriptsApi.md#getScriptsPublishedScriptId) | **GET** /api/v2/scripts/published/{scriptId} | Get the published script.
[**getScriptsPublishedScriptIdPages**](ScriptsApi.md#getScriptsPublishedScriptIdPages) | **GET** /api/v2/scripts/published/{scriptId}/pages | Get the list of published pages
[**getScriptsPublishedScriptIdPagesPageId**](ScriptsApi.md#getScriptsPublishedScriptIdPagesPageId) | **GET** /api/v2/scripts/published/{scriptId}/pages/{pageId} | Get the published page.
[**getScriptsPublishedScriptIdVariables**](ScriptsApi.md#getScriptsPublishedScriptIdVariables) | **GET** /api/v2/scripts/published/{scriptId}/variables | Get the published variables
[**getScriptsScriptId**](ScriptsApi.md#getScriptsScriptId) | **GET** /api/v2/scripts/{scriptId} | Get a script
[**getScriptsScriptIdPages**](ScriptsApi.md#getScriptsScriptIdPages) | **GET** /api/v2/scripts/{scriptId}/pages | Get the list of pages
[**getScriptsScriptIdPagesPageId**](ScriptsApi.md#getScriptsScriptIdPagesPageId) | **GET** /api/v2/scripts/{scriptId}/pages/{pageId} | Get a page


# **getScripts**
> \PureCloudSDK\ScriptEntityListing getScripts($pageSize, $pageNumber, $expand, $name, $feature, $flowId, $sortBy, $sortOrder)

Get the list of scripts



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ScriptsApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$expand = "expand_example"; // string | Expand
$name = "name_example"; // string | Name filter
$feature = "feature_example"; // string | Feature filter
$flowId = "flowId_example"; // string | Secure flow id filter
$sortBy = "sortBy_example"; // string | SortBy
$sortOrder = "sortOrder_example"; // string | SortOrder

try {
    $result = $api_instance->getScripts($pageSize, $pageNumber, $expand, $name, $feature, $flowId, $sortBy, $sortOrder);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ScriptsApi->getScripts: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **expand** | **string**| Expand | [optional]
 **name** | **string**| Name filter | [optional]
 **feature** | **string**| Feature filter | [optional]
 **flowId** | **string**| Secure flow id filter | [optional]
 **sortBy** | **string**| SortBy | [optional]
 **sortOrder** | **string**| SortOrder | [optional]

### Return type

[**\PureCloudSDK\ScriptEntityListing**](../Model/ScriptEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getScriptsPublished**
> \PureCloudSDK\ScriptEntityListing getScriptsPublished($pageSize, $pageNumber, $expand, $name, $feature, $flowId)

Get the published scripts.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ScriptsApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$expand = "expand_example"; // string | Expand
$name = "name_example"; // string | Name filter
$feature = "feature_example"; // string | Feature filter
$flowId = "flowId_example"; // string | Secure flow id filter

try {
    $result = $api_instance->getScriptsPublished($pageSize, $pageNumber, $expand, $name, $feature, $flowId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ScriptsApi->getScriptsPublished: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **expand** | **string**| Expand | [optional]
 **name** | **string**| Name filter | [optional]
 **feature** | **string**| Feature filter | [optional]
 **flowId** | **string**| Secure flow id filter | [optional]

### Return type

[**\PureCloudSDK\ScriptEntityListing**](../Model/ScriptEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getScriptsPublishedScriptId**
> \PureCloudSDK\Script getScriptsPublishedScriptId($scriptId)

Get the published script.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ScriptsApi();
$scriptId = "scriptId_example"; // string | Script ID

try {
    $result = $api_instance->getScriptsPublishedScriptId($scriptId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ScriptsApi->getScriptsPublishedScriptId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **scriptId** | **string**| Script ID |

### Return type

[**\PureCloudSDK\Script**](../Model/Script.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getScriptsPublishedScriptIdPages**
> \PureCloudSDK\Page[] getScriptsPublishedScriptIdPages($scriptId)

Get the list of published pages



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ScriptsApi();
$scriptId = "scriptId_example"; // string | Script ID

try {
    $result = $api_instance->getScriptsPublishedScriptIdPages($scriptId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ScriptsApi->getScriptsPublishedScriptIdPages: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **scriptId** | **string**| Script ID |

### Return type

[**\PureCloudSDK\Page[]**](../Model/Page.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getScriptsPublishedScriptIdPagesPageId**
> \PureCloudSDK\Page getScriptsPublishedScriptIdPagesPageId($scriptId, $pageId)

Get the published page.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ScriptsApi();
$scriptId = "scriptId_example"; // string | Script ID
$pageId = "pageId_example"; // string | Page ID

try {
    $result = $api_instance->getScriptsPublishedScriptIdPagesPageId($scriptId, $pageId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ScriptsApi->getScriptsPublishedScriptIdPagesPageId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **scriptId** | **string**| Script ID |
 **pageId** | **string**| Page ID |

### Return type

[**\PureCloudSDK\Page**](../Model/Page.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getScriptsPublishedScriptIdVariables**
> object getScriptsPublishedScriptIdVariables($scriptId)

Get the published variables



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ScriptsApi();
$scriptId = "scriptId_example"; // string | Script ID

try {
    $result = $api_instance->getScriptsPublishedScriptIdVariables($scriptId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ScriptsApi->getScriptsPublishedScriptIdVariables: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **scriptId** | **string**| Script ID |

### Return type

**object**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getScriptsScriptId**
> \PureCloudSDK\Script getScriptsScriptId($scriptId)

Get a script



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ScriptsApi();
$scriptId = "scriptId_example"; // string | Script ID

try {
    $result = $api_instance->getScriptsScriptId($scriptId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ScriptsApi->getScriptsScriptId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **scriptId** | **string**| Script ID |

### Return type

[**\PureCloudSDK\Script**](../Model/Script.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getScriptsScriptIdPages**
> \PureCloudSDK\Page[] getScriptsScriptIdPages($scriptId)

Get the list of pages



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ScriptsApi();
$scriptId = "scriptId_example"; // string | Script ID

try {
    $result = $api_instance->getScriptsScriptIdPages($scriptId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ScriptsApi->getScriptsScriptIdPages: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **scriptId** | **string**| Script ID |

### Return type

[**\PureCloudSDK\Page[]**](../Model/Page.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getScriptsScriptIdPagesPageId**
> \PureCloudSDK\Page getScriptsScriptIdPagesPageId($scriptId, $pageId)

Get a page



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ScriptsApi();
$scriptId = "scriptId_example"; // string | Script ID
$pageId = "pageId_example"; // string | Page ID

try {
    $result = $api_instance->getScriptsScriptIdPagesPageId($scriptId, $pageId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ScriptsApi->getScriptsScriptIdPagesPageId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **scriptId** | **string**| Script ID |
 **pageId** | **string**| Page ID |

### Return type

[**\PureCloudSDK\Page**](../Model/Page.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

